/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = TOUTYPES.H
 *
 * DESCRIPTIVE NAME = Touch typedefs
 *
 *
 * VERSION = V2.0
 *
 * DATE        07/12/91
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#ifndef  TOUTYPES_INCLUDED             /* stop multiple inclusion            */
#define  TOUTYPES_INCLUDED

#define  BASED_Q                       /* if defined use based ptrs for event
                                          queues                             */

/*
** typedefs
*/

#pragma     pack(1)                    /* set pack size of 1                 */

typedef USHORT NEAR *NPUSHORT;
typedef VOID(FAR *PFVOID)();           /* far ptr to 'VOID function()'       */
typedef VOID(NEAR *NPFVOID)();         /* near ptr to 'VOID function()'      */
typedef VOID(FAR *PFUSHORT)();         /* far ptr to 'USHORT function()'     */
typedef ULONG LIN32,FAR *PLIN32;

/*
** ioctl 11,41h - session, switch or termination, notify structure
*/
typedef struct
{
  USHORT len;
  USHORT action;
  union
  {
    struct
    {                                  /* save, swap, restore                */
      USHORT ssr_sess_in;              /* valid for swap, restore            */
      USHORT ssr_sess_out;             /* valid for save, swap               */
    } ;

    struct
    {                                  /* terminate                          */
      USHORT term_type_out;            /* ??                                 */
      USHORT term_sess_out;            /* ??                                 */
    } ;

    struct
    {                                  /* create                             */
      USHORT creat_sess_in;
      USHORT creat_type_in;
    } ;

    struct
    {                                  /* pre/post switch                    */
      USHORT psw_sess_in;
      USHORT psw_type_in;
      USHORT psw_sess_out;
      USHORT psw_type_out;
    } ;

    struct
    {                                  /* aim post save                      */
      ULONG aim_Errors;
      USHORT aim_Active;
      USHORT aim_TimeOut;
      ULONG aim_FkAccept;
      ULONG aim_FkRate;
      ULONG aim_FkDelay;
    } ;

  } ;

} NOTIFY, FAR *PNOTIFY;

/*
** session action
*/
#define  SESA_SAVE         0x01        /* save old session                   */
#define  SESA_SWAP         0x02        /* old to new session, transition     */
#define  SESA_REST         0x04        /* restore new session                */
#define  SESA_TERM         0x08        /* old session terminated             */
#define  SESA_CREATE       0x10        /* create new session                 */
#define  SESA_START        0x20        /* start a session switch             */
#define  SESA_END          0x40        /* end a session switch               */
#define  SESA_CHANGE       0x80        /* change session type                */

/*
** session types (see SSF_TYPE_xxx)
*/
#define  SEST_PROT_FS      1           /* fullscreen                         */
#define  SEST_PROT_WIN     2           /* windowable vio                     */
#define  SEST_PM           3
#define  SEST_REAL_FS      4           /* vdm                                */
#define  SEST_REAL_WIN     7           /* widowed vdm                        */

/*
** DosSMRegisterDD types
*/
#define  SMREG_SAVE        0x0001      /* pre, sess-save                     */
#define  SMREG_SWAP        0x0002      /* post, sess-save or pre, sess-retore*/
#define  SMREG_RESTORE     0x0004      /* post, sess-restore                 */
#define  SMREG_TERMINATE   0x0008      /* session termination                */
#define  SMREG_CREATE      0x0010      /* session creation                   */
#define  SMREG_PRESWITCH   0x0020      /* pre, sess-switch                   */
#define  SMREG_POSTSWITCH  0x0040      /* post, sess-switch                  */
/* ?                       0x0080   */
#define  SMREG_AIMPOSTSAVE 0x0100      /* application input method!          */

/*
** event queue record
*/
typedef struct
{
  USHORT Status;
  ULONG Time;
  USHORT X;
  USHORT Y;
  USHORT Z;

#ifdef   BASED_Q
} EVENT, FAR *PEVENT, _based((_segment)_self) *NPEVENT;
#else
} EVENT, FAR *PEVENT, NEAR *NPEVENT;
#endif

/*
** monitor chain record, used by dh_monwrite
*/
typedef struct
{
  USHORT MFlags;                       /* monitor specific flags or fgnd sess
                                          (vdd)                              */
  EVENT Event;
} MONREC, FAR *PMONREC;

/*
** monitor chain o/p buffer, used by dh_moncreate & monitor_handler
*/
typedef struct
{
  USHORT MB_Len;                       /* o/p buff length                    */
  MONREC MB_Mr;
} MONBUF, FAR *PMONBUF;

/*
** monitor registration, used by register a monitor (ioctl 10,40)
*/
typedef struct
{
  USHORT fPlace;
  USHORT Index;
  BYTE FAR *pIBuff;
  BYTE FAR *pOBuff;
} MONREG, FAR *PMONREG;


#if 0
/*
** VDM screen group control block
*/
typedef struct
{
  UCHAR VMEmulState;                   /* emulation flag                     */
} VDMSGCB;
#endif

/*
** screen group control block
*/
typedef struct
{
  /* union                       */
  /* { full screen or vdm        */
  /*   struct  { full screen     */
  struct
  {
    unsigned int eq_busy:1;
    unsigned int blocked:1;
    unsigned int flush:1;
    /* unsigned int singleq    : 1;    */
  } DevStatus;

  USHORT EventMask;
  USHORT Hdle_Count;
  NPEVENT Eq_Start;
  NPEVENT Eq_Head;
  NPEVENT Eq_Tail;
  USHORT Eq_Pid;
  USHORT Eq_Size;
  USHORT Chain_Size;
  USHORT Chain_Hdle;
  struct
  {
    USHORT x;
    USHORT y;
    USHORT z;
    USHORT Status;
  } xyzSingleTouch;

  struct
  {
    USHORT x;
    USHORT y;
  } xyzStablePoint;

  struct
  {
    USHORT usMethod;
    USHORT usCount;
    USHORT usTolerance;
    USHORT usLimit;
    USHORT usOTCount;
    USHORT usFlag;
    USHORT usSPBuffHead;
    USHORT usSPBuffTail;
    struct
    {
      USHORT x;
      USHORT y;
    } SPBuffer[TDI_SEL_SMAX];

  } smData;

  /* USHORT   CoordOrg;          */    /* coordinate origin                  */
  TDICOORDSYS CoordSys;                /* coordinate system                  */
  TDISELMETHOD SelMech;                /* selection mechanism                */
  USHORT EmulState;                    /* emulation flag                     */
  USHORT QueueSize;                    /* event queue size                   */
  /*   };                              */
  /* VDMSGCB;                          */
  /* }; union - full screen/VDM sgcb   */
  MONBUF MonBuf;
} SGCB, FAR *PSGCB;

/*
** interrupt packet
*/
typedef struct
{
  USHORT Status;
  USHORT X;
  USHORT Y;
  USHORT Z;
  USHORT RX;
  USHORT RY;
  USHORT RZ;
} INTPKT, FAR *PINTPKT;

/*
** configuration data, used by idc query config
*/
typedef struct
{
  USHORT length;
  BYTE dev_irq;
  USHORT mouse_status;                 /* mouse flags                        */
  USHORT touch_status;                 /* touch flags                        */
} CONFDAT, FAR *PCONFDAT;

/*
** mouse status flags
*/
#define  MS_REAL_MOUSE     1
#define  MS_DI_ATTACHED    2
#define  MS_PROT_EMUL      4
#define  MS_REAL_EMUL      8
#define  MS_EMUL_BEEP      16

/*
** touch status flags
*/
#define  TS_CALIBRATED     1

/*
** screen group control block table
*/
typedef struct
{
  UCHAR sess;                          /* session id                         */
  UCHAR type;                          /* type of session SEST_?             */
  PSGCB pSgcb;                         /* sgcb 16:16 address                 */
  LIN32 linSgcb;                       /* sgcb 0:32 address                  */
} CBTAB, FAR *PCBTAB;

/*
** VDM function table
*/
#define  VDMFUNC       USHORT NEAR CDECL
typedef  USHORT(NEAR CDECL *PVDMFUNC)();
typedef  struct
{
  /* PVDMFUNC Func;              */    /* function offset                    */
  USHORT DataSize;                     /* size of data to be read            */
  USHORT fSess;                        /* TRUE if session ID supplied        */
} VDMTAB, FAR *PVDMTAB;

/*
** IOCTL function table
*/
#define  IOCFUNC       VOID NEAR PASCAL
typedef  VOID(NEAR PASCAL *PIOCFUNC)(PREQBLK);
typedef  struct
{
  PIOCFUNC Func;
  USHORT ParmsCheck;
  USHORT DataCheck;
} IOCTAB, FAR *PIOCTAB;

#define  ACC_NONE          0x00        /* do not check access rights         */
#define  ACC_CHECK         0x10        /* do a check on access rights        */
#define  ACC_BMASK         0x0f        /* number of bytes to check (max 15)  */
/* #define ACC_READ        0x10  */    /* read access                        */
#define  ACC_RCHK          0x10        /* check for read access              */
#define  ACC_WRITE         0x20        /* write access                       */
#define  ACC_WCHK          0x30        /* check for write access             */
#define  ACC_NULLOK        0x40        /* skip check if selector is null     */
#define  ACC_LVL2          0x80        /* set if lvl2 call & size supplied in
                                          req blk                            */

/*
** Request funtion table
*/
#define  REQFUNC           STATIC VOID NEAR PASCAL
typedef  STATIC VOID(NEAR PASCAL NEAR *PREQFUNC)(PREQBLK);

typedef struct
{
  PREQFUNC Func;
} REQTAB, FAR *PREQTAB;

/*
** event queue
*/
typedef struct
{
  BYTE q[1000];                        /* ??                                 */
} EVENTQ, NEAR *NPEVENTQ;

typedef struct
{
  USHORT Len;
  USHORT Sess;                         /* incoming or outgoing, during
                                          session switch                     */
} ICB;

typedef struct
{
  ULONG off32;
  USHORT sel16;
} FWORD;

typedef enum _ETOK
{
  TOK_TYPE = 0, TOK_SEL, TOK_QSIZE, TOK_ILLEGAL = -1
} ETOK;

typedef struct _TOK
{
  CHAR *name;                          /* token name                         */
  ETOK idx;                            /* token index                        */
  USHORT nargs;                        /* nember of arguments                */
  UCHAR fUsed;                         /* used flag                          */
} TOKENS, *PTOKENS;


#pragma  pack()                        /* restore default setting            */

#endif                                 /* TOUTYPES_INCLUDED                  */

/*
** end
*/
