/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = TOUASM.H
 *
 * DESCRIPTIVE NAME = Include file for asssembler support
 *
 *
 * VERSION = V2.0
 *
 * DATE        07/12/91
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
** Register macros used to access registers when _saveregs used.
** The function must be declared cdecl for these to work, otherwise
** the dummy variable will cause a ret 2, which is       as no variable
** has actually been pushed. It is just acting as a place holder on the
** stack.
*/

/*
** VOID SAVEREGS CDECL func( USHORT regs) { return( _AX(regs)); }
*/

/*
**      reg    ss:bp    off
**      ---    -----    ---
**      es      +0      -c
**      ds      +2      -b
**      di      +4      -a
**      si      +6      -9
**      bp      +8      -8
**      sp      +c      -7
**      bx      +e      -6
**      dx      +10     -5
**      cx      +12     -4
**      ax      +14     -3
**      ret-off +16     -2
**      ret-seg +18     -1
**      (dummy) +1a     -0
*/

#define  _REGS          -3          /* word offset of start of AX from dummy
                                       parameter                             */
#define  _AX(x)         ((int far *)(&x))[_REGS]
#define  _CX(x)         ((int far *)(&x))[_REGS-1]
#define  _DX(x)         ((int far *)(&x))[_REGS-2]
#define  _BX(x)         ((int far *)(&x))[_REGS-3]
#define  _SP(x)         ((int far *)(&x))[_REGS-4]
#define  _BP(x)         ((int far *)(&x))[_REGS-5]
#define  _SI(x)         ((int far *)(&x))[_REGS-6]
#define  _DI(x)         ((int far *)(&x))[_REGS-7]
#define  _DS(x)         ((int far *)(&x))[_REGS-8]
#define  _ES(x)         ((int far *)(&x))[_REGS-9]

#define  _RETOFF(x)     ((int far *)(&x))[_REGS+1]
#define  _RETSEG(x)     ((int far *)(&x))[_REGS+2]

/*
** return far macros
*/

#define  RETFD(parms_count, ret_val)\
_asm    { /* return far double, when called 16:32 */ \
        _asm    mov     ax, ret_val\
        _asm    leave\
        _asm    _emit   0x66\
        _asm    retf    parms_count\
        }

/*
** Functions:
**
**      0 - draw ptr (bimodal)
**      1 - remove ptr (bimodal) uses CX (remove flag)
**      2 - free ptr mem (bimodal)
**      3 - check prot mode (prot only)
**      4 - check real mode (real only)
**      5 - get ptr mem (bimodal)
*/

enum _PTRFUNC
{
  PTRF_DRAW, PTRF_REMOVE, PTRF_FREEMEM, PTRF_CHECKP, PTRF_CHECKR, PTRF_GETMEM
} ;

enum _PTRREM
{
  PTRR_MANDATORY, PTRR_ADVISORY
} ;

VOID FAR PASCAL SAVEREGS PointerFunc(USHORT func,USHORT fRemove,UCHAR sess,
                                     PSGCB pSgcb);

/*
** prototypes
*/

/*
** Pdd entry from Vdd call
*/
VOID FAR PASCAL PddEntry(ULONG,PUSHORT,PUSHORT,ULONG);

/*
** Enables Pdd to call Vdd
*/
USHORT FAR PASCAL TouVddCall(ULONG,VOID FAR *,VOID FAR *);


VOID clc(VOID);
VOID stc(VOID);
VOID cli(VOID);
VOID sti(VOID);

USHORT FAR PASCAL SAVEREGS GetCS(VOID);
USHORT FAR PASCAL SAVEREGS GetDS(VOID);
USHORT FAR PASCAL SAVEREGS GetMSW(VOID);

/*
** end
*/
