/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = TDICALLS.H
 *
 * DESCRIPTIVE NAME = Touch device independant sub system (TdiXxx)
 *
 *
 * VERSION = V2.0
 *
 * DATE        07/12/91
 *
 * DESCRIPTION
 *             Include file for touch device independant sub system (TdiXxx)
 *             only 16:16 interface supported.
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
** Stop multiple inclusion
*/

#ifndef  TDI_INCLUDED                     /* test if included                */
#define  TDI_INCLUDED                     /* now included                    */

/*
** Sort out default interface defines for 32 & 16 calling
*/

#ifdef   INCL_32
#define  _FAR           _far16   /* force thunk from 32 bit apps to tddcalls */
#else
#define  _FAR           FAR               /* conventional 16:16 interface    */
#endif

#define  TDIENTRY       _export _pascal _FAR

/*
** File handle for touch device
*/
typedef USHORT HTDI,_FAR *PHTDI;

/*
** Open touch device
** (emulation is turned off & data is directed to the event queue)
*/
USHORT TDIENTRY TdiOpen(PHTDI);

/*
** Close touch device
** (emulation is turned back on if it was enabled originally)
*/
USHORT TDIENTRY TdiClose(HTDI);

/*
** Structure for TdiSet/GetCoordSys()
*/
typedef struct _TDICOORDSYS
{
  SHORT XMin;                             /* -32767 <= x <= +32767           */
  SHORT XMax;                             /* -32767 <= x <= +32767           */
  SHORT YMin;                             /* -32767 <= y <= +32767           */
  SHORT YMax;                             /* -32767 <= y <= +32767           */
  SHORT ZMin;                             /* -32767 <= z <= +32767           */
  SHORT ZMax;                             /* -32767 <= z <= +32767           */
  USHORT XHys;                            /* delta-x >= x-hys/1000           */
  USHORT YHys;                            /* delta-y >= y-hys/1000           */
} TDICOORDSYS, _FAR *PTDICOORDSYS;

/*
** Set/get coordinate system
*/
USHORT TDIENTRY TdiSetCoordSys(const PTDICOORDSYS,HTDI);
USHORT TDIENTRY TdiGetCoordSys(PTDICOORDSYS,HTDI);

/*
** Structure for TdiSet/GetSelectMethod()
*/
typedef struct _TDISELMETHOD
{
  USHORT Type;                      /* used by all mechanisms                */
  USHORT NumPoints;                 /* used by single-touch & stable-point   */
  USHORT Tolerance;                 /* used by single-touch & stable-point   */
  USHORT SearchLimit;               /* used only by stable-point             */
} TDISELMETHOD, _FAR *PTDISELMETHOD;

/*
** Defines for TdiSet/GetSelectMethod() type
*/
#define  TDI_SM_PUSH          0           /* default at power up             */
#define  TDI_SM_LIFTOFF       1
#define  TDI_SM_SINGLE_TOUCH  2
#define  TDI_SM_STABLE_POINT  4

/*
** Set/get selection method
*/
USHORT TDIENTRY TdiSetSelectMethod(const PTDISELMETHOD,HTDI);
USHORT TDIENTRY TdiGetSelectMethod(PTDISELMETHOD,HTDI);

/*
** Defines for TdiReadEventQueue() status & TdiSet/GetEventMask()
*/
#define  TDI_MASK_ON_SCREEN            0x0001  /* on-screen active           */
#define  TDI_MASK_TOUCH_DOWN           0x0002  /* on-screen OFF to ON        */
#define  TDI_MASK_LIFT_OFF             0x0004  /* on-screen ON to OFF        */
#define  TDI_MASK_SELECT_ON            0x0008  /* selection active           */
#define  TDI_MASK_SELECT_TURNED_ON     0x0010  /* selection OFF to ON        */
#define  TDI_MASK_SELECT_TURNED_OFF    0x0020  /* selection ON to OFF        */
/* not used                            0x0040  */
/* not used                            0x0080  */
/* not used                            0x0100  */
/* not used                            0x0200  */
/* not used                            0x0400  */
/* not used                            0x0800  */
/* not used                            0x1000  */
/* not used                            0x2000  */
/* not used                            0x4000  */
#define  TDI_MASK_DATA_ERROR           0x8000  /* data is in error           */
#define  TDI_MASK_ALL_DATA             0x803f  /* report all data            */

/*
** Defines for TdiReadEventQueue() options flag
*/
#define  TDI_READ_NOWAIT      0     /* return if no data                     */
#define  TDI_READ_WAIT        1     /* wait for data before returning        */
#define  TDI_READ_PEEK        2     /* get data, but do not change queue     */

/*
** Structure for TdiReadEventQueue()
*/
typedef struct _TDIEVENTINFO
{
  USHORT cEvents;                   /* Count of events in queue PRIOR to read */
  USHORT Status;                    /* Event status as defined in TDI_MASK_XXX*/
  ULONG Time;                       /* Time stamp of event                    */
  USHORT X;                         /* X coordinate                           */
  USHORT Y;                         /* Y coordinate                           */
  USHORT Z;                         /* Z coordinate                           */
} TDIEVENTDATA, _FAR *PTDIEVENTDATA;

/*
** Read event queue data
*/
USHORT TDIENTRY TdiReadEventQueue(PTDIEVENTDATA,USHORT,HTDI);

/*
** Set/get event mask (see TDI_MASK_ for defines)
*/
USHORT TDIENTRY TdiSetEventMask(USHORT,HTDI);
USHORT TDIENTRY TdiGetEventMask(PUSHORT,HTDI);

/*
** Set/get size of event queue (zero sets config line default)
*/
USHORT TDIENTRY TdiSetQueueSize(USHORT,HTDI);
USHORT TDIENTRY TdiGetQueueSize(PUSHORT,HTDI);

/*
** Flush event queue
*/
USHORT TDIENTRY TdiFlushQueue(HTDI);

/*
** Defines for TdiSet/GetEmulState()
*/
#define  TDI_EMUL_OFF         0
#define  TDI_EMUL_ON          1

/*
** Set/get emulation state, turns on/off emulation while touch active
*/
USHORT TDIENTRY TdiSetEmulState(USHORT,HTDI);
USHORT TDIENTRY TdiGetEmulState(PUSHORT,HTDI);

/*
** Defines for TdiXxx returns
*/
#define  TDI_NO_ERROR                  0
#define  TDI_ERR_NOT_CALIBRATED        0x19
#define  TDI_ERR_UNKNOWN_COMMAND       0x16
#define  TDI_ERR_GENERAL_FAILURE       0x1f
#define  TDI_ERR_PARAMETERS_INVALID    0x57

#endif                                         /* TDI_INCLUDED               */

/*
** end
*/
