/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = SINGLEQ.H
 *
 * DESCRIPTIVE NAME = Single queue device driver support
 *
 *
 * VERSION = V2.0
 *
 * DATE        07/12/91
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
** Single Queue -  equates
*/

#define  Que_Header_Size      8


/*
** Single Queue - devices (AH)
*/

#define  SQ_DEV_KDB           1
#define  SQ_DEV_MOU           2


/*
** Single Queue - functions (BL)
*/

#define  SQ_FUNC_INIT         1
/*
** ah = device
** al = 0
** bh = 0 - FIFO buffer ???
** bl = 1
** cx = total byte count
*/

#define  SQ_FUNC_WRITE        2
#define  SQ_FUNC_UPDATE       4
/*
** ah = device
** al = data record size
** bh = time stamp offset
** bl = 2/4
** ch = reserve byte count
** cl = free byte count
** ds:si = data ptr
** es = data segment
*/

#define  SQ_FUNC_END          3
/*
** ah = device
** al = 0
** bh = 0
** bl = 3
*/

/*
** Single Queue - error return codes (CY set, AX)
*/

#define  SQ_NO ERROR                   0     /* CY clear                    */
#define  ERROR_SQ_ALREADY_ACTIVE       1
#define  ERROR_SQ_ALREADY_CALLED       2
#define  ERROR_SQ_BUFFER_ERROR         3
#define  ERROR_SQ_GDT_FAILURE          4
#define  ERROR_SQ_INSUF_SPACE          5
#define  ERROR_SQ_INVALID_ID           6
#define  ERROR_SQ_INVALID_QUEUE_MODE   7
#define  ERROR_SQ_INVALID_SEMAPHORE    8
#define  ERROR_SQ_NOT_ACTIVE           9
#define  ERROR_SQ_NOT_IN_MODE          10
#define  ERROR_SQ_ID_USED              11
#define  ERROR_SQ_UNKNOWN_FUNCTION     12
#define  ERROR_SQ_GENERAL_FAILURE      13

/*
** end
*/
