/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = REQBLK.H
 *
 * DESCRIPTIVE NAME = Include file for strategy requests
 *
 *
 * VERSION = V2.0
 *
 * DATE        07/12/91
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#ifndef  REQBLK_INCLUDED
#define  REQBLK_INCLUDED

/*
** defines & enums
*/

/*
** request block functions
*/

enum _REQF
{
  REQF_INIT   = 0x00,
  REQF_IFLUSH = 0x07,
  REQF_OPEN   = 0x0D,
  REQF_CLOSE,
  REQF_IOCTL  = 0x10,
  REQF_DEINS  = 0x14,
  REQF_SHTDWN = 0x1c
} ;

/*
** request block status values
*/

#define  REQS_NOERROR   0              /* no error                           */
#define  REQS_EMSK      0x00ff         /* error mask                         */
#define  REQS_DONE      0x0100         /* done                               */
#define  REQS_BUSY      0x0200         /* busy                               */
/* reserved             0x0400 */
/* reserved             0x0800 */
/* reserved             0x1000 */
/* reserved             0x2000 */
#define  REQS_DEVERR    0x4000         /* dev error                          */
#define  REQS_ERROR     0x8000         /* error                              */

/* request block status, error returns*/

#define  REQE_NOTRDY    0x8002         /* not ready                          */
#define  REQE_UCMD      0x8003         /* unknown cmd                        */
#define  REQE_SEEK      0x8006         /* seek error                         */
#define  REQE_GENF      0x800c         /* general failure                    */
#define  REQE_CHARINT   0x8011         /* char i/o interrupted               */
#define  REQE_NOMON     0x8012         /* monitors not supported             */
#define  REQE_PARM      0x8013         /* invalid params                     */
#define  REQE_DIU       0x8014         /* device in use                      */
#define  REQE_ABORT     0x802f         /* abort DD load                      */
#define  REQE_CPARMS    0x804f         /* config parms                       */
#define  REQE_INIT      0x808f         /* init error, shutdown DD            */

/*
** ioctl category codes
*/

#define  IOC_CAT_TOU    129            /* touch                              */
#define  IOC_CAT_MON    10             /* monitors                           */
#define  IOC_CAT_GEN    11             /* general                            */

/*
** device header attributes
*/

#define  HDR_KBD        0x0001         /* STDIN device                       */
#define  HDR_SCR        0x0002         /* STDOUT device                      */
#define  HDR_NUL        0x0004         /* NUL device                         */
#define  HDR_CLK        0x0008         /* CLOCK device                       */
/* reserved             0x0010 */
/* reserved             0x0020 */
/* reserved             0x0040 */
#define  HDR_LVL1       0x0080         /* function level 1 - OS/2 1.0, 1.1   */
#define  HDR_LVL2       0x0100         /* 2 - OS/2 1.2                       */
#define  HDR_LVL4       0x0200         /* 3 - OS/2 2.0 ?                     */
/* reserved             0x0400 */
#define  HDR_OPN        0x0800         /* char: open/close needed, block:
                                                removable                    */
#define  HDR_SHR        0x1000         /* char: shared device access checking*/
#define  HDR_IBM        0x2000         /* char: o/p till busy, block: non-ibm
                                                media                        */
#define  HDR_IDC        0x4000         /* idc supported                      */
#define  HDR_CHR        0x8000         /* character device driver            */
#define  HDR_LVL_SHFT   7

/*
** typedefs
*/

#pragma     pack(1)                    /* set pack size of 1                 */

/*
** device header record
** fddentry must be cdecl as regs macros are used from touasm
*/
#define  FDDENTRY      VOID FAR CDECL SAVEREGS
#define  NDDENTRY      VOID NEAR CDECL SAVEREGS
typedef VOID(NEAR CDECL SAVEREGS *NPDDENTRY)();

typedef struct _DEVHDR DEVHDR,FAR *PDEVHDR;
struct _DEVHDR
{
  PDEVHDR link;
  USHORT attribute;
  NPDDENTRY strat_entry;
  NPDDENTRY idc_entry;
  UCHAR name[8];
  USHORT prot_cs;
  USHORT prot_ds;
  USHORT real_cs;
  USHORT real_ds;
} ;

typedef struct
{
  BYTE length;
  BYTE unit;
  BYTE cmd;
  USHORT status;
  VOID FAR *dos_link;
  VOID FAR *dev_link;
  /* command specific data */
  union
  {
    struct
    {
      BYTE data1;
      VOID (FAR PASCAL *dev_hlp)();
      VOID FAR *init_args;
      BYTE units;
    } init_in;

    struct
    {
      BYTE units;
      VOID NEAR *code_end;
      VOID NEAR *data_end;
      VOID FAR *pBPB;
      BYTE data2;
    } init_out;

    struct
    {
      USHORT sfn;                      /* system file number                 */
    } open_close;

    struct
    {
      BYTE category;
      BYTE function;
      /* could use PPARMS & PDATA which are unions of all parm/data types    */
      /*      by including appropriate os2?.h file                           */
      VOID FAR *pParms;
      VOID FAR *pData;
      USHORT sfn;                      /* system file number                 */

    #if DD_LEVEL >= 2
      USHORT cbParms;                  /* bytes in parms pkt                 */
      USHORT cbData;                   /* bytes in data pkt                  */
    #endif                             /*                                    */
    } ioctl;

  } ;

} FAR *PREQBLK;

/*
** ioctl parm/data word/pointer extraction macros, index with byte offset
*/
#define  IOC_PARMW(x,y)  (USHORT)((PUCHAR)(x->ioctl.pParms)[y])
#define  IOC_DATAW(x,y)  (USHORT)((PUCHAR)(x->ioctl.pData)[y])
/* ??#define IOC_PARMP(x,y)     *(VOID FAR *)&((PUCHAR)(x->ioctl.pParms)[y]) */
/* ??#define IOC_DATAP(x,y)     *(VOID FAR *)&((PUCHAR)(x->ioctl.pData)[y])  */

#pragma  pack()                       /* restore default setting             */

#endif                                /* REQBLK_INCLUDED                     */

/*
** end
*/
