/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = DEVHLP.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE        07/12/91
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
/*
** DHVMAlloc Flags
*/

#define  DH_VMA_BELOW_16M     0x01
#define  DH_VMA_FIXED         0x02
#define  DH_VMA_SWAPPABLE     0x04    /* DH_VMA_FIXED must NOT be set        */
#define  DH_VMA_CONTIGUOUS    0x08
#define  DH_VMA_LINEAR        0x10
#define  DH_VMA_PROCESS       0x20
#define  DH_VMA_REGISTER      0x40    /* DH_VMA_PROCESS must be set          */
#define  DH_VMA_VIRTUAL       0x80

/*
** DHGetDOSVar Ordinals
*/

enum _GDVORD
{
  GDV_GlobalInfoSeg = 1, GDV_LocalInfoSeg, GDV_Reserved3, GDV_VectorSDF,
     GDV_VectorReboot, GDV_VectorMSATS, GDV_YieldFlag, GDV_TCYieldFlag,
     GDV_Reserved9, GDV_Reserved10, GDV_VectorCPTag
} ;

/*
** DHVerifyAccess Read/Write Defines
*/

#define  DH_VA_RD             (UCHAR)0        /* read only access            */
#define  DH_VA_RW             (UCHAR)1        /* read/write access           */

/*
** DHBeep Function Defines
*/

#define  DH_BP_OFF            0       /* stop beeper                         */
#define  DH_BP_ON             1       /* start beeper                        */
#define  DH_BP_FREQ           2       /* define frequency for on/off         */
#define  DH_BP_TIMED          3       /* use frequency & duration supplied   */

/*
** typedefs
*/

/*
** ???NOT ANY MORE??? Use loadds as may not be called with DS set to DGROUP
**      could declare DevHlp_Entry as extern far in devhlp.c
*/
#define  DHENTRY       FAR PASCAL

typedef struct
{
  VOID(FAR *RealEntry)();
  SEL RealDS;
  VOID(FAR *ProtEntry)();
  SEL ProtDS;
} IDC, FAR *PIDC, NEAR *NPIDC;

typedef struct
{
  ULONG Lin;
  union
  {
    ULONG Virt;
    struct
    {
      USHORT VirtOff;
      USHORT VirtSel;
    } ;

  } ;

} MEM, FAR *PMEM;

/*
** prototypes
*/

USHORT DHENTRY DHVerifyAccess(VOID FAR *pMem,USHORT Len,UCHAR Type);
VOID   FAR *DHENTRY DHGetDOSVar(UCHAR Ord);
USHORT DHENTRY DHBlock(VOID FAR *EventId,ULONG Time,UCHAR fInt);
USHORT DHENTRY DHRun(VOID FAR *EventId);
USHORT DHENTRY DHAttachDD(PSZ Name,PIDC pIdc);
USHORT DHENTRY DHRegisterPDD(PSZ name,USHORT(FAR PASCAL *func)());
USHORT DHENTRY DHSemRequest(VOID FAR *psem,ULONG time);
USHORT DHENTRY DHDevDone(PREQBLK pReqBlk);
USHORT DHENTRY DHDeRegister(USHORT pid,USHORT handle,PUSHORT pnum);
USHORT DHENTRY DHRegister(BYTE FAR *pIBuf,BYTE FAR *pOBuf,USHORT pid,
                          USHORT handle,UCHAR flag);
USHORT DHENTRY DHMonitorCreate(PMONBUF pBuf,PFVOID pfnNotify,PUSHORT pHandle);
USHORT DHENTRY DHMonitorDestroy(USHORT Handle);
USHORT DHENTRY DHMonWrite(PMONREC pRec,USHORT Count,USHORT Handle,UCHAR fWait);
USHORT DHENTRY DHMonFlush(USHORT Handle);
USHORT DHENTRY DHSemClear(VOID FAR *psem);
VOID   DHENTRY DHBeep(USHORT func,USHORT freq,USHORT durat);
ULONG  DHENTRY DHVMFree(LIN32 linAddr);
ULONG  DHENTRY DHVMAlloc(ULONG Flags,ULONG Size,LIN32 pPhysAddr,PMEM pMem);
ULONG  DHENTRY DHVirtToLin(VOID FAR *sel_off,PLIN32 pLin);
VOID   DHENTRY DHInternalError(PSZ msg_txt,USHORT msg_len);

/*
** end
*/
