;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = TOUIOCTL.ASM
;*
;* DESCRIPTIVE NAME =
;*
;*
;* VERSION      V2.0
;*
;* DATE         07/12/91
;*
;* DESCRIPTION
;*
;* FUNCTIONS    ioc_read_data,      ioc_set_mode,       ioc_get_mode,
;*              ioc_read_mem,       ioc_write_mem,      ioc_set_mpi,
;*              ioc_get_mpi,        ioc_set_cc,         ioc_get_cc,
;*              ioc_set_rate,       ioc_get_rate,       ioc_set_thresh,
;*              ioc_get_thresh,     ioc_set_filter,     ioc_get_filter,
;*              ioc_set_offset,     ioc_get_offset,     ioc_set_click,
;*              ioc_get_click,      thre_scale_z2p,     thre_calc_lift_off,
;*              set_thresholds,     set_report_rate,    set_filters,
;*              ioc_set_beep,       ioc_get_beep,       ioc_set_emul,
;*              ioc_get_emul.
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*****************************************************************************/

if 1
.286p

.seq
DSEG    segment para public 'DATA'
DSEG    ends
CSEG    segment para public 'CODE'
CSEG    ends

.xlist
.xcref

include struc.inc
include proc.inc

include toudderr.inc
include touequ.inc
include toustruc.inc
include toumacro.inc


extrn   _def_emul:byte
extrn   _def_beep:byte
extrn   _glass_mpi:word
extrn   _clk_size:word
extrn   _clk_time:word
extrn   _clk_type:byte
extrn   _filter_parms:byte
extrn   _thre_oth_z:word
extrn   _thre_phy_z:word
extrn   _thre_pth_z:word
extrn   thresh_p:byte
extrn   _report_rate:byte
extrn   _y_offset:word
extrn   _x_offset:word
extrn   calib_cons:byte
extrn   eq_base:byte
extrn   eq_end:word
extrn   eq_size:word
extrn   eq_head:word
extrn   emul_mode:byte
extrn   beep_mode:byte
extrn   has_been_calib:byte
extrn   filt_table:byte
extrn   raw_mode:byte
extrn   thre_scale_fact:word
extrn   coord_sys:byte
extrn   rates:byte
extrn   set_raw_mode:near
extrn   dev_status:word
extrn   set_xyz_mode:near
extrn   prescott_io:near
extrn   prescott_io_resp:byte
extrn   essi2dsdi:near
extrn   conf_data:byte


CSEG    segment
        assume  cs:CSEG, ds:DSEG
endif


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_read_data
;*
;* DESCRIPTION   = IOCtl Read xyz/raw data
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_read_data
PROCEDURE       ioc_read_data   near
VARIABLE        temp_es         word
VARIABLE        temp_bx         word
        BEGINPROC

        mov     temp_es, es
        mov     temp_bx, bx

        ;*
        ;* Return: C,S,X,Y,Z or C,S,T1,T2,T3,T4
        ;*

        les     di, es:[bx].req_data.ioctl_data

        cli

        mov     ax, eq_size

        stosw                           ; save queue size in first element

        .if     <nonzero ax>
                ;*
                ;* data available
                ;*

                ;*
                ;* copy queue data to user elements after count
                ;*
                mov     si, eq_head

                cld
                mov     cx, size DBUF
                rep     movsb

                ;*
                ;* update Q size & head
                ;*
                dec     eq_size
                mov     eq_head, si

                ;*
                ;* test for Q head ptr wrap
                ;*
                .if     <eq_head ae <offset eq_end>>
                        ;*
                        ;* head ptr wrapped
                        ;*

                        ;*
                        ;* update head with base
                        ;*
                        mov     eq_head, offset eq_base

                .endif                  ; head wrap test

        .endif                          ; queue empty test

        sti

        mov     es, temp_es
        mov     bx, temp_bx

FREEVAR temp_es
FREEVAR temp_bx

ENDPROC         ioc_read_data


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_set_mode
;*
;* DESCRIPTION   = IOCtl set raw/xyz data mode
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_set_mode
PROCEDURE       ioc_set_mode    near
VARIABLE        temp_es         word
VARIABLE        temp_bx         word
        BEGINPROC

        mov     temp_es, es
        mov     temp_bx, bx

        les     di, es:[bx].req_data.ioctl_parms

        .if     <bit <word ptr es:[di].wparm0> and 1>
                ;*
                ;* set raw mode
                ;*
                call    set_raw_mode
        .else
                ;*
                ;* set xyz mode
                ;*
                .if     <bit dev_status nand DEVS_DCC>
                        stc             ; fail if trying to set xyz & not
                                        ;   calibrated
                .else
                        call    set_xyz_mode
                .endif
        .endif

        .if     <c>
                SET_REQSTAT     STAT_GENF
        .endif

        mov     es, temp_es
        mov     bx, temp_bx

FREEVAR temp_es
FREEVAR temp_bx

ENDPROC         ioc_set_mode


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_get_mode
;*
;* DESCRIPTION   = IOCtl Get xyz/raw data mode
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_get_mode
PROCEDURE       ioc_get_mode    near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        les     di, es:[bx].req_data.ioctl_data

        mov     al, raw_mode
        xor     ah, ah
        mov     es:[di].wparm0, ax

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_get_mode


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_read_mem
;*
;* DESCRIPTION   = IOCtl Read from Memory
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_read_mem
PROCEDURE       ioc_read_mem    near
VARIABLE        temp_es         word
VARIABLE        temp_bx         word
        BEGINPROC

        mov     temp_es, es
        mov     temp_bx, bx

        push    PIO_READ_MEM
        push    es:[bx].req_data.ioctl_parms.xseg       ; ptr to addr
        push    es:[bx].req_data.ioctl_parms.xoff
        call    prescott_io
        .if     <c>
                SET_REQSTAT     STAT_GENF
        .else
                ;*
                ;* command succeded
                ;*

                les     di, es:[bx].req_data.ioctl_data

                ;*
                ;* get response & move to target
                ;*
                mov     al, prescott_io_resp            ; get response data
                mov     byte ptr es:[di], al            ; save it

        .endif

        mov     es, temp_es
        mov     bx, temp_bx

FREEVAR temp_es
FREEVAR temp_bx

ENDPROC         ioc_read_mem


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_write_mem
;*
;* DESCRIPTION   = IOCtl Write to Memory
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_write_mem
PROCEDURE       ioc_write_mem   near
VARIABLE        temp_es         word
VARIABLE        temp_bx         word
        BEGINPROC

        mov     temp_es, es
        mov     temp_bx, bx

        push    PIO_WRITE_MEM
        push    es:[bx].req_data.ioctl_parms.xseg       ;  ptr to data+addr
        push    es:[bx].req_data.ioctl_parms.xoff
        call    prescott_io
        .if     <c>
                SET_REQSTAT     STAT_GENF
        .endif

        mov     es, temp_es
        mov     bx, temp_bx

FREEVAR temp_es
FREEVAR temp_bx

ENDPROC         ioc_write_mem


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_set_mpi
;*
;* DESCRIPTION   = IOCtl Set Mickeys per Inch
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_set_mpi
PROCEDURE       ioc_set_mpi     near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        les     di, es:[bx].req_data.ioctl_parms

        mov     ax, es:[di].wparm0

        .if     <ax eq SET_DEFAULTS>
                mov     ax, DEF_USER_MPI
        .endif
        mov     _glass_mpi, ax

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_set_mpi


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_get_mpi
;*
;* DESCRIPTION   = IOCtl Get Mickeys per Inch
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_get_mpi
PROCEDURE       ioc_get_mpi     near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        les     di, es:[bx].req_data.ioctl_data

        mov     ax, _glass_mpi
        mov     es:[di].wparm0, ax

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_get_mpi


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_set_cc
;*
;* DESCRIPTION   = IOCtl Set Calibration Constants
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_set_cc
PROCEDURE       ioc_set_cc      near
VARIABLE        temp_es         word
VARIABLE        temp_bx         word
        BEGINPROC

        mov     temp_es, es
        mov     temp_bx, bx

        les     di, es:[bx].req_data.ioctl_parms

        ;*
        ;* ckeck for duff constants
        ;*
        mov     cx, 20                  ; words
        xor     ax, ax                  ; checking for zeros
        repe    scasw                   ; rep while equal, find non-zero
        .if     <e>
                ;*
                ;* constants all zero
                ;*

                ;*
                ;* downloading duff const so un-set calibrated flags
                ;*
                and     dev_status, not DEVS_DCC
                and     conf_data.conf_tou_stat, not TS_CALIBRATED

                ;*
                ;* tell didd not calibrated
                ;*
;* ??           XIDC_UPDCONF    dddd_idc, dev_status

        .else
                ;*
                ;* constants not all zeros
                ;*

                ;*
                ;* only download if good constants
                ;*
                mov     es, temp_es

                push    PIO_SET_CALIB
                push    es:[bx].req_data.ioctl_parms.xseg
                push    es:[bx].req_data.ioctl_parms.xoff
                call    prescott_io
                .if     <c>
                        SET_REQSTAT     STAT_GENF
                        jmp     short dcc_exit
                .endif

                ;*
                ;* show constants have been downloaded, even if they are
                ;* not perfect, this allows set-xyz-mode to take place
                ;*
                mov     has_been_calib, 1

                ;*
                ;* download successful so set calibrated flags
                ;*
                or      dev_status, DEVS_DCC
                or      conf_data.conf_tou_stat, TS_CALIBRATED

        .endif                          ; duff/good calib cons

        ;*
        ;* save calibration constants (for a later get)
        ;*

        mov     es, temp_es
        mov     bx, temp_bx

        les     si, es:[bx].req_data.ioctl_parms
        mov     di, offset calib_cons
        mov     cx, 40                  ; 20 WORDS
        call    essi2dsdi

        mov     es, temp_es
        mov     bx, temp_bx

dcc_exit:

FREEVAR temp_es
FREEVAR temp_bx

ENDPROC ioc_set_cc


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_get_cc
;*
;* DESCRIPTION   = IOCtl Get Calibration Constants
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_get_cc
PROCEDURE       ioc_get_cc      near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        mov     si, offset calib_cons
        les     di, es:[bx].req_data.ioctl_data

        ;*
        ;* move data to target
        ;*
        mov     cx, 20                  ; WORDS
        cld
        rep     movsw                   ; ds:si -> es:di

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_get_cc


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_set_rate
;*
;* DESCRIPTION   = IOCtl Set data report rate
;*
;*
;* INPUT         = es:bx -> request block
;*    Parameter packet:
;*          Report rate             WORD
;*                  Value:
;*                  0 - 10 reports per sec
;*                  1 - 20 reports per sec
;*                  2 - 30 reports per sec
;*                  3 - 40 reports per sec
;*                  4 - 60 reports per sec
;*                  All other values reserved
;*    Data packet:
;*          none
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_set_rate
PROCEDURE       ioc_set_rate    near
VARIABLE        temp_es         word
VARIABLE        temp_bx         word
        BEGINPROC

        mov     temp_es, es
        mov     temp_bx, bx

        ;*
        ;* get parms pkt addr
        ;*
        les     di, es:[bx].req_data.ioctl_parms

        mov     ax, es:[di].wparm0
        .if     <ax eq SET_DEFAULTS>
                mov     al, DEF_REP_RATE
        .endif
        mov     _report_rate, al

        call    set_report_rate
        .if     <c>
                SET_REQSTAT     STAT_GENF
        .endif

        mov     es, temp_es

FREEVAR temp_es
FREEVAR temp_bx

ENDPROC         ioc_set_rate


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_get_rate
;*
;* DESCRIPTION   = IOCtl Get data report rate
;*
;*
;* INPUT         = es:bx -> request block
;*    Parameter packet:
;*          none
;*    Data packet:
;*          Report rate             WORD
;*                  Value:
;*                  0 - 10 reports per sec
;*                  1 - 20 reports per sec
;*                  2 - 30 reports per sec
;*                  3 - 40 reports per sec
;*                  4 - 60 reports per sec
;*                  All other values reserved
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = This function returns to the caller the current report rate
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_get_rate
PROCEDURE       ioc_get_rate    near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        ;*
        ;* get data pkt addr
        ;*
        les     di, es:[bx].req_data.ioctl_data

        mov     al, _report_rate
        xor     ah, ah
        mov     es:[di].wparm0, ax

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_get_rate


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_set_thresh
;*
;* DESCRIPTION   = IOCtl Set thresholds
;*
;*
;* INPUT         = es:bx -> request block
;*    Parameter packet:
;*          On screen threshold     WORD
;*          Push hysteresis (z)     WORD
;*          Push threshold  (z)     WORD
;*    Data packet:
;*          none
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_set_thresh
PROCEDURE       ioc_set_thresh  near
VARIABLE        temp_es         word
VARIABLE        temp_bx         word
        BEGINPROC

        mov     temp_es, es
        mov     temp_bx, bx

        ;*
        ;* get parms pkt addr
        ;*
        les     di, es:[bx].req_data.ioctl_parms

        mov     ax, es:[di].wparm0
        .if     <ax eq SET_DEFAULTS>
                mov     ax, DEF_THRE_OTH_Z
        .endif
        mov     _thre_oth_z, ax

        mov     ax, es:[di].wparm1
        .if     <ax eq SET_DEFAULTS>
                mov     ax, DEF_THRE_PHY_Z
        .endif
        mov     _thre_phy_z, ax

        mov     ax, es:[di].wparm2
        .if     <ax eq SET_DEFAULTS>
                mov     ax, DEF_THRE_PTH_Z
        .endif
        mov     _thre_pth_z, ax

        call    set_thresholds
        .if     <c>
                SET_REQSTAT     STAT_GENF
        .endif

        mov     es, temp_es

FREEVAR temp_es
FREEVAR temp_bx

ENDPROC         ioc_set_thresh


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_get_thresh
;*
;* DESCRIPTION   = IOCtl Get thresholds
;*
;*
;* INPUT         = es:bx -> request block
;*    Parameter packet:
;*          none
;*    Data packet:
;*          On screen threshold     WORD
;*          Push hysteresis (z)     WORD
;*          Push threshold  (z)     WORD
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = This function returns to the caller the current
;*                 threshold values in terms of Z
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_get_thresh
PROCEDURE       ioc_get_thresh  near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        ;*
        ;* get data pkt addr
        ;*
        les     di, es:[bx].req_data.ioctl_data

        mov     ax, _thre_oth_z
        mov     es:[di].wparm0, ax

        mov     ax, _thre_phy_z
        mov     es:[di].wparm1, ax

        mov     ax, _thre_pth_z
        mov     es:[di].wparm2, ax

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_get_thresh


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_set_filter
;*
;* DESCRIPTION   = IOCtl Set Filter Parameters
;*
;*
;* INPUT         = es:bx -> request block
;*    Parameter packet:
;*          none
;*    Data packet:
;*          none
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_set_filter
PROCEDURE       ioc_set_filter  near
VARIABLE        temp_es         word
VARIABLE        temp_bx         word
        BEGINPROC

        mov     temp_es, es
        mov     temp_bx, bx

        ;*
        ;* get parms pkt addr
        ;*
        les     di, es:[bx].req_data.ioctl_parms

        mov     ax, es:[di].wparm0
        .if     <ax eq SET_DEFAULTS>
                mov     ax, DEF_FILT_TYPE
        .endif
        mov     _filter_parms.fp_type, ax

        mov     ax, es:[di].wparm1
        .if     <ax eq SET_DEFAULTS>
                mov     ax, DEF_FILT_FREQ
        .endif
        mov     _filter_parms.fp_freq, ax


        call    set_filters
        .if     <c>
                SET_REQSTAT     STAT_GENF
        .endif

        mov     es, temp_es

FREEVAR temp_es
FREEVAR temp_bx

ENDPROC         ioc_set_filter


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_get_filter
;*
;* DESCRIPTION   = IOCtl Get Filter Parameters
;*
;*
;* INPUT         = es:bx -> request block
;*    Parameter packet:
;*          none
;*    Data packet:
;*          none
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_get_filter
PROCEDURE       ioc_get_filter  near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        ;*
        ;* get data pkt addr
        ;*
        les     di, es:[bx].req_data.ioctl_data

        mov     ax, _filter_parms.fp_type
        mov     es:[di].wparm0, ax

        mov     ax, _filter_parms.fp_freq
        mov     es:[di].wparm1, ax

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_get_filter


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_set_offset
;*
;* DESCRIPTION   = IOCtl Set XY offset
;*
;*
;* INPUT         = es:bx -> request block
;*    Parameter packet:
;*          X offset                WORD
;*          Y offset                WORD
;*    Data packet:
;*          none
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_set_offset
PROCEDURE       ioc_set_offset  near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        ;*
        ;* get parms pkt addr
        ;*
        les     di, es:[bx].req_data.ioctl_parms

        mov     ax, es:[di].wparm0
        .if     <ax eq SET_DEFAULTS>
                mov     ax, DEF_X_OFFSET
        .endif
        mov     _x_offset, ax

        mov     ax, es:[di].wparm1
        .if     <ax eq SET_DEFAULTS>
                mov     ax, DEF_Y_OFFSET
        .endif
        mov     _y_offset, ax

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_set_offset


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_get_offset
;*
;* DESCRIPTION   = IOCtl Get XY offset
;*
;*
;* INPUT         = es:bx -> request block
;*    Parameter packet:
;*          none
;*    Data packet:
;*          X offset                WORD
;*          Y offset                WORD
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_get_offset
PROCEDURE       ioc_get_offset  near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        ;*
        ;* get data pkt addr
        ;*
        les     di, es:[bx].req_data.ioctl_data

        mov     ax, _x_offset
        mov     es:[di].wparm0, ax

        mov     ax, _y_offset
        mov     es:[di].wparm1, ax

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_get_offset


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_set_click
;*
;* DESCRIPTION   = IOCtl Set Click Locking Data
;*
;*
;* INPUT         = es:bx -> request block
;*    Parameter packet:
;*          Click size              WORD
;*          Click time              WORD
;*          Click type              BYTE
;*    Data packet:
;*          none
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_set_click
PROCEDURE       ioc_set_click   near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        ;*
        ;* get parms pkt addr
        ;*
        les     di, es:[bx].req_data.ioctl_parms

        mov     ax, es:[di].wparm0
        .if     <ax eq SET_DEFAULTS>
                mov     ax, DEF_CLK_SIZE
        .endif
        mov     _clk_size, ax

        mov     ax, es:[di].wparm1
        .if     <ax eq SET_DEFAULTS>
                mov     ax, DEF_CLK_TIME
        .endif
        mov     _clk_time, ax

        mov     ax, es:[di].wparm2
        .if     <ax eq SET_DEFAULTS>
                mov     al, DEF_CLK_TYPE
        .endif
        mov     _clk_type, al

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_set_click


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_get_click
;*
;* DESCRIPTION   = IOCtl Get Click Locking Data
;*
;*
;* INPUT         = es:bx -> request block
;*    Parameter packet:
;*          none
;*    Data packet:
;*          Click size              WORD
;*          Click time              WORD
;*          Click type              BYTE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_get_click
PROCEDURE       ioc_get_click   near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        ;*
        ;* get data pkt addr
        ;*
        les     di, es:[bx].req_data.ioctl_data

        mov     ax, _clk_size
        mov     es:[di].wparm0, ax

        mov     ax, _clk_time
        mov     es:[di].wparm1, ax

        mov     al, _clk_type
        xor     ah, ah
        mov     es:[di].wparm2, ax

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_get_click


;/***************************************************************************
;*
;* FUNCTION NAME = thre_scale_z2p
;*
;* DESCRIPTION   = Scale Touch Values (in terms of Z) to prescott threshold
;*                 system
;*    scaled_val = (orig_val - zmin) * scale_fact / (zmax - zmin + 1)
;*
;*
;* INPUT         = ax - value to convert (ito z)
;*                 cx - zmin
;*                 dx - zmax
;*
;* OUTPUT        = ax - scaled value (ito p)
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          thre_scale_z2p
thre_scale_z2p  proc    near

        push    cx
        push    dx

        sub     ax, cx                  ; ax -= zmin

        ;*
        ;* cx := zmax-zmin
        ;*
        sub     cx, dx                  ; cx := zmin-zmax
        neg     cx                      ; cx := zmax-zmin
        inc     cx                      ; delta z = zmax-zmin+1

        mul     thre_scale_fact         ; dx:ax := ax*scale_fact

        div     cx                      ; ax /= (delta z)

        pop     dx
        pop     cx

        ret

thre_scale_z2p          endp


;/***************************************************************************
;*
;* FUNCTION NAME = thre_calc_lift_off
;*
;* DESCRIPTION   = Calculate Lift-off Threshold
;*       LiftOff = phy - (phy - oth) / 8
;*
;*
;* INPUT         = ax = on-screen threshold (ito z)
;*                 cx = push hysteresis (ito z)
;*
;* OUTPUT        = ax = lift off threshold in terms of z
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public                  thre_calc_lift_off
thre_calc_lift_off      proc    near

        sub     ax, cx                  ; ax = oth-phy
        neg     ax                      ; ax = phy-oth
        shr     ax, 3                   ; / 8
        adc     ax, 0                   ; round up
        .if     <zero ax>
                inc     ax              ; force: off < phy
        .endif
        sub     ax, cx
        neg     ax                      ; ax = phy-ax

        ret

thre_calc_lift_off      endp


;/***************************************************************************
;*
;* FUNCTION NAME = set_thresholds
;*
;* DESCRIPTION   = Set Thresholds from data area
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public  set_thresholds
set_thresholds  proc    near

        pusha

        mov     cx, coord_sys.csys_z_min
        mov     dx, coord_sys.csys_z_max

        mov     ax, _thre_oth_z
        call    thre_scale_z2p
        mov     thresh_p.thre_oth, ax

        mov     ax, _thre_phy_z
        call    thre_scale_z2p
        mov     thresh_p.thre_phy, ax

        mov     ax, _thre_pth_z
        call    thre_scale_z2p
        mov     thresh_p.thre_pth, ax

        mov     ax, _thre_oth_z
        mov     cx, _thre_phy_z
        call    thre_calc_lift_off

        mov     cx, coord_sys.csys_z_min
        mov     dx, coord_sys.csys_z_max
        call    thre_scale_z2p
        mov     thresh_p.thre_off, ax

        mov     ax, offset thresh_p

        push    PIO_LD_THRE
        push    ds
        push    ax
        call    prescott_io

        popa

        ret

set_thresholds  endp


;/***************************************************************************
;*
;* FUNCTION NAME = set_report_rate
;*
;* DESCRIPTION   = Set Report Rate form data area
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public  set_report_rate
set_report_rate proc    near

        pusha

        mov     bl, _report_rate
        xor     bh, bh
        lea     ax, rates[bx]

        push    PIO_SET_SAMPLE
        push    ds
        push    ax
        call    prescott_io

        popa

        ret

set_report_rate endp


;/***************************************************************************
;*
;* FUNCTION NAME = set_filters
;*
;* DESCRIPTION   = Set Filter Paramters form data area
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public  set_filters
set_filters     proc    near

        pusha

        ;*
        ;* calculate filter const offset
        ;*
        mov     ax, _filter_parms.fp_type
        mov     cx, FILT_F_MAX+1
        mul     cx

        .if     <nonzero dx>
                stc
                jmp     short set_filters_exit
        .endif

        add     ax, _filter_parms.fp_freq
        mov     cx, size FILT
        mul     cx

        .if     <nonzero dx>
                stc
                jmp     short set_filters_exit
        .endif

        add     ax, offset filt_table

        push    PIO_SET_FILT
        push    ds
        push    ax
        call    prescott_io
        .if     <c>
                jmp     short set_filters_exit
        .endif

        ;*
        ;* ax value preserved from above if no errors
        ;* bump ax to feed forward data
        ;*
        add     ax, filt_fdfwd - filt_parms

        push    PIO_SET_FDFWD
        push    ds
        push    ax
        call    prescott_io

set_filters_exit:

        popa

        ret

set_filters     endp


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_set_beep
;*
;* DESCRIPTION   = IOCtl Set Emulation Beeper Default & Current Mode
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_set_beep
PROCEDURE       ioc_set_beep    near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        les     di, es:[bx].req_data.ioctl_parms

        mov     ax, es:[di].wparm0
        .if     <ax eq SET_DEFAULTS>
                mov     ax, 1
        .endif
        mov     beep_mode, al           ; set current
        mov     _def_beep, al           ; set default

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_set_beep


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_get_beep
;*
;* DESCRIPTION   = IOCtl Get Emulation Beeper Default mode
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_get_beep
PROCEDURE       ioc_get_beep    near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        les     di, es:[bx].req_data.ioctl_data

        mov     al, _def_beep
        xor     ah, ah
        mov     es:[di].wparm0, ax

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_get_beep


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_set_emul
;*
;* DESCRIPTION   = IOCtl Set Emulation State Default & Current Mode
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_set_emul
PROCEDURE       ioc_set_emul    near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        les     di, es:[bx].req_data.ioctl_parms

        mov     ax, es:[di].wparm0
        .if     <ax eq SET_DEFAULTS>
                mov     ax, 1
        .endif
        mov     emul_mode, al           ; set current
        mov     _def_emul, al           ; set default

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_set_emul


;/***************************************************************************
;*
;* FUNCTION NAME = ioc_get_emul
;*
;* DESCRIPTION   = IOCtl Get Emulation State Default mode
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public          ioc_get_emul
PROCEDURE       ioc_get_emul    near
VARIABLE        temp_es         word
        BEGINPROC

        mov     temp_es, es

        les     di, es:[bx].req_data.ioctl_data

        mov     al, _def_emul
        xor     ah, ah
        mov     es:[di].wparm0, ax

        mov     es, temp_es

FREEVAR temp_es

ENDPROC         ioc_get_emul


CSEG    ends

        end

;*
;* end
;*
