;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)testcfga.inc       6.1 92/01/09

;*** TESTCFGA.INC - TESTCFG Device Driver Assemby Include file
;*
;*
;*
;*
;*   DESCRIPTION
;*
;*     DEVHLP equates and macros
;*
;*   MODIFICATION HISTORY
;*
;* 6.1  01/15/92 CP20 B731???  Jeff Muir   Original Version
;*


; [bp+base] is the first parameter on the stack for the assembly
; routines if being called from C.  base can be changed for near or far.
; base is 4 for near calls, 6 for far.
nbase       equ     4
fbase       equ     6

;
;  APM_Info structure
;
APM_Info struc
   APM_CodeSeg     DW      ?
   APM_DataSeg     DW      ?
   APM_Offset      DW      ?
   APM_Flags       DW      ?
   APM_Level       DW      ?
   APM_IdleHookRtn DF      ?
APM_Info ends


;
; Simple macro to guarantee far c entry point for assembly routine.
;
FCPROC   MACRO   NAME
public  NAME
NAME   PROC    FAR
       push    bp
       mov     bp,sp
       ENDM

;
; Simple macro for exiting assembly routine back to C.
;
ENDFCPROC MACRO   NAME
        pop     bp
        retf
NAME    endp
        ENDM

;
; Simple macro to guarantee near C entry point for assembly routine.
;
NCPROC   MACRO   NAME
public  NAME
NAME   PROC    NEAR
       push    bp
       mov     bp,sp
       ENDM

;
; Simple macro for exiting assembly routine back to C.
;
ENDNCPROC MACRO   NAME
        pop     bp
        ret
NAME    endp
        ENDM

;
; DEVHELP Equates used by TESTCFG
;

DevHlp_ProcBlock        EQU      4      ;  4    Block process
DevHlp_ProcRun          EQU      5      ;  5    Run a blocked process

DevHlp_PhysToVirt       EQU     21      ; 15    convert physical address to virtual
DevHlp_VirtToPhys       EQU     22      ; 16    convert virtual address to physical
DevHlp_PhysToUVirt      EQU     23      ; 17    convert physical to LDT

DevHlp_GetDOSVar        EQU     36      ; 24    Return pointer to DOS variable

DevHlp_VerifyAccess     EQU     39      ; 27    Verify access to memory

DevHlp_UnPhysToVirt     EQU     50      ; 32    mark completion of PhysToVirt

DevHlp_GetLIDEntry      EQU     52      ; 34    Obtain Logical ID
DevHlp_FreeLIDEntry     EQU     53      ; 35    Release Logical ID
DevHlp_ABIOSCall        EQU     54      ; 36    Call ABIOS

