/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)testcfg.h  6.2 92/02/13";*/

/*** TESTCFG.H - TESTCFG Device Driver Include File
 *
 *
 *
 *
 *   DESCRIPTION
 *
 *     TESTCFG specific include information (defines, protocols, macros)
 *
 *   MODIFICATION HISTORY
 *
 * 6.1  01/15/92 CP20 B731???  J.Muir      Original Version
 * 6.2  02/12/92 CP20 B733010  K.Harris    Query ABIOS for RB length that
 *                                          should be used for Read POS data.
 * 1.x  09/17/94 rbdd          J.Grimm     Resource Manager
 */



/*************************************************************************
 *                          T Y P E D E F S                              *
 *************************************************************************/
#define FAR             _far

typedef unsigned char   UCHAR;
typedef unsigned short  USHORT;
typedef unsigned long   ULONG;
typedef void far      *PVOID;
typedef UCHAR far     *PUCHAR;
typedef UCHAR far     *PBYTE;
typedef USHORT far    *PUSHORT;
typedef ULONG far     *PULONG;
typedef char far      *PCHAR;
typedef short far     *PSHORT;
typedef long far      *PLONG;
typedef void near     *POINTER;
typedef POINTER near *PPOINTER;
typedef void far      *FARPOINTER;
typedef FARPOINTER near *PFARPOINTER;
typedef FARPOINTER far *FPFARPOINTER;
typedef UCHAR near     *NPBYTE;

typedef USHORT         ERRCODE; /* error code returned                  */
typedef ERRCODE far  *PERRCODE; /* pointer to an error code             */
typedef UCHAR          FLAG;    /* 8-bit flag                           */
typedef FLAG far     *PFLAG;    /* pointer to 8-bit flag                */
typedef USHORT         SEL;     /* 16-bit selector                      */
typedef SEL near     *PSEL;     /* pointer to a selector                */
typedef USHORT         SEG;     /* 16-bit segment                       */
typedef USHORT         OFF;     /* 16-bit offset                        */
typedef USHORT         PID;     /* Process ID                           */
typedef USHORT         TID;     /* Task ID                              */
typedef ULONG          PHYSADDR;/* 32-bit physical address              */
typedef PHYSADDR far  *PPHYSADDR; /* pointer to 32-bit physical address */
typedef char near     *PSTRING; /* pointer to character string          */
typedef USHORT         SHANDLE; /* short (16-bit) handle                */
typedef SHANDLE far  *PSHANDLE; /* pointer to a short handle            */
typedef ULONG          LHANDLE; /* long  (32-bit) handle                */
typedef LHANDLE far  *PLHANDLE; /* pointer to a long handle             */
typedef char CHAR;                      // ch
#define NEAR near
typedef CHAR FAR *PSZ;                  // psz
typedef CHAR NEAR *NPSZ;                // npsz

/*  pointers to functions
 */
typedef int (pascal near          *PFUNCTION) ();
typedef int (pascal near * near  *PPFUNCTION) ();
typedef int (pascal far          *FPFUNCTION) ();
typedef int (pascal far  * near *PFPFUNCTION) ();

/*************************************************************************
 *                             M A C R O S                               *
 *************************************************************************/

#define FALSE   0
#define TRUE    1
#define NULL    0

#define NP near pascal
#define NC near cdecl
#define FC far cdecl


/* Create untyped far pointer from selector and offset */
#define MAKEP(sel, off)     ( (void far *) MAKEULONG(off, sel) )

/* Extract selector or offset from far pointer */
#define SELECTOROF(p)       ( ((USHORT far *) &(p)) [1])
#define OFFSETOF(p)         ( ((USHORT far *) &(p)) [0])

/* Cast any variable to an instance of the specified type. */
#define MAKETYPE(v, type)   (*((type far *)&v))

/* Calculate the byte offset of a field in a structure of type type. */
#define FIELDOFFSET(type, field)    ((SHORT)&(((type *)0)->field))

/* Combine l & h to form a 32 bit quantity. */
#define MAKEULONG(l, h)  ((ULONG)(((USHORT)(l)) | ((ULONG)((USHORT)(h))) << 16))
#define MAKELONG(l, h)   ((LONG)MAKEULONG(l, h))

/* Combine l & h to form a 16 bit quantity. */
#define MAKEUSHORT(l, h) (((USHORT)(l)) | ((USHORT)(h)) << 8)
#define MAKESHORT(l, h)  ((SHORT)MAKEUSHORT(l, h))

/* Extract high and low order parts of 16 and 32 bit quantity */
#define LOBYTE(w)       LOUCHAR(w)
#define HIBYTE(w)       HIUCHAR(w)
#define LOUCHAR(w)      ((UCHAR)(w))
#define HIUCHAR(w)      (((USHORT)(w) >> 8) & 0xff)
#define LOUSHORT(l)     ((USHORT)(l))
#define HIUSHORT(l)     ((USHORT)(((ULONG)(l) >> 16) & 0xffff))


/*************************************************************************
 *                        S T R U C T U R E S                            *
 * (including manifest constants for definitions of struct elements)     *
 *************************************************************************/

/*  The Device Header
 */
typedef struct DeviceHdr {
        struct DeviceHdr far *DHnext;   /* pointer to next header, or FFFF */
        USHORT DHattribute;             /* device attribute word           */
        OFF    DHstrategy;              /* offset of strategy routine      */
        OFF    DHidc;                   /* offset of IDC routine           */
        UCHAR  DHname[8];               /* dev name (char) or #units (blk) */
        char   reserved[8];
        } DEVICEHDR;
typedef DEVICEHDR near *PDEVICEHDR;

/*  Device Attribute Word
 */
#define DAW_CHR         0x8000  /* 1=char, 0=block                      */
#define DAW_IDC         0x4000  /* 1=IDC available in this DD           */
#define DAW_IBM         0x2000  /* 1=non-IBM block format               */
#define DAW_SHR         0x1000  /* 1=supports shared device access      */
#define DAW_OPN         0x0800  /* 1=open/close, or removable media     */
#define DAW_LEVEL       0x0080  /* level; should be 001 for OS/2 base   */
#define DAW_LEVEL2      0x0100  /* level; 010 supports DOSDevIoctl2     */
#define DAW_GIO         0x0040  /* 1=generic IOCtl supported            */
#define DAW_CLK         0x0008  /* 1=CLOCK device                       */
#define DAW_NUL         0x0004  /* 1=NUL device                         */
#define DAW_SCR         0x0002  /* 1=STDOUT (screen)                    */
#define DAW_KBD         0x0001  /* 1=STDIN  (keyboard)                  */

/*  The Request Packet
 */
typedef struct ReqPacket {
        UCHAR   RPlength;       /* request packet length                */
        UCHAR   RPunit;         /* unit code for block DD only          */
        UCHAR   RPcommand;      /* command code                         */
        USHORT  RPstatus;       /* status word                          */
        UCHAR   RPreserved[4];  /* reserved bytes                       */
        ULONG   RPqlink;        /* queue linkage                        */
        union {                 /* command-specific data                */
            UCHAR   avail[19];  /* available space, in 32-byte packet   */

            struct {    /*  INIT Packet (one for entry, one for exit)   */
                   UCHAR      units;            /* number of units      */
                   FPFUNCTION DevHlp;           /* &DevHlp              */
                   char far  *args;             /* &args                */
                   UCHAR      drive;            /* drive #              */
                   } Init;                      /* available: 9 bytes   */
            struct {
                   UCHAR      units;            /* same as input        */
                   OFF        finalCS;          /* final code offset    */
                   OFF        finalDS;          /* final data offset    */
                   FARPOINTER BPBarray;         /* &BPB                 */
                   } InitExit;

            struct {    /*  READ, WRITE, WRITE_VERIFY                   */
                   UCHAR      media;            /* media descriptor     */
                   PHYSADDR   buffer;           /* transfer address     */
                   USHORT     count;            /* bytes/sectors        */
                   ULONG      startsector;      /* starting sector#     */
                   USHORT     reserved;
                   } ReadWrite;                 /* available: 6 bytes   */

            struct {    /*  IOCTL                                       */
                   UCHAR      category;         /* category code        */
                   UCHAR      function;         /* function code        */
                   FARPOINTER parameters;       /* &parameters          */
                   FARPOINTER buffer;           /* &buffer              */
                   USHORT     SFN;              /* System File Number   */
                   USHORT     paramlen;         /* length of parameter  */
                   USHORT     bufferlen;        /* length of buffer     */
                   } IOCtl;                     /* available: 3 bytes   */

            struct {    /*  READ_NO_WAIT                                */
                   UCHAR      char_returned;    /* char to return       */
                   } ReadNoWait;                /* available: 18 bytes  */

            struct {    /*  MEDIA_CHECK                                 */
                   UCHAR      media;            /* media descriptor     */
                   UCHAR      return_code;      /* see #defines         */
                   FARPOINTER prev_volume;      /* &previous volume ID  */
                   } MediaCheck;                /* available: 13 bytes  */

            struct {    /*  BUILD_BPB                                   */
                   UCHAR      media;            /* media descriptor     */
                   FARPOINTER buffer;           /* 1-sector buffer FAT  */
                   FARPOINTER BPBarray;         /* &BPB array           */
                   UCHAR      drive;            /* drive #              */
                   } BuildBPB;                  /* available: 9 bytes   */

            struct {    /*  query PARTITIONABLE fixed disks             */
                   UCHAR      count;            /* 1-based # disks      */
                   ULONG      reserved;
                   } Partitionable;             /* available: 14 bytes  */

            struct {    /*  Get Fixed Disk/Logical Unit Map             */
                   ULONG      units;            /* units supported      */
                   ULONG      reserved;
                   } GetFixedMap;               /* available: 11 bytes  */

               } s;     /* command-Specific information */
        } REQPACKET;
typedef REQPACKET far *PREQPACKET;
typedef PREQPACKET far *PPREQPACKET;
typedef PREQPACKET QHEAD;               /* Queue Head is &ReqPacket  */
typedef QHEAD near *PQHEAD;

/* ABIOS Request Block */

typedef struct _ABIOSRB {
    USHORT RBLen;
    USHORT LID;
    USHORT Unit;
    USHORT Func;
    USHORT Resv1;
    USHORT Resv2;
    USHORT RetCode;
    USHORT TimeOut;
} ABIOSRB;

typedef struct _INQUIRYPARMPACKET{
        ULONG       CmdWord;
        UCHAR       Dev_Type;
} INQUIRYPARMPACKET;

typedef INQUIRYPARMPACKET far * PINQUIRYPARMPACKET;

typedef struct _INQUIRYDATA {
   UCHAR Pad[36];
} INQUIRYDATA, far * PINQUIRYDATA;

typedef struct _INQUIRYDATAPACKET{
        USHORT      nDevices;
        INQUIRYDATA InquiryEntry[32];
} INQUIRYDATAPACKET;

typedef INQUIRYDATAPACKET far * PINQUIRYDATAPACKET;


/*************************************************************************
 *               M A N I F E S T   C O N S T A N T S                     *
 *************************************************************************/

/*  RPstatus bit values
 */
#define RPERR    0x8000 /*  error occurred, error code in RPstatuserr   */
#define RPDEV    0x4000 /*  also set ERR; error code defined by DD      */
#define RPBUSY   0x0200 /*  device is busy                              */
#define RPDONE   0x0100 /*  DD all done with request packet             */

/*  Error codes, to be returned in RPstatus
 */
#define ERROR_WRITE_PROTECT             0x0000
#define ERROR_BAD_UNIT                  0x0001
#define ERROR_NOT_READY                 0x0002
#define ERROR_BAD_COMMAND               0x0003
#define ERROR_CRC                       0x0004
#define ERROR_BAD_LENGTH                0x0005
#define ERROR_SEEK                      0x0006
#define ERROR_NOT_DOS_DISK              0x0007
#define ERROR_SECTOR_NOT_FOUND          0x0008
#define ERROR_OUT_OF_PAPER              0x0009
#define ERROR_WRITE_FAULT               0x000A
#define ERROR_READ_FAULT                0x000B
#define ERROR_GEN_FAILURE               0x000C
#define ERROR_DISK_CHANGE               0x000D
#define ERROR_WRONG_DISK                0x000F
#define ERROR_UNCERTAIN_MEDIA           0x0010
#define ERROR_CHAR_CALL_INTERRUPTED     0x0011
#define ERROR_NO_MONITOR_SUPPORT        0x0012
#define ERROR_INVALID_PARAMETER         0x0013

/*  Request Packet commands  (in RPcommand)  B=Block, C=Character
 */
#define RPINIT          0x00    /*  BC  */
#define RPMEDIA_CHECK   0x01    /*  B   */
#define RPBUILD_BPB     0x02    /*  B   */
#define RPREAD          0x04    /*  BC  */
#define RPREAD_NO_WAIT  0x05    /*   C  */
#define RPINPUT_STATUS  0x06    /*   C  */
#define RPINPUT_FLUSH   0x07    /*   C  */
#define RPWRITE         0x08    /*  BC  */
#define RPWRITE_VERIFY  0x09    /*  BC  */
#define RPOUTPUT_STATUS 0x0a    /*   C  */
#define RPOUTPUT_FLUSH  0x0b    /*   C  */
#define RPOPEN          0x0d    /*  BC  */
#define RPCLOSE         0x0e    /*  BC  */
#define RPREMOVABLE     0x0f    /*  B   */
#define RPIOCTL         0x10    /*  BC  */
#define RPRESET         0x11    /*  B   */
#define RPGET_DRIVE_MAP 0x12    /*  B   */
#define RPSET_DRIVE_MAP 0x13    /*  B   */
#define RPDEINSTALL     0x14    /*   C  */
#define RPPARTITIONABLE 0x16    /*  B   */
#define RPGET_FIXED_MAP 0x17    /*  B   */
#define RPINIT_COMPLETE 0x1F    /*  BC  */

/* VerifyAccess Memory access flags
 */
#define VERIFY_READACCESS       0
#define VERIFY_READWRITEACCESS  1

/* Definitions for ABIOS Device Types
 */

#define ABIOS_Internal   0x00             /*ABIOS Internal Calls         */
#define Diskette         0x01
#define Disk             0x02
#define Video            0x03
#define Keyboard         0x04
#define Printer          0x05
#define Asynch           0x06
#define SysTimer         0x07
#define RTCTimer         0x08
#define SysService       0x09
#define NMInterrupt      0x0a
#define PointDevice      0x0b
#define LightPen         0x0c
#define JoyStick         0x0d
#define CMOSRam          0x0e
#define DMA              0x0f
#define POS              0x10             /*Programmable Option Select */
#define ErrorLog         0x11             /*Error Logging              */
#define SAD              0x12             /*Stand Alone Dump           */
#define IOPortAlloc      0x13             /*I/O Port Allocation        */
#define AudioTone        0x14
#define IntController    0x15             /*Interrupt Controller       */
#define Security         0x16

/* DOS API available at Device Driver Init time
 */

#define APIENTRY far pascal

USHORT APIENTRY DosBeep(USHORT, USHORT);
USHORT APIENTRY DosCaseMap(USHORT, FARPOINTER, FARPOINTER);
USHORT APIENTRY DosChgFilePtr(SHANDLE, long, USHORT, FARPOINTER);
USHORT APIENTRY DosClose(SHANDLE);
USHORT APIENTRY DosDelete(FARPOINTER, ULONG);
USHORT APIENTRY DosDevConfig(FARPOINTER, USHORT, USHORT);
USHORT APIENTRY DosDevIOCtl(FARPOINTER, FARPOINTER, USHORT, USHORT, USHORT);
USHORT APIENTRY DosDevIOCtl2(FARPOINTER, USHORT, FARPOINTER, USHORT, USHORT, USHORT, USHORT);
USHORT APIENTRY DosFindClose(SHANDLE);
USHORT APIENTRY DosFindFirst(FARPOINTER, FARPOINTER, USHORT, FARPOINTER,
                             USHORT, FARPOINTER, ULONG);
USHORT APIENTRY DosFindNext(SHANDLE, FARPOINTER, USHORT, FARPOINTER);
USHORT APIENTRY DosGetEnv(FARPOINTER, FARPOINTER);
USHORT APIENTRY DosGetMessage(FARPOINTER, USHORT, FARPOINTER, USHORT,
                              USHORT, FARPOINTER, FARPOINTER);
USHORT APIENTRY DosOpen(FARPOINTER, FARPOINTER, FARPOINTER, ULONG,
                        USHORT, USHORT, USHORT, ULONG);
USHORT APIENTRY DosPutMessage(SHANDLE, USHORT, FARPOINTER);
USHORT APIENTRY DosQCurDir(USHORT, FARPOINTER, FARPOINTER);
USHORT APIENTRY DosQCurDisk(FARPOINTER, FARPOINTER);
USHORT APIENTRY DosQFileInfo(SHANDLE, USHORT, FARPOINTER, USHORT);
USHORT APIENTRY DosQFileMode(FARPOINTER, FARPOINTER, ULONG);
USHORT APIENTRY DosRead(SHANDLE, FARPOINTER, USHORT, PUSHORT);
USHORT APIENTRY DosWrite(SHANDLE, FARPOINTER, USHORT, FARPOINTER);

/* private entry for determining MCA, EISA */

#define HW_CFG_MCA              0x0001
#define HW_CFG_EISA             0x0002
#define HW_CFG_ABIOS_SUPPORTED  0x0004
#define HW_CFG_ABIOS_PRESENT    0x0008

USHORT APIENTRY DosQueryABIOSSupport(ULONG);


/* IOCTL function defines */

#define  CFG_CATEGORY      0x80

#define  CFG_MISC_QUERY    0x60
#define  CFG_READ_POSID    0x61
#define  CFG_READ_EISAID   0x62
#define  CFG_SCSI_INQUIRY  0x63
#define  CFG_READ_ADPMEM   0x40
#define  CFG_IN_IO         0x41
#define  CFG_OUT_IO        0x42

/* Read Adapter Memory definitions */

#define CFG_ADP_MIN_ADDR  0xC0000
#define CFG_ADP_MAX_ADDR  0xFFFFF

/* Input/Output definitions */

#define CFG_IO_BYTE 1
#define CFG_IO_WORD 2
#define CFG_IO_DWORD 4

#define CFG_IO_MIN_PORT  0x100                 /* Lowest port allowed */

/* MISC Query Sub Functions */
#define CFG_MISC_BUS_TYPE  0
#define CFG_MISC_ST506     1001
#define CFG_MISC_SCB       1002

/* Bus Type definitions */
#define CFG_ISA_BUS    0
#define CFG_MCA_BUS    1
#define CFG_EISA_BUS   2

/* Adapter Slot */
#define CFG_MAX_POS_SLOTS 8
#define CFG_MAX_EISA_SLOTS 16

/* structures */

/* IO packet structure */
typedef struct _IOPKT {
     USHORT     io_address;
     USHORT     data_width;
     union {
       UCHAR      ucData;
       USHORT     usData;
       ULONG      ulData;
      } d;
     } IOPKT;
typedef IOPKT far *PIOPKT;

typedef struct _IODATAPKT {
     union {
       UCHAR      ucData;
       USHORT     usData;
       ULONG      ulData;
       } d;
     } IODATAPKT;
typedef IODATAPKT far *PIODATAPKT;

typedef struct _ADPMEM {
        ULONG command;
        ULONG addr0;
        USHORT length0;
        } ADPMEM;
typedef ADPMEM far *PADPMEM;

typedef struct _ADPPOS {
        USHORT POSID[CFG_MAX_POS_SLOTS+1];
        } ADPPOS;
typedef ADPPOS far *PADPPOS;

typedef struct _ADPEISA {
        ULONG  EISAID[CFG_MAX_EISA_SLOTS];
        } ADPEISA;
typedef ADPEISA far *PADPEISA;

typedef ULONG far *PCMD;

/* OEM HELP routines */

#define  OEM_CATEGORY      0x80

#define OEM_DOS_INFO         0
#define OEM_MACH_INFO        1
#define OEM_CHECK_VIDEO      2
#define OEM_GET_FONTS        3
#define OEM_GET_EISA_CONFIG  4
#define OEM_BIOS_INFO        5
#define OEM_MISC_BIOS_INFO   6


/* OEM EISA Subfunctions */
#define OEM_GET_SLOT_INFO      0
#define OEM_GET_FUNCTION_INFO  1

/* OEM HELP typedefs */

typedef struct _BIOSINFO {
        USHORT Model;
        USHORT SubModel;
        USHORT RevisionLevel;
        USHORT ABIOS_Present;
        } BIOSINFO;
typedef BIOSINFO far *PBIOSINFO;

typedef struct _EISAPARM {
        UCHAR  SubFunc;
        UCHAR  Slot;
        UCHAR  Func;
        } EISAPARM;

typedef struct _EISASLOTDATA {
       UCHAR    Error;
       UCHAR    Flags;
       UCHAR    MajorVer;
       UCHAR    MinorVer;
       USHORT   CheckSum;
       UCHAR    DevFunc;
       UCHAR    FuncInfo;
       ULONG    CardID;
       } EISASLOTDATA;

/* ABIOS Request Block for obtaining LID parameters.
   (TESTCFG uses this to obtain RB length for Reading POS).
 */
typedef struct _POSLENRB {
  ABIOSRB     rb;
  UCHAR       HWIntLevel;                   /* 0x10 */
  UCHAR       ArbitrationLevel;             /* 0x11 */
  USHORT      DeviceID;                     /* 0x12 */
  USHORT      NumberOfUnits;                /* 0x14 */
  USHORT      Flags;                        /* 0x16 */
  USHORT      RBLen;                        /* 0x18 */
  UCHAR       Rsv1;                         /* 0x1a */
  UCHAR       RevisionLevel;                /* 0x1b */
  USHORT      Rsv2;                         /* 0x1c */
  USHORT      Rsv3;                         /* 0x1e */
} POSLENRB;

/* ABIOS Request Block for Reading POS Data*/
#define POSRB_PAD_LENGTH 0x20
        // The length of this structure is machine dependent.  We have
        // seen total lengths of 0x20 and 0x21.  Padding this out with
        // 0x20 bytes is probably safe for the future.  -Kip Harris 2/92.
typedef struct _POSRB {
  ABIOSRB     rb;
  UCHAR       Slot;                         /* 0x10 */
  UCHAR       Rsv1;                         /* 0x11 */
  USHORT      AdapterID;                    /* 0x12 */
  USHORT      Rsv2;                         /* 0x14 */
  ULONG       DataBuf;                      /* 0x16 */
  USHORT      Rsv3;                         /* 0x1a */
  USHORT      Rsv4;                         /* 0x1c */
  UCHAR       dummy[POSRB_PAD_LENGTH];      /* 0x1e */
} POSRB;

/* MACROS */

#define ENABLE  _asm {sti}
#define DISABLE _asm {cli}
#define PUSHFLAGS _asm {pushf}
#define POPFLAGS _asm {popf}
