/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)testcfg.h  6.2 92/02/13";*/

/*** TCFGDATA.C - TESTCFG Device Driver Data Module
 *
 *
 *
 *
 *   DESCRIPTION
 *
 *     TESTCFG specific include information (defines, protocols, macros)
 *
 *   MODIFICATION HISTORY
 *
 * 6.1  09/17/94               Jon Grimm   Data moved into single module
 */

#include "testcfg.h"
#include "IORB.h"
#include "SCSI.h"
#include "devclass.h"
#include "tcfgscsi.h"
#include "tcfgx.h"
#define RMCode SWAPCODE
#include "rmcalls.h"
#include "tcfgex.h"


/* Device Driver Header */
DEVICEHDR devhdr = {
            (void far *) 0xFFFFFFFF,                    /* link         */
            (DAW_GIO | DAW_CHR | DAW_OPN | DAW_LEVEL2), /* attribute    */
            (OFF) STRATEGYCFG,                          /* &strategy    */
            (OFF) 0,                                    /* &IDCroutine  */
            "TESTCFG$"                                  /* name/#units  */
            };

ULONG    APMPresent = 0;
FPFUNCTION Device_Help= 0;

BIOSINFO BIOSInfo = {0};                            /* BIOS Level Information     */
ULONG    EisaCardID[CFG_MAX_EISA_SLOTS]={0};  /* planar id plus 15 adapters */
USHORT   POSCardID[CFG_MAX_POS_SLOTS+1]={0};  /* planar id plus 8 adapters  */
FLAG     fEisaPresent=0;                      /* flag for EISA presence     */
FLAG     fMCAPresent=0;                       /* flag for MCA  presence     */
FARPOINTER  pDataSeg=0L;                  /* virt ptr of our data segment   */
ULONG       ppDataSeg=0L;                 /* phys addr of our data segment  */

// 6.2 UCHAR InitMessage[] = "TESTCFG$ successfully installed.\r\n";
UCHAR FailMessage[] = "TESTCFG$ did not install. OEMHLP$ not present.\r\n";
UCHAR OEMHelp[] = "OEMHLP$";                  /* Name of OEM Help Dev Drvr  */
POSRB    RB={0};                              /* ABIOS request block        */
POSLENRB POSLenRB={0};
         /* Another ABIOS request block.  Must go to ABIOS to obtain the
            length of the RB to use with function 0xB (read POS data). */

IORB_CONFIGURATION ConfigIORB={0};
IORB_CDB           PassthruIORB={0};
IORB_UNIT_CONTROL  UnitControlIORB={0};
char   DeviceTableBuffer[MAX_DT_SIZE]={0};       /*Scratch buffer */
struct DevClassTableStruc far *pDriverTable={0}; /* ptr to registered ADD EPs */
INQUIRYDATA InquiryData = {0};                   /* Device Inquiry Data          */

USHORT         FilterADDHandle=0;
void           (far *DriverEP)()= NULL;  // Driver entry point
void           (far *DriverEPF)()=NULL; // Filter entry point



HDRIVER DriverHandle = 0;
PFNRM   RM_Help0 = 0;
ULONG   RMFlags  = 0;

USHORT InitData = 0;


PFNRM  RM_Help3 = 0;
UCHAR  DrvrNameTxt[]     = "TESTCFG.SYS ";
USHORT DrvrNameSize      = sizeof(DrvrNameTxt);
UCHAR  DrvrDescriptTxt[] = "TESTCFG Test Configuration Device Driver";
UCHAR  VendorNameTxt[]   = "IBM OS/2";

DRIVERSTRUCT DriverStruct =
{
   DrvrNameTxt,                              /* DrvrName                */
   DrvrDescriptTxt,                          /* DrvrDescript            */
   VendorNameTxt,                            /* VendorName              */
   CMVERSION_MAJOR,                          /* MajorVer                */
   CMVERSION_MINOR,                          /* MinorVer                */
   1994,9,17,                                /* Date                    */
   DRF_STATIC,                               /* DrvrFlags               */
   DRT_SERVICE,                              /* DrvrType                */
   DRS_UNDEFINED,                            /* DrvrSubType             */
   NULL                                      /* DrvrCallback            */
};

