/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME =  RMCALLS.H
 *
 * DESCRIPTIVE NAME =  RM function prototypes exported to drivers
 *
 *
 *
 * VERSION = V1.01
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 * FUNCTIONS  :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/


/****************************************************************************/
/*                                                                          */
/* Function Prototypes                                                      */
/*                                                                          */
/****************************************************************************/



#ifndef __RM_CALLS__
#define __RM_CALLS__

#include <rmbase.h>
#include <rmioctl.h>


typedef USHORT (_cdecl FAR *PFNRM)();

USHORT _cdecl FAR RMCreateDriver(PDRIVERSTRUCT pDriverStruct,
                                 PHDRIVER phDriver);

USHORT _cdecl FAR RMDestroyDriver(HDRIVER hDriver);

USHORT _cdecl FAR RMCreateAdapter(HDRIVER hDriver,
                                  PHADAPTER phAdapter,
                                  PADAPTERSTRUCT pAdapterStruct,
                                  HDEVICE hDevice,
                                  PAHRESOURCE pahResource);

USHORT _cdecl FAR RMDestroyAdapter(HDRIVER hDriver,
                                   HADAPTER hAdapter);


USHORT _cdecl FAR RMCreateDevice(HDRIVER hDriver,
                                 PHDEVICE phDevice,
                                 PDEVICESTRUCT pDeviceStruct,
                                 HADAPTER hAdapter,
                                 PAHRESOURCE pahResource);

USHORT _cdecl FAR RMDestroyDevice(HDRIVER hDriver,
                                   HDEVICE hDevice);

USHORT _cdecl FAR RMAllocResource(HDRIVER hDriver,
                                  PHRESOURCE phResource,
                                  PRESOURCESTRUCT pResourceStruct);


USHORT _cdecl FAR RMDeallocResource(HDRIVER hDriver,
                                    HRESOURCE hResource);

USHORT _cdecl FAR RMClaimResources(HDRIVER hDriver,
                                   HADAPTER hAdapter);

USHORT _cdecl FAR RMReleaseResources(HDRIVER hDriver,
                                    HADAPTER hAdapter);

USHORT _cdecl FAR RMCreateLDev(HDRIVER hDriver,
                                PHLDEV  phLDev,
                                HDEVICE hDevice,
                                PLDEVSTRUCT pLDevStruct);

USHORT _cdecl FAR RMDestroyLDev(HDRIVER hDriver,
                                 HLDEV   hLDev);

USHORT _cdecl FAR RMCreateSysName(HDRIVER hDriver,
                                  PHSYSNAME phSysName,
                                  HLDEV hLDev,
                                  PSYSNAMESTRUCT pSysNameStruct);

USHORT _cdecl FAR RMDestroySysName(HDRIVER hDriver,
                                   HSYSNAME   hLDev);

USHORT _cdecl FAR RMADDToHDEVICE(PHDEVICE phDevice,
                                 USHORT ADDHandle,
                                 USHORT UnitHandle);

USHORT _cdecl FAR RMKeyToHandleList(RMHANDLE    hStartNode,
                                    PSZ         SearchKey,
                                    PHANDLELIST pHandleList);

USHORT _cdecl FAR RMHandleToType(RMHANDLE  hHandle,
                                 PUSHORT   pHandleType );

USHORT _cdecl FAR RMHandleToParent(RMHANDLE   hHandle,
                                   PRMHANDLE  phParent );

USHORT _cdecl FAR RMUpdateAdjunct(HDRIVER  hDriver,
                                  HDEVICE  hDevice,
                                  USHORT   AdjunctIndex,
                                  PADJUNCT pAdjunct   );

USHORT _cdecl FAR RMAdjToHandleList(PADJUNCT       pAdj,
                                    HADAPTER       hStartNode,
                                    PADJHANDLELIST pAdjHndList     );

USHORT _cdecl FAR RMHDevToHLDev( HDEVICE  hDevice,
                                 HLDEV    hStartLDev,
                                 PHLDEV   phLDev );

USHORT _cdecl FAR RMResToHandleList(PRESOURCESTRUCT   pRes,
                                    PHANDLELIST       pHndList );

USHORT _cdecl FAR RMActivateAdapter(HDRIVER hDriver,
                                    HADAPTER hAdapter);

USHORT _cdecl FAR RMDeactivateAdapter(HDRIVER hDriver,
                                      HADAPTER hAdapter);

USHORT _cdecl FAR RMCreateLinkDevice(HDRIVER  hDriver,
                                     PHDEVICE phLinkDevice,
                                     PDEVICESTRUCT pDeviceStruct,
                                     PAHDEVICES pahDevices);

USHORT _cdecl FAR RMModifyResources(HDRIVER   hDriver,
                                    HADAPTER  hAdapter,
                                    USHORT    ModifyAction,
                                    HRESOURCE hResource);


USHORT _cdecl FAR RMGetNodeInfo(RMHANDLE         RMHandle,
                                PRM_GETNODE_DATA pNodeInfo,
                                USHORT           BufferSize);


USHORT _cdecl FAR RMParseScsiInquiry(PVOID   pInquiry,
                                     PSZ     pDescBuffer,
                                     USHORT  BufferSize);



/*******************************************************/
/* The alloc_text pragma allows steering of a function */
/* to a specified segment.                             */
/* To override the names of these segments place a     */
/* #define RMCode MY_SEGMENT_NAME                      */
/*******************************************************/


#pragma alloc_text(RMCode,RMCreateDriver)
#pragma alloc_text(RMCode,RMDestroyDriver)

#pragma alloc_text(RMCode,RMCreateAdapter)
#pragma alloc_text(RMCode,RMDestroyAdapter)

#pragma alloc_text(RMCode,RMCreateDevice)
#pragma alloc_text(RMCode,RMDestroyDevice)

#pragma alloc_text(RMCode,RMAllocResource)
#pragma alloc_text(RMCode,RMDeallocResource)

#pragma alloc_text(RMCode,RMClaimResources)
#pragma alloc_text(RMCode,RMReleaseResources)

#pragma alloc_text(RMCode,RMCreateLDev)
#pragma alloc_text(RMCode,RMDestroyLDev)

#pragma alloc_text(RMCode,RMCreateSysName)
#pragma alloc_text(RMCode,RMDestroySysName)

#pragma alloc_text(RMCode,RMADDToHDEVICE)
#pragma alloc_text(RMCode,RMActivateAdapter)
#pragma alloc_text(RMCode,RMDeactivateAdapter)

#pragma alloc_text(RMCode,RMKeyToHandleList)
#pragma alloc_text(RMCode,RMHandleToType)
#pragma alloc_text(RMCode,RMHandleToParent)

#pragma alloc_text(RMCode,RMCreateLinkDevice)
#pragma alloc_text(RMCode,RMModifyResources)
#pragma alloc_text(RMCode,RMParseScsiInquiry)

#pragma alloc_text(RMCode,RMUpdateAdjunct)
#pragma alloc_text(RMCode,RMAdjToHandleList)
#pragma alloc_text(RMCode,RMHDevToHLDev)
#pragma alloc_text(RMCode,RMResToHandleList)
#pragma alloc_text(RMCode,RMGetNodeInfo)

/****************************************************************************/
/*                                                                          */
/* Resource Manager Return Codes                                            */
/*                                                                          */
/****************************************************************************/
#define RMRC_SUCCESS               0x0000
#define RMRC_NOTINITIALIZED        0x0001
#define RMRC_BAD_DRIVERHANDLE      0x0002
#define RMRC_BAD_ADAPTERHANDLE     0x0003
#define RMRC_BAD_DEVICEHANDLE      0x0004
#define RMRC_BAD_RESOURCEHANDLE    0x0005
#define RMRC_BAD_LDEVHANDLE        0x0006
#define RMRC_BAD_SYSNAMEHANDLE     0x0007
#define RMRC_BAD_DEVHELP           0x0008
#define RMRC_NULL_POINTER          0x0009
#define RMRC_NULL_STRINGS          0x000a
#define RMRC_BAD_VERSION           0x000b
#define RMRC_RES_ALREADY_CLAIMED   0x000c
#define RMRC_DEV_ALREADY_CLAIMED   0x000d
#define RMRC_INVALID_PARM_VALUE    0x000e
#define RMRC_OUT_OF_MEMORY         0x000f
#define RMRC_SEARCH_FAILED         0x0010
#define RMRC_BUFFER_TOO_SMALL      0x0011
#define RMRC_GENERAL_FAILURE       0x0012
#define RMRC_IRQ_ENTRY_ILLEGAL     0x0013
#define RMRC_NOT_IMPLEMENTED       0x0014
#define RMRC_NOT_INSTALLED         0x0015


/*********************/
/*  RM Types         */
/*********************/

typedef struct {
   UCHAR      MajorVersion;
   UCHAR      MinorVersion;
   USHORT     NumRSMEntries;
} RSMVERSTRUCT, FAR *PRSMVERSTRUCT, NEAR *NPRSMVERSTRUCT;


#endif /* __RM_CALLS__ */
