/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME =  RMGETNM.C
 *
 * DESCRIPTIVE NAME =  RMGetDriverName Module for RMCALLS.LIB
 *
 *
 *
 * VERSION = V0.5
 *
 * DATE
 *
 * DESCRIPTION : Extract the Device Driver name from the init packet.
 *
 * Purpose:
 *
 *
 *
 * FUNCTIONS  :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_NOPMAPI
#include <os2.h>
#include <strat2.h>
#include <devcmd.h>
#include <dskinit.h>

#include "dhcalls.h"
#include "reqpkt.h"
#include "rmlib.h"
#include "rmdata.h"

/*****************/
/* String Length */
/*****************/

static strlen( PSZ s )
{
  INT   i = 0;

  while( *s++ ) i++;

  return ( i );
}

/*******************************/
/* reverse string s in place   */
/*******************************/

static reverse(PSZ s)
{
  SHORT i, j;
  CHAR  c;

  for (i = 0, j = strlen(s)-1; i < j; i++, j-- ){
    c = s[i];
    s[i] = s[j];
    s[j] = c;
  } /* endfor */

  return ( 0 );
}

/****************************************************************************
 *
 * FUNCTION NAME = RMGetDriverName
 *
 * DESCRIPTION   = Get init parms from BASEDEV command line
 *
 *                 VOID GetInitParms (PRPINITIN pRP);
 *
 * INPUT         = pRP              - Pointer to init request packet
 *                 pBuf             - Pointer to char buffer
 *                 size             - Buffer size
 *
 * OUTPUT        = none
 *
 * RETURN-NORMAL = contents of PSZ will be device driver name
 * RETURN-ERROR  = contents of PSZ will be nul
 *
 ****************************************************************************/

VOID RMGetDriverName (pRP, pBuf, size )

PRPINITIN pRP;
PSZ       pBuf;
USHORT    size;

{
   PSZ    pCmdString;
   PSZ    pCmdStringStart;
   PSZ    pBufStart;
   USHORT i;

   if (!pRP)
   {
      *pBuf = 0;
      goto RMGetDriverNameExit;
   }

   pCmdStringStart = pRP->InitArgs;
   pBufStart       = pBuf;

   if (pRP->rph.Cmd == CMDInitBase)
      OFFSETOF(pCmdStringStart)=((PDDD_PARM_LIST)pRP->InitArgs)->cmd_line_args;
   else
   {
      *pBuf = 0;
      goto RMGetDriverNameExit;
   }

   pCmdString = pCmdStringStart;

   /* Find end of device name */
   for (i = 0; *pCmdString != 0 &&
               *pCmdString != ' ' &&
               i < 255               ; i++, pCmdString++)
      ;

   for (pCmdString, i = 0; pCmdString != pCmdStringStart &&
                           *pCmdString != '\\' &&
                           *pCmdString != ':'  &&
                           i < 12              &&
                           i < size              ; i++,pBuf++)
   {
      *pBuf = *(--pCmdString);
   }

   *pBuf = 0; /* Put a nul character at the end of the reversed DD name */

   reverse (pBufStart);

   pBuf = pBufStart;

   /*
   ** Fold characters to upper case
   */
   for (i = 0; *pBufStart != 0 && i < 255; i++, pBufStart++)
   {
      if (*pBufStart >= 'a' &&  *pBufStart <= 'z')
         *pBufStart = *pBufStart - ('a' - 'A');
   }

   RMGetDriverNameExit:;
}
