/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME =  RMCDRVR.C
 *
 * DESCRIPTIVE NAME =  RMCreateDriver Module for RMCALLS.LIB
 *
 *
 *
 * VERSION = V0.5
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 * FUNCTIONS  :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_NOPMAPI
#include <os2.h>

#include "dhcalls.h"
#include "rmlib.h"
#include "rmdata.h"

/******************************************/
/* My_DevHlp_AttachDD                     */
/*                                        */
/*    Removing dependancy on dhcalls.lib  */
/*                                        */
/*                                        */
/******************************************/


USHORT APIENTRY My_DevHelp_AttachDD( NPSZ   DDName, NPBYTE IDCTable );
#define DevHlp_AttachDD  42  /* from devhlp.inc */

#pragma alloc_text( RMCode, My_DevHelp_AttachDD)
USHORT APIENTRY My_DevHelp_AttachDD( NPSZ   DDName, NPBYTE IDCTable )
{

   _asm mov bx, DDName
   _asm mov di, IDCTable
   _asm mov dl, DevHlp_AttachDD

   (*Device_Help)();

   _asm jc mydh_out
   return 0;

mydh_out:
   _asm leave;
   _asm ret
}



USHORT _cdecl FAR RMCreateDriver(PDRIVERSTRUCT pDriverStruct,
                                 PHDRIVER phDriver)
{

   if (RMFlags & RMF_INITIALIZED)
   {
      return( CallRM( RMCREATEDRIVER, (PVOID) &pDriverStruct ) );
   }

   /* if no RM, Pretend everything is ok */

   if (RMFlags & RMF_NO_RM)
   {
      *phDriver = (HDRIVER)-1L;
      return RMRC_SUCCESS;
   }

   if (Device_Help == 0L)
   {
      return RMRC_BAD_DEVHELP;
   }


   if ( My_DevHelp_AttachDD((NPSZ)RMNAME, (NPBYTE)&RMIDCTable) != 0)
   {
      RMFlags |= RMF_NO_RM;
      *phDriver = (HDRIVER)-1L;
   }
   else
   {
      /* I'm not checking return code at this point */
      /* Get Pointer to FuncTable                   */

      SELECTOROF(RM_Help3) = RMIDCTable.Reserved[2];
        OFFSETOF(RM_Help3) = 0;

      SELECTOROF(RM_Help0) = RMIDCTable.Reserved[1];
        OFFSETOF(RM_Help0) = OFFSETOF(RMIDCTable.ProtIDCEntry);

      RMFlags |= RMF_INITIALIZED;
      return ( CallRM( RMCREATEDRIVER, (PVOID) &pDriverStruct ) );
   }
   return RMRC_SUCCESS;
}

