/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME =  RSMTYPES.H
 *
 * DESCRIPTIVE NAME =  Resource Management Driver - Internal Data Types
 *
 *
 *
 * VERSION = V1.01
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 * FUNCTIONS  :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/
/*---------------------------------------------------*/
/*                                                   */
/*                                                   */
/*                                                   */
/*                                                   */
/*---------------------------------------------------*/

typedef struct _RMNODE   RMNODE,   NEAR *NPRMNODE,   FAR *PRMNODE;
typedef struct _RESNODE  RESNODE,  NEAR *NPRESNODE,  FAR *PRESNODE;
typedef struct _RESHDR   RESHDR,   NEAR *NRESHDR,    FAR *PRESHDR;
typedef struct _DRVRNODE DRVRNODE, NEAR *NPDRVRNODE, FAR *PDRVRNODE;
typedef struct _NODELIST NODELIST, NEAR *NPNODELIST, FAR *PNODELIST;
typedef struct _ADJINFO  ADJINFO,  NEAR *NPADJINFO,  FAR *PADJINFO;

typedef struct _ADJNODELIST ADJNODELIST, NEAR *NPADJNODELIST, FAR *PADJNODELIST;

/*---------------------------------------*/
/*                                       */
/*                                       */
/*---------------------------------------*/


typedef struct _RESHDR
{
  ULONG         Cookie;
  USHORT        Unique;

  PRESHDR       pResHdrSibling;

  PRMNODE       pDevParent;

  PRESNODE      pResUsers;

  USHORT        ResClass;
  USHORT        ResOrdinal;

} RESHDR;



typedef struct _RESNODE
{
  ULONG         Cookie;
  USHORT        Unique;

  PRMNODE       pDevUser;

  PRESNODE      pResDevChain;
  PRESNODE      pResUsers;

  USHORT        ResourceType;
  union
  {
    PIORESOURCE   pIO;
    PIRQRESOURCE  pIRQ;
    PMEMRESOURCE  pMEM;
    PDMARESOURCE  pDMA;
    PTMRRESOURCE  pTMR;

  };

  UCHAR            NodeData[2];

} RESNODE;

#define RESNODELEN     (sizeof(RESNODE) - sizeof(USHORT))

#define RESOURCE_NODE_COOKIE   (  (ULONG)'R'         \
                             |   ((ULONG)'E' << 8 )  \
                             |   ((ULONG)'S' << 16)  \
                             |   ((ULONG)'N' << 24)    )

#define RESOURCE_HDR_COOKIE    (  (ULONG)'R'         \
                             |   ((ULONG)'H' << 8 )  \
                             |   ((ULONG)'D' << 16)  \
                             |   ((ULONG)'R' << 24)    )


/*---------------------------------------*/
/*                                       */
/* RSMNODE.C                             */
/*                                       */
/*---------------------------------------*/

typedef struct _DRVRNODE
{
  ULONG         Cookie;
  USHORT        Unique;

  PDRVRNODE     pDrvSibling;
  PRMNODE       pDevChain;
  PRESNODE      pResChain;

  PDRIVERSTRUCT pDrv;
  UCHAR         NodeData[2];

} DRVRNODE;



typedef struct _RMNODE
{
  ULONG         Cookie;
  USHORT        Unique;

  PRMNODE       pDevParent;
  PRMNODE       pDevSibling;
  PRMNODE       pDevChild;

  union
  {
    PRESNODE    pResChain;
    PRMNODE     pDevAssoc;
  };

  USHORT        DevFlags;

  PDRVRNODE     pDriver;
  PRMNODE       pDevDrvChain;

  union
  {

    PADAPTERSTRUCT      pAdpt;
    PDEVICESTRUCT       pDev;
    PLDEVSTRUCT         pLDev;
    PSYSNAMESTRUCT      pSysDev;

  };

  UCHAR         NodeData[2];

} RMNODE;

#define RMNODELEN       (sizeof(RMNODE) - sizeof(USHORT))

/* PRMNODE->DevFlags */
#define DNF_LDEV_OWNER  0x8000


#define ADAPTER_NODE_COOKIE   (  (ULONG)'A'        \
                            |   ((ULONG)'D' << 8 ) \
                            |   ((ULONG)'P' << 16) \
                            |   ((ULONG)'N' << 24)   )


#define DEVICE_NODE_COOKIE    (  (ULONG)'D'        \
                            |   ((ULONG)'E' << 8 ) \
                            |   ((ULONG)'V' << 16) \
                            |   ((ULONG)'N' << 24)   )


#define DRIVER_NODE_COOKIE    (  (ULONG)'D'        \
                            |   ((ULONG)'R' << 8 ) \
                            |   ((ULONG)'V' << 16) \
                            |   ((ULONG)'R' << 24)    )

#define ANY_COOKIE      0L
#define ANY_LOG_COOKIE  1L
#define ANY_PHYS_COOKIE 2L




/*---------------------------------------------------*/
/*                                                   */
/* RSMLDEV.C                                         */
/*                                                   */
/*---------------------------------------------------*/

#define LDEV_NODE_COOKIE      (  (ULONG)'L'        \
                            |   ((ULONG)'D' << 8 ) \
                            |   ((ULONG)'E' << 16) \
                            |   ((ULONG)'V' << 24)   )

#define SYS_NODE_COOKIE       (  (ULONG)'S'        \
                            |   ((ULONG)'Y' << 8 ) \
                            |   ((ULONG)'S' << 16) \
                            |   ((ULONG)'N' << 24)   )

/*---------------------------------------------------*/
/*                                                   */
/* RSMALLOC.C                                        */
/*                                                   */
/*---------------------------------------------------*/

typedef struct _BUFHEADER  BUFHEADER, FAR *PBUFHEADER;

typedef struct _BUFHEADER
{
   USHORT                   Size;
   PBUFHEADER               pNext;
} BUFHEADER;


typedef struct _BUFINFO
{
  PBUFHEADER    pBUF;
  PBUFHEADER    pBUFPrev;
} BUFINFO, FAR *PBUFINFO;

#define MIN_BUF_SIZE 16

/*---------------------------------------------------*/
/*                                                   */
/* RSMINIT.C                                         */
/*                                                   */
/*---------------------------------------------------*/

typedef struct
{

  USHORT BasePort;
  USHORT NumPorts;

} PORTLIST;

typedef struct
{

  NPSZ   Name;
  USHORT Class;

} LDEVLIST;


#define HANDLE_MAGIC          (  (ULONG)'R'         \
                            |   ((ULONG)'M'  << 8 ) \
                            |   ((ULONG)0xff << 16) \
                            |   ((ULONG)0xff << 24)   )

/* Adapter Slot */
#define CFG_MAX_POS_SLOTS 8
#define CFG_MAX_EISA_SLOTS 16



/*---------------------------------------------------*/
/*                                                   */
/* RSMENTRY.C                                        */
/*                                                   */
/*---------------------------------------------------*/
typedef struct
{
  PFNRM         Entry;
  USHORT        cArgs;
} RMFNTABLE;

/*---------------------------------------------------*/
/*                                                   */
/* RSMSRCH.C                                         */
/*                                                   */
/*---------------------------------------------------*/
typedef struct
{
  union
  {
    PNODELIST    pNodeL;
    PADJNODELIST pAdjNodeL;
  };

  PRMNODE     pStartNode;
  USHORT      cNodes;
  USHORT      cMaxNodes;
  USHORT      CmpLen;

  union
  {
    struct
    {
      UCHAR       SearchKey[MAX_KEY_LEN];
      UCHAR       NodeKey[MAX_KEY_LEN];
    };
    struct
    {
      PADJUNCT    pAdj;
    };
  };

} SEARCHINFO, FAR *PSEARCHINFO;

typedef USHORT (*PRMFN)();

typedef struct _NODELIST
{

  USHORT        cMaxNodes;
  USHORT        cNodes;
  PRMNODE       pNodes[1];

} NODELIST;

typedef struct  _ADJNODEINFO
  {
    PRMNODE     pNode;
    USHORT      AdjIndex;
} ADJNODEINFO;

typedef struct _ADJNODELIST
{

  USHORT        cMaxNodes;
  USHORT        cNodes;
  ADJNODEINFO   Adj[1];

} ADJNODELIST;

/*---------------------------------------------------*/
/*                                                   */
/* RSMAPIR3.C                                        */
/*                                                   */
/*---------------------------------------------------*/

#define RMMAKEHANDLE( pNode )  RMMakeHandle( (PRMNODE)(pNode))


#define FUNC_RM_BASEDEV_INIT      0x40
#define FUNC_RM_BASEDEV_FAIL      0x41
#define FUNC_RM_BASEDEV_LOAD      0x42
#define FUNC_RM_DEVICE_INIT       0x60
#define FUNC_RM_DEVICE_FAIL       0x61
#define FUNC_RM_DEVICE_LOAD       0x62


/*----------------------------------------------------------------*/
/* RMMAKELINEAR create linear address by adding offset to lbase   */
/* Beware - do sizing before addition to base so we never blow up */
/*----------------------------------------------------------------*/

#define RMMAKELINEAR( vpointer) ( ((ULONG)vpointer  -      \
                                   (ULONG)pNodeInfo +      \
                                   (ULONG)LinBase  ) )

/*---------------------------------------------------*/
/*                                                   */
/* RSMHLPR.C                                         */
/*                                                   */
/*---------------------------------------------------*/

typedef struct {
   RMHANDLE RMHandle;
   PRMNODE  pRMNode;
}HPSEUDO_LOOKUP, FAR *PHPSEUDO_LOOKUP, NEAR *NPHPSEUDO_LOOKUP;

