/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME =  RSMTRACE.C
 *
 * DESCRIPTIVE NAME =  Resource Management Driver - RAS Trace
 *
 *
 *
 * VERSION = V1.01
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 * FUNCTIONS  :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/
#define  INCL_NOBASEAPI
#define  INCL_NOPMAPI
#define  INCL_DOSERRORS
#include <os2.h>

#include <eisa.h>
#include <dskinit.h>
#include <devhdr.h>

#include "dhcalls.h"

#include "strat2.h"
#include "scsi.h"
#include "reqpkt.h"

#define RMCode SwapCode
#include "rmcalls.h"
#include "rmioctl.h"

#include "rsmcons.h"
#include "rsmtypes.h"
#include "rsmproto.h"
#include "rsmextrn.h"


/*------------------------------------------------------------------------*/
/*                                                                        */
/*                                                                        */
/*                                                                        */
/*------------------------------------------------------------------------*/



VOID NEAR RMTraceAlloc(  USHORT          Event,
                         PDRVRNODE       pDriver,
                         USHORT          ResourceType,
                         PIORESOURCE     pRes,
                         USHORT          rc            )
{
  UCHAR         TraceBuf[128];
  PBYTE         pBuf;

  PSZ           pResText;
  PSZ           pResFlgText;

  ULONG         ResOrdinal;
  ULONG         ResCount;
  USHORT        ResFlags;
  USHORT        TraceType;
  USHORT        Len;


  if ( !TEST_TRACING( pTraceBits, RSM_TRACE_MAJOR ) )
  {
    goto TraceExit;
  }

  pBuf = (PBYTE)TraceBuf;

  switch ( ResourceType )
  {
    case RS_TYPE_IO:
      pResText   = "I/O Port";
      ResOrdinal = ((PIORESOURCE)pRes)->BaseIOPort;
      ResCount   = ((PIORESOURCE)pRes)->NumIOPorts;
      ResFlags   = ((PIORESOURCE)pRes)->IOFlags;
      TraceType  = TRACE_TYPE_0;
      break;

    case RS_TYPE_IRQ:
      pResText   = "IRQ Level";
      ResOrdinal = ((PIRQRESOURCE)pRes)->IRQLevel;
      ResCount   = 0;
      ResFlags   = ((PIRQRESOURCE)pRes)->IRQFlags;
      TraceType  = TRACE_TYPE_1;
      break;

    case RS_TYPE_DMA:
      pResText   = "DMA Channel";
      ResOrdinal = ((PDMARESOURCE)pRes)->DMAChannel;
      ResCount   = 0;
      ResFlags   = ((PDMARESOURCE)pRes)->DMAFlags;
      TraceType  = TRACE_TYPE_1;
      break;

    case RS_TYPE_TIMER:
      pResText   = "Timer Channel";
      ResOrdinal = ((PTMRRESOURCE)pRes)->TMRChannel;
      ResCount   = 0;
      ResFlags   = ((PTMRRESOURCE)pRes)->TMRFlags;
      TraceType  = TRACE_TYPE_1;
      break;

    case RS_TYPE_MEM:
      pResText   = "Memory";
      ResOrdinal = ((PMEMRESOURCE)pRes)->MemBase;
      ResCount   = ((PMEMRESOURCE)pRes)->MemSize;
      ResFlags   = ((PMEMRESOURCE)pRes)->MemFlags;
      TraceType  = TRACE_TYPE_2;
      break;

    default:
      goto TraceExit;
  }

  if ( ResFlags & RS_IO_EXCLUSIVE )
  {
    pResFlgText = "EXC";
  }
  else if ( ResFlags & RS_IO_MULTIPLEXED )
  {
    pResFlgText = "MUX";
  }
  else if ( ResFlags & RS_IO_SHARED )
  {
    pResFlgText = "SHR";
  }
  else if ( ResFlags & RS_IO_GRANT_YIELD )
  {
    pResFlgText = "YLD";
  }
  else
  {
    pResFlgText = "UNK";
  }

  Len = strlen( pDriver->pDrv->DrvrName );

  memcpy( pBuf, pDriver->pDrv->DrvrName, Len+1 );

  pBuf[Len] = 0;

  pBuf += Len+1;

  strcpy( pBuf, pResText );

  pBuf += strlen( pResText ) + 1;

  *(PULONG)  pBuf = ResOrdinal;
  pBuf           += sizeof(ULONG);

  *(PULONG)  pBuf = ResCount;
  pBuf           += sizeof(ULONG);

  strcpy( pBuf, pResFlgText );

  pBuf           += strlen(pResFlgText) + 1;

  *(PUSHORT) pBuf = rc;
  pBuf           += sizeof(USHORT);

  Len = pBuf - (PBYTE)TraceBuf;

  DevHelp_RAS( (USHORT) RSM_TRACE_MAJOR,
               (USHORT) Event+TraceType,
               (USHORT) Len,
               (PBYTE)  TraceBuf             );

TraceExit: ;

}
