/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME =  RSMPROTO.H
 *
 * DESCRIPTIVE NAME =  Resource Management Driver - Function Prototypes
 *
 *
 *
 * VERSION = V1.01
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 * FUNCTIONS  :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*---------------------------------------------------*/
/* RSMAPIR3.C                                        */
/*---------------------------------------------------*/
VOID        NEAR RMStrat1(VOID);
VOID        FAR  StatusError(PRPH pRPH, USHORT ErrorCode );
VOID        FAR  RMIOCtl( PRPH pRPH );
VOID        NEAR RMEnumNodeIOCtl( PRP_GENIOCTL pRP);
VOID        NEAR RMGetNodeInfoIOCtl( PRP_GENIOCTL pRP);
VOID        NEAR RMGetEnumEntry(PRMNODE pRMNode, PNODEENTRY FAR *ppNodeEntry, USHORT Depth);
VOID        NEAR RMGetDrvrEnumEntry(PDRVRNODE pDrvrNode, PNODEENTRY FAR *ppNodeEntry, USHORT Depth);
USHORT      NEAR RMCalcNodeInfoSize( RMHANDLE RMHandle);
VOID        NEAR RMCopyAdapter( PUCHAR FAR *ppBuffer, PADAPTERSTRUCT pAS);
VOID        NEAR RMCopyDevice( PUCHAR FAR *ppBuffer, PDEVICESTRUCT pDS);
VOID        NEAR RMCopyStdNode( PUCHAR FAR *ppBuffer, ULONG NodeCookie, PVOID pDS);
VOID        NEAR RMCopyDriver( PUCHAR FAR *ppBuffer, PDRIVERSTRUCT pDS);
VOID        NEAR RMCopyResources( PUCHAR FAR *ppBuffer, PRESNODE pResNode);
VOID        NEAR RMCopyLDev(PUCHAR FAR *ppBuffer, PLDEVSTRUCT pLS);
VOID        NEAR RMCopySysName(PUCHAR FAR *ppBuffer, PSYSNAMESTRUCT pSS);
VOID        NEAR RMFixNodeInfoPointers( PRM_NODE pNodeInfo);
VOID        NEAR RMFixAdapterPointers( PRM_NODE pNodeInfo, LIN LinBase);
VOID        NEAR RMFixDevicePointers( PRM_NODE pNodeInfo, LIN LinBase);
VOID        NEAR RMFixDriverPointers( PRM_NODE pNodeInfo, LIN LinBase);
VOID        NEAR RMFixLDevPointers( PRM_NODE pNodeInfo, LIN LinBase);
VOID        NEAR RMFixSysNamePointers( PRM_NODE pNodeInfo, LIN LinBase);
VOID        NEAR RMKrnlIOCtl( PRP_GENIOCTL pRP);

#pragma alloc_text( SwapCode, RMIOCtl )
#pragma alloc_text( SwapCode, RMEnumNodeIOCtl )
#pragma alloc_text( SwapCode, RMGetEnumEntry )
#pragma alloc_text( SwapCode, RMGetDrvrEnumEntry )
#pragma alloc_text( SwapCode, RMGetNodeInfoIOCtl )
#pragma alloc_text( SwapCode, RMCalcNodeInfoSize )
#pragma alloc_text( SwapCode, RMCopyAdapter )
#pragma alloc_text( SwapCode, RMCopyDevice )
#pragma alloc_text( SwapCode, RMCopyStdNode )
#pragma alloc_text( SwapCode, RMCopyDriver )
#pragma alloc_text( SwapCode, RMCopyResources )
#pragma alloc_text( SwapCode, RMCopyLDev)
#pragma alloc_text( SwapCode, RMCopySysName)
#pragma alloc_text( SwapCode, RMFixNodeInfoPointers )
#pragma alloc_text( SwapCode, RMFixAdapterPointers  )
#pragma alloc_text( SwapCode, RMFixDevicePointers  )
#pragma alloc_text( SwapCode, RMFixDriverPointers  )
#pragma alloc_text( SwapCode, RMFixLDevPointers  )
#pragma alloc_text( SwapCode, RMFixSysNamePointers  )
#pragma alloc_text( SwapCode, RMKrnlIOCtl )

/*---------------------------------------------------*/
/* RSMINIT.C                                         */
/*---------------------------------------------------*/
VOID        FAR  RMInit(PRPINITIN pRPH );
USHORT      NEAR RMAllocInit(VOID);

PRMNODE     NEAR RMBusInit(  PMACHINE_CONFIG_INFO pMCHI );
PRMNODE     NEAR RMInitXBus( PMACHINE_CONFIG_INFO pMCHI, PRMNODE pCpuNode );
PRMNODE     NEAR RMInitISA(  PMACHINE_CONFIG_INFO pMCHI, PRMNODE pCpuNode );
PRMNODE     NEAR RMInitMCA(  PMACHINE_CONFIG_INFO pMCHI, PRMNODE pCpuNode );
PRMNODE     NEAR RMInitEISA( PMACHINE_CONFIG_INFO pMCHI, PRMNODE pCpuNode );
PRMNODE     NEAR RMInitPCI(  PMACHINE_CONFIG_INFO pMCHI, PRMNODE pCpuNode );
VOID        NEAR RMInitROMScan( PRMNODE pROMAdpt );
VOID        NEAR RMInitLDEV( VOID );
VOID        NEAR RMInitPseudoHandles( VOID );



/*---------------------------------------------------*/
/* RSMALLOC.C                                        */
/*---------------------------------------------------*/
PUCHAR      FAR  RMAlloc( USHORT cBytes );
VOID        FAR  RMFree( PUCHAR pUserBuf );

USHORT      NEAR FindFreeBlock( USHORT cBytes, PBUFINFO pBUFInfo );
PBUFHEADER  NEAR AllocBuf( USHORT cBytes, PBUFINFO pBUFInfo );

#pragma alloc_text( SwapCode, RMAlloc       )
#pragma alloc_text( SwapCode, RMFree        )

#pragma alloc_text( SwapCode, FindFreeBlock )
#pragma alloc_text( SwapCode, AllocBuf      )

/*---------------------------------------------------*/
/* RSMAPIR0.C                                        */
/*---------------------------------------------------*/

USHORT _loadds FAR RSMGetVersion(PUCHAR    pMajorVersion,
                                 PUCHAR    pMinorVersion);

USHORT _loadds FAR RSMCreateDriver(PDRIVERSTRUCT pDriverStruct,
                                   PHDRIVER      phDriver);

USHORT _loadds FAR RSMDestroyDriver(HDRIVER hDriver);

USHORT _loadds FAR RSMCreateAdapter(HDRIVER        hDriver,
                                    PHADAPTER      phAdapter,
                                    PADAPTERSTRUCT pAdapterStruct,
                                    HDEVICE        hDevice,
                                    PAHRESOURCE    pahResource);

USHORT _loadds FAR RSMDestroyAdapter(HDRIVER  hDriver,
                                     HADAPTER hAdapter);


USHORT _loadds FAR RSMCreateDevice(HDRIVER       hDriver,
                                   PHDEVICE      phDevice,
                                   PDEVICESTRUCT pDeviceStruct,
                                   HADAPTER      hAdapter,
                                   PAHRESOURCE   pahResource);

USHORT _loadds FAR RSMDestroyDevice(HDRIVER hDriver,
                                    HDEVICE hDevice);

USHORT _loadds FAR RSMAllocResource(HDRIVER         hDriver,
                                    PHRESOURCE      phResource,
                                    PRESOURCESTRUCT pResourceStruct);


USHORT _loadds FAR RSMDeallocResource(HDRIVER   hDriver,
                                      HRESOURCE hResource);

USHORT _loadds FAR RSMClaimResources(HDRIVER  hDriver,
                                     HADAPTER hAdapter);

USHORT _loadds FAR RSMReleaseResources(HDRIVER  hDriver,
                                       HADAPTER hAdapter);

USHORT _loadds FAR RSMCreateLDev(HDRIVER     hDriver,
                                 PHLDEV      phLDev,
                                 HDEVICE     hDevice,
                                 PLDEVSTRUCT pLDevStruct);

USHORT _loadds FAR RSMDestroyLDev(HDRIVER hDriver,
                                  HLDEV   hLDev);

USHORT _loadds FAR RSMCreateSysName(HDRIVER        hDriver,
                                    PHSYSNAME      phSysName,
                                    HLDEV          hLDev,
                                    PSYSNAMESTRUCT pSysNameStruct);

USHORT _loadds FAR RSMDestroySysName(HDRIVER    hDriver,
                                     HSYSNAME   hSysName);

USHORT _loadds FAR RSMADDToHDEVICE(PHDEVICE phDevice,
                                   USHORT   ADDHandle,
                                   USHORT   UnitHandle);

USHORT _loadds FAR RSMKeyToHandleList( HADAPTER    hStartNode,
                                       PSZ         Key,
                                       PHANDLELIST pHndList     );

USHORT _loadds FAR RSMHandleToType( RMHANDLE  hHandle,
                                    PUSHORT   pHandleType );

USHORT _loadds FAR RSMHandleToParent( RMHANDLE   hHandle,
                                      PRMHANDLE  phParent );

USHORT _loadds FAR RSMUpdateAdjunct(HDRIVER  hDriver,
                                    HDEVICE  hDevice,
                                    USHORT   AdjunctIndex,
                                    PADJUNCT pAdjunct   );

USHORT _loadds FAR RSMAdjToHandleList( PADJUNCT    pAdj,
                                       HADAPTER    hStartNode,
                                       PADJHANDLELIST pHndList     );

USHORT _loadds FAR RSMHDevToHLDev( HDEVICE  hDevice,
                                   HDEVICE  hStartLDev,
                                   PHLDEV   phLDev );

USHORT _loadds FAR RSMResToHandleList( PRESOURCESTRUCT   pRes,
                                       PHANDLELIST       pHndList );

USHORT _loadds FAR RSMActivateAdapter(HDRIVER  hDriver,
                                      HADAPTER hAdapter);

USHORT _loadds FAR RSMDeactivateAdapter(HDRIVER  hDriver,
                                        HADAPTER hAdapter);

USHORT _loadds FAR RSMCreateLinkDevice(HDRIVER       hDriver,
                                       PHDEVICE      phLinkDevice,
                                       PDEVICESTRUCT pDeviceStruct,
                                       PAHDEVICES    pahDevices);

USHORT _loadds FAR RSMModifyResources(HDRIVER   hDriver,
                                      HADAPTER  hAdapter,
                                      USHORT    ModifyAction,
                                      HRESOURCE hResource);


USHORT _loadds FAR RSMGetNodeInfo(RMHANDLE         RMHandle,
                                  PRM_GETNODE_DATA pNodeInfo,
                                  USHORT           BufferSize);

USHORT _loadds FAR RSMParseScsiInquiry(PVOID            pInquiry,
                                       PSZ              pDescBuffer,
                                       USHORT           BufferSize);


#pragma alloc_text( SwapCode, RSMGetVersion)
#pragma alloc_text( SwapCode, RSMCreateDriver)
#pragma alloc_text( SwapCode, RSMDestroyDriver)
#pragma alloc_text( SwapCode, RSMCreateAdapter)
#pragma alloc_text( SwapCode, RSMDestroyAdapter)
#pragma alloc_text( SwapCode, RSMCreateDevice)
#pragma alloc_text( SwapCode, RSMDestroyDevice)
#pragma alloc_text( SwapCode, RSMAllocResource)
#pragma alloc_text( SwapCode, RSMDeallocResource)
#pragma alloc_text( SwapCode, RSMClaimResources)
#pragma alloc_text( SwapCode, RSMReleaseResources)
#pragma alloc_text( SwapCode, RSMCreateLDev)
#pragma alloc_text( SwapCode, RSMDestroyLDev)
#pragma alloc_text( SwapCode, RSMCreateSysName)
#pragma alloc_text( SwapCode, RSMDestroySysName)
#pragma alloc_text( SwapCode, RSMADDToHDEVICE)
#pragma alloc_text( SwapCode, RSMKeyToHandleList)
#pragma alloc_text( SwapCode, RSMHandleToType)
#pragma alloc_text( SwapCode, RSMHandleToParent)
#pragma alloc_text( SwapCode, RSMUpdateAdjunct)
#pragma alloc_text( SwapCode, RSMAdjToHandleList)
#pragma alloc_text( SwapCode, RSMHDevToHLDev)
#pragma alloc_text( SwapCode, RSMResToHandleList)
#pragma alloc_text( SwapCode, RSMActivateAdapter)
#pragma alloc_text( SwapCode, RSMDeactivateAdapter)
#pragma alloc_text( SwapCode, RSMCreateLinkDevice)
#pragma alloc_text( SwapCode, RSMModifyResources)
#pragma alloc_text( SwapCode, RSMGetNodeInfo)
#pragma alloc_text( SwapCode, RSMParseScsiInquiry)

/*---------------------------------------------------*/
/* RSMNODE.C                                         */
/*---------------------------------------------------*/
PRMNODE     FAR  f_RMCreateAdapterNode( PADAPTERSTRUCT   pAS );
PRMNODE     NEAR   RMCreateAdapterNode( PADAPTERSTRUCT   pAS );
PRMNODE     FAR  f_RMCreateDeviceNode( PDEVICESTRUCT     pDS );
PRMNODE     NEAR   RMCreateDeviceNode( PDEVICESTRUCT     pDS );
PRMNODE     NEAR   RMCreateStdNode( ULONG NodeCookie, PVOID pDS );
USHORT      FAR  f_RMDeleteRMNode( PRMNODE pNodeDel );
USHORT      NEAR   RMDeleteRMNode( PRMNODE pNodeDel );
PRESNODE    FAR  f_RMCreateResourceNode( PRESOURCESTRUCT pRS );
PRESNODE    NEAR   RMCreateResourceNode( PRESOURCESTRUCT pRS );
USHORT      FAR  f_RMDeleteResourceNode( PRESNODE pResNodeDel  );
USHORT      NEAR   RMDeleteResourceNode( PRESNODE pResNodeDel  );
PDRVRNODE   FAR  f_RMCreateDriverNode( PDRIVERSTRUCT     pDS );
PDRVRNODE   NEAR   RMCreateDriverNode( PDRIVERSTRUCT     pDS );
USHORT      FAR  f_RMDeleteDriverNode( PDRVRNODE pDriverDel );
USHORT      NEAR   RMDeleteDriverNode( PDRVRNODE pDriverDel );
VOID        FAR  f_RMAddChild(PRMNODE pParentNode, PRMNODE pChildNode );
VOID        NEAR   RMAddChild( PRMNODE pParentNode, PRMNODE pChildNode );
VOID        FAR  f_RMRegisterNode( PDRVRNODE pDriverNode, PRMNODE pRMNode);
VOID        NEAR   RMRegisterNode(   PDRVRNODE pDriverNode, PRMNODE pRMNode);
VOID        NEAR   RMUpdateKey( PSZ d, USHORT Ord1, USHORT Ord2 );
PSZ         NEAR   RMItoA( PSZ d, USHORT Value );
USHORT      NEAR   RMDestroyRMNode(PDRVRNODE pDrvrNode, PRMNODE pRMNode);
USHORT      NEAR   RMDestroyFamily( PRMNODE pRMNode );
USHORT      NEAR   RMDestroyMyNode( PRMNODE pRMNode );


#pragma alloc_text( SwapCode, f_RMCreateAdapterNode, RMCreateAdapterNode      )
#pragma alloc_text( SwapCode, f_RMCreateDeviceNode,  RMCreateDeviceNode       )
#pragma alloc_text( SwapCode,   RMCreateStdNode                               )
#pragma alloc_text( SwapCode, f_RMDeleteRMNode,      RMDeleteRMNode           )
#pragma alloc_text( SwapCode, f_RMCreateDriverNode,  RMCreateDriverNode       )
#pragma alloc_text( SwapCode, f_RMDeleteDriverNode,  RMDeleteDriverNode       )
#pragma alloc_text( SwapCode, f_RMCreateResourceNode,RMCreateResourceNode     )
#pragma alloc_text( SwapCode, f_RMDeleteResourceNode,RMDeleteResourceNode     )
#pragma alloc_text( SwapCode, f_RMAddChild,          RMAddChild               )
#pragma alloc_text( SwapCode, f_RMRegisterNode,      RMRegisterNode           )
#pragma alloc_text( SwapCode,   RMUpdateKey                                   )
#pragma alloc_text( SwapCode,   RMItoA                                        )
#pragma alloc_text( SwapCode,   RMDestroyRMNode                               )
#pragma alloc_text( SwapCode,   RMDestroyFamily                               )
#pragma alloc_text( SwapCode,   RMDestroyMyNode                               )

/*---------------------------------------------------*/
/* RSMRSRC.C                                         */
/*---------------------------------------------------*/
USHORT      FAR  f_RMRegisterResourceClass( USHORT ResClass, USHORT ResOrdinal,
                                            PRMNODE pDevice  );
USHORT      NEAR   RMRegisterResourceClass( USHORT ResClass, USHORT ResOrdinal,
                                            PRMNODE pDevice  );

VOID        FAR  f_RMAddResource( PRMNODE pNode, PRESNODE pResourceNode );
VOID        NEAR   RMAddResource( PRMNODE pNode, PRESNODE pResourceNode );


VOID        NEAR RMAddIOResource(  PRMNODE pNode, PRESNODE pResourceNode );
VOID        NEAR RMAddMEMResource( PRMNODE pNode, PRESNODE pResourceNode );
VOID        NEAR RMAddDMAorIRQResource( PRMNODE pNode, PRESNODE pResourceNode );

PRESHDR     NEAR RMFindResourceHdr( USHORT ResClass, USHORT ResOrdinal );

USHORT      NEAR RMUnlinkResourceNode( PRESNODE pResNodeDel );

USHORT      FAR  f_RMCheckResConflict( PRESOURCESTRUCT pRes, PRMNODE pAdptNode );
USHORT      NEAR   RMCheckResConflict( PRESOURCESTRUCT pRes, PRMNODE pAdptNode );

USHORT      FAR  f_RMCheckIOConflict( PIORESOURCE pIO, PRMNODE pAdptNode );
USHORT      NEAR   RMCheckIOConflict( PIORESOURCE pIO, PRMNODE pAdptNode );

USHORT      NEAR   RMCheckIOConflictSub( PIORESOURCE pIO, PRMNODE pAdptShare,
                                         PRMFN pRMFcn,    PVOID pRMFcnParm     );

USHORT      NEAR   CalcDecodeMask( USHORT IOLines );
USHORT      NEAR   CalcAlignMask(  USHORT Num     );

USHORT      FAR  f_RMCheckIRQConflict( PIRQRESOURCE pIRQ );
USHORT      NEAR   RMCheckIRQConflict( PIRQRESOURCE pIRQ );

USHORT      NEAR   RMCheckIRQConflictSub( PIRQRESOURCE pIRQ, PRMNODE pUnused,
                                          PRMFN pRMFcn,      PVOID pRMFcnParm );

USHORT      FAR  f_RMCheckDMAConflict( PDMARESOURCE pDMA );
USHORT      NEAR   RMCheckDMAConflict( PDMARESOURCE pDMA );

USHORT      NEAR   RMCheckDMAConflictSub( PDMARESOURCE pDMA, PRMNODE pUnused,
                                          PRMFN  pRMFcn,     PVOID   pRMFcnParm );

USHORT      FAR  f_RMCheckTMRConflict( PTMRRESOURCE pTMR );
USHORT      NEAR   RMCheckTMRConflict( PTMRRESOURCE pTMR );

USHORT      NEAR   RMCheckTMRConflictSub( PTMRRESOURCE pTMR, PRMNODE pUnused,
                                          PRMFN      pRMFcn, PVOID   pRMFcnParm );

USHORT      FAR  f_RMCheckMEMConflict( PMEMRESOURCE pMEM );
USHORT      NEAR   RMCheckMEMConflict( PMEMRESOURCE pMEM );

USHORT      NEAR   RMCheckMEMConflictSub( PMEMRESOURCE pMEM, PRMNODE pUnused,
                                          PRMFN      pRMFcn, PVOID   pRMFcnParm );

USHORT      NEAR   RMFindIOPorts( PIORESOURCE pIO );
USHORT      NEAR   RMFindMemSpace( PMEMRESOURCE pMEM );


#pragma alloc_text( SwapCode, f_RMRegisterResourceClass                       )
#pragma alloc_text( SwapCode,   RMRegisterResourceClass                       )
#pragma alloc_text( SwapCode, f_RMAddResource,       RMAddResource            )

#pragma alloc_text( SwapCode, RMAddIOResource  )
#pragma alloc_text( SwapCode, RMAddMEMResource )
#pragma alloc_text( SwapCode, RMAddDMAorIRQResource )

#pragma alloc_text( SwapCode, RMFindResourceHdr )

#pragma alloc_text( SwapCode, RMUnlinkResourceNode )

#pragma alloc_text( SwapCode, f_RMCheckResConflict,  RMCheckResConflict       )
#pragma alloc_text( SwapCode, f_RMCheckIOConflict,   RMCheckIOConflict        )
#pragma alloc_text( SwapCode,   RMCheckIOConflictSub                          )
#pragma alloc_text( SwapCode,   CalcDecodeMask )
#pragma alloc_text( SwapCode,   CalcAlignMask )
#pragma alloc_text( SwapCode, f_RMCheckIRQConflict,   RMCheckIRQConflict      )
#pragma alloc_text( SwapCode,   RMCheckIRQConflictSub                         )
#pragma alloc_text( SwapCode, f_RMCheckDMAConflict,   RMCheckDMAConflict      )
#pragma alloc_text( SwapCode,   RMCheckDMAConflictSub                         )
#pragma alloc_text( SwapCode, f_RMCheckTMRConflict,   RMCheckTMRConflict      )
#pragma alloc_text( SwapCode,   RMCheckTMRConflictSub  )
#pragma alloc_text( SwapCode, f_RMCheckMEMConflict,   RMCheckMEMConflict      )
#pragma alloc_text( SwapCode,   RMCheckMEMConflictSub  )
#pragma alloc_text( SwapCode,   RMFindIOPorts          )
#pragma alloc_text( SwapCode,   RMFindMemSpace         )

/*---------------------------------------------------*/
/* RSMLDEV.C                                         */
/*---------------------------------------------------*/

PRMNODE     FAR  f_RMCreateLDEVNode( PLDEVSTRUCT pLDS );
PRMNODE     NEAR   RMCreateLDEVNode( PLDEVSTRUCT pLDS );

USHORT      FAR  f_RMLinkLDEVNode( PRMNODE pLDevParent, PRMNODE pLDev,
                                   PRMNODE pDevAssoc );
USHORT      NEAR   RMLinkLDEVNode( PRMNODE pLDevParent, PRMNODE pLDev,
                                   PRMNODE pDevNode );

USHORT      FAR  f_RMDeleteLDEVNode( PRMNODE pNodeDel );
USHORT      NEAR   RMDeleteLDEVNode( PRMNODE pNodeDel );

PRMNODE     NEAR   RMCreateSysNameNode( PSYSNAMESTRUCT pSNS );
USHORT      NEAR   RMDeleteSysNameNode( PRMNODE pNodeDel );

#pragma alloc_text( SwapCode, f_RMCreateLDEVNode,   RMCreateLDEVNode     )
#pragma alloc_text( SwapCode, f_RMLinkLDEVNode,     RMLinkLDEVNode       )
#pragma alloc_text( SwapCode, f_RMDeleteLDEVNode,   RMDeleteLDEVNode     )
#pragma alloc_text( SwapCode, RMCreateSysNameNode )
#pragma alloc_text( SwapCode, RMDeleteSysNameNode  )

/*---------------------------------------------------*/
/* RSMSRCH.C                                         */
/*---------------------------------------------------*/

PRMNODE     NEAR   RMDevToLDev( PRMNODE pLDev, PRMNODE pDev );
PRMNODE     NEAR   RMDevToLDevSub( PRMNODE pLDev, PRMNODE pDev );

VOID        NEAR   RMAdjToNodeList( PRMNODE pDev, PADJUNCT pAdj, PADJNODELIST pNodeList );
VOID        NEAR   RMAdjToNodeListSub( PRMNODE pNode, PSEARCHINFO pSI );

VOID        FAR  f_RMKeyToNodeList( PSZ pKey, PRMNODE pNode, PNODELIST pNodeList );
VOID        NEAR   RMKeyToNodeList( PSZ pKey, PRMNODE pNode, PNODELIST pNodeList );
VOID        NEAR   RMKeyToNodeSub( PRMNODE pNode, PSEARCHINFO pSI );

VOID        NEAR   RMCpyKey( PSZ d, PSZ s );

VOID        FAR  f_RMResourceToNodeList( PRESOURCESTRUCT pRes, PNODELIST pNodeList );
VOID        NEAR   RMResourceToNodeList( PRESOURCESTRUCT pRes, PNODELIST pNodeList );

USHORT      NEAR   RMNodeListFcn( PRESNODE pResNode, PNODELIST pNodeList );

#pragma alloc_text( SwapCode,   RMDevToLDev )
#pragma alloc_text( SwapCode,   RMDevToLDevSub )
#pragma alloc_text( SwapCode,   RMAdjToNodeList  )
#pragma alloc_text( SwapCode,   RMAdjToNodeListSub   )
#pragma alloc_text( SwapCode,   f_RMKeyToNodeList, RMKeyToNodeList  )
#pragma alloc_text( SwapCode,   RMKeyToNodeSub   )
#pragma alloc_text( SwapCode,   RMCpyKey         )
#pragma alloc_text( SwapCode,   RMResourceToNodeList, f_RMResourceToNodeList )
#pragma alloc_text( SwapCode,   RMNodeListFcn    )

/*---------------------------------------------------*/
/* RSMHLPR.C                                         */
/*---------------------------------------------------*/

PRMNODE  NEAR RMNodeFromHandle(   RMHANDLE RMHandle, ULONG Cookie );
PRMNODE  NEAR RMNodeFromBusType( USHORT HostBusType );
RMHANDLE NEAR RMMakeHandle( PRMNODE pNode );
USHORT   NEAR RMEntry(VOID);
USHORT   NEAR RMExit(VOID);
USHORT   NEAR RMGetResFlags( PRESNODE pResNode );                   /*@V103757*/

#pragma alloc_text( SwapCode, RMNodeFromHandle )
#pragma alloc_text( SwapCode, RMNodeFromBusType )
#pragma alloc_text( SwapCode, RMMakeHandle )
#pragma alloc_text( SwapCode, RMEntry      )
#pragma alloc_text( SwapCode, RMExit       )
#pragma alloc_text( SwapCode, RMGetResFlags)                        /*@V103757*/


/*---------------------------------------------------*/
/* RSMENTRY.C                                        */
/*---------------------------------------------------*/

USHORT FAR _loadds RSMR3Entry(VOID);
USHORT FAR _loadds RSMR0Entry( USHORT RMIndex );

/*---------------------------------------------------*/
/* RSMTRACE.C                                        */
/*---------------------------------------------------*/
VOID NEAR RMTraceAlloc(  USHORT          Event,
                         PDRVRNODE       pDriver,
                         USHORT          ResourceType,
                         PIORESOURCE     pRes,
                         USHORT          rc            );

#pragma alloc_text( SwapCode, RMTraceAlloc       )
