/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME =  RSMLDEV.C
 *
 * DESCRIPTIVE NAME =  Resource Management Driver - LDEV Node Serivces
 *
 *
 *
 * VERSION = V1.01
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 * FUNCTIONS  :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/
#define  INCL_NOBASEAPI
#define  INCL_NOPMAPI
#define  INCL_DOSERRORS
#include <os2.h>

#include <dskinit.h>

#include "dhcalls.h"

#include "strat2.h"
#include "scsi.h"
#include "reqpkt.h"

#define RMCode SwapCode
#include "rmcalls.h"
#include "rmioctl.h"

#include "rsmcons.h"
#include "rsmtypes.h"
#include "rsmproto.h"
#include "rsmextrn.h"

/*--------------------------------------------------------*/
/*                                                        */
/* RMCreateLDEVNode                                       */
/*                                                        */
/*                                                        */
/*                                                        */
/*--------------------------------------------------------*/

PRMNODE FAR f_RMCreateLDEVNode( PLDEVSTRUCT pLDS )
{
  return ( RMCreateLDEVNode( pLDS ) );
}

PRMNODE NEAR RMCreateLDEVNode( PLDEVSTRUCT pLDS )
{
  return( RMCreateStdNode( LDEV_NODE_COOKIE, pLDS ) );
}

/*--------------------------------------------------------*/
/*                                                        */
/* RMLinkLDEVNode                                         */
/*                                                        */
/*                                                        */
/*                                                        */
/*--------------------------------------------------------*/

USHORT FAR f_RMLinkLDEVNode( PRMNODE pLDevParent, PRMNODE pLDev,
                             PRMNODE pDevAssoc )
{
  return ( RMLinkLDEVNode( pLDevParent, pLDev, pDevAssoc ) );
}

USHORT NEAR RMLinkLDEVNode( PRMNODE pLDevParent, PRMNODE pLDev,
                            PRMNODE pDevAssoc )
{

  if ( pLDev->pDevParent )
  {
    _asm int 3
    return ( 1 );
  }
  if ( pLDev->pDevAssoc )
  {
    _asm int 3
    return ( 1 );
  }

  RMAddChild( pLDevParent, pLDev );

  return ( 0 );
}


/*--------------------------------------------------------*/
/*                                                        */
/* RMDeleteLDEVNode                                       */
/*                                                        */
/*                                                        */
/*                                                        */
/*--------------------------------------------------------*/

USHORT FAR f_RMDeleteLDEVNode( PRMNODE pNodeDel )
{
  return ( RMDeleteLDEVNode( pNodeDel ) );
}

USHORT NEAR RMDeleteLDEVNode( PRMNODE pNodeDel )
{
  PRMNODE       pDevNode;

  /*-----------------------------------------------*/
  /* Mark associated device node as nolonger being */
  /* referenced by LDev Node                       */
  /*-----------------------------------------------*/

  cRMNodes++;       /* Fix up for decrement in RMDeleteRMNode */
  cRMLNodes--;
  return( RMDeleteRMNode( pNodeDel ) );
}

/*--------------------------------------------------------*/
/*                                                        */
/* RMCreateSysNameNode                                    */
/*                                                        */
/*                                                        */
/*                                                        */
/*--------------------------------------------------------*/

PRMNODE NEAR RMCreateSysNameNode( PSYSNAMESTRUCT pSDS )
{
  return ( RMCreateStdNode( SYS_NODE_COOKIE, pSDS ) );
}
