/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME =  RSMEXTRN.H
 *
 * DESCRIPTIVE NAME =  Resource Management Driver - External Data Declarations
 *
 *
 *
 * VERSION = V1.01
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 * FUNCTIONS  :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/
/*------------------------------------------------------------------------*/
/*                                                                        */
/* Global Data Declarations                                               */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*---------------------------------------------------*/
/* RSMINIT.C                                         */
/*---------------------------------------------------*/
extern PFN        Device_Help;

extern PRMNODE    PDevPtrs[MAX_PDEV_PTRS];
extern PRMNODE    LDevPtrs[MAX_LDEV_CLASSES];
extern USHORT     NumLDevClasses;

extern PRESHDR         ResHeader[];
extern USHORT          NumResClasses;
extern USHORT          cUnique;

extern HPSEUDO_LOOKUP  PseudoLookup[];

/*---------------------------------------------------*/
/* RSMALLOC.C                                        */
/*---------------------------------------------------*/
extern USHORT     cAllocations;
extern PBUFHEADER pBUFChain;


/*---------------------------------------------------*/
/* RSMDATA.C                                         */
/*---------------------------------------------------*/
extern USHORT     RMInitData;

/*---------------------------------------------------*/
/* RSMAPIR0.C                                        */
/*---------------------------------------------------*/

extern SEL       RMR3CallGate;
extern RMFNTABLE RMFunctionTable[];

extern PSZ pszKeyFixDisk;
extern PSZ pszKeyTape;
extern PSZ pszKeyPrinter;
extern PSZ pszKeyCPU;
extern PSZ pszKeyWORM;
extern PSZ pszKeyCDROM;
extern PSZ pszKeyScanner;
extern PSZ pszKeyOpticalMem;
extern PSZ pszKeyChanger;
extern PSZ pszKeyComm;
extern PSZ pszKeyScsiUnknown;


/*---------------------------------------------------*/
/* RSMAPIR3.C                                        */
/*---------------------------------------------------*/

extern USHORT DriverState;
extern DRIVERSTRUCT DummyDriver;
extern UCHAR DummyBasedevTxt[];
extern UCHAR DummyDeviceTxt[];

/*---------------------------------------------------*/
/* RSMNODE.C                                         */
/*---------------------------------------------------*/

extern USHORT     cRMNodes;
extern USHORT     cRMDrvrNodes;

/*---------------------------------------------------*/
/* RSMLDEV.C                                         */
/*---------------------------------------------------*/

extern USHORT     cRMLNodes;

/*---------------------------------------------------*/
/* RSMHLPR.C                                         */
/*---------------------------------------------------*/
extern USHORT     RSMSem;
extern USHORT     RSMWaitCount;
extern PULONG     pCurIntLevel;
extern SEL        RMPools[];

/*---------------------------------------------------*/
/* RSMTRACE.C                                        */
/*---------------------------------------------------*/
extern PBYTE      pTraceBits;

/*---------------------------------------------------*/
/* RSMSEGS.ASM                                       */
/*---------------------------------------------------*/
extern BYTE   FAR RMDDHeader;
extern USHORT     RMPoolSize;
extern UCHAR  FAR RMPool[];



/*------------------------------------------------------------------------*/
/*                                                                        */
/*      Initialization Data                                               */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*------------------------------------*/
/* RMINIT.C                           */
/*------------------------------------*/
extern USHORT     RMInitData;

extern PORTLIST   DMAPort[NUM_DMA_CHANNELS*NUM_DMA_CONTROLLERS][NUM_DMA_PORT_RANGES];
extern PORTLIST   VGAPorts[NUM_VGA_PORT_RANGES];

extern UCHAR      CpuText386[]  ;
extern UCHAR      CpuText486[]  ;
extern UCHAR      CpuText586[]  ;
extern UCHAR      CpuTextxxx[]  ;

extern UCHAR      PDevTxtRoot[] ;
extern UCHAR      PCIBusText[]  ;
extern UCHAR      ISABusText[]  ;
extern UCHAR      MCABusText[]  ;
extern UCHAR      EISABusText[] ;

extern UCHAR      XBusText[]    ;
extern UCHAR      MemText[]     ;
extern UCHAR      IRQText[]     ;
extern UCHAR      PICText[]     ;
extern UCHAR      DMAText[]     ;
extern UCHAR      DMAChnText[]  ;
extern UCHAR      VGAText[]     ;
extern UCHAR      TmrText[]     ;
extern UCHAR      TmrChnText[]  ;
extern UCHAR      BIOSText[]    ;
extern UCHAR      RTCText[]     ;

extern LDEVLIST     LDevNodes[NUM_LDEV_CLASSES];

extern DRIVERSTRUCT RMDriverStruct;
extern DRIVERSTRUCT KrnlDriverStruct;

extern UCHAR EISASlotDescript[];
extern UCHAR MCASlotDescript[];

extern DEVICESTRUCT SlotDevice;
