/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME =  RSMENTRY.C
 *
 * DESCRIPTIVE NAME =  Resource Management Driver -
 *
 *
 *
 * VERSION = V1.01
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 * FUNCTIONS  :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/
#define  INCL_NOBASEAPI
#define  INCL_NOPMAPI
#define  INCL_DOSERRORS
#include <os2.h>

#include <eisa.h>
#include <dskinit.h>

#include "dhcalls.h"

#include "strat2.h"
#include "scsi.h"
#include "reqpkt.h"

#define RMCode SwapCode
#include "rmcalls.h"
#include "rmioctl.h"

#include "rmlib.h"

#include "rsmcons.h"
#include "rsmtypes.h"
#include "rsmproto.h"
#include "rsmextrn.h"


/*------------------------------------------------------------------------*/
/*                                                                        */
/*                                                                        */
/*                                                                        */
/*------------------------------------------------------------------------*/


/*------------------------------------*/
/*                                    */
/*                                    */
/*                                    */
/*                                    */
/*                                    */
/*------------------------------------*/

USHORT FAR _loadds RSMR0Entry( USHORT RMIndex )
{
  PFN  RMRoutine;

  RMRoutine = (PFN) RMFunctionTable[RMIndex].Entry;

  _asm  mov   ax, RMRoutine[0]
  _asm  mov   dx, RMRoutine[2]

  _asm  pop   ds
  _asm  leave            ; Delete RSMR0Entry Frame
  _asm  add   sp, 4      ; Delete CallRM return addr

  _asm  leave            ; Delete CallRM frame
  _asm  add   sp, 4      ; Delete Stub return addr

  _asm  leave            ; Delete Stub Frame

  _asm  push  dx         ; Push RSM Function Addr
  _asm  push  ax
  _asm  retf             ; Enter RM Function
}

/* struct _R3Frame                                                   */
/* {                                                                 */
/*                                                                   */
/*   USHORT        RSMR3_BP;                                         */
/*   PVOID         RSMR3_RA;                                         */
/*   PUSHORT       pRMIndex;                                         */
/*   USHORT        RMCall_BP;                                        */
/*   PVOID         RMCall_RA;                                        */
/*   USHORT        RMIndex;                                          */
/*   USHORT        RMLib_BP;                                         */
/*   PVOID         RMLib_RA;                                         */
/*   USHORT        RMLib_Parms[1];                                   */
/*                                                                   */
/* } R3Frame;                                                        */


USHORT FAR _loadds RSMR3Entry()
{
  PFNRM    pRMRoutine;
  USHORT   RMParmCount;
  USHORT   RMIndex;
  PBYTE    pR3Parms;

  _asm     mov     ax, ss:[si][0]
  _asm     mov     RMIndex, ax

  _asm     mov     ax, ss:[si][2]
  _asm     mov     pR3Parms[0], ax

  _asm     mov     ax, ss:[si][4]
  _asm     mov     pR3Parms[2], ax

  pRMRoutine   = (PFNRM) RMFunctionTable[RMIndex].Entry;
  RMParmCount  =         RMFunctionTable[RMIndex].cArgs;

  _asm      mov    si, RMParmCount
  _asm      shl    si, 1

  _asm      les    bx, pR3Parms

 CopyParms:  ;
  _asm      mov    ax, es:[bx][si-2]
  _asm      push   ax
  _asm      sub    si, 2
  _asm      jnz    CopyParms

  _asm      call   dword ptr pRMRoutine

  _asm      mov    si, RMParmCount
  _asm      shl    si, 1
  _asm      add    sp, si

  _asm      stc
}

