/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME =  RSMDATA.C
 *
 * DESCRIPTIVE NAME =  Resource Management Driver - Memory allocation
 *
 *
 *
 * VERSION = V1.01
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 * FUNCTIONS  :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/
#define  INCL_NOBASEAPI
#define  INCL_NOPMAPI
#define  INCL_DOSERRORS
#include <os2.h>

#include <dskinit.h>

#include "dhcalls.h"

#include "strat2.h"
#include "scsi.h"
#include "reqpkt.h"

#define RMCode SwapCode
#include "rmcalls.h"
#include "rmioctl.h"

#include "rmlib.h"

#include "rsmcons.h"
#include "rsmtypes.h"
#include "rsmproto.h"
#include "rsmextrn.h"

/*------------------------------------------------------------------------*/
/*                                                                        */
/* Global Data Declarations                                               */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*---------------------------------------------------*/
/* RSMINIT.C                                         */
/*---------------------------------------------------*/
PFN             Device_Help           = 0L;

PRMNODE         PDevPtrs[MAX_PDEV_PTRS]    =  { 0 };

PRMNODE         LDEVPtrs[MAX_LDEV_CLASSES] =  { 0 };
USHORT          NumLDevClasses        = NUM_LDEV_CLASSES;

PRESHDR         ResHeader[MAX_RESOURCE_CLASSES] = { 0 };
USHORT          NumResClasses                   = NUM_DEFAULT_RESOURCES;

USHORT          cUnique                = 1;

HPSEUDO_LOOKUP  PseudoLookup[LOOKUP_SIZE] =
{ HANDLE_PHYS_TREE     , NULL,
  HANDLE_SYS_TREE      , NULL,
  HANDLE_DEFAULT_SYSBUS, NULL,
  HANDLE_X_BUS         , NULL,
  HANDLE_PCI_BUS       , NULL
};



/*---------------------------------------------------*/
/* RSMALLOC.C                                        */
/*---------------------------------------------------*/
USHORT     cAllocations               =  0;
PBUFHEADER pBUFChain                  =  (PBUFHEADER) RMPool;

/*---------------------------------------------------*/
/* RSMNODE.C                                         */
/*---------------------------------------------------*/

USHORT     cRMNodes                   = 0;
USHORT     cRMDrvrNodes               = 0;

/*---------------------------------------------------*/
/* RSMLDEV.C                                         */
/*---------------------------------------------------*/

USHORT     cRMLNodes                  = 0;

/*---------------------------------------------------*/
/* RSMAPIR0.C                                        */
/*---------------------------------------------------*/
SEL     RMR3CallGate                  = NULL;

                     /* ParmList Length (WORDS) */
RMFNTABLE RMFunctionTable[RMTABLESIZE] = {
   (PFNRM)NULL,                   0,
   (PFNRM)NULL,                   0,
   (PFNRM)RSMCreateDriver,        4,
   (PFNRM)RSMDestroyDriver,       2,
   (PFNRM)RSMCreateAdapter,      10,
   (PFNRM)RSMDestroyAdapter,      4,
   (PFNRM)RSMCreateDevice,       10,
   (PFNRM)RSMDestroyDevice,       4,
   (PFNRM)RSMAllocResource,       6,
   (PFNRM)RSMDeallocResource,     4,
   (PFNRM)RSMClaimResources,      4,
   (PFNRM)RSMReleaseResources,    4,
   (PFNRM)RSMCreateLDev,          8,
   (PFNRM)RSMDestroyLDev,         4,
   (PFNRM)RSMCreateSysName,       8,
   (PFNRM)RSMDestroySysName,      4,
   (PFNRM)RSMADDToHDEVICE,        4,
   (PFNRM)RSMKeyToHandleList,     6,
   (PFNRM)RSMHandleToType,        4,
   (PFNRM)RSMHandleToParent,      4,
   (PFNRM)RSMUpdateAdjunct,       7,
   (PFNRM)RSMAdjToHandleList,     6,
   (PFNRM)RSMHDevToHLDev,         6,
   (PFNRM)RSMResToHandleList,     4,
   (PFNRM)RSMActivateAdapter,     4,
   (PFNRM)RSMDeactivateAdapter,   4,
   (PFNRM)RSMCreateLinkDevice,    8,
   (PFNRM)RSMModifyResources,     7,
   (PFNRM)RSMGetNodeInfo,         5,
   (PFNRM)RSMParseScsiInquiry,    5
};



PSZ pszKeyFixDisk     =  KEY_FIXDISK;
PSZ pszKeyTape        =  KEY_TAPE;
PSZ pszKeyPrinter     =  KEY_PRINTER;
PSZ pszKeyCPU         =  KEY_CPU;
PSZ pszKeyWORM        =  KEY_WORM;
PSZ pszKeyCDROM       =  KEY_CDROM;
PSZ pszKeyScanner     =  KEY_SCANNER;
PSZ pszKeyOpticalMem  =  KEY_OPTICAL_MEM;
PSZ pszKeyChanger     =  KEY_CHANGER;
PSZ pszKeyComm        =  KEY_COMM;
PSZ pszKeyScsiUnknown =  KEY_SCSI_UNKNOWN;

/*---------------------------------------------------*/
/* RSMAPIR3.C                                        */
/*---------------------------------------------------*/

USHORT DriverState = DRIVER_NONE_CURRENT;

DRIVERSTRUCT DummyDriver =
{
   NULL,
   NULL,
   "Unknown Vendor",
   CMVERSION_MAJOR,
   CMVERSION_MINOR,
   1994,9,17,
   DRF_STATIC,
   DRT_OS2,
   DRS_UNDEFINED,
   NULL
};

UCHAR DummyBasedevTxt[]= "Non-Resource manager aware base device driver";
UCHAR DummyDeviceTxt[]= "Non-Resource manager aware device driver";

/*---------------------------------------------------*/
/* RSMHLPR.C                                         */
/*---------------------------------------------------*/
USHORT          RSMSem        = 0;
USHORT          RSMWaitCount  = 0;
PULONG          pCurIntLevel  = NULL;
SEL             RMPools[NUM_POOLS] = {0};


/*---------------------------------------------------*/
/* RSMTRACE.C                                        */
/*---------------------------------------------------*/
PBYTE           pTraceBits    = 0;


/*------------------------------------------------------------------------*/
/*                                                                        */
/*      Initialization Data                                               */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*------------------------------------*/
/* RMINIT.C                           */
/*------------------------------------*/
USHORT          RMInitData            = 0;

PORTLIST DMAPort[NUM_DMA_CHANNELS*NUM_DMA_CONTROLLERS][NUM_DMA_PORT_RANGES] =
{
  { 0x00, 2, 0x87, 1, 0x0C,  4 },
  { 0x02, 2, 0x83, 1, 0x0C,  4 },
  { 0x04, 2, 0x81, 1, 0x0C,  4 },
  { 0x06, 2, 0x82, 1, 0x0C,  4 },
  { 0xC0, 4, 0x8F, 1, 0xD0, 16 },
  { 0xC4, 4, 0x8B, 1, 0xD0, 16 },
  { 0xC8, 4, 0x89, 1, 0xD0, 16 },
  { 0xCC, 4, 0x8A, 1, 0xD0, 16 }
};

PORTLIST VGAPorts[NUM_VGA_PORT_RANGES] =
{
  { 0x01CE,  2  },               /* ATI Specific */
  { 0x03B4,  2  },
  { 0x03BA,  2  },
  { 0x03C0, 10  },
  { 0x03CC,  1  },
  { 0x03CE,  2  },
  { 0x03D4,  2  },
  { 0x03DA,  2  },
  { 0x03DD,  1  }
};

UCHAR CpuText386[]  = "CPU_# 386";
UCHAR CpuText486[]  = "CPU_# 486";
UCHAR CpuText586[]  = "CPU_# 586";
UCHAR CpuTextxxx[]  = "CPU_0 ???";

UCHAR PDevTxtRoot[] = "PDEV Physical Device Tree";
UCHAR PCIBusText[]  = "PCI_Bus_0" ;
UCHAR ISABusText[]  = "ISA_Bus"   ;
UCHAR MCABusText[]  = "MCA_Bus"   ;
UCHAR EISABusText[] = "EISA_Bus"  ;

UCHAR XBusText[]    = "X_Bus"     ;

UCHAR PICText[]     = "PIC_# "     ;
UCHAR IRQText[]     = "IRQ_# "     ;
UCHAR DMAText[]     = "DMA_CTLR_# ";
UCHAR DMAChnText[]  = "DMA_CH_# "  ;

UCHAR VGAText[]     = "VGA";

UCHAR TmrText[]     = "TIMER"      ;
UCHAR TmrChnText[]  = "TIMER_CH_# ";

UCHAR BiosText[]    = "BIOS_ROM";

UCHAR RTCText[]     = "RTC ";

UCHAR LDevTxtROOT[]     = "LDEV Logical Device Tree"     ;
UCHAR LDevTxtDASD[]     = "DASD"     ;
UCHAR LDevTxtCDROM[]    = "CDROM"    ;
UCHAR LDevTxtSERIAL[]   = "SERIAL"   ;
UCHAR LDevTxtPARALLEL[] = "PARALLEL" ;
UCHAR LDevTxtTAPE[]     = "TAPE"     ;

LDEVLIST LDevNodes[NUM_LDEV_CLASSES] =
{
  { LDevTxtROOT,        LDEV_CLASS_ROOT     },
  { LDevTxtDASD,        LDEV_CLASS_DASD     },
  { LDevTxtCDROM,       LDEV_CLASS_CDROM    },
  { LDevTxtSERIAL,      LDEV_CLASS_SERIAL   },
  { LDevTxtPARALLEL,    LDEV_CLASS_PARALLEL },
  { LDevTxtTAPE,        LDEV_CLASS_TAPE     }
};

/*----------------------------------------------*/
/* Driver Description                           */
/*----------------------------------------------*/
DRIVERSTRUCT RMDriverStruct =
{
   "RESOURCE.SYS",                           /* DrvrName                */
   "IBM Resource Manager",                   /* DrvrDescript            */
   "IBM OS/2",                               /* VendorName              */
   CMVERSION_MAJOR,                          /* MajorVer                */
   CMVERSION_MINOR,                          /* MinorVer                */
   1994,9,17,                                /* Date                    */
   0,                                        /* DrvrFlags               */
   DRT_SERVICE,                              /* DrvrType                */
   DRS_UNDEFINED,                            /* DrvrSubType             */
   NULL                                      /* DrvrCallback            */
};

DRIVERSTRUCT KrnlDriverStruct =
{
   "OS2KRNL",                                /* DrvrName                */
   "OS/2 Kernel Module",                     /* DrvrDescript            */
   "IBM OS/2",                               /* VendorName              */
   CMVERSION_MAJOR,                          /* MajorVer                */
   CMVERSION_MINOR,                          /* MinorVer                */
   1994,9,17,                                /* Date                    */
   0,                                        /* DrvrFlags               */
   DRT_SERVICE,                              /* DrvrType                */
   DRS_UNDEFINED,                            /* DrvrSubType             */
   NULL                                      /* DrvrCallback            */
};

UCHAR EISASlotDescript[] = "EISA_Slot_xx";
UCHAR MCASlotDescript[]  = "MCA_Slot_xx";

DEVICESTRUCT SlotDevice =
{
   NULL,
   0,
   DS_TYPE_SLOT,
   NULL
};

