/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME =  RSMCONS.H
 *
 * DESCRIPTIVE NAME =  Resource Management Driver - Constants
 *
 *
 *
 * VERSION = V1.01
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 * FUNCTIONS  :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define MAX_NODE_TEXT           128
#define MAX_KEY_LEN             16

#define NUM_DEFAULT_RESOURCES   5
#define MAX_RESOURCE_CLASSES    8

/*---------------*/
/* X-Bus Devices */
/*---------------*/

#define NUM_PIC_DEVICES         2
#define NUM_PIC_LEVELS          8
#define PIC_0_PORT              0x20
#define PIC_1_PORT              0xA0
#define PIC_CASCADE_IRQ         2

#define NUM_SYS_MEM_RANGES      4

#define NUM_DMA_CONTROLLERS     2
#define NUM_DMA_CHANNELS        4
#define NUM_DMA_PORT_RANGES     3
#define DMA_CASCADE_CH          4                                   /*@V107246*/

#define NUM_VGA_PORT_RANGES     9

#define NUM_TIMER_CHANNELS      3
#define TIMER_BASE_PORT         0x40
#define TIMER_0_IRQ             0

#define RTC_BASE_PORT           0x70
#define NUM_RTC_PORTS           2
#define RTC_IRQ                 8

/*--------------*/
/* BIOS Range   */
/*--------------*/
#define MIN_MEM_RANGE           0x0C0000l
#define MAX_MEM_RANGE           0x0E0000l

/*---------------------------*/
/* ISA Compatible Port Range */
/*---------------------------*/
#define MIN_ISA_PORT            0x0100
#define MAX_ISA_PORT            0x03FF

/*--------------*/
/* Adapter Slot */
/*--------------*/

#define CFG_MAX_POS_SLOTS 8
#define CFG_MAX_EISA_SLOTS 16

/*-------------------------*/
/* Base Enumeration Depth  */
/*-------------------------*/
#define BASE_DEPTH 0

#define STATUS_GEN_ERR  0x810c

#ifndef CPUINFO_586
#define CPUINFO_586  (CPUINFO_486 + 1)
#endif


#define PDEV_BASE               0
#define PDEV_ROOT              (PDEV_BASE+0)
#define PDEV_SYSBUS            (PDEV_BASE+1)
#define PDEV_PCIBUS            (PDEV_BASE+2)
#define PDEV_XBUS              (PDEV_BASE+3)
#define PDEV_DRIVER            (PDEV_BASE+4)
#define PDEV_RMDD              (PDEV_BASE+5)
#define PDEV_KRNLDD            (PDEV_BASE+6)

#define PDEV_CPU_BASE          (PDEV_BASE+7)

#define PDEV_CPU_0             (PDEV_CPU_BASE+0)
#define PDEV_CPU_1             (PDEV_CPU_BASE+1)

#define MAX_PDEV_PTRS          (PDEV_CPU_BASE+1)

/*-----------------------------------*/
/*  RSMAPIR3.C                       */
/*-----------------------------------*/
#define DRIVER_NONE_CURRENT  0
#define DRIVER_INIT          1
#define DRIVER_CREATED       2


/*-----------------------------------*/
/*  RSMAPIR3.C                       */
/*-----------------------------------*/
#define LOOKUP_SIZE             5
#define NUM_POOLS               1
#define UNIQUE_LIMIT       0x4000
#define PSEUDO_KEY     0xFFFF0000
#define POOL_MASK          0x0003

/*-----------------------------------*/
/*  RSMTRACE.C                       */
/*-----------------------------------*/

#define SAS_SELECTOR    0x0070

#define TEST_TRACING(RMT,Maj)   \
        ((*(RMT+(Maj>>3)) & (0x80>>(Maj&7))))

#define RSM_TRACE_MAJOR       0x0008
#define RSM_TRACE_ALLOCATE    0x0001
#define RSM_TRACE_DEALLOCATE  0x0011

#define TRACE_TYPE_0          0x0000
#define TRACE_TYPE_1          0x0001
#define TRACE_TYPE_2          0x0002

#define DISABLE _asm cli
#define ENABLE  _asm sti
