;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/

; SCCSID = @(#)prtdd.inc        6.19 92/01/07
;/**********************************************************************
;/*                                                                    *
;/*                                                                    *
;/*                                                                    *
;/**********************************************************************
;/********************** START OF SPECIFICATIONS ***********************/
;/*                                                                    */
;/* SUBROUTINE NAME: PRTDATA                                           */
;/*                                                                    */
;/* DESCRIPTIVE NAME: PRINTER DEVICE DRIVER EQUATES AND STRUCTURES     */
;/*                                                                    */
;/* NOTES:  Error correction / code modification tagging philosophy    */
;/*         is not being used in 32 bit OS/2.                          */
;/*                                                                    */
;/*********************** END OF SPECIFICATIONS ************************/
.xlist
include error.inc                       ; GET DEVICE DRIVER ERROR CODES
.list

MAXPRINTERS     EQU     3               ; MAXIMUM NUMBER OF PRINTERS SUPPORTED
LPT1_INDEX      EQU     0               ; INDEX OF LPT1
LPT2_INDEX      EQU     1               ; INDEX OF LPT2
LPT3_INDEX      EQU     2               ; INDEX OF LPT3
LPT1_FLAG       EQU     1               ; FLAG FOR LPT1
LPT2_FLAG       EQU     2               ; FLAG FOR LPT2
LPT3_FLAG       EQU     4               ; FLAG FOR LPT3
CACHESIZE       EQU     128             ; SIZE OF VARIABLE PART OF MONITOR CACHE
IRQ5INTNUM      EQU     05H             ; IRQ NUMBER FOR IRQ5
IRQ7INTNUM      EQU     07H             ; IRQ NUMBER FOR IRQ7

; BUS TYPES
ISABUS          EQU     01h             ; ISA BUS SYSTEM
EISABUS         EQU     02h             ; EISA BUS SYSTEM
MCBUS           EQU     04h             ; MICRO CHANNEL BUS SYSTEM

; RETURN CODES FOR KERNEL REQUEST BLOCK STATUS WORD
REQDONE         EQU             STDON + 0
REQDONEBUSY     EQU     STBUI + STDON + 0
UNKNOWNCMD      EQU     STERR + STDON + ERROR_I24_BAD_COMMAND
NOACCESS        EQU     STERR + STDON + ERROR_I24_BAD_UNIT
DEVNOTREADY     EQU     STERR + STDON + ERROR_I24_NOT_READY
INVALIDCOMMD    EQU     STERR + STDON + ERROR_I24_BAD_COMMAND
PAPEROUTERR     EQU     STERR + STDON + ERROR_I24_OUT_OF_PAPER
WRITEFAULT      EQU     STERR + STDON + ERROR_I24_WRITE_FAULT
GENFAILURE      EQU     STERR + STDON + ERROR_I24_GEN_FAILURE
CHARIOINT       EQU     STERR + STDON + ERROR_I24_CHAR_CALL_INTERRUPTED
INVALIDPARM     EQU     STERR + STDON + ERROR_I24_INVALID_PARAMETER
USERRETCODE     EQU     0C100H          ; CPF 1.1 USER ERROR IN PKT STATUS

ENABLEINT       EQU     1CH             ; ENABLE INTERRUPT MASK IN CONTROL BYTE
DISABLEINT      EQU     0CH             ; DISABLE INTERRUPT MASK IN CONTROL BYTE
INITLINELOW     EQU     08H             ; CONTROL BYTE THAT CAUSES INIT LINE LOW
INITLINEHIGH    EQU     0CH             ; CONTROL BYTE THAT CAUSES INIT LINE HI
INITLOOPCNT     EQU     4000            ; INIT LOOP COUNT WHEN INITIALIZING
STROBELOW       EQU     1DH             ; DEVICE CONTROL REG - LATCH DATA REG
STROBEHIGH      EQU     1CH             ; DEVICE CONTROL REG - TURN STROBE OFF
RESERVEDBITS    EQU     0C0H            ; DEVICE CONTROL REG - RESERVED BITS
DIRECTBIT       EQU     20H             ; DEVICE CONTROL REG - DIRECTION R/W BIT
IRQENABLEBIT    EQU     10H             ; DEVICE CONTROL REG - IRQ ENABLE BIT
AUTOFEEDBIT     EQU     02H             ; DEVICE CONTROL REG - AUTO FEED BIT
UNUSEDBITS      EQU     0F8H            ; STATUS BYTE MASK-ELIMINATE UNUSED BITS
REVERSEBITS     EQU     48H             ; STATUS BYTE MASK-REVERSE ACKNOWLEDGE
                                        ; AND I/O ERROR BITS.
; MONITOR EQUATES
MONWAIT         EQU     0               ; WAIT IF BUFFER FULL
MONNOWAIT       EQU     1               ; DONT WAIT IF BUFFER FULL
MONTIMEOUT      EQU     2               ; DONT WAIT IF BUFFER FULL - TIMEOUT

; GETDOSVAR INDEX CODES
GLOBINFOSEG     EQU     1               ; SYSTEM GLOBAL INFO SEGMENT
LOCINFOSEG      EQU     2               ; SYSTEM LOCAL INFO SEGMENT
YIELDFLAG       EQU     7               ; YIELD FLAG

; MONITOR CODE PAGE/FONT EQUATES
; HIGH BYTE OF FLAG
MONCPFREQ       EQU     01H             ; CODE PAGE/FONT REQUEST FLAG
MONCPFDONE      EQU     02H             ; CODE PAGE/FONT COMPLETE FLAG
MONCPFINT17REQ  EQU     04H             ; INT 17H CODE PAGE/FONT REQUEST
MONCPFERRPKT    EQU     08H             ; MONITOR PRT ERROR PACKET REQUEST
MONPJOBTITLE    EQU     20H             ; MONITOR PRT JOB TITLE REQUEST
; LOW BYTE OF FLAG
MONCLEAR        EQU     00              ; MONITOR WRITE FLAG
MONOPEN         EQU     01              ; MONITOR OPEN FLAG
MONCLOSE        EQU     02              ; MONITOR CLOSE FLAG
MONFLUSH        EQU     04              ; MONITOR FLUSH FLAG

MONACTCPF       EQU     01H             ; ACTIVATE CODE PAGE/FONT
MONQRYCPF       EQU     02H             ; QUERY ACTIVE CODE PAGE/FONT
MONVFYCPF       EQU     03H             ; VERIFY CODE PAGE/FONT
NULLENTRY       EQU     00H             ; NULL CODE PAGE ENTRY

; PRINTER CONTROL CODES
ESCAPE          EQU     1BH             ; ESCAPE CONTROL CODE
COMPRESSED      EQU     0FH             ; COMPRESSED MODE CONTROL CODE
ENDCOMPRESSED   EQU     12H             ; END COMPRESSED MODE CONTROL CODE
ONESIXTH        EQU     50              ; ONE SIXTH LINE SPACING CONTROL CODE
ONEEIGHTH       EQU     48              ; ONE EIGHTH LINE SPACING CONTROL CODE
SELECT          EQU     17              ; SELECTS THE PRINTER

; VALID FRAME CONTROL VALUES
CHARS80_LINE    EQU     80              ; 80 CHARACTERS PER LINE
CHARS132_LINE   EQU     132             ; 132 CHARACTERS PER LINE
LINES6_INCH     EQU     6               ; SIX LINES PER INCH SPACING
LINES8_INCH     EQU     8               ; EIGHT LINES PER INCH SPACING
FRMCTRLCNT      EQU     3               ; # OF BYTES NEEDED TO SET FRMCTRL

PRTEQUIPMASK    EQU     0C000H          ; # OF PRTS. INSTALL MASK, IN EQUIP FLAG
EQUIPFLAGROL    EQU     2               ; ROTATE - INSTALLED PRTS INTO BITS 0, 1
BIOSDATA        EQU     ES:[BX]         ; ADDRESS OF BIOS ROM DATA AREA
BIOSROMDATA     EQU     0040H           ; BIOS ROM DATA SEGMENT
PORT3BCH        EQU     3BCH            ; PORT 3BCH ADDRESS
PORT378H        EQU     378H            ; PORT 378H ADDRESS
PORT278H        EQU     278H            ; PORT 278H ADDRESS
LEVEL5          EQU     5               ; IRQ5 INTERRUPT LEVEL
LEVEL7          EQU     7               ; IRQ7 INTERRUPT LEVEL

; PROC BLOCK VALUES
BLOCKLOWVALUE   EQU     -1              ; NEVER TIMEOUT
BLOCKHIVALUE    EQU     -1              ; NEVER TIMEOUT
BLOCKSLEEPNOTINT EQU    1               ; SLEEP IS NOT INTERRUPTIBLE
BLOCKSLEEPINT   EQU     0               ; SLEEP IS INTERRUPTIBLE

; FLAG EQUATES
FIRSTINIT       EQU     01H             ; FIRST TIME INITIALIZING FLAG

MINWAITTIME     EQU     1               ; MINIMUM TIME NEED FOR TIMER
TIMERMASK       EQU     07H             ; TIMER NEED TO DRIVE DEVICE
                                        ; BIT 1 - LPT1 TIMER MASK
                                        ; BIT 2 - LPT2 TIMER MASK
                                        ; BIT 3 - LPT3 TIMER MASK

DEINSTALLMSK    EQU     07H             ; KERNEL ASKED US TO DEINSTALL DEVICE
                                        ; BIT 1 - LPT1 DEINSTALL MASK
                                        ; BIT 2 - LPT2 DEINSTALL MASK
                                        ; BIT 3 - LPT3 DEINSTALL MASK

;* THE FOLLOWING VALUE IS DEFINED FOR THE PC/AT VERSION ONLY

TICKSTOWAIT     EQU     000AH           ; NUMBER OF TICKS BEFORE IRQ STOLEN

;/*******************************/
; COMMONFLAGS EQUATES           */
;/*******************************/

;* THE FOLLOWING FLAGS ARE DEFINED FOR ALL VERSIONS OF THE PRINTER DEV DRVR
MONINT17PRTREQ  EQU     8000H           ; SEEN MONITOR INT 17 PRINT REQ
USEPOLLING      EQU     4000H           ; IF SET USE TASK TIME POLLING

;* THE FOLLOWING FLAG IS DEFINED FOR THE PC/AT VERSION ONLY
CHARACTER_OUT   EQU     2000H           ; PC/AT ONLY - CHAR SENT (INTERUPTS ONLY)

MONERRPKTSENT   EQU     1000H           ; MONITOR ERROR PACKET HAS BEEN SENT
RMCPSET         EQU     0800H           ; REAL MODE CODE PAGE IS SET
CPFINPROGRESS   EQU     0400H           ; CPF IS STILL IN PROGRESS
RETRY2A         EQU     0200H           ; INT2AH REQUEST PENDING
PRTRESTART      EQU     0100H           ; RESTART PRT REQUEST FROM TIMER
IOACTIVE        EQU     0080H           ; I/O ACTIVE
INFINRETRY      EQU     0040H           ; INFINITE RETRY
MONREG1         EQU     0020H           ; DATA MONITOR 1 REGISTERED
MONCHAIN1       EQU     0010H           ; DATA MONITOR CHAIN 1 CREATED
MONPRINTING     EQU     0008H           ; DATA MONITOR CURRENTLY PRINTING
MONREG2         EQU     0004H           ; CODE PAGE MONITOR 2 REGISTERED
MONCHAIN2       EQU     0002H           ; CODE PAGE MONITOR CHAIN 2 CREATED
INT17REQ        EQU     0001H           ; INT 17H CURRENTLY PRINTING

; COMMONFLAGS1 EQUATES

PDDDIRACCESS    EQU     8000H           ; PDD HAS DIRECT ACCESS
DENIEDACCESS    EQU     4000H           ; PDD DENIED EXCLUSIVE ACCESS
TIMEDOUT        EQU     2000H           ; PRINTER TIMED OUT (FOR POLLING)
PORTEXISTS      EQU     0400H           ; PORT HARDWARE EXISTS IN SYSTEM UNIT
INT17TOTIMER    EQU     0200H           ; INTERRUPT 17H TIMEOUT TIMER
MONPROCESSING   EQU     0100H           ; MONITOR BETWEEN OPEN AND CLOSE
DIRECTACCESS    EQU     0080H           ; DD REQUESTS DIRECT ACCESS TO HARDWARE
DIRMODEACCESS   EQU     0040H           ; DIRECT MODE ACCESS
CANMONPKT       EQU     0020H           ; MONITOR WANTS PRT REQUEST CANCELED
DMAAVAIL        EQU     0010H           ; DMA IS AVAILABLE FOR THE DEVICE
RETRYIFBUSY     EQU     0002H           ; ABIOS RETURNED PRTDEVBUSY - PS/2 ONLY
BOOTINIT        EQU     0001H           ; BOOT INITIALIZATION IN PROGRESS

; MONITOR ERROR ACTION EQUATES
EA_ABORT        EQU     00000001B       ; ABORT MONITOR REQUEST UNTIL CLOSE

; CANCEL FLAG EQUATES
CANNOERROR      EQU     00              ; NO ERROR ON THE DEVICE
CANNOTSELECT    EQU     01              ; DEVICE IS NOT SELECTED
CANPAPEROUT     EQU     02              ; PAPER IS OUT OR DEVICE IS POWERED OFF
CANIOERROR      EQU     03              ; I/O ERROR ON DEVICE

; PRINTER STATUS
NOTBUSY         EQU     80H             ; NOT BUSY MASK IN STATUS PORT
ACKNOWLEDGE     EQU     40h             ; ACKNOWLEDGE STATUS LINE
PAPEROUT        EQU     20H             ; PAPER OUT MASK IN STATUS PORT
NOTSELECTED     EQU     10H             ; NOT SELECTED MASK IN STATUS PORT
IOERROR         EQU     08H             ; I/O ERROR MASK IN STATUS PORT
NOTINTPENDING   EQU     04H             ; HARDWARE INTERRUPT IS NOT PENDING
DEVICETIMOUT    EQU     01H             ; DEVICE TIMED OUT
NORMALSTAT      EQU     90H             ; NORMAL NOT BUSY STATUS

; MISC EQUATES
WAITFLAG        EQU     0               ; WAIT UNTIL AVAILABLE
NOWAITFLAG      EQU     1               ; DO NOT WAIT UNTIL AVAILABLE
SHORTTERM       EQU     0               ; LOCK:  SEGMENT LOCKED < 2 SECS
LONGTERM        EQU     1               ; LOCK:  SEGMENT LOCKED > 2 SECS
RACCESS         EQU     0               ; VERIFY ACCESS:  0 = READ ONLY
RWACCESS        EQU     1               ; VERIFY ACCESS:  1 = READ/WRITE
ABOVE1MEG       EQU     0               ; ALLOCPHYS:  ABOVE 1 MEG BOUNDARY
BELOW1MEG       EQU     1               ; ALLOCPHYS:  BELOW 1 MEG BOUNDARY
BUSYRETRY       EQU     20H             ; BUSY RETRY COUNT
IOCTLMASK       EQU     0FFE0H          ; PRODUCE TABLE INDEX FOR IOCTLS

; ERROR PACKET STRUCTURE

monerrpkt       STRUC
                dw      ?               ; FLAGS
                dw      ?               ; SFN
er_code         db      ?               ; ERROR CODE
er_action       db      ?               ; ERROR ACTION
monerrpkt       ENDS
MONERRPKTLEN    EQU     SIZE monerrpkt

; CODE PAGE STRUCTURES

cpfmonreq       STRUC
cpfcommnd       db      ?               ; CODE PAGE/FONT COMMAND
cpfrsvd1        db      ?               ; RESERVED AREA
cpfrsvd2        db      ?               ; RESERVED AREA
cpfrsvd3        db      ?               ; RESERVED AREA
cpfreturn       dw      ?               ; SWITCHER RETURN CODE
cpfcodepg       dw      ?               ; CODE PAGE WORD
cpffont         dw      ?               ; FONT WORD
cpfmonreq       ENDS
CPFMONREQLEN    EQU     ((SIZE cpfmonreq)/2)

cpfrealmode     STRUC
cpfreal         dw      ?               ; REAL MODE CODE PAGE VALUE
cpfrealmode     ENDS

; GENERIC IOCTL DATA POINTER STRUCTURES
; CATEGORY 5:  PRINTER CONTROL IOCTL COMMANDS

framectrlreq    STRUC                   ; 42/62 - SET/RET FRAME CTRL
charsperline    db      ?               ; CHARACTERS PER LINE
linesperinch    db      ?               ; LINES PER INCH
framectrlreq    ENDS
FRAMECTRLDBLEN  EQU     SIZE framectrlreq

infretryreq     STRUC                   ; 44H/64H - SET/RET INF RETRY
retry           db      ?               ; ENABLE/DISABLE INF RETRY
infretryreq     ENDS
INFRETRYDBLEN   EQU     SIZE infretryreq
ENABLEIR        EQU     01H             ; ENABLE INFINITE RETRY
DISABLEIR       EQU     00H             ; DISABLE INFINITE RETRY

statusreq       STRUC                   ; 46H/66H - INIT PRT/RET STATUS
prntstatus      db      ?               ; STATUS OF PRINTER
statusreq       ENDS
STATUSREQDBLEN  EQU     SIZE statusreq

cpfreq          STRUC                   ; 48H/69H/6AH - ACTIVATE/QUERY/VERIFY
ioctlpage       dw      ?               ; CODE PAGE VALUE
ioctlfont       dw      ?               ; FONT VALUE
cpfreq          ENDS
CPFDBLEN        EQU     SIZE cpfreq

pjobtitle       STRUC                   ; 4DH - SET PRINT JOB TITLE
pjtitlelen      dw      ?               ; LENGTH OF PRINT JOB TITLE
pjtitleoff      dw      ?               ; PRINT JOB TITLE OFFSET
pjtitlesel      dw      ?               ; PRINT JOB TITLE SELECTOR
pjobtitle       ENDS
PJOBDBLEN       EQU     SIZE pjobtitle

timeoutreq      STRUC                   ; 4EH/6EH  SET/GET TIMEOUT VALUE
usertimeout     dw      ?               ; USER SPECIFIED TIMEOUT VALUE
timeoutreq      ENDS
TIMEOUTLEN      EQU     SIZE timeoutreq

directmoderq    STRUC                   ; 51H/71H  SET/GET DIRECT MODE ACCESS
useraccessflag  db      ?               ; USER SPECIFIED ACCESS FLAG
directmoderq    ENDS
DIRECTMODELEN   EQU     SIZE directmoderq
ENABLEDM        EQU     01H             ; ENABLE DIRECT ACCESS
DISABLEDM       EQU     00H             ; DISABLE DIRECT ACCESS

; CATEGORY 10:  CHARACTER DEVICE MONITOR IOCTL COMMANDS

monregreq       STRUC                   ; 40H - REGISTER A MONITOR
placement       dw      ?               ; PLACEMENT FLAG
monindex        dw      ?               ; MONITOR INDEX
moninbuf        dd      ?               ; MONITOR INPUT BUFFER
monoutbuf       dw      ?               ; MONITOR OUTPUT BUFFER
monregreq       ENDS
MONREGDBLEN     EQU     SIZE monregreq

; MONITOR AND MONITOR DISPATCHER STRUCTURES

mcache          STRUC                   ; MONITOR CACHE STRUCTURE
saveflags       dw      0               ; MONITOR FLAGS
savesfn         dw      0               ; SYSTEM FILE NUMBER
savedata        db      CACHESIZE DUP(0) ; MONITOR DATA BUFFER AREA
saveindex       dw      0               ; INDEX INTO DATA
mcache          ENDS

tomon           STRUC
tomonflags      dw      ?               ; FLAGS
tomonsfn        dw      ?               ; SFN - SYSTEM FILE NUMBER
tomonbuf        db      ?               ; START OF DATA TO SEND TO MONITOR
tomon           ENDS
TOMONFIXEDLEN   EQU     ((SIZE tomon) - (SIZE tomonbuf)) ; FIXED PART OF MON PKT

frommon         STRUC
monfinalbufsize dw      ?               ; SIZE OF MONITOR FINAL BUFFER
frommonflags    dw      ?               ; FLAGS
frommonsfn      dw      ?               ; SFN - SYSTEM FILE NUMBER
frommonbuf      db      ?               ; START OF DATA RETURNED FROM MONITOR
frommon         ENDS
FROMMONFIXEDLEN EQU     ((SIZE frommon) - (SIZE frommonbuf)) ; FIXED PART OF PKT

biosarea        STRUC                   ; POINTED TO BY BIOSDATA (ES:[BX])
serial_adapter  dw      4 DUP(?)        ; 4 SERIAL ADAPTERS
printer_adapt   dw      4 DUP(?)        ; 4 PRINTER ADAPTERS
equipflag       dw      ?               ; EQUIPMENT FLAG
                                        ; BIT 14-15 NUMBER OF PRINTERS ATTACHED
biosarea        ENDS

prfvw_devarea   STRUC
num_writes      dd      0               ; NUMBER OF WRITE REQUESTS
write_time      dd      0               ; TIME REQUIRED TO WRITE
                dd      0
write_bytes     dd      0               ; NUMBER OF BYTES WRITTEN
prfvw_devarea   ENDS

pvtimer MACRO   ASFLAG
        LOCAL   exit
.386
        test    data_block.dbh_flFlags,RPC_FL_CONFIG    ; IS PERFVIEW ACTIVE?
        jz      exit                                    ; NO, EXIT
        push    ds                                      ; SAVE SEGMENT OF TIMER
        mov     si,[di].prfvw_off                       ; OFF OF PERFVIEW CTRS
        lea     dx,[si].write_time                      ; OFF OF PERFVIEW TIMER
        push    dx                                      ; SAVE OFFSET OF TIMER
        inc     data_block.dbh_ulSem                    ; INDICATE TIMER UPDATE
       IFB     <ASFLAG>                                 ; REQ FOR SUB ROUTINE?
        call    data_block.dbh_pfnTmrAdd                ; CALL ADD ROUTINE
        movzx   edx,es:[bx].IOCount                     ; GET WRITE BYTES
        add     [si].write_bytes,edx                    ; ADD BYTES TO TOTAL
        inc     [si].num_writes                         ; INC NUMBER OF WRITES
       ELSE
        call    data_block.dbh_pfnTmrSub                ; CALL SUB ROUTINE
       ENDIF
        dec     data_block.dbh_ulSem                    ; INDICATE UPDATE DONE
exit:
.286C
        ENDM

printer_database        STRUC           ; POINTED TO BY DS:[DI]
        signature       db      'LPT1'  ; DEBUG AID
        cpqueue         dd      0       ; OPEN/ACT CP REQ PKT QUEUE
        dosoffset       dw      0       ; OFFSET OF DOS REQUEST BLOCK
        dosrqseg        dw      0       ; SEGMENT OF DOS REQUEST BLOCK
        monoffset       dw      0       ; OFFSET OF MON THREAD REQUEST BLOCK
        monseg          dw      0       ; SEGMENT OF MON THREAD REQUEST BLOCK
        gdtuserbuf      dw      0       ; GDT TO USER (RING 3) BUFFER
        prtfrmctrl      db      80,6    ; CURRENT FRAME CONTROL STATUS
        timeoutmax      dw      120     ; IRQ TIMEOUT MAXIMUM - USER DEFINABLE
        deviceindex     db      0       ; DEVICE INDEX (0, 1, or 2)
        deviceflag      db      0       ; DEVICE FLAG (001, 010, or 100)
        accessctr       db      0       ; NUMBER ACCESSING PDD
        cancelflags     db      0       ; 00 = NO ERROR WHEN REQ IS CANCELED
                                        ; 01 = NOT SELECTED WHEN REQ IS CANCELED
                                        ; 02 = PAPER OUT WHEN REQ IS CANCELED
                                        ; 03 = I/O ERROR WHEN REQ IS CANCELED
        xmiterror       db      0       ; TRANSMIT ERROR (SAME AS ERRORSTATUS)
                        db      0       ; KEEP WORD ALIGNMENT
        directid        dw      0       ; PID TO DIRECT ACCESS PROCESS
        waitcount       dw      0       ; NUMBER WAITING FOR DIRECT ACCESS

;/******************************************************************************
;/*     HARDWARE COMMON VARIABLES (REFERENCED BY PRTCOMMN.ASM) FOLLOW:         *
;/******************************************************************************

        gdtprintbuf     dw      0       ; GDT TO PRINT BUFFER (RING 3 OR PDD)
        deviceaddr      dw      0       ; DEVICE ADDRESS
        timeout_off     dw      0       ; OFFSET OF TIMEOUT ROUTINE
        timeoutctr      dw      0       ; TIME OUT CTR FROM 1 TO TIMEOUTMAX

;*******************************************************************************
;*  N O T E !!!!: Do not add any members above here without changing the       *
;*                the hardware_specific structure offsets (in prtdd1.inc &     *
;*                ptrdd2.inc) accordingly !!!!!                                *
;*******************************************************************************

;/******************************************************************************
;/*     "HOLE" RESERVED FOR HARDWARE_SPECIFIC DATA STRUCTURE:                  *
;/*                                                                            *
;/*     The space below is reserved for system specific variables.  Please     *
;/*     refer to the hardware_specific structure defined in system specific    *
;/*     INC file (prtdd1.inc or ptrdd2.inc).  The value in the DUP below must  *
;/*     large enough to contain the members of the bigger of the               *
;/*     hardware_specfifc structure (either prtdd1.inc's or prtdd2.inc')       *
;/******************************************************************************

                        db      20 DUP (0) ; HARDWARE SPECIFIC AREA

;/******************************************************************************
;/*                                                                            *
;/*     ERROR / STATUS MONITOR PACKET AREA - SENT ON DATA MONITOR CHAIN        *
;/*                                                                            *
;/******************************************************************************

        errorflags      dw      0       ; MONITOR ERROR FLAGS
        errorsfn        dw      0       ; MONITOR ERROR SFN
        errorstatus     db      0       ; MONITOR PRT RETURN CODE
        erroraction     db      0       ; MONITOR PRT ACTION CODE

;/******************************************************************************
;/*     THIS BUFFER DEFINED IS AN INPUT BUFFER WHICH WILL RECEIVE THE          *
;/*     RESULTS OF THE CODE PAGE REQUESTS.                                     *
;/******************************************************************************

                                        ; NEXT 4 ENTRIES MUST NOT CHANGE ORDER
        moncpbufsize    dw      0       ; SIZE OF CODE PAGE BUFFER
        moncpinflgs     dw      0       ; MONITOR FLAGS
        moncpinsfn      dw      0       ; USER'S CODE PAGE SYSTEM FILE NUMBER
        moncpinbuf      db SIZE cpfmonreq DUP(0) ; 10 BYTE BUFFER

;/******************************************************************************
;/*     MISCELLANEOUS MONITOR INFORMATION.                                     *
;/******************************************************************************

        monhandle       dw      0       ; DATA MONITOR HANDLE
        cpfhandle       dw      0       ; CODE PAGE MONITOR HANDLE
        cache_off       dw      0       ; MONITOR CACHE OFFSET
        tomonbuf_off    dw      0       ; TO-MONITOR PACKET OFFSET
        frommonbuf_off  dw      0       ; FROM-MONITOR PACKET OFFSET

        configbufsize   dw      0       ; "PRINTMONBUFSIZE =" SIZE OF MON BUFFER
        physbufoff      dw      0       ; PHSYICAL ADDR OF FROM-MONITOR BUFFER
        physbufseg      dw      0       ; PHYSICAL ADDR OF FROM-MONITOR BUFFER

        hdroff          dw      0       ; DEVICE DRIVER HEADER OFFSET

        commonflags     dw      0       ; BIT 15 = POLLING FLAG
                                        ;   0 = USE IRQs
                                        ;   1 = USE POLLING

                                        ; BIT 14 = USED IN PC/AT VERSION ONLY
                                        ;   0 =
                                        ;   1 =

                                        ; BIT 13 = USED IN PC/AT VERSION ONLY
                                        ;   0 =
                                        ;   1 =

                                        ; BIT 12 = MONITOR ERROR PACKET SEND BIT
                                        ;   0 = HAVE NOT SENT IT YET
                                        ;   1 = HAVE SENT MONITOR ERROR PACKET

                                        ; BIT 11 = USED IN PREVIOUS RELEASE
                                        ;   0 =
                                        ;   1 =

                                        ; BIT 10 = RESUME CODE PAGE BLOCK
                                        ;   0 = NOT A CODE PAGE UNBLOCK REQUEST
                                        ;   1 = RESUME CODE PAGE BLOCKED THREAD

                                        ; BIT 9 = USED IN PREVIOUS RELEASE
                                        ;   0 =
                                        ;   1 =

                                        ; BIT 8 = RESTART REQUEST-DEV IN ERROR
                                        ;   0 = DON'T RESTART NEXT TIMER INT
                                        ;   1 = RESTART NEXT TIMER INT

                                        ; BIT 7 = I/O ACTIVE
                                        ;   0 = I/O INACTIVE
                                        ;   1 = I/O ACTIVE

                                        ; BIT 6 = INFINITE RETRY
                                        ;   0 = INFINITE RETRY DISABLED
                                        ;   1 = INFINITE RETRY ENABLED

                                        ; BIT 5 = DATA MONITOR REGISTERED
                                        ;   0 = DATA MONITOR NOT REGISTERED
                                        ;   1 = DATA MONITOR REGISTERED

                                        ; BIT 4 = DATA MONITOR CHAIN
                                        ;   0 = NO DATA MONITOR CHAIN
                                        ;   1 = DATA MONITOR CHAIN CREATED

                                        ; BIT 3 = MONITOR PRINTING
                                        ;   0 = NO MONITOR CURRENTLY PRINTING
                                        ;   1 = MONITOR CURRENTLY PRINTING

                                        ; BIT 2 = CODE PAGE MONITOR REGISTERED
                                        ;   0 = CODE PAGE MONITOR NOT REGISTERED
                                        ;   1 = CODE PAGE MONITOR REGISTERED

                                        ; BIT 1 = CODE PAGE MONITOR CHAIN
                                        ;   0 = NO CODE PAGE MONITOR CHAIN
                                        ;   1 = CODE PAGE MONITOR CHAIN CREATED

                                        ; BIT 0 = USED IN PREVIOUS RELEASE
                                        ;   0 =
                                        ;   1 =

        commonflags1    dw      0
                                        ; BIT 15 = PDD DIRECT ACCESS
                                        ;   0 = PDD DOES NOT HAVE DIRECT ACCESS
                                        ;   1 = PDD HAS DIRECT ACCESS

                                        ; BIT 13 = TIMED OUT WHILE POLLING
                                        ;   0 = TIMED OUT RESET
                                        ;   1 = TIMED OUT

                                        ; BIT 10 = PORT HARDWARE PRESENT
                                        ;   0 = PORT NOT PRESENT IN SYSTEM
                                        ;   1 = PORT PRESENT IN SYSTEM

                                        ; BIT 9 = USED IN PREVIOUS RELEASE
                                        ;   0 =
                                        ;   1 =

                                        ; BIT 8 = MONITOR PROCESSING
                                        ;   0 = MONITOR NOT REQ DATA TO HARDWARE
                                        ;   1 = MONITOR REQUEST DATA TO HARDWARE

                                        ; BIT 7 = DIRECT HARDWARE ACCESS
                                        ;   0 = DD DOES NOT HAVE DIRECT ACCESS
                                        ;   1 = DD HAS DIRECT ACCESS

                                        ; BIT 6 = DIRECT MODE "SHARE" ACCESS
                                        ;   0 = PLPT WILL PROTECT FROM MIXED IO
                                        ;   1 = PLPT WILL NOT PROTECT

                                        ; BIT 5 = CANCEL MONITOR PRINT REQUEST
                                        ;   0 = DO NOT CANCEL PRT REQUEST
                                        ;   1 = CANCEL PRT REQUEST

                                        ; BIT 4 = DMA AVAILABLE   (PS/2 ONLY)
                                        ;   0 = DMA NOT AVAILABLE
                                        ;   1 = DMA AVAILABLE

                                        ; BIT 1 = RETRY [DI].RETRYCTR TIMES
                                        ;   0 = DO NOT RETRY
                                        ;   1 = RETRY

                                        ; BIT 0 = BOOT INITIALIZATION PROCESS
                                        ;   0 = BOOT INITIALIZATION NOT ACTIVE
                                        ;   1 = BOOT INITIALIZATION ACTIVE

printer_database        ENDS

