;*DDK*************************************************************************/
;
; COPYRIGHT (C) Award Software International Inc., 1994
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
                name    SSPCICVA
                page    60, 132
                title   'SSPCICVA'
;******************************************************************************
;*
;*                            File SSPCICVA.ASM
;*
;*                        Socket Services PCIC File
;*
;*                           Validation routines
;*
;*
;*
;******************************************************************************

                include ssmac.inc           ; Macros
                include ssdefs.inc          ; Sockets Services definitions
                include ss_segm.inc         ; Segment definitions
                include ssPCIC.inc          ; PCIC module defs


;*****************************************************************************
;*                         --- Segment ResCode ---
;*****************************************************************************
sBegin          ResCode


COMMENT ~*********************************************************************
        Procedure:      covValidateIRQ
        Revision:       2
        Date:           05/25/1993
        Purpose:        Validate request IRQ level and active state valid
        Entry:          [AL] = IRQ request level
                        [SI] = Ptr to Info Table with valid IRQ levels
        Exit:           [CF] = status
                        If IRQ invalid, then CY and AH = BAD_IRQ
                        Else NC
*****************************************************************************~
covValidateIRQ  PROC    NEAR
                assume  ds:@data, es:Nothing

                pushx   <cx, dx>
                push    ax

                mov     dx, word ptr ((CHARTBL PTR [SI]).ActiveLo)
                test    al, IRQ_HIGH            ; Active low request ?
                jz      @f                      ; Yes, continue
                                                ; No, get valid high IRQ levels
                mov     dx, word ptr ((CHARTBL PTR [SI]).ActiveHi)

@@:             mov     cl, al                  ; Setup shift count
                and     cl, IRQ_LEVEL_MSK       ; Mask for IRQ Level
                test    cl, NOT P_IRQ15         ; IRQ above 15 ?
                jnz     BadIRQ                  ; Yes, error out

                mov     ax, 1                   ; Create bit mask for request IRQ level
                and     cx, P_IRQ15             ; Mask-in IRQ 0 thru 15
                jcxz    @f                      ; If zero, we're done

                shl     ax, cl                  ; Otherwise shift into appropriate bit

@@:             test    ax, dx                  ; Valid IRQ level ?
                jz      BadIRQ

                pop     ax                      ; Restore ooriginal AX
                clc                             ; Indicate success
                jmp     short @f

BadIRQ:         mov     ah, BAD_IRQ             ; Indicate     IRQ
                add     sp, 2                   ; Discard ax in the stack
                stc

@@:             popx    <dx, cx>
                ret

covValidateIRQ  ENDP

;*****************************************************************************
;*                         --- CheckPowerLevel ---
;*
;*     Purpose: Check, if power level is valid
;*       Input: AL - Power table entry
;*              AH - VCC or VPP1 or VPP2
;*              SI - Pointer to the first entry to the power table
;*              CX - Number of entries into power table
;*      Output: CY - if level is invalid
;* Scratch reg: none
;*     Written: by Alexis A.Piatetsky 10.06.94
;*****************************************************************************
CheckPowerLevel PROC    NEAR
                assume  ds:@data, es:Nothing

                pushx   <ax, cx, si>

                mov     si, offset PowerTable
                mov     cx, [si]            ; Number of table entries
                add     si, 2               ; Point to the 1st entry

;----------------------- Check, if entry is in the table ----------------------

                cmp     al, cl              ; Entry in range?
                jae     cpl_fail            ; No, report error

;----------------- Check, if entry is valid for selected power ----------------

                mov     ch, ah              ; Save attribute
                xor     ah, ah              ; Use word
                push    cx
                mov     cx, SIZEOF PWRENTRY
                mul     cl                  ; Calculate table offset
                pop     cx
                add     si, ax              ; Point to selected entry

                test    (PWRENTRY PTR [SI]).ValidSignals, ch
                jz      cpl_fail

                clc                         ; Report valid entry
                jmp     short @f            ; Terminate

cpl_fail:       stc                         ; Report checking fail
@@:             popx    <si, cx, ax>
                ret
CheckPowerLevel ENDP


;*****************************************************************************
;*                          --- covValidatePw ---
;*
;*     Purpose: Validate Power levels
;*       Input: [BX] - Pointer to the adapter structure
;*              [BP] - Pointer to the user args
;*              SI   - Socket number
;*              AH   - Lower nibble - Vcc Level
;*              AL   - Upper nibble - Vpp1 Level, Lower nibble - Vpp2 Level
;*      Output: If SUCCESS, then NC.
;*              If error - CY and AH - Error code
;* Scratch reg: AX, if check fail
;*     Written: by Alexis A.Piatetsky 09.06.94
;*****************************************************************************
covValidatePw   PROC    NEAR
                assume  ds:@data, es:Nothing

                pushx   <cx, dx, ax>

                mov     dl, al              ; Separate Vpp1 and Vpp2
                mov     dh, al

                and     dl, 0Fh             ; dl = Vpp2
                mov     cl, 4
                shr     dh, cl              ; dh = Vpp1

                mov     cl, ah              ; cl = Vcc

                mov     ch, 0               ; ch - Index of 0.0V

;---------------------------- Validate Power levels ---------------------------

                mov     al, ah              ; Check Vcc
                mov     ah, VCC
                call    CheckPowerLevel
                jc      vp_bad_vcc

                mov     al, dh              ; Check Vpp1
                mov     ah, VPP1
                call    CheckPowerLevel
                jc      vp_bad_vpp

                mov     al, dl              ; Check Vpp2
                mov     ah, VPP2
                call    CheckPowerLevel
                jc      vp_bad_vpp

                cmp     cl, ch              ; Switch Vcc off?
                jne     @f

                cmp     dl, ch              ; Vcc == 0, Vpp must be 0
                jne     vp_bad_vpp
                cmp     dh, dl
                jne     vp_bad_vpp

@@:
                clc                         ; Report success
                pop     ax
                jmp     short vp_exit

vp_bad_vcc:     mov     ah, BAD_VCC         ; Report     Vcc value
                jmp     short @f

vp_bad_vpp:     mov     ah, BAD_VPP         ; Report     Vpp value
@@:             add     sp, 2               ; Discard AX in the stack
                stc

vp_exit:        popx    <dx, cx>
                ret
covValidatePw   ENDP

;*****************************************************************************
;*                          --- covValidateIFt ---
;*
;*     Purpose: Validate interface Type
;*       Input: Reagister AH = IFType
;*                  Bit 0    = Memory-only interface
;*                  Bit 1    = I/O and memory interface
;*                  All other bits reserved and are reset to zero (0)
;*                  [SI]     = Pointer to the Socket Info structure
;*      Output: If successful, NC
;*              else CY and AH = BAD_TYPE
;* Scratch reg: none
;*     Written: by Alexis A.Piatetsky 10.06.94
;*****************************************************************************
covValidateIFt  PROC    NEAR
                assume  ds:@data, es:Nothing

                test    ah, NOT (IF_MEMORY OR IF_IO)
                jnz     vit_err                 ; Any reserved bit set

                and     ah, IF_MEMORY OR IF_IO  ; Mask in interface type bits
                jz      vit_err                 ; If neither set, error out

                cmp     ah, IF_MEMORY OR IF_IO  ; Are both set ?
                je      vit_err

                test    byte ptr (CHARTBL PTR [si]).SktCaps, ah
                jz      vit_err                 ; Can socket do this?

                clc
                jmp     short @f

vit_err:        mov     ah, BAD_TYPE
                stc

@@:             ret
covValidateIFt  ENDP
sEnd            ResCode
                end
