;*DDK*************************************************************************/
;
; COPYRIGHT (C) Award Software International Inc., 1994
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;*
;*                              File SSDEFS.INC
;*
;*                       Socket Services Definitions
;*
;*
;*
;******************************************************************************

ifndef   __SSDEFS_INC_
__SSDEFS_INC_   equ     1

;----------------------------------- Version ----------------------------------

RELEASE_NUM     equ     0200h               ; (Target release is 0200h)
PCMCIA_LEVEL    equ     0210h               ; PCMCIA Socket Services Specifi-
                                            ;  cation compliance level
EXCA_LEVEL      equ     0150h               ; ExCA Compliance level

; ----- Function Code Definitions

GET_ADP_CNT     equ     80h
                                            ; 81h and 82h reserved for
                                            ;  historical purposes
GET_SS_INFO     equ     83h
INQ_ADAPTER     equ     84h
GET_ADAPTER     equ     85h
SET_ADAPTER     equ     86h
INQ_WINDOW      equ     87h
GET_WINDOW      equ     88h
SET_WINDOW      equ     89h
GET_PAGE        equ     8Ah
SET_PAGE        equ     8Bh
INQ_SOCKET      equ     8Ch
GET_SOCKET      equ     8Dh
SET_SOCKET      equ     8Eh
GET_STATUS      equ     8Fh
RESET_SOCKET    equ     90h
                                            ; 91h thru 94h reserved for
                                            ;  historical purposes
INQ_EDC         equ     95h
GET_EDC         equ     96h
SET_EDC         equ     97h
START_EDC       equ     98h
PAUSE_EDC       equ     99h
RESUME_EDC      equ     9Ah
STOP_EDC        equ     9Bh
READ_EDC        equ     9Ch
GET_VENDOR_INFO equ     9Dh
ACK_INTERRUPT   equ     9Eh
PRIOR_HANDLER   equ     9Fh
SS_ADDR         equ     0A0h
ACCESS_OFFSETS  equ     0A1h
                                            ; A2h thru ADH are reserved
                                            ;  for expansion
VEND_SPECIFIC   equ     0AEh
CARD_SERVICES   equ     0AFh

SS_INT          equ     1Ah                 ; Socket Services Int vector

; ----- Return codes

SUCCESS         equ     00h
BAD_ADAPTER     equ     01h
BAD_ATTRIBUTE   equ     02h
BAD_BASE        equ     03h
BAD_EDC         equ     04h
                                            ; 5 reserved for historical purposes
BAD_IRQ         equ     06h
BAD_OFFSET      equ     07h
BAD_PAGE        equ     08h
READ_FAILURE    equ     09h
BAD_SIZE        equ     0Ah
BAD_SOCKET      equ     0Bh
BAD_TYPE        equ     0Dh
BAD_VCC         equ     0Eh
BAD_VPP         equ     0Fh
                                            ; 0Fh and 10h are reserved for
                                            ;  historical purposes
BAD_WINDOW      equ     11h
WRITE_FAILURE   equ     12h
                                            ; 13h is reserved for
                                            ;  historical purposes
NO_CARD         equ     14h
BAD_FUNCTION    equ     15h
BAD_MODE        equ     16h
BAD_SPEED       equ     17h
BUSY            equ     18h
GENERAL_FAILURE equ     19h

; ----- Defined data types

ADAPTER         TYPEDEF BYTE
BASE            TYPEDEF WORD
BUFFER          TYPEDEF DWORD
BCD             TYPEDEF WORD
COUNT           TYPEDEF BYTE
EDC             TYPEDEF BYTE
FLAGS8          TYPEDEF BYTE
FLAGS16         TYPEDEF WORD
FLAGS32         TYPEDEF DWORD
IRQ             TYPEDEF BYTE
COFFSET         TYPEDEF WORD                ; COFFSET replaces OFFSET  (keyword)
WPAGE           TYPEDEF BYTE                ; WPAGE   replaces PAGE    (keyword)
PWRINDEX        TYPEDEF BYTE
RETCODE         TYPEDEF BYTE
SIGNATURE       TYPEDEF WORD
WSIZE           TYPEDEF WORD                ; WSIZE   replaces SIZE    (keyword)
SOCKET          TYPEDEF BYTE
SPEED           TYPEDEF BYTE
WINDOW          TYPEDEF BYTE

; ----- Local Functon Definitions

GET_RAW_ADAPTER equ     0B0h
GET_RAW_SOCKET  equ     0B1h
GET_RAW_WINDOW  equ     0B2h

; ----- Card Services Definitions

GET_CARD_SERVICES_INFO equ 0Bh

; ----- Size Definitions

S4K             equ     1000h               ;  4 KiloBytes
S16K            equ     4000h               ; 16 KiloBytes
S64K            equ     10000h              ; 64 KiloBytes
S1M             equ     100000h             ;  1 MegaBytes
S16M            equ     1000000h            ; 16 MegaBytes

SS_SIGNATURE    equ     'SS'                ; Socket Services signature
CS_SIGNATURE    equ     'SC'


                SUBTTL  Miscelaneous equates
                PAGE

; ----- Validation bit-masks

BM_ADAPTER      equ     00000001b
BM_WINDOW       equ     00000010b
BM_SOCKET       equ     00000100b
BM_PAGE         equ     00001000b
BM_CARD         equ     00010000b

; ----- Structures

PWRENTRY        STRUCT                      ; Power level and valid signals
PowerLevel      FLAGS8  ?                   ; as returned by InquireAdapter
ValidSignals    FLAGS8  ?
PWRENTRY        ENDS


CHARTBL         STRUCT                      ; Info returned by Inquire Adapter
                                            ; and Inquire Socket
                UNION
AdpCaps         FLAGS16 ?
SktCaps         FLAGS16 ?
                ENDS
ActiveHi        FLAGS32 ?
ActiveLo        FLAGS32 ?

CHARTBL ENDS

MEMWINTBL       STRUCT                      ; Info returned by Inquire Window
                                            ; for Memory Windows
MemWndCaps      FLAGS16 ?                   ; Window Capabilities Flags
FirstByte       BASE    ?                   ; System Address of First Byte
LastByte        BASE    ?                   ; System Address of Last Byte
MinSize         WSIZE   ?                   ; Minimum Window Size
MaxSize         WSIZE   ?                   ; Maximum Window Size
ReqGran         WSIZE   ?                   ; Size Granularity
ReqBase         WSIZE   ?                   ; Window Base Alignment requirement
ReqOffset       WSIZE   ?                   ; Alignment Requirement for offsets
Slowest         SPEED   ?                   ; Slowest Access Speed for Window
Fastest         SPEED   ?                   ; Fastest Access Speed for Window

MEMWINTBL       ENDS


IOWINTBL        STRUCT                      ; Info returned by Inquire Window
                                            ; for IO Windows
IOWndCaps       FLAGS16 ?                   ; Window Capabilities Flags
FirstByte       BASE    ?                   ; System Address of First Byte
LastByte        BASE    ?                   ; System Address of Last Byte
MinSize         WSIZE   ?                   ; Minimum Window Size
MaxSize         WSIZE   ?                   ; Maximum Window Size
ReqGran         WSIZE   ?                   ; Size Granularity
AddrLines       COUNT   ?                   ; Number of Address Lines Decoded
                                            ; by Window
EISASlot        FLAGS8  ?                   ; Upper 4 I/O Address lines for
                                            ; EISA Slot-Specific Addr.

IOWINTBL        ENDS


WIN_INFO        UNION
        m       MEMWINTBL       {?}
        i       IOWINTBL        {?}

WIN_INFO        ENDS

; ----- Card Services Structure

GetCSInfoARGS   STRUC

        wInfoLen        WORD    ?
        wSignature      WORD    ?
        wCount          WORD    ?
        wRevision       WORD    ?
        wCSLevel        WORD    ?
        wVStrOff        WORD    ?
        wVStrLen        WORD    ?
        szVendorString  BYTE    82 DUP (?)

GetCSInfoARGS   ENDS

; ----- For Reference Only

;AISTRUCT       STRUCT                      ; Filled by InquireAdapter
;
;wBufferLength  WORD    ?
;wDataLength    WORD
;CharTable      CHARTBL {?}
;wNumPwrEntries WORD    ?
;PwrEntry[MAX_PWR_ENTRIES] PWRENTRY {?}
;
;AISTRUCT       ENDS

; ----- For Reference Only

BUFFSIZE        equ     256

VISTRUCT        STRUCT
wBufferLength   WORD    ?
wDataLength     WORD    ?
szImplementor   BYTE    (BUFFSIZE - 4) DUP (?)
VISTRUCT        ENDS



; ----- Valid power level bit-masks

VCC             equ     10000000b
VPP1            equ     01000000b
VPP2            equ     00100000b

; ----- Adapter capabilities bit-masks

AC_IND          equ     0000000000000001b
AC_PWR          equ     0000000000000010b
AC_DBW          equ     0000000000000100b

; ----- Adapter state

AS_POWERDOWN    equ     00000001b
AS_MAINTAIN     equ     00000010b

; ----- Generic window capabilities bit-masks

WC_COMMON       equ     00000001b           ; Implies Memory Window Capability
WC_ATTRIBUTE    equ     00000010b           ; Implies Memory Window Capability
WC_IO           equ     00000100b
WC_WAIT         equ     10000000b

; ----- Memory and I/O window capabilities bit-masks

WC_BASE         equ     0000000000000001b
WC_SIZE         equ     0000000000000010b
WC_WENABLE      equ     0000000000000100b
WC_8BIT         equ     0000000000001000b
WC_16BIT        equ     0000000000010000b
WC_BALIGN       equ     0000000000100000b
WC_POW2         equ     0000000001000000b
WC_CALIGN       equ     0000000010000000b

; ----- Memory window (page) capabilities only

WC_PAVAIL       equ     0000000100000000b
WC_PSHARED      equ     0000001000000000b
WC_PENABLE      equ     0000010000000000b
WC_WP           equ     0000100000000000b

; ----- I/O window capabilities only

WC_INPACK       equ     0000000010000000b
WC_EISA         equ     0000000100000000b
WC_CENABLE      equ     0000001000000000b

; ----- Generic window state

WS_IO           equ     00000001b
WS_ENABLED      equ     00000010b
WS_16BIT        equ     00000100b

; ----- Memory window state

WS_PAGED        equ     00001000b

; ----- I/O window state

WS_EISA         equ     00001000b
WS_CENABLE      equ     00010000b

; ----- Page state

PS_ATTRIBUTE    equ     00000001b
PS_ENABLED      equ     00000010b
PS_WP           equ     00000100b

; ----- IRQ level bit-masks (low word of 32-bit mask)

IRQ_0           equ     0000000000000001b
IRQ_1           equ     0000000000000010b
IRQ_2           equ     0000000000000100b
IRQ_3           equ     0000000000001000b
IRQ_4           equ     0000000000010000b
IRQ_5           equ     0000000000100000b
IRQ_6           equ     0000000001000000b
IRQ_7           equ     0000000010000000b
IRQ_8           equ     0000000100000000b
IRQ_9           equ     0000001000000000b
IRQ_10          equ     0000010000000000b
IRQ_11          equ     0000100000000000b
IRQ_12          equ     0001000000000000b
IRQ_13          equ     0010000000000000b
IRQ_14          equ     0100000000000000b
IRQ_15          equ     1000000000000000b

; ----- IRQ level bit-masks (high word of 32-bit mask)

IRQ_NMI         equ     0000000000000001b
IRQ_IO          equ     0000000000000010b
IRQ_BUSERR      equ     0000000000000100b

; ----- IRQ state bit-masks

IRQ_LEVEL_MSK   equ     00011111b
IFDEF _INTEL_EPG
IRQ_HIGH        equ     00100000b           ; modified for intel
ELSE
IRQ_HIGH        equ     01000000b           ; PCMCIA Setting
ENDIF

IRQ_ENABLED     equ     10000000b

P_IRQ00         equ     00000000b
P_IRQ01         equ     00000001b
P_IRQ02         equ     00000010b
P_IRQ03         equ     00000011b
P_IRQ04         equ     00000100b
P_IRQ05         equ     00000101b
P_IRQ06         equ     00000110b
P_IRQ07         equ     00000111b
P_IRQ08         equ     00001000b
P_IRQ09         equ     00001001b
P_IRQ10         equ     00001010b
P_IRQ11         equ     00001011b
P_IRQ12         equ     00001100b
P_IRQ13         equ     00001101b
P_IRQ14         equ     00001110b
P_IRQ15         equ     00001111b

; ----- Socket bit-masks

SBM_WP          equ     00000001b
SBM_LOCKED      equ     00000010b
SBM_EJECT       equ     00000100b
SBM_INSERT      equ     00001000b
SBM_BVD1        equ     00010000b
SBM_BVD2        equ     00100000b
SBM_RDYBSY      equ     01000000b
SBM_CD          equ     10000000b

SBM_LOCK        equ     00010000b
SBM_BATT        equ     00100000b
SBM_BUSY        equ     01000000b
SBM_XIP         equ     10000000b

; ----- Interface bit-masks

IF_MEMORY       equ     00000001b
IF_IO           equ     00000010b

; ----- EDC definitions

EC_UNI          equ     00000001b
EC_BI           equ     00000010b
EC_REGISTER     equ     00000100b
EC_MEMORY       equ     00001000b
EC_PAUSABLE     equ     00010000b

EC_WRITE        equ     00000010b

ET_CHECK8       equ     00000001b
ET_SDLC16       equ     00000010b

SS_ADDR_MAIN    STRUCT                      ; SubFunc 0 buffer definition

wCodeBaseLo     DW      ?
wCodeBaseHi     DW      ?
wCodeSizeLo     DW      ?
wCodeSizeHi     DW      ?
wCodeEntryLo    DW      ?
wCodeEntryHi    DW      ?
wDataBaseLo     DW      ?
wDataBaseHi     DW      ?
wDataSizeLo     DW      ?
wDataSizeHi     DW      ?
wDataOffsetLo   DW      ?
wDataOffsetHi   DW      ?

SS_ADDR_MAIN    ENDS

;--------------------------------- Speed byte  --------------------------------

DSPEED_NULL     equ     0
DSPEED_250NS    equ     1
DSPEED_200NS    equ     2
DSPEED_150NS    equ     3
DSPEED_100NS    equ     4

MANTISSA_BITS   equ     01111000b
EXPONENT_BITS   equ     00000111b
EXT_BIT         equ     10000000b

;------------------------------ Speed constantes ------------------------------

SPEED_0100_NS   equ     (01h SHL 3) OR 2
SPEED_0120_NS   equ     (02h SHL 3) OR 2
SPEED_0130_NS   equ     (03h SHL 3) OR 2
SPEED_0150_NS   equ     (04h SHL 3) OR 2
SPEED_0200_NS   equ     (05h SHL 3) OR 2
SPEED_0250_NS   equ     (06h SHL 3) OR 2
SPEED_0300_NS   equ     (07h SHL 3) OR 2
SPEED_0350_NS   equ     (08h SHL 3) OR 2
SPEED_0400_NS   equ     (09h SHL 3) OR 2
SPEED_0450_NS   equ     (0Ah SHL 3) OR 2
SPEED_0500_NS   equ     (0Bh SHL 3) OR 2
SPEED_0550_NS   equ     (0Ch SHL 3) OR 2
SPEED_0600_NS   equ     (0Dh SHL 3) OR 2
SPEED_0700_NS   equ     (0Eh SHL 3) OR 2
SPEED_0800_NS   equ     (0Fh SHL 3) OR 2
SPEED_1000_NS   equ     (01h SHL 3) OR 3
SPEED_1200_NS   equ     (02h SHL 3) OR 3
SPEED_1300_NS   equ     (03h SHL 3) OR 3
SPEED_1500_NS   equ     (04h SHL 3) OR 3
SPEED_2000_NS   equ     (05h SHL 3) OR 3

;----------------------------------- Timing -----------------------------------

RESET_WAIT      equ     40                  ; Wait after Reset mSecs
POWERON_WAIT    equ     20                  ; Wait after Poweron to set output enable
                                            ; PC CARD Standard 2.01 Page 4-9
                                            ; Section 4.3.6
PROG_POWER_WAIT equ     100                 ; Wait after programming of Vpp

;---------------------------------- CPU Mode ----------------------------------

RSSE_REAL_MODE  equ     000h                ; Real Mode
RSSE_PROT_1616  equ     001h                ; 16:16 Protected mode
RSSE_PROT_1632  equ     002h                ; 16:32 Protected mode
RSSE_PROT_FLAT  equ     003h                ; 00:32 Protected mode (Flat Model)

endif                                           ; __SSDEFS_INC_
