/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*    The following IBM OS/2 2.1 source code is provided to you solely for   */
/*    the purpose of assisting you in your development of OS/2 2.x device    */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CLSAMPLE.H
 *
 * DESCRIPTIVE NAME = PCMCIA Client Services sample code header file
 *
 *
 *
 *
 * The following IBM OS/2 2.1 source code is provided to you solely for
 * the purpose of assisting you in your development of OS/2 2.x device
 * drivers. You may use this code in accordance with the IBM License
 * Agreement provided in the IBM Device Driver Source Kit for OS/2. This
 * Copyright statement may not be removed.
 *
 *
 *
 * VERSION =
 *
 * DATE        06/22/93
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 ***************************************************************************/



/*
** strategy commands definition  B=block, C=character
*/
#define RPINIT            0x00      /*  BC                                  */
#define RPOPEN            0x0d      /*  BC                                  */
#define RPCLOSE           0x0e      /*  BC                                  */
#define RPIOCTL           0x10      /*  BC                                  */
#define RPDEINSTALL       0x14      /*   C                                  */
#define RPINITCOMP        0x1F      /*                                      */


/*
** RPstatus bit values
*/
#define RPERR             0x8000    /*  error occurred, err in RPstatus     */
#define RPDEV             0x4000    /*  error code defined by driver        */
#define RPBUSY            0x0200    /*  device is busy                      */
#define RPDONE            0x0100    /*  driver done with request packet     */

/*
** client code status
*/
#define CODE_LOCKED       0x0001    /*  code is locked                      */
#define TIMER_START       0x0002    /*  timer is started                    */
#define ARGPKT_BUSY       0x0004    /*  ArgPacket buffer is not available    */
#define INIT_FAILURE      0x0008    /*  this driver's initialization fails  */

/*
** timer default tick count
*/
#define TIMERCOUNT        0x0002

/*
** Card Service level
*/
#define CS_LEVEL          0x0200
/*define CS_REVISION       0x0200 */
#define CS_REVISION       0x0100   /* modified for MR1,0x105 for WARP */

/*
** Clear ArgPacket buffer
*/
#define CLEAR_ARGPACKET   for(i=0; i<100; i++) ArgPacket[i]=0

#ifdef WAT

    void cliasm();                  /* Watcom does not support In Line Assembly */
    #pragma aux cliasm = "cli"    ;
    #define DISABLE cliasm()

    void stiasm();
    #pragma aux stiasm = "sti"    ;
    #define ENABLE  stiasm()

#else

    #define DISABLE _asm {cli}
    #define ENABLE  _asm {sti}

#endif

/*
**  the driver device header
*/
typedef struct DeviceHdr {
   struct  DeviceHdr far *DHnext;   /* pointer to next header, or FFFF      */
   USHORT  DHattribute;             /* device attribute word                */
   USHORT *DHstrategy;              /* offset of strategy routine           */
   USHORT  DHidc;                   /* offset of IDC routine                */
   UCHAR   DHname[8];               /* dev name (char) or #units (blk)      */
   UCHAR   reserved[8];
   ULONG   bit_strip;               /* bit 0 DevIOCtl2, bit 1 32 bit addr   */
} DEVICEHDR;


/*
** request packet definition
*/
typedef struct ReqPacket {
   UCHAR   RPlength;                /* request packet length                */
   UCHAR   RPunit;                  /* unit code for block DD only          */
   UCHAR   RPcommand;               /* command code                         */
   USHORT  RPstatus;                /* status word                          */
   UCHAR   RPreserved[4];           /* reserved bytes                       */
   ULONG   RPqlink;                 /* queue linkage                        */
   union {                          /* command-specific data                */
   UCHAR   avail[19];
    struct {                        /* init                                 */
      UCHAR      units;             /* number of units                      */
      PFN        DevHlp;            /* &DevHlp                              */
      PBYTE      pArgs;             /* &args                                */
      UCHAR      drive;             /* drive #                              */
      }Init;

    struct {
      UCHAR      units;             /* same as input                        */
      USHORT     finalCS;           /* final offset, 1st code segment       */
      USHORT     finalDS;           /* final offset, 1st data segment       */
      PBYTE      BPBarray;          /* &BPB                                 */
      } InitExit;

    struct {                        /* open/close                           */
      USHORT     sysfilenum;        /* system file number                   */
      } OpenClose;

    struct {                        /* IOCtl                                */
      UCHAR      category;          /* category code                        */
      UCHAR      function;          /* function code                        */
      PBYTE      parameters;        /* &parameters                          */
      PBYTE      buffer;            /* &buffer                              */
      } IOCtl;

   } s;                             /* command info                         */
} REQPACKET;
typedef REQPACKET far *PREQPACKET;                                  /* PKS */



/*
** AttachDD inter device driver communication data area
*/
typedef struct AttachArea {
   USHORT  offEPReal;               /* real-mode offset of idc entry point  */
   USHORT  segEPReal;               /* real-mode CS of IDC entry point      */
   USHORT  segDSRead;               /* real-mode DS of IDC DD               */
   USHORT  offEPProt;               /* protect-mode offset of entry point   */
   USHORT  selEPProt;               /* protect-mode CS of entry point       */
   USHORT  selDSProt;               /* protect-mode DS of other DD          */
} ATTACHAREA;
typedef ATTACHAREA near *NPATTACHAREA;

