;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;*****************************************************************************/
;
;
;    The following IBM OS/2 2.1 source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 2.x device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = CLCARDIF.ASM
;*
;* DESCRIPTIVE NAME = Client Services Sample Card interface subrutines
;*
;*
;*
;*
;* The following IBM OS/2 2.1 source code is provided to you solely for
;* the purpose of assisting you in your development of OS/2 2.x device
;* drivers. You may use this code in accordance with the IBM License
;* Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;* Copyright statement may not be removed.
;*
;*
;*
;* VERSION
;*
;* DATE         06/22/93
;*
;* DESCRIPTION  There are callback entry from Card Services and the part
;*              which calls to Card Services from Client Services.
;*
;* FUNCTIONS
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;***************************************************************************/



        EXTRN  _CBHandler:near
        EXTRN  _CBMTDHandler:near
        EXTRN  _CSEntry:dword

        public _CBEntry

        public _CSCall
;
; card services event definition
;
MTD_REQUEST     equ      012h

Code     segment word public 'CODE'
Code     ends

InitCode segment word public 'CODE'
InitCode ends

SwapCode segment word public 'CODE'
SwapCode ends

StaticGroup   group   _TEXT, InitCode
SwapGroup     group   SwapCode


_TEXT   segment word public 'CODE'

        assume  cs:_TEXT
        .286P


;/***************************************************************************
;*
;* FUNCTION NAME = _CBEntry
;*
;* DESCRIPTION   = Entry point for callback request from Card Services.
;*
;* INPUT         = [AL]      Function
;*                 [CX]      Socket
;*                 [DX]      Information
;*                 [DI]      ClientVal field from ClientData structure
;*                 [DS]      ClientDS field from ClientData structure
;*                 [SI]      ClientOff field from ClientData structure
;*                 [SS]:[BP] MTD Request
;*                 [ES]:[BX] Buffer argument
;*                 [BX]      Miscellaneous argument, when no buffer argument
;*
;* OUTPUT        = [AX]  Return code
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

_CBEntry        proc    far

                cmp     al,MTD_REQUEST
                jz      CBEMTDReq

                push    es                   ; buffer
                push    bx                   ; buffer / miscellaneous
                push    si                   ; client data
                push    ds                   ; client data
                push    di                   ; client data
                push    dx                   ; information
                push    cx                   ; socket
                and     ax,00FFh
                push    ax                   ; function

                call    _CBHandler

                add     sp,16
                jmp     short CBEexit

CBEMTDReq:
                push    es                   ; buffer
                push    bx                   ; buffer
                push    ss                   ; MTD request
                push    bp                   ; MTD request
                push    si                   ; client data
                push    ds                   ; client data
                push    di                   ; client data
                push    cx                   ; socket
                and     ax,00FFh
                push    ax                   ; fucntion

                call    _CBMTDHandler

                add     sp,18

CBEexit:
                ret
_CBEntry        endp



        .286P
;/***************************************************************************
;*
;* FUNCTION NAME = _CSCall
;*
;* DESCRIPTION   = This routine calls to Card Services directly.
;*
;* INPUT         = [BP+4]          function argument
;*                 [BP+6]          handle argument
;*                 [BP+10]:[BP+8]  pointer argument
;*                 [BP+12]         Arglength argument
;*                 [BP+16]:[BP+14] ArgPointer argument
;*
;* OUTPUT        = [AX]            Status argument
;*                 [DX]            handle
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

_CSCall         proc    near

                push    bp
                mov     bp,sp

                push    bx                   ; seve registers
                push    cx
                push    di
                push    si
                push    es

                mov     ax,word ptr [bp+4]   ; function
                mov     dx,word ptr [bp+6]   ; handle
                mov     di,word ptr [bp+10]  ; pointer
                mov     si,word ptr [bp+8]   ; 
                mov     cx,word ptr [bp+12]  ; argument length
                mov     es,word ptr [bp+16]
                mov     bx,word ptr [bp+14]

                call    _CSEntry             ; call Card Services

;*
;* Please check carry flag.
;*
                jc      save_error
                xor     ax,ax
save_error:
                pop     es                   ; restore registers
                pop     si
                pop     di
                pop     cx
                pop     bx

                pop     bp
                ret                          ; 

_CSCall         endp


_TEXT   ends
         end
