;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = SHELL.ASM
;*
;* DESCRIPTIVE NAME =
;*
;*
;* VERSION
;*
;* DATE
;*
;* DESCRIPTION  This file contains the device strategy routine,
;*              the end of initialization code marker,
;*              and the end of initialization data marker.
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*****************************************************************************/


.286
.287

_DATA   SEGMENT WORD PUBLIC 'DATA'
_DATA   ENDS

_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS

CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS

_DATA   SEGMENT
_DATA   ENDS


_BSS    SEGMENT
_BSS    ENDS


_ENDDATA   SEGMENT WORD PUBLIC 'ENDDATA'
public _End_of_data
_ENDDATA   ENDS

_TEXT   SEGMENT WORD PUBLIC 'CODE'
extrn _do_strat:near
public _strategy
public _end_of_text
_TEXT   ENDS


DGROUP  GROUP   CONST, _BSS, _DATA, _ENDDATA
CGRP    GROUP   _TEXT

_TEXT   SEGMENT WORD PUBLIC 'CODE'
        ASSUME cs:CGRP, ds:DGROUP, es:NOTHING, ss:NOTHING

;/***************************************************************************
;*
;* FUNCTION NAME = _strategy
;*
;* DESCRIPTION   = This function is the device driver strategy routine
;*                 and entry point into the device driver.
;*                 The register pair es:bx contains the address of request
;*                 information from the operating system.
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL =
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

_strategy proc far

            push    es                 ; save registers
            push    bx

            call    _do_strat          ; do it

            pop     bx                 ; restore registers
            pop     es

            ret                        ; done
_strategy endp


_end_of_text proc far
            ret                ; This is the end of initialization code marker
_end_of_text endp


_TEXT   ENDS

_ENDDATA   SEGMENT WORD PUBLIC 'ENDDATA'
                               ; This is the end of initialization data marker
_End_of_data dw 0
_ENDDATA   ENDS

        END
