;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*************************************************************************
;*
;* SOURCE FILE NAME = MOUSE.INC
;*
;* DESCRIPTIVE NAME = Mouse Device Driver Equates and Data Structures.
;*
;*
;* VERSION      V2.0
;*
;* DATE         02/29/92
;*
;* DESCRIPTION  Mouse Device Driver Equates and Data Structures.
;*
;* FUNCTIONS    NONE
;*
;* NOTES        This file contains the equates used by the mouse DD
;*              code.
;*
;*
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   04/21/93              67424  Loose mouse when coming back from suspend
;*                                mode on Dell 325nc laptop.
;*   06/03/93              69671  Lose pointing stick when coming back from
;*                                suspend mode on IBM 700 series laptops.
;**************************************************************************



.xlist
        include abios.inc
        include aberror.inc
        include devsym.inc
        include struc.inc
        include sgcb.inc
        include devhlp.inc
        include macs.inc
        include hw.inc
        include apmidc.inc                      ;           
.list

TRUE             equ         -1
FALSE            equ          0

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;*                 C O N S T A N T S  ==>  Protect Mode                    *
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Func_HReq_End    EQU        6BH     ; Last valid Mouse IOCTL Function Code
Func_LReq_Start  EQU        50H     ; 1ST valid Mouse IOCTL Function Code
Mou_Cat          EQU        07H     ; Mouse IOCTL Category Code
Mon_Cat          EQU        0AH     ; Mouse Monitor Category Code
Gen_Cat          EQU        0BH     ; General DD Category Code
QMonSup          EQU        60H     ; Query DD Monitor Support
Hk_Mask_Min      EQU      0001H     ; Min Hot Key Mask Value
ElRec_Size       EQU        0AH     ; Event Queue Element Size (in bytes)
DevStatRet       EQU      0BFFH     ; Dev Status Get Value Ret Filter
DevStatSetMax    EQU      0f00H     ; Dev Status settable sits

;*
;* The following equates are for the session device status
;*

THRHLDDSBLD      EQU      0800h     ; !! bit 3 set hi byte (threshold disabled)
SQ_MODE          EQU      0400H     ; SingleQ mode is acitve for the session
MICKEYDATA       EQU      0200H     ; Report relative motion in events
PTRDRAW          EQU      0100H     ; Don't call ptr draw for drawing operations
USS_MODE         EQU      0008H     ; Display mode is not supported.
Q_FLUSH          EQU      0004H     ; A Queue flush is in progress
BLOCK_MASK       EQU      0002H     ; A process is blocked on mouse events
BUSY_MASK        EQU      0001H     ; The event queue is busy


ReqBlk_Busy      EQU      0200H     ; Bit 9 set in Req Blk Status Field
Max_Eq_Rec       EQU       100D     ; Max Event Queue Element Count
MBuf_Size        EQU      000EH     ; Monitor Output Buffer Size (in bytes)
MRec_Size        EQU      000CH     ; MOB Mouse Data Record Size (in bytes)
RBlk_Min         EQU        00D     ; Min Request Block Command Code
RBlk_Max         EQU        1FH     ; Max Request Block Command Code ;           
Req_MM           EQU        40H     ; Mouse Monitor Function Request Code
SM_WinFlag       EQU      0004H     ; Bit 2 set in Ptr Flags of SG CB
Max_Scale        EQU     07FFFH     ; Max allowed Scaling Factor (32K-1)
MaxSupConfigs    EQU         8      ; max number of supported configurations
MouseVersion     EQU         1      ; current level of support ver number
ExtModeLen       EQU        22      ; length of extended mode data

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;*                C O N S T A N T S  ==>  Both Modes                       *
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

ON               EQU          0     ; Used on Byte Flags = Enabled
OFF              EQU         -1     ; Used on Byte Flags = Disabled
Done             EQU          0     ; EOI Already issued Flag
Max_Ints         EQU          2     ; Max # of Nested Ints allowed
Graphics         EQU  00000010B     ; SG CB Type Flag for Graphics Disp Mode
Shell_Session    EQU          1     ; Shell/Winthorne SG ID
VIO_PopUp_SG     EQU          3     ; Vio Popup Session ID
Max_CBs          EQU        16D     ; Number of Mouse SG's supportable
Ack_Port         EQU        20H     ; Interrupt controller's acking port
Both             EQU        00H     ; OpMode Flag = Both Modes Supported
Real             EQU        01H     ; OpMode Flag = Real Mode Only Support
Protect          EQU        02H     ; OpMode Flag = Protect Mode Only Support
CfgNumOff        EQU        10      ; offset to config # in config data

GIOParaPacx      EQU  WORD PTR GIOParaPack   ; Since GIOParaPack is DD
GIODataPacx      EQU  WORD PTR GIODataPack   ; Since GIODataPack is DD
GIODataSelector  EQU  word ptr es:[bx].GIODataPack+2
GIODataOffset    EQU  word ptr es:[bx].GIODataPack
GIOParaSelector  EQU  word ptr es:[bx].GIOParaPack+2
GIOParaOffset    EQU  word ptr es:[bx].GIOParaPack

GDTINFOINDEX     EQU          1     ; GDT Info Segment Var number
LDTINFOINDEX     EQU          2     ; LDT Info Segment Var number
UPPERCASE        EQU         90     ; Max ASCII value for Upper case letters
LOWERTOUPPER     EQU         32     ; Delta between Lower/Upper Case letters
UNKNOWNCMD       EQU      8003H     ; Unknown Command CP/DOS RB Error Code
GENERALFAILURE   EQU      800CH     ; General Failure   "    "    "    "
CHARINT          EQU      8011H     ; Char Call Interrupted    "    "
MNS              EQU      8012H     ; Mon Not Sup'd  "    "    "    "
INVALIDPARMS     EQU      8013H     ; Invalid Parms  "    "    "    "
DEVICENOTREADY   EQU      8002h     ; ### device not ready error
TAB              EQU          9     ; ASCII code for TAB
LF               EQU         10     ; ASCII code for Line Feed
CR               EQU         13     ; ASCII code for Carriage Return
SYNCHMASKSAVED   EQU          1     ; Initial Synch Mask Has been saved
HOTPLUG1         EQU  00000010B     ; Hot Plug stage one has occurred
HOTPLUG2         EQU  00000100B     ; Hot Plug stage two has occurred
HOTPLUG          EQU  11111001B     ; Hot Plug clear flag mask  ;           
PDI_SAMPLERATE   EQU        3CH     ; Default sample rate: 60/second
PDI_RESOLUTION   EQU        03H     ; Default resolution: 8 counts/mm


StandardOutput   EQU          1     ; Standard Output Device

INITBAD          EQU      802FH     ; Fatal Init Error = ABORT DD Load
BADLPARM         EQU      804FH     ; Config.sys Parameter Error
RMINITBAD        EQU      808FH     ; Serious Init Error = DD ShutDown


;*********************************************************************
;*     Device Independent/Dependent IDC funtion equates.             *
;*********************************************************************

QUERYCONFIG     EQU     1        ; Query config function
READENABLE      EQU     2        ; Read enable function
READDISABLE     EQU     3        ; read disable function
ENABLEDEVICE    EQU     4        ; enable the mouse device function
DISABLEDEVICE   EQU     5        ; disable the mouse device function

PROCESSPACKET   EQU     1        ; process interrupt packet function
DISABLESUPPORT  EQU     2        ; disable all support function
PROCESSABSOLUTE EQU     3        ; process an absolute mouse event
OPENMOUSE       EQU     4        ; Request a handle communication with MOUSE$
CLOSEMOUSE      EQU     5        ; Release the handle returned from OPENMOUSE
QUERYMOUSE      EQU     6        ; Query mouse activity function

;**********************************************************************
;* Equates for MouseType byte field in the Dev_Data structure         *
;**********************************************************************

UNKNOWN_DEVICE     equ    00h
BUS_DEVICE         equ    01h
MSS_DEVICE         equ    02h
INP_DEVICE         equ    03h
PDI_DEVICE         equ    04h
PSC_DEVICE         equ    05h
LOG_DEVICE         equ    06h      ; Logitech mouse
KYP_DEVICE         equ    07h      ; Screen Reader Keypad

;**********************************************************************
;*  The following equates define the DevStatus word.                  *
;**********************************************************************

gREADENABLE   equ    0001h    ; device status - read enabled (report data)
ATTACHED      equ    0002h    ; device status - MOUSE$ attached
IRQENABLED    equ    0004h    ; device status - IRQ is enabled
DEINSTALLED   equ    0008h    ; device status - we've been deinstalled
DEVICEENABLED equ    0010h    ; device status - we are enabled

;*********************************************************************
;*     Access check table equates.                                   *
;*********************************************************************

CHECKREQD       equ     10h      ; used to see if a check is required
READCHECK       equ     10h      ; used to build the access check table
WRITECHECK      equ     30h      ; used to build the access check table
NULLOK          equ     40h      ; used to skip access check if sel is null


;*********************************************************************
;*   VMSE to PMSE IDC function numbers.                              *
;*********************************************************************

PMSE_REGISTER       EQU      0      ; Register the VMSE entry point.
PMSE_DEREGISTER     EQU      1      ; De-Register the VMSE entry point.
PMSE_QUERYTYPE      EQU      2      ; Query the physical mouse parms.
PMSE_SETSCREENSIZE  EQU      3      ; Set the row and column numbers.
PMSE_XMOUSEMODE     EQU      4      ; Set exclusive mouse mode on/off.

;*********************************************************************
;*   PMSE to VMSE IDC function numbers.                              *
;*********************************************************************

VMSE_EVENT          EQU      1      ; PMSE reporting a relative event to VMSE.

;*********************************************************************
;*   Bits for the (ve_Event) field of the VMSE_EVENT input packet.   *
;*********************************************************************

ABSPIXEVENT         EQU      8000H  ; This is an absolute event.

;*********************************************************************
;*     Screen group switch control equates                           *
;*********************************************************************

TERMINATION     equ   0000000000001000b   ; 8
CREATION        equ   0000000000010000b   ; 16  or 10h
PRESWITCH       equ   0000000000100000b   ; 32  or 20h
POSTSWITCH      equ   0000000001000000b   ; 64  or 40h
AIMPOSTSAVE     equ   0000000100000000b   ; 256 or 100h

;*********************************************************************
;*     Bit definitions for VDM_Flags word                            *
;*********************************************************************

VDMREGISTERED   equ   0001h      ; The VMSE has registered with PMSE
VDMXMOUSEMODE   equ   0002h      ; The windowed VDM has exclusive access

;*********************************************************************
;*     Bit definitions for DDDInit flags word                        *
;*********************************************************************

DI_IDC          equ   0001h      ; We need to call the DDDD for init
DI_ERROR        equ   0002h      ; The IDC communication is down

;*
;*      Pointer Definition record template (10 byte structure)
;*

Ptr_Template   STRUC
               Buf_Len          DW  ?   ; Pointer shape buffer length in bytes
               PWidth           DW  ?   ; Ptr's width shape demension
               PHeight          DW  ?   ; Ptr's height shape demension
               Col_Hot          DW  ?   ; Pointer col coord hot spot pixel
               Row_Hot          DW  ?   ; Pointer row coord hot spot pixel
Ptr_Template   ENDS


;*
;*      Mode data record template (34 byte structure for Protect Mode)
;*

Mode_Data      STRUC
               Len              DW  ?   ; Length of this data structure
               M_Type           DB  ?   ; Display Mode type value
               M_Color          DB  ?   ; Number of color bits
               New_TCol_Res     DW  ?   ; Text column resolution
               New_TRow_Res     DW  ?   ; Text row resolution
               New_GCol_Res     DW  ?   ; Graphics column resolution
               New_GRow_Res     DW  ?   ; Graphics row resolution
               Attrib_Fmt       DB  ?   ; Attribute format
               Num_Attrib       DB  ?   ; Number of attributes
               Buf_Address      DD  ?   ; Display buffer address
               BufLen           DD  ?   ; Buffer length
               FullBuf          DD  ?   ; Full buffer size
               PartBuf          DD  ?   ; Partial buffer size
               ExtData          DD  ?   ; Extended data area address
Mode_Data      ENDS


;*
;*      Internal Data Structure used for GetPointerMemory Function call
;*

Call_5Blk      STRUC
               Addr1            DD  ?   ; Address to ptr definition record
               Addr2            DD  ?   ; Address to ptr image buffer
Call_5Blk      ENDS


;*
;*      Collision Area Definition record template (8 byte structure)
;*

C_Area_Rec     STRUC
               R_Pos            DW  ?   ; Area's starting row coord
               C_Pos            DW  ?   ; Area's starting col coord
               R_End            DW  ?   ; Area's ending row coord
               C_End            DW  ?   ; Area's ending col coord
C_Area_Rec     ENDS


;*
;*      Event Queue element definition record template (10 byte structure)
;*

Event_Rec      STRUC
               EVMask           DW  ?   ; Event occurrence mask
               Time             DD  ?   ; Event time stamp
               PR_Pos           DW  ?   ; Current pointer row-coord
               PC_Pos           DW  ?   ; Current pointer col-coord
Event_Rec      ENDS


;*
;*      Monitor Chain Buffer definition record template (12 byte structure)
;*

Mon_Rec        STRUC
               Mon_Flags        DW  ?   ; Monitor specific flags
               Mon_Emask        DW  ?   ; Event occurrence mask
               Mon_Time         DD  ?   ; Event's MilliSec Time Stamp
               Mon_Row_Pos      DW  ?   ; Current pointer row-coord
               Mon_Col_Pos      DW  ?   ; Current pointer col-coord
Mon_Rec        ENDS


;*
;*      Generic IOCtl Function I/O Structure template (4 byte structure)
;*

Gen_Temp       STRUC
               Parm1            DW  ?   ; 1st Word parameter
               Parm2            DW  ?   ; 2nd Word parameter
Gen_Temp       ENDS

;*
;*      Monitor Register Data Parm Structure (10 byte structure)
;*

Mon_Data       STRUC
               P_Flag           DW  ?   ; Placement Flag
               Index            DW  ?   ; DD Dependent Index
               Input_Buff       DD  ?   ; Input Buffer Address
               Output_Buff      DW  ?   ; Output Buffer Offset
Mon_Data       ENDS


;*
;*      Mouse event data collection record template (5 byte structure)
;*

Mou_Event      STRUC
               Buttons          DB  ?   ; Interrupt button status field
               Mouse_Col1       DB  ?   ; Interrupt 1st X delta value
               Mouse_Row1       DB  ?   ; Interrupt 1st Y delta value
               Mouse_Col2       DB  ?   ; Interrupt 2nd X delta value
               Mouse_Row2       DB  ?   ; Interrupt 2nd Y delta value
Mou_Event      ENDS

;*
;*      Interrupt packet.  Built by device specific mouse routines.
;*      has common format:
;*          Event  DW   Bit 0 - Pure motion
;*                      button x - bit 2x-1 set for with motion
;*                                 bit 2x set for w/o motion
;*          Col_Mov DW  Column movement in mickeys (2's complement)
;*          Row_Mov DW  Row movement in mickeys (2's complement)
;*
;*      The second Abs_Data is for absolute events.
;*          The event is the same format
;*          X_Pos,Y_Pos is the location of the event in the absolute
;*          device space represented by X_Size,Y_Size.  X_Pos and Y_Pos
;*          are 0 based numbers, while X_Size and Y_Size represent the
;*          size (1 based).
;*


Packet    Struc
          Event       DW      ?
          Col_Mov     dw      ?
          Row_Mov     dw      ?
Packet    Ends


Abs_Data    struc
            Abs_Event    dw     ?
            Y_Pos        dw     ?
            X_Pos        dw     ?
            Y_Size       dw     ?
            X_Size       dw     ?
Abs_Data    Ends



;*
;* Register protect mode pointer draw routine parameter structure.
;*

SD_Param     struc                  ; 
             DLLen       dw    ?    ; length of structure (6)
             DLCfg       dw    ?    ; new display config number
             DLCaller    dw    ?    ; caller flag
SD_Param     Ends                   ; 


;*
;* DevHlp_AttachDD Data Record, used for SQ DD Input Mode Interface
;*

Atch_DD      STRUC                  ; For SQ DD Interface Data
             RealEntry   DD  ?      ; DD Real Mode Entry Pt (Seg:Offset)
             RealDS      DW  ?      ; DD Real Mode Data Segment
             ProtEntry   DD  ?      ; DD Protect Mode Entry Pt (Sel:Offset)
             ProtDS      DW  ?      ; DD Protect Mode Data Selector
Atch_DD      ENDS                   ; SQ DD Call Record

;*
;* Device data from the hardware DD
;*

Dev_Data    struc
            DDlen        dw  ?            ; length of this structure in bytes
            NumMics      db  ?            ; Number of mickeys per cm
            NumButt      db  ?            ; number of buttons
            IRQ          db  ?            ; device IRQ level
            MouseType    db  ?            ; Mouse type attached:
            ComNum       db  ?            ; 0 if non-serial device
            ComPort      dw  ?            ; Com port address
Dev_Data    EndS

;*
;* Queue structure for use by QueueWrite and Read functions
;*

QueueStruc   Struc
   Start     dw         ?   ; start of queue
   Head      dw         ?   ; head of queue
   Tail      dw         ?   ; tail of queue
   PID       dw         ?   ; PID blocked on event queue
   EQSize    db         ?   ; size of event queue
QueueStruc   Ends

;*
;* Threshold structure.
;*

ThrHold        Struc
   THLength    dw         ?   ;  length of structure
   THLevel1    dw         ?   ;  level 1 movement value
   THLvl1Mplr  dw         ?   ;  level 1 multiplier
   THLevel2    dw         ?   ;  level 2 movement value
   THLvl2Mplr  dw         ?   ;  level 2 multiplier
ThrHold        Ends

;*
;* This structure is used when the PMSE sends an event to the VMSE.
;*

VDMEvent_        struc        ; Used on the NOTIFYEVENT function.
   ve_SGID       dw       ?   ; Screen group number.
   ve_Event      dw       ?   ; Button/motion status bits.
   ve_X          dw       ?   ; Column motion in mickeys (OR) ABS col position.
   ve_Y          dw       ?   ; Row motion in mickeys (OR) ABS row position.
VDMEvent_        Ends

;*
;* This is the input packet the VMSE sends on the PMSE_XMOUSEMODE function
;*

xmm_             struc
   xmm_len       dw       ?   ; Length of packet in (8 bytes)
   xmm_sgid      dw       ?   ; DOS window session id number
   xmm_flags     dd       ?   ; Flags
xmm_             ends

;*
;* This structure top portion for all notification types from the
;* Cat B function 41h IOCTL call from the Session Manager.
;*

SC_     Struc
   SC_Length     dw             ?     ; length of the structure
   SC_Action     dw             ?     ; type of control operation
SC_     Ends

;*
;* This structure is for the TERMINATION notification type of the
;* Cat B function 41h IOCTL call from the Session Manager.
;*

TERMINATION_     Struc
                 db (size SC_) dup (?)
   TN_TypeOut    dw             ?     ; 
   TN_SIDOut     dw             ?     ; 
TERMINATION_     Ends

;*
;* This structure is for the CREATION notification type of the
;* Cat B function 41h IOCTL call from the Session Manager.
;*

CREATION_        Struc
                 db (size SC_) dup (?)
   CN_SIDIn      dw             ?     ; 
   CN_TypeIn     dw             ?     ; 
CREATION_        Ends

;*
;* This structure is for the both PRESWITCH and POSTSWITCH notification
;* types of the Cat B function 41h IOCTL call from the Session Manager.
;*

PSWITCH_       Struc
                 db (size SC_) dup (?)
   PS_SIDIn      dw             ?     ; 
   PS_TypeIn     dw             ?     ; 
   PS_SIDOut     dw             ?     ; 
   PS_TypeOut    dw             ?     ; 
PSWITCH_       Ends

;*
;* This structure is for the AIMPOSTSAVE notification type of the Cat B
;* function 41h IOCTL call from the Session Manager.
;*

AIM_       Struc
                 db (size SC_) dup (?)
   AIM_Errors    dd             ?     ; 
   AIM_Active    dw             ?     ; 
   AIM_TimeOut   dw             ?     ; 
   AIM_FKAccept  dd             ?     ; 
   AIM_FKRate    dd             ?     ; 
   AIM_FKDelay   dd             ?     ; 
AIM_       Ends

;*
;* This structure is for the dynamic allocation of FULL screen CBs.
;*

CBPtrStruc  struc
            SGSelOff    dd     ?   ; selector:offset to control block
            SGLinear    dd     ?   ; linear address to control block
CBPtrStruc  EndS

;*********************************************************************
;*     IDC_Entry defines the structure for each IDC handle given     *
;*     by MOUSE$ in the Start_IDC routine.                           *
;*********************************************************************

IDC_Entry   struc
            IDC_Flags   dw     ?   ; IDC flags per handle.
            IDC_Status  dw     ?   ; IDC activity status.
IDC_Entry   EndS

MAXIDCS     equ      5             ; Maximum IDC handles allowed

;*********************************************************************
;*     IDC_Flags equate definitions                                  *
;*********************************************************************

IDC_ACTIVE         equ   0001h     ; This IDC handle is now active.

;*********************************************************************
;*     SN_Flags  equate definitions                                  *
;*********************************************************************

SNF_ACTIVE          equ   0001h    ; Special needs support is now active.

;*********************************************************************
;*     APM bit definitions         ;                                 *
;*********************************************************************

APM_DEVICEID        equ   0001h     ; Indicates we are dependent on BIOS

;*********************************************************************
;*     APM bit positions defined in SynchFlag ( DATA.ASM )           *
;*********************************************************************
APM_IDCACTIVE       equ   00001000b ; Bit mask to indicate APM active
APM_IDCINACTIVE     equ   11110111b ; Bit mask to clear APM Inactive bit
APM_RESETMOUSE_ON   equ   00010000b ; Bit mask to indicate APM reset needed
APM_RESETMOUSE_CLEAR equ  11101111b ; Bit mask to clear APM reset needed bit
