;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/

;/*************************************************************************
;*
;* SOURCE FILE NAME = DATA.ASM
;*
;* DESCRIPTIVE NAME = Device dependent DD data segment for
;*                    the vision serial mice.
;*
;*
;* VERSION      V2.0
;*
;* DATE         07/08/91
;*
;* DESCRIPTION  This file contains the device dependent DD data
;*              segment.  It is the 1st module in the link list.
;*              It also contains conditional assemble statements.
;*
;* FUNCTIONS    NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;**************************************************************************



DSEG   SEGMENT   WORD  PUBLIC  'DATA'
DSEG   ENDS

CSEG   SEGMENT   WORD  PUBLIC  'CODE'
CSEG   ENDS

DUMMY  SEGMENT   WORD  PUBLIC  'CODE'
DUMMY  ENDS

DGROUP GROUP DSEG
CGROUP GROUP CSEG, DUMMY

.xlist
       include devsym.inc
       include dddd.inc
.list

.286c

;*
;*  External Mouse Referneces From this Module
;*

       extrn HIDC_Entry         : near
       extrn Strategy           : near
       extrn Query_Config       : near
       extrn Read_Enable        : near
       extrn Read_Disable       : near
       extrn Enable_Device      : near
       extrn Disable_Device     : near


DSEG     SEGMENT

;*
;*      OS/2 Device Driver Header
;*

MouseHDR    LABEL   WORD
            DW       -1                    ; Device header pointer
            DW       -1                    ; Device header pointer
            DW       DEV_IOCTL+DEV_CHAR_DEV+DEVLEV_3 ; Device Driver attributes
            DW       Strategy              ; Strategy Routine Offset
            DW       HIDC_Entry            ; IDC entry point
IFDEF VIS
            DB       'VISION$ '            ; Device Name
ENDIF
IFDEF PCL
            DB       'PCLOGIC$'            ; Device Name
ENDIF
            DW       0                     ; Protect-mode CS Strategy Selector
            DW       0                     ; Protect-mode DS selector
            DW       0                     ; Real-mode CS Strategy Segment
            DW       0                     ; Real-mode DS segment
            DD       2                     ; Can handle > 16MB physical memory


;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;              IDC function table                                          *
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

IDC_Func      dw     Query_Config
              dw     Read_Enable
              dw     Read_Disable
              dw     Enable_Device
              dw     Disable_Device

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;                           Variables                                      *
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Device_Help   dd         0               ; Dev helper entry point
DevStatus     dw         0               ; current device status
                                         ; High byte: reserved 0
                                         ; Low byte:
                                         ;   0000000x  Read enabled
                                         ;   000000x0  MOUSE$ attach done
                                         ;   00000x00  IRQ enabled
                                         ;   0000x000  We've been deinstalled
                                         ;   000x0000  device enabled
                                         ;   00000000
                                         ;   00000000
IntPacketOff  dw         0               ; offset in Mouse DS for int data
First_Port    dw         ?               ; used to claim BIOS data area
ByteCount     dw         0               ; packet counter
pComAddr      dw         0               ; pointer to com port address


;*
;* This section contains conditionally assembled device data blocks.  Each is
;* changed during initialization to indicate the device IRQ level and any
;* other device characteristics.
;*

IFDEF VIS
DeviceData   Dev_Data  <CFGDATLEN,40,2,0,2,1>    ; !! Device data   (KD)
ENDIF

IFDEF PCL
DeviceData   Dev_Data  <CFGDATLEN,40,3,0,2,1>    ; !! Device data   (KD)
ENDIF

MseDD         Attach_DD  <>              ; mse DD Interface Data Record
msename       db   'MOUSE$  ',0          ; mouse device name for AttachDD
Disable_8259  db         ?               ; disable IRQ level mask for the 8259
Enable_8259   db         ?               ; enable IRQ level mask for the 8259
MEvent        db    5 dup (0)            ; interrupt data building buffer

;*
;* everything following is discarded at the end of initialization
;*

ENDDATA       EQU        $               ; end of data segment

DSEG     ENDS


;*
;*  Data Segment Variables Made Public for other Mouse Modules
;*

       public IDC_Func
       public Device_Help
       public DevStatus
       public msename
       public IntPacketOff
       public DeviceData
       public MseDD
       public ENDDATA
       public Enable_8259
       public Disable_8259
       public First_Port
       public MEvent
       public ByteCount
       public pComAddr

     END
