;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/

;/*************************************************************************
;*                                                                         
;* SOURCE FILE NAME = EMIIDC.INC
;*                                                                         
;* DESCRIPTIVE NAME =                         
;*                                                                         
;*                                                                         
;* VERSION      V2.0                                                       
;*                                                                         
;* DATE                                                          
;*                                                                         
;* DESCRIPTION                                
;*                                                                         
;* FUNCTIONS    
;*              
;*              
;*              
;*                                                                         
;*             
;* NOTES       
;*             
;*             
;*             
;*             
;* STRUCTURES   NONE                                                       
;*                                                                         
;* EXTERNAL REFERENCES                                                     
;*                                                                         
;*              NONE                                                       
;*                                                                         
;* EXTERNAL FUNCTIONS                                                      
;*                                                                         
;*              NONE                                                       
;*                                                                         
;* CHANGE ACTIVITY =                                                       
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION                       
;*   --------  ----------  -----  --------------------------------------   
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx                                  
;**************************************************************************
                                                                    
;*
;* RegisterDeviceClass Defines
;*

DEVCLASS_INPUT  EQU     2    ;  Device Class for Register Device Class
REG_EXT_IF EQU     0001H     ;  Emi driver
REG_AUX    EQU     8000H     ;  Keyboard AUX port used

;*
;* Mouse.sys defaults
;*

DEFAULT_QSIZE EQU  24        ; fault QSIZE if emi is active

;*
;* Flags for EmiFlags in Mouse.sys
;*

EMI_ACTIVE      EQU         01h       ; emi present flag
EMI_AUX_BUSY    EQU         02h       ; emi using aux port
EMI_NEED_CONFIG EQU         04h       ; emi configuration complete
EMI_READY       EQU         08H       ; emi is ready for requests

;*
;* Emi IDC interface (calls from Mouse.sys to Emi driver)
;*

EMI_CONFIGURE   EQU          1        ; configure emi
                                      ; es:di = Mouse Variable Table
EMI_SYSEVENT    EQU          2        ; indicate system event
                                      ; es:di = Session Info
EMI_STK_REL     EQU          3        ; indicate stock relative event
EMI_STK_ABS     EQU          4        ; indicate stock absolute event
EMI_DISABLE     EQU          5        ; disable emi drivers
EMI_ENABLE      EQU          6        ; enable emi drivers

;*
;* Mouse Var Table
;*

MOUVARTABLE STRUC
EmiEntry        dd  0      ; Emi entry point in mouse.sys
IntPacket       dd  0      ; Address of the interrupt packet
SIntPacket      dd  0      ; Address of the stock interrupt packet
TimeStamp       dd  0      ; Address of where to pass time stamp
SDevData        dd  0      ; Address of the stock DeviceData
EventMask       dd  0      ; Address of the EMaskMax
MOUVARTABLE ENDS

;*
;* Mouse IDC interface (calls from Emi driver to Mouse.sys)
;*

EMI_GETRES_ABS  EQU          1        ; get current screen resolution
                                      ; returns  cx= x screen extents
                                      ;          dx= y screen extents
EMI_CONVERT_REL EQU          2        ; convert device to screen coordinatea
                                      ;          cx= x device coord
                                      ;          dx= y device coord
                                      ; returns  cx= x screen coord
                                      ;          dx= y screen coord
EMI_REL         EQU          3        ; process relative event
EMI_ABS         EQU          4        ; process absolute event
EMI_DISABLE_STK EQU          5        ; disable stk driver
EMI_ENABLE_STK  EQU          6        ; enable stk driver

;*
;* Session Switch Info
;*

SESSWITCHINFO STRUC
Ssi_Command     db 0                  ; system event
Ssi_InfoValid   db 0                  ; 1= video data valid 0= invalid
Ssi_Current     dw 0                  ; current screen group ID
Ssi_Future      dw 0                  ; future screen group ID
Ssi_Mtype       db 0                  ;  video mode type
Ssi_Color       db 0                  ;  number of colors
Ssi_TCol_res    dw 0                  ;  text colomn resolution
Ssi_TRow_res    dw 0                  ;  text row resolution
Ssi_GCol_res    dw 0                  ;  graphics colomn resolution
Ssi_GRow_res    dw 0                  ;  graphics row resolution
SESSWITCHINFO ENDS

;*
;* Ssi_Command values
;*

SSI_START_SES_SWITCH  EQU 1           ; start session switch
SSI_END_SES_SWITCH    EQU 2           ; end of session switch
SSI_START_VM_CHANGE   EQU 3           ; start of video mode change
SSI_END_VM_CHANGE     EQU 4           ; end of video mode change
