;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
  Page  58,132
  Title   KBDIDC - OS/2 2.2 Device Driver
  Name    KBDIDC
;/*****************************************************************************
;*
;* SOURCE FILE NAME = KBDIDC.ASM
;*
;* DESCRIPTIVE NAME = Keyboard Device Driver for OS/2
;*
;*
;* VERSION      V2.X
;*
;* DATE         ????
;*
;* DESCRIPTION  This device driver handles all physical I/O between OS/2
;*              and the keyboard device.
;*
;* FUNCTIONS
;*
;* NOTES   DEPENDENCIES:
;*
;*
;*         RESTRICTIONS:
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*                    ROUTINES:    None.
;*                    DEVHELPS:    Jumps to ThrowMeAway, which calls:
;*                                 DevHlp (GetLIDEntry, SetIRQ, UnSetIRQ,
;*                                         ABIOSCall, GetDOSVar, AllocPhys,
;*                                         AllocGDTSelector, PhysToGDTSelector,
;*                                         TickCount, ResetTimer, ABIOSGetParms,
;*                                         RegisterPDD)
;*
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG         APAR        CHANGE DESCRIPTION
;*   --------  ----------  -------      --------------------------------------
;*****************************************************************************/
;*
BREAK   <Masm   directives, Included files>
.286p
.sall
.xcref
;/*
;**The following files are included, but XLISTed:
;*/
.xlist
;        Include iodelay.inc    ; DevIODelay replaced IODelay
        Include mvdm.inc       ; 
        Include basemaca.inc   ;DOS macros.
        Include osmaca.inc     ;Macro file for OS/2 kernel
        CPUMODE 286
        Include struc.inc      ;Structured assembly macros.
        Include devhlp.inc     ;DevHlp & Signal equates, char queue structure
;        Include dosmac.inc    ; translation table equates.
        Include infoseg.inc    ;InfoSeg structure.
        Include devsym.inc     ;Device driver header definitions.
        Include kbdseg.inc     ;Segment definitions.
        Include kbdddr.inc     ;Keyboard Device Driver structures & equates.
        Include kbddi.inc      ; 
        Include vkbdpdd.inc    ;VKBD structures
;        Include kbdaim.inc     ;AIM equates
.list

StkFrameVars                   ; Macro to define the local stack
                               ; variables.

;/*****************************/
;/*   External Routines       */
;/*****************************/

  Extrn    ProcessScanCode   :Near
  Extrn    SetLocalVar       :Near
  Extrn    VDDEntryPoint     :Near
  Extrn    AccessKCB         :Near
  Extrn    PENIDC            :Near

;/*****************************/
;/*   External Variables      */
;/*****************************/

  Extrn    PDataSel          :WORD
  Extrn    DeviceHelp        :DWORD
  Extrn    IDC_CB            :WORD
  Extrn    KeyboardType      :WORD
  Extrn    Open_IDC          :BYTE
  Extrn    Close_IDC         :BYTE
  Extrn    Process_Keystroke :BYTE
  Extrn    Process_Reinit    :BYTE
  Extrn    Pen_Functions     :BYTE
  Extrn    Query_ID          :BYTE
  Extrn    OtherFlags        :BYTE
  Extrn    Keystroke         :BYTE
  Extrn    Keystroke2        :BYTE
  Extrn    VDMFocus          :BYTE
  Extrn    IDFlags           :BYTE
  Extrn    MiscFlags         :BYTE
  Extrn    IntFlags          :BYTE
  Extrn    IDstructure       :WORD
  Extrn    KbdHWIDs          :WORD
  Extrn    PDDtoVDDSCPkt     :WORD
  Extrn    SCCount           :BYTE
  Extrn    KeyHistBuf        :BYTE
  Extrn    KBDDDcall         :DWORD
  Extrn    CheckKBDDD        :WORD


;/*************************************************************************/

Code Segment
Assume  CS:Code,DS:DGROUP,ES:Nothing

;**********************************************************************
;*
;* FUNCTION NAME  DD_Entry
;*
;* DESCRIPTION    Interface to other device dependent drivers.
;*
;*       This routine interfaces to the other hardware dependent drivers.
;*       It will send the information to any device that is registered,
;*       unless that device registered with a zero code segment.  This means
;*       that the driver doesn't want to receive updates.
;*
;* INPUT       Three variables on the stack:
;*                1- variable for execution.
;*                2- Variable for execution.
;*                3- Function to be executed.
;*
;* Exit-normal  Return information in Registry IDC_Return structure.
;*
;* Exit-error   None
;*
;* Effects      Registered devices are updated.
;*
;* Internal Calls: None.
;*
;* External Calls: Far call to KBDDDcall (address of registered devices).
;*
;**********************************************************************

Public DD_Entry
Procedure DD_Entry, FAR

  ArgVar Var0 WORD
  ArgVar Var1 WORD
  ArgVar Var2 WORD

  EnterProc

  Pusha                                ; Save registers
  Push si
  push es

  .if <Var0 eq DD_Cmd_Typematic>       ; Check to see if word needs adjusting
     mov bx, Var1                      ; It does so shift word into a byte
     mov ah, bh                        ;  that is correct for the IDC.
     shl ah, 5
     or  bl, ah
     xor bh, bh
     mov Var1, bx
  .endif
  .if <bit OtherFlags nz InterruptTime> ; Is this called during interrupt time
     mov ax, Var0
     or ax, 8000h                       ; Set interrupt bit in variable
     mov Var0, ax
  .endif
;;
;; call to device dependent functions
;;
  lea  si, IDC_CB                      ; Offset to the block of handles
  xor cx,cx                            ; Initialize counter
  .while <cx lt MAXIDCS>               ; Check all register locations
     .if <bit [si].IDC_Flags nz IDC_ACTIVE>   ; If handle is active
        push si                        ; If registration is active
        push cx                        ; Save registers
        mov bx, [si].IDC_Offset        ; Get offset of IDC
        mov word ptr KBDDDcall[0], bx  ; Store it in pointer
        mov bx, [si].IDC_Segment       ; Get segment of IDC
        mov word ptr KBDDDcall[2], bx  ; Save it in pointer
        .if <bx ne 0>                  ; If Code seg equals zero then driver
                                       ;  doesn't want to be notified.
                                   ; C func - KBDDDcall(Var2, Var1, Var0);
          push Var2                    ; Push third parameter
          push Var1                    ; Push second parameter
          push Var0                    ; Push first parameter
          call dword ptr [KBDDDcall]   ; Call function
          add sp, 6                    ; Add to stack to get rid of parameters
        .endif

        pop cx                         ; Restore counter
        pop si                         ; Restore pointer to registry
        mov [si].IDC_Return, ax        ; Save value returned
     .endif
     inc cx                            ; Increment counter
     add si, size IDC_Entry            ; Point to next registered device
  .endwhile                            ; End while loop
  pop es                               ; Restore ES
  pop si                               ; Restore SI
  Popa                                 ; Restore registers
  LeaveProc                            ; Clean up stack
  Ret 6                                ; Clean up the 3 words passed in

EndProc DD_Entry                       ; End IDC interface to Device Dependents


;**********************************************************************
;*
;* FUNCTION NAME  KbdIDC
;*
;* DESCRIPTION    IDC entry from other device dependent drivers.
;*
;*       This routine interfaces to the other hardware dependent drivers.
;*       It receives commands from the drivers and then executes them.
;*
;* INPUT        Four variables on the stack:
;*                  1- Function to be executed.
;*                  2- Offset
;*                  3- Data Segment
;*                  4- Handle or Code Segment
;*              If device dependent driver does not need to notified of
;*              changes, ie. LED changes, then set the code segment to
;*              zero when requesting an open.  Data segment should be
;*              callers segment.
;*
;* Exit-normal  AX = 0 or Handle
;*
;* Exit-error   AX = 1
;*
;* Internal Calls: ProcessScanCode
;*                 PENIDC
;*
;* External Calls: None
;*
;**********************************************************************
;*
;/*************************************************************************/
;/*                                                                       */
;/*      Pseudo-code for KBDIDC.ASM                                       */
;/*                                                                       */
;/*   USHORT KBDICD(USHORT IDC_CMD)                                       */
;/*   {                                                                   */
;/*       switch (IDC_CMD)                                                */
;/*       {   case CMD_Open : Get offset and segment                      */
;/*                           Compare to other handles to make sure that  */
;/*                              there isn't a duplicate.                 */
;/*                           Assign a new handle if not duplicate.       */
;/*                           break;                                      */
;/*                                                                       */
;/*           case CMD_Close : Get handle.                                */
;/*                            Verify that it is valid.                   */
;/*                               If not valid return error.              */
;/*                            Delete handle from list.                   */
;/*                            break;                                     */
;/*                                                                       */
;/*           case CMD_KeyStroke : Get handle.                            */
;/*                                Verify that it is valid.               */
;/*                                    If not valid return error.         */
;/*                                Get offset and segment of scancode.    */
;/*                                Send to be processed.                  */
;/*                                break;                                 */
;/*                                                                       */
;/*           case CMD_Reinit : Get handle.                               */
;/*                             Verify that it is valid.                  */
;/*                                If not valid return error.             */
;/*                             Get keyboard ID.                          */
;/*                             Set LEDs.                                 */
;/*                             Set type rate.                            */
;/*                             Notify others of reinit.                  */
;/*                                                                       */
;/*           case PEN_FUNCTIONS : ...                                    */
;/*                                break;                                 */
;/*                                                                       */
;/*           default : error.                                            */
;/*                     break;                                            */
;/*                                                                       */
;/*       }                                                               */
;/*   }                                                                   */
;/*                                                                       */
;/*************************************************************************/

Public KbdIDC
Procedure KbdIDC, FAR

  ArgVar HandleNum  WORD               ; Handle or Code Segment
  ArgVar DD_Seg     WORD               ; Data Segment
  ArgVar DD_Off     WORD               ; Offset
  ArgVar func       WORD               ; Function requested

  EnterProc

  push ax
  mov ax, ds
  .if <ax eq KbdData>                  ; Do we have a pen 1.0 request?
     pop ax                            ; Yes so use backward compatible
     call PENIDC                       ;  interface
.386p
     pop bx
     pop eax
     sub sp, 8
     push eax
     push bx
     mov bp, sp
.286p
     jmp EndPen
  .endif

  pop ax
  push ds                              ; Save Data Segment of incoming driver
  mov ax, KbdData                      ; Get our own Data Segment
  mov ds, ax                           ; And store it
  mov ax, func                         ; Check MSB to see if the we are running
  .if <bit ax eq 8000h>                ;  during interrupt time
     or OtherFlags, InterruptTime      ; If we are then set interrupt flag
  .endif

  .if <ah eq Pen_Functions>            ; Are we requesting to process a Pen Func?
     mov di, DD_Off                    ; Load registers
     mov es, DD_Seg
     mov bx, Handlenum
     call PENIDC
                                       ; Note: this is hit most so put it first.
  .elseif <al eq Process_Keystroke>    ; Are we requesting to process a keystroke?
     call Handle_Check                 ; Check the handle given
     .if <c>                           ; Is it a valid handle?
        call Proc_Keystroke            ; It is so process keystroke
     .else
        mov ax, -1                     ; It's not so flag an error
     .endif

  .elseif <al eq Open_IDC>             ; Are we requesting to register a device?
     call Open_KBD                     ; Go and register it
     .if <c>                           ; Check to see if it failed
        mov ax, bx                     ; It is registered, return handle in AX
     .else
        mov ax, -1                     ; It failed, return -1
     .endif

  .elseif <al eq Close_IDC>            ; Are we requesting to close a device?
     call Handle_Check                 ; Check the handle given
     .if <c>                           ; Is it a valid handle?
        and  [si].IDC_Flags, NOT IDC_ACTIVE ; This handle is now open
     .endif

  .elseif <al eq Process_Reinit>       ; Are we requesting to process a Hot Plug?
     call Handle_Check                 ; Check the handle given
     .if <c>                           ; Is it a valid handle?
        call Proc_Reinit               ; Go process the Hot Plug
     .endif

  .else
     mov ax, -1                        ; Error
  .endif
  pop ds                               ; Restore Data Segment
EndPen:
  LeaveProc                            ; Clean up stack
  Ret 8                                ; Clean up the 4 words passed in

KbdIDC  Endp


;**********************************************************************
;*
;*  FUNCTION NAME :  Open_KBD
;*
;*  DESCRIPTION   :  Start an Inter Device Communication link
;*                     with the keyboard device independent device
;*                     driver (KBDDI$).
;*
;*                   This function is invoked by another Device
;*                   driver to get a keyboard IDC interface handle.
;*                   This function supports a max of 5 open keyboard
;*                   IDC handles at any one time. If a 6th keyboard IDC
;*                   handle is requested a NO_HANDLES_AVAILABLE error
;*                   code will be returned.
;*
;*  ENTRY POINT  :  Open_KBD        LINKAGE:  CALL NEAR
;*
;*  ENTRY        :  AX = Function code
;*                  Open_KBD = 00h
;*                  DS = KBDDI$ DD DS value
;*                  ES = Calling DD DS value
;*                  All other reqs are undefined
;*
;*  RETURN-NORMAL: Carry Flag clear. Register listed below;
;*
;*                   BX = Keyboard IDC handle
;*                   DS = KBDDI$ DD DS value
;*                   ES = Calling DD DS value
;*                   All other reqs are undefined
;*
;*  RETURN-ERROR :  Carry set, registers listed below;
;*
;*                  AX = Error return code if carry set
;*                  DS = KBDDI DD DS value
;*                  ES = Calling DD DS value
;*                  All other reqs are undefined
;*
;*  EFFECTS      :  Registers modified.
;*
;*  INTERNAL REFERENCES:
;*     ROUTINES:  NONE.
;*
;*  EXTERNAL REFERENCES:
;*     ROUTINES:  NONE.
;*     DevHelps:  NONE.
;*
;**********************************************************************
;*  PSEUDOCODE :
;*
;* BeginSub  Open_KBD
;*
;*
;*    Get CB for handle 0
;*    REPEAT
;*       IF <this handle is free>
;*          Mark this handle as active in CB
;*          LEAVE
;*       ENDIF
;*       Get CB for next handle
;*    UNTIL <MAXIDCS have been checked>
;*
;*    IF <a new handle has been given>
;*       Clear carry flag
;*    ELSE
;*       move into AX register (ERROR_NO_MORE_HANDLES)
;*       Set carry flag
;*    ENDIF
;*
;*  return
;*
;* EndSub  Open_KBD
;*
;************************************************************************

Public Open_KBD
Open_KBD  proc  near

   lea  si, IDC_CB                       ; Offset to the block of handles.
   xor  bx, bx                           ; Start with handle zero.

   .repeat
      .if <bit [si].IDC_Flags z IDC_ACTIVE>    ; If handle is free.
         or [si].IDC_Flags, IDC_ACTIVE   ; This handle is now in use.
         mov ax, DD_Off                  ; Get IDC Offset
         mov [si].IDC_Offset, ax         ; Load IDC Offset
         mov ax, DD_Seg                  ; Get IDC Data Segment
         mov [si].IDC_ds, ax             ; Load IDC Data Segment
         mov ax, HandleNum               ; Get IDC Code Segment
         mov [si].IDC_Segment, ax        ; Load IDC Code Segment
         .leave                          ; We found a slot so get out
      .endif
      inc  bx                            ; Try next handle
      add  si, size IDC_Entry            ; Get next slot
   .until <bx eq MAXIDCS>                ; Zero based (6th entry is invalid)

   .if <bx lt MAXIDCS>                   ; If a new handle has been given
      mov CheckKBDDD, 0001h              ; Flag that we have a device registered
      stc                                ; Set carry
   .else
      mov  ax, 8024h                     ; ERROR_NO_MORE_HANDLES
      clc                                ; Clear carry
   .endif
   Ret

Open_KBD  endp

;**********************************************************************
;*
;*  FUNCTION NAME :  Handle_Check
;*
;*  DESCRIPTION   :
;*
;**********************************************************************

Public Handle_Check
Handle_Check  proc  near

   mov bx, HandleNum                      ; Load handle value
   .if <bx lt MAXIDCS>                    ; If handle is less then MAX IDCs
      lea  si, IDC_CB                     ; Offset to the block of handles
      imul bx, size IDC_Entry             ; Get offset to this entry
      add  si, bx                         ; We now point to the handle entry
      mov  bx, DD_Seg                     ; Load Data Segment
      .if <bit [si].IDC_Flags nz IDC_ACTIVE> AND   ; Check if handle is active.
      .if <[si].IDC_ds eq bx>             ; And if data segments are the same
         stc                              ; Yes they are, Handle is OK
      .else
         clc                              ; They aren't so clear carry
      .endif
   .else
                     ; The value of 502 will need to be changed to say invalid
                     ; keyboard instead of mouse (502 is from the mouse code)
      mov  ax, 502                        ; ERROR_KBD_INVALID_HANDLE
      clc                                 ; Failed to find correct handle
   .endif
   Ret

Handle_Check  endp

;**********************************************************************
;*
;*  FUNCTION NAME :  Proc_Keystroke
;*
;*  DESCRIPTION   :
;*
;******************************************************************************

Public Proc_Keystroke
Proc_Keystroke Proc Near

  Enter  0022, 00                      ; Set stack space for SetLocal Var

    mov ax, -1                         ; Set AX to -1 for SetLocalVar
    call SetLocalVar                   ; Set up the local stack variables
    mov di, StkPSG                     ; Load DI

    push ds                            ; Save DS
    mov si, DD_Off+6                   ; Point to key stroke data offset
    mov ds, DD_Seg+6                   ; Load Driver's DS
    mov al, [si]                       ; Get first scan code
    mov bl, [si]+1                     ; Get second scan code
    pop ds                             ; Restore my DS
    mov Keystroke, al                  ; Store first scan code
    mov Keystroke2, bl                 ; Store second scan code
    Call ProcessScanCode               ; Go process first scan code
    mov bl, Keystroke
    .if <bl eq OtherKey>
       mov al, Keystroke2
       Call ProcessScanCode
    .endif
    .If <VDMFocus eq 0> AND            ; If VDM does NOT have focus AND
    .If <bit IntFlags nz Up_LEDs>      ; If LEDs need to be updated
       And IntFlags,NOT Up_LEDs        ; Clear flag
       Shr AX,4                        ; Move LED bits to low nibble
       And AX,7                        ; Turn off all unwanted bits
       Push 2222h                      ; Var2 (Not used for this call)
       Push AX                         ; Var1 (LED state)
       Push DD_Cmd_IndicatorsI         ; Function, INTERRUPT TIME           
       Call DD_Entry                   ; Device Independent Entry Point
    .Endif

    And OtherFlags, NOT InterruptTime  ; Clear Interrupt Time flag
   Leave
   Ret

Proc_Keystroke endp



;**********************************************************************
;*
;*  FUNCTION NAME :  Proc_Reinit
;*
;*  DESCRIPTION   :
;*
;**********************************************************************

Public Proc_Reinit
Proc_Reinit proc near

  Enter  0022, 00                      ; Set stack space for SetLocal Var

    mov ax, -1                         ; Set AX to -1 for SetLocalVar
    call SetLocalVar                   ; Set up the local stack variables
    mov di, StkPSG                     ; Load DI
;*Ŀ
;* Reinit certain data areas   
;*
;* This is copied from KBDHWDD.ASM version 2.1
  Mov  SCCount, 00                    ; Set SCCount to zero,prevent BLOCKS on it
                                      ;    Clear out the KeyHistBuf because
                                      ;    sometimes the hardware sends junk
  Push SI                             ; MAKES when the hot plug is done before
  Push BX                             ; the ffh aah sequence.  Otherwise SG's
  Xor  AX, AX                         ; would be blocked waiting for the BREAKS
  Xor  BX, BX                         ; of the      scan codes which will
  Mov  SI, Offset KeyHistBuf          ; never happen.
 .While <AX le 9>                     ; 
   Mov Byte Ptr [SI], BL              ; 
   Inc SI                             ; 
   Inc AX                             ; 
 .Endwhile                            ; Endwhile KeyHistBuf not cleared out
  Pop BX                              ; Restore reg
  Pop SI                              ; Restore reg
                                      ; Reinit these BEFORE ReadIDHP in case
                                      ; of a resend, values must be preserved
  Mov IDFlags, 00                     ; Reinitialize flags
  Mov Byte Ptr [KbdHWIDs], 00h        ; Reinitialize KbdHWIDs
  Mov Byte Ptr [KbdHWIDs + 1], 00h    ; Reinitialize KbdHWIDs

;*Ŀ
;* Get the new hardware ID bytes.                                     
;*

  push ds                              ; Push Data Segment
  mov ax, Offset KbdData:IDstructure   ; Get offset to structure of KBD ID
  push ax                              ; Push Offset to structure
  mov al, Query_ID                     ; Get Keyboard ID
  xor ah,ah                            ; 
  push ax                              ; Push Function
  Call DD_Entry                        ; Device Independent Entry Point
                                       ; 
  Call Handle_Check                    ; Reset the pointer to the right driver
  mov ax, word ptr IDstructure.idbytes ; Get ID word
  mov word ptr KbdHWIDs, ax            ; Store ID word
  .if <ah eq ID2B>                     ; Is it a Super Sport Keyboard?
     or IDFlags, SuperSport            ; If yes then set flag
  .endif                               ; 
  mov keyboardtype, 1                  ; Set Keyboard type to 1
  or  IDFlags, EnhancedKbd             ; Default ID Flag to Enhanced
  or MiscFlags, EnhancedKbd            ; Set Misc Flag to Enhanced
  .if <ax eq 0100h>                    ; If an AT keyboard
     and  IDFlags, NOT EnhancedKbd     ; Unset default
     or  IDFlags, ATKbd                ; Set ID bit
     and MiscFlags, NOT EnhancedKbd    ; Make it not Enhanced
     mov KeyboardType, 0               ; Set keyboard type to 0
  .endif

;*Ŀ
;* UPDATE THE LEDS                                                    
;*

  Mov    DH,ES_DI                      ;* Tell PhysToVirt where to put it.
  Call   AccessKCB                     ;* Go get access to this SG's KCB
  Mov    BX,DI                         ;* Put KCB offset in BX
  Mov    ax ,ES:[BX].KCBShift          ;* Put them in the KCB
  Shr AX,4                             ; Move LED bits to low nibble
  And AX,7                             ; Turn off all unwanted bits
  Push 2222h                           ; Var2 (Not used for this call)
  Push AX                              ; Var1 (LED state)
  Push DD_Cmd_IndicatorsI              ; Function, INTERRUPT TIME           
  Call DD_Entry                        ; Device Independent Entry Point

;*Ŀ
;* TELL THE VKBD A HOT PLUG OCCURRED                                  
;*
;* This is copied from KBDHWDD.ASM version 2.1

 .If < <word ptr VDDEntryPoint+2> ne 0 >  ;* If the VDD's high word isn't 0
                                          ;* Then VKBD has registered.
    Mov  PDDtoVDDSCPkt.khp_len, KHP_PKT_LEN ;*  Set up the parms for call to VKBD
    Mov  AX, KbdHWIDs                       ;*
    Mov  PDDtoVDDSCPkt.khp_usKbdHWID, AX ;* Set up the parms for call to VKBD
    pusha                               ;* Push all regs (VDDEntryPoint) trashes
    SaveReg<ES>                         ;* VDD is also trashing ES
    Push Word Ptr 0                     ;* Send zero in high word
    Push Word Ptr VKBDCMD_HOTPLUG       ;* VKBDCMD_HOTPLUG event
    Push DS                             ;* Send our Data Selector
    Push Offset PDDtoVDDSCPkt           ;* Send offset to packet from our DS
    Push Word Ptr 0                     ;* Send zero in high word
    Push Word Ptr 0                     ;* Send zero in high word
    .386p                               ;*
       Call Fword Ptr VDDEntryPoint     ;* Call the VDD entry point
    .286p                               ;*
    RestoreReg<ES>                      ;* Get VDDs data sel back
    Mov PDDtoVDDSCPkt.khp_len,  6       ;*
    popa                                ;* Pop all regs (VDDEntryPoint)
 .Endif

;*Ŀ
;* SEND DEVHLP TO TELL SYSTEM A HOT PLUG OCCURED                      
;*
;* This is copied from KBDHWDD.ASM version 2.1

  Mov  AH, event_HOT_PLUG               ;* Specify DevHlp function
  Xor  BX, BX                           ;* Set argument to zero
  Mov  DL,DevHlp_SendEvent              ;* Set DevHlp function for SendEvent.
  Call DeviceHelp                       ;* Call Device Help

  Leave
  Ret

Proc_Reinit endp

Code    Ends

        End
