;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
  Page  58,132
  Title   KBDDATA - 1.1 Keyboard Device Driver Data Declarations
  Name    KBDDATA

;/*****************************************************************************
;*
;* SOURCE FILE NAME = KBDDATA.asm
;*
;* DESCRIPTIVE NAME = Keyboard Device Driver Data Declarations
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*                          Keyboard Device Driver Data
;*
;*             This file contains the most of the data segment of the Keyboard
;*             Device Driver.  The data segment has several parts:
;*
;*              1) The device driver header.
;*
;*              2) Miscellaneous keyboard buffers and constants area (below).
;*
;*              3) Per-SG (per Session) data areas. There is one PSG data
;*                 area for each possible screen group. (Also below.) The PSG's
;*                 offset is contained in a pointer table, and the memory
;*                 requirements for both the pointers and the PSG areas are
;*                 determined dynamically at INIT time.
;*
;*              4) Default Keyboard Control Blocks (DKCB's).  There is one
;*                 DKCB imbedded in each PSG.
;*
;*             The size of the device driver data segment is initially the full
;*             full 64K bytes (see the filler calculation at the end of the
;*             segment);  the size is reduced by the DD INIT routine.  The
;*             final size of the data segment is dependent upon the number of
;*             sessions (i.e., screen groups) at IPL time.
;*
;* FUNCTIONS
;*
;* ENTRY POINTS:
;*
;* DEPENDENCIES:
;*
;* NOTES
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*  DATE      FLAG        APAR      CHANGE DESCRIPTION
;*  --------  ----------  -----     --------------------------------------
;*  mm/dd/yy  @Vr.mpppxx  xxxxx     xxxxxxx
;*  02/17/92              DCR1555   Adopted DDK standards - FUG
;*  02/17/92              DCR1195   Adopted DDK standards - FUG
;*  02/17/92              DCR1176   Adopted DDK standards - FUG
;*  02/17/92              DCR8      Adopted DDK standards - FUG
;*  02/17/92              DCR1187   Adopted DDK standards - FUG
;*  02/17/92              DCR1131   Adopted DDK standards - FUG
;*  02/17/92              DCR1388   Adopted DDK standards - FUG
;*  02/17/92              DCR408    Adopted DDK standards - FUG
;*  02/17/92              DCR549    Adopted DDK standards - FUG
;*  02/17/92              PTM 1699  Adopted DDK standards - FUG
;*  02/17/92              PTM 2382  Adopted DDK standards - FUG
;*  02/17/92              PTM 291   Adopted DDK standards - FUG
;*  02/17/92              PTM 1114  Adopted DDK standards - FUG
;*  02/17/92              PTM 5024  Adopted DDK standards - FUG
;*  02/17/92              B786969
;*  02/17/92              B724802
;*****************************************************************************/

BREAK <Assembler directives, Included files>
.286p
.xcref

;*
;* The following files are included (but xlist'd):
;*
.xlist
incl_mi equ 1
  Include mvdm.inc       ; Equates and data for MVDM support
  Include osmaca.inc     ; Macro file for OS/2 kernel
  CPUMODE 286            ; 
  include vkbdpdd.inc    ; Common structures and data shared between V/P(KBD)
  Include devsym.inc     ; Device driver header definitions.
  Include kbdseg.inc     ; Segment definitions.
  Include kbdddr.inc     ; Keyboard Device Driver structures & equates.
  Include kbdxlat.inc    ; 
  Include kbddi.inc      ; 
  Include kbdaim.inc     ; AIM Needs support
.list

Extrn KBDSTRA:Near                     ;@@ Needed for DD header.
Extrn KbdIDC:Far                       ;PEN SUPPORT

BREAK <Keyboard Device Driver Header>
KbdData Segment ;======================================================\
BeginData       Label   Byte    ; Label for segment filler calculation
                                ;  at the end of this data segment.

;*
;*  Device Header - as defined in the CP/DOS Spec. Must be first
;*                  in the data segment AND linked .sys file.
;*
       public KBDDEV ; 
KBDDEV label  Dword  ;This label used when KBDDD is linked into IBMBIO.

;*
;*  Pointer to next device is unknown, so mark it per the spec.
;*
    dd    -1

;*
;* Device attribute word (CharDev,IOCTL,Open/Close,CP/DOS,KBD):
;*
                                                        ;           
    dw    DEV_IOCTL+DEV_CHAR_DEV+DEVLEV_3+DEV_30+DEV_CIN; DD attributes

;*
;* Pointer to Strategy Entry Point:
;*
    dw    KbdCode:KBDSTRA

;*
;* Reserved word
;*
    dw    KbdCode:KbdIDC          ;PEN SUPPORT

;*
;* Name of device driver:
;*
    db    "KBD$    "       ;Must be 8 characters.

;*
;* Code Seg selector value save area:
;*
    dw    ?

;*
;* Data Seg selector value save area:
;*
Public PDataSel
PDataSel label  Word  ; This label used to block and run threads in both
                      ; modes.  (                      )
    dw    ?

;*
;* Code Seg segment value save area:
;*
    dw    ?

;*
;* Data Seg segment value save area:
;*
    dw    ?             ; 
                        ;           
    dd    2             ; Can handle > 16MB physical memory

;*
;* ***** End of Device Header *****************************************
;*

BREAK <Miscellaneous Declarations>

;*
;*    Miscellaneous keyboard buffers and constants not tied to a SG.
;*

;*
;*     added data declaration
;*

Public PKBDName,VDDEntryPoint,fVDMReady,VDMKeyQ,VDMQInPtr,PDDtoVDDSCPkt
fVDMReady       dw   0                  ;not ready at init time
VDDEntryPoint   df   0                  ;VDD entry point by registration
PKBDName        db   KBD_NAME,0         ;KBD registered name for VDD-PDD comm.
VDMQInPtr       db   MAX_VDM_SC         ;Next slot available in Q (zero based)
VDMKeyQ         db   MAX_VDM_SC+1 DUP(0);Type ahead queue for a VDM SG
PDDtoVDDSCPkt   kint_s <6,,>            ;Scan Code Packet we send to VDD


;*
;*  Count of code pages (including the "hardware default") supported
;*  for this IPL:
;*
Public CPCount          ; Make it public
CPCount     dw  0       ; Set by KbdInit.

;*
;*  Session Manager hotkey table, related data:
;*

Public      HotKeyTable,HotKeyCount,FoundHKID           ; 
HotKeyTable db  MaxHotKeyCt * HKEntrySize dup (0)       ;  Hot Key Table
HotKeyCount db  0                                       ;  key.
FoundHKID   dw  0


                        ; BEGIN           
DD 09CBE9F9Eh           ; 1st half DD start signature for KBD$
DD 0AFAB8BADh           ; 2nd half DD start signature for KBD$
DD 0A19CBEAEh           ; 1st half DD end signature for KBD$
DD 09F9FAB8Dh           ; 2nd half DD end signature for KBD$
                        ; END           


;*
;*  ShiftScanTable used at screen group switch time
;*

Public ShiftScanTable
ShiftScanTable  SST <Scan_R_Shift,RShiftFlag,0>
                SST <Scan_L_Shift,LShiftFlag,0>
                SST <Scan_Ctrl,   RCtlFlag,  SecPrefix>
                SST <Scan_Ctrl,   LCtlFlag,  0>
                SST <Scan_Alt,    RAltFlag,  SecPrefix>
                SST <Scan_Alt,    LAltFlag,  0>

Public KbdIRQ
KbdIRQ      db 1    ; Interrupt level for the keyboard.

Public KbdOpenReq   ;            : Do NOT DeInstall if there are open handles.
KbdOpenReq  db 0    ; Count of the number of OPEN handles for the keyboard.

;*
;* Miscellaneous data buffers and values.
;*

Public      MaxSG,CurSG,KeyboardType,SwitchPID,KCBShFlgs
MaxSG       dw  0   ; Maximum number of sessions, set at INIT time.
CurSG       dw  0   ; Current Screen Group number.
KeyboardType dw  0  ; Save spot for keyboard type returned from kbd.
SwitchPID   dw  0   ; Save spot to remember who can do a SG switch.
KCBShFlgs   dw  0   ;            save spot for the current shift flags for a
                    ; given KCB.  Needed for E0 packet processing.
Public      KbdHWIDs
KbdHWIDs    dw  0                     ; place to put the hardware IDs.

;*
;*

;*
;*


;*
;*  KCB save area doubleword, used as a temp variable to hold various
;*  physical addresses when adding/removing KCB memory.
;*

Public KCBSave
KCBSave     dd  0       ; Used for KCB creation/destruction.

;*
;*  KCB save area doubleword, used as a temp variable to
;*  physical addresses of the KCB that has the focus when processing an int
;*  belonging to a KCB other than the one that currently das the focus.
;*

Public KCBFocusAddress
KCBFocusAddress     dd  0       ; Used for KCB int processing.

;*
;*

;*
;* Miscellaneous save locations for external addresses.
;*

Public      DeviceHelp,SADump
DeviceHelp  dd  0   ; Save spot for indirect address to DevHelp.
SADump      dd  0   ; Save spot for Stand Alone Dump address.

Public      LInfoSeg,SInfoSeg,CBDataSel
LInfoSeg    dd  0   ; Save spot for Local Information segment address.
SInfoSeg    dw  0   ; Save spot for System Information segment address.
CBDataSel   dw     0     ; (KIB/CPCB) Control Block Data Area
                         ;  selector (assumed 0 offset).

;*
;*             Begin
;*
Public          SQDDname,SQDDarea,SQDDrm@,SQDDrds,SQDDpm@,SQDDpds
SQDDname        db      'SINGLEQ$'      ; Single Queue Device Driver name.

SQDDarea        label   byte            ; Begin Single Queue Device Driver
                                        ; (SQDD) address save area.
SQDDrm@         dd      0               ; Real mode entry point.
SQDDrds         dw      0               ; Real mode DS segment.
SQDDpm@         dd      0               ; Protect mode entry point.
SQDDpds         dw      0               ; Protect mode DS selector.
                                        ; End SQDD address save area.

;*
;*             End
;*

Public SQHotKeyData        
SQHotKeyData  db        0
Public NumPadAccum
NumPadAccum   db        0  

;*
;* CmdFlags: Used when a command is sent to the keyboard.
;*

Public   CmdFlags
CmdFlags CFlags <>

;*
;* IntFlags: Used at interrupt time
;*

Public   IntFlags
IntFlags db ?

;*
;* OtherFlags: Misc flags (should be zeroed on a SG switch).
;*

Public     OtherFlags
OtherFlags OFlags <>

;*
;* MiscFlags: Misc flags, mostly just used once by KBDDD.
;*

Public    MiscFlags
MiscFlags MFlags <>

;*
;*
;*  MiscFlags2: More misc. flags for additional checking.
;*
;*

Public    MiscFlags2            ; Make it recognizable to others.
MiscFlags2 MFlags2 <>           ; Define the storage.

;*
;*
;*  MiscFlags3: More misc. flags for additional checking.
;*
;*

Public    MiscFlags3            ; Make it recognizable to others.
MiscFlags3  db 0                ; Define the storage.

;*
;*           
;*

Public VDMFocus, HKBypass, HKTemp, ShiftData
VDMFocus        db   0                  ; 1 vdm in focus / 0 vdm not in focus
HKBypass        dd   0
HKTemp          db   0
ShiftData       dw   0

Public BypassTbl
BypassTbl    db    00,0ah,081h     ; 01h  Alt-Esc
             db    00,05,081h      ; 02h  Ctrl-Esc
             db    00,0ah,0C7h     ; 04h  Alt-Home
             db    87 dup(0)       ; 29 entries not defined yet x 3 fields

;*
;*
;*  IDFlags: Flags for determining keyboard hardware.
;*
;*

Public    IDFlags               ; Make it recognizable to others.
IDFlags   IDFlagbits <>         ; Define the storage.


;*
;*    Lockup support code flag             
;*
Public LockupFlags
LockupFlags  db      0

;*
;*  IDC Support
;*
;*These are the entries for every handle given by the Open_KBD call.
;*The Open_KBD call is available to any DD that does an AttachDD
;*on KBDDI$. This call is function 0004h. We are allowing a maximum
;*of 5 open handles at any given time. The handle is a required parameter
;*for all other IDC functions greater then 00004h.
;*


even

IDC_CB           IDC_Entry <0,0>
                 IDC_Entry <0,0>
                 IDC_Entry <0,0>
                 IDC_Entry <0,0>
                 IDC_Entry <0,0>

Public  IDC_CB

Public  KBDDDcall, CheckKBDDD, DD_Cmd
KBDDDcall         dd      ?
DD_Cmd            dw      ?
CheckKBDDD        dw      ?

Public  IDstructure
IDstructure    IDstruc    <>

Public  Open_IDC, Close_IDC, Process_Keystroke, Process_Reinit, Pen_Functions
Open_IDC           db     00
Close_IDC          db     01
Process_Keystroke  db     02
Process_Reinit     db     03
Pen_Functions      db     04

Public  Keystroke, Keystroke2
Keystroke          db     ?
Keystroke2         db     ?

;;Public Query_Capabilities, Query_Typematic, Query_LEDs, Query_ID
;;Query_Capabilities db     02
;;Query_Typematic    db     03
;;Query_LEDs         db     04
Public Query_ID
Query_ID           db     05

;;Public Disable_Keyboard, Enable_Keyboard
;;Query_Disabled     db     06
;;Disable_Keyboard   db     07
;;Enable_Keyboard    db     08
;;Reset_Hardware     db     09

;;Public Set_Typematic, Set_LEDs, Send_Generic, Query_Kbd_Rdy
;;Set_Typematic      db     0Ah
;;Set_LEDs           db     0Bh
;;Send_Generic       db     0Eh
;;Query_Kbd_Rdy      db     0Fh

;;Public Flush_Partial, Save_State, Restore_State
;;Flush_Partial      db     10
;;Save_State         db     12
;;Restore_State      db     13

Public DD_Off, DD_Seg, DD_ds
DD_Off             dw      ?
DD_Seg             dw      ?
DD_ds              dw      ?


;*
;* PEN SUPPORT
;*
Public IntCount, CallBack, IDC_Write, PenHotKeyAE, PenHotKeyCE, PenBreakEsc
IntCount    dd      0
CallBack    db      0
IDC_Write    SINFO  <>

;*
;* The below values are used to emulate Alt+Esc and Ctrl+Esc key packet
;* sequences.  These are sent to the singleq because it must see these
;* (present architecture) to act on a Hot Key.  Simply sending a devHlp
;* sendevent of a Hot Key is not sufficient.
;*

PenHotKeyAE   dw    03800h, 00000h, 00040h, 00208h, 00000h, 00000h, 00007h
              dw    00100h, 00100h, 00042h, 00208h, 00000h, 00000h, 0003fh
              dw    08100h, 00100h, 00042h, 00208h, 00000h, 00000h, 0004ch
              dw    0b800h, 00000h, 00040h, 00000h, 00000h, 00000h, 00047h

PenHotKeyCE   dw    01d00h, 00000h, 00040h, 00104h, 00000h, 00000h, 00007h
              dw    00100h, 0011bh, 00040h, 00104h, 00000h, 00000h, 0003fh
              dw    08100h, 0011bh, 00040h, 00104h, 00000h, 00000h, 0004ch
              dw    09d00h, 00000h, 00040h, 00000h, 00000h, 00000h, 00047h

;*
;* This next set of values is to emulate a "feature/bug" of the way KBD$
;* works.  Since we must emulate it as close as possible we need to send
;* this keypacket when hotkey-ing from a NON-PM session back to PM.
;* This is what KBD$ does.  The other alternative is to fix KBD$ to not send
;* a packet like this but this could break something we're not aware of....thus:
;*

PenBreakEsc   dw    08100h, 0011bh, 00040h, 00000h, 00000h, 00000h, 0007fh


;*
;*          --- Alternate Input Methods Data Area ---
;*

Public AIMFlags,LastScan,StuckScan,StickMakes,StickBreaks,StickyTbl
Public CtrlMakes,CtrlBreaks
AIMFlags      dw          0         ; AIM Flags word for AIM state processing.
                                    ; AIM   in order to give the stuck dowm or "sticky" affect.
StickMakes    dw          0         ; AIM # of Shift key Makes before a modifier
StickBreaks   dw          0         ; AIM # of Shift key Breaks before a modifier
CtrlMakes     dw          0         ; AIM # of Shift key Makes before a modifier
CtrlBreaks    dw          0         ; AIM # of Shift key Breaks before a modifier
LastScan      db          0         ; AIM This is the last scan code seen by the PKBD
StuckScan     db          0         ; AIM This is the break key that will be thrown away

StickyTbl     db  MaxStickyKeys dup(0)  ;AIM Table of currently defined Sticky keys


Public AIMTimeOut,AIMAccept,AIMRate,AIMDelay
AIMTimeOut      dw      0           ; AIM Time out value given by IOCtl caller
AIMAccept       dd      0           ; AIM Acceptance value given by IOCtl caller
AIMRate         dd      0           ; AIM Rate value given by IOCtl caller
AIMDelay        dd      0           ; AIM Delay value given by IOCtl caller


;*
;* FilterFlags: Used for AIM
;*

Public    FilterFlags
FilterFlags  db  TYP_DELAY or TYP_REP

;*
;* AIM   Filter Key Control Variables
;*

Public    Acc_Ctrl,Typematic_Ctrl,Delay_Ctrl,Filter_Ctrl
Acc_Ctrl             dw  0          ;AIM Accepatnce Rate Delta Interrupt Count
Typematic_Ctrl       dw  0          ;AIM Typematic Rate Delta Interrupt Count
Delay_Ctrl           dw  0          ;AIM Typematic Delay Delta Interrupt Count
Filter_Ctrl          db  0          ;AIM Shift Key Interrupt Count

Public    Comp_Acc_Ctrl,Comp_Typematic_Ctrl,Comp_Delay_Ctrl,Comp_AIMTimeout
Comp_Acc_Ctrl        dw  0          ;AIM Computed Acceptance Delta
Comp_Typematic_Ctrl  dw  0          ;AIM Computed Typematic Rate Delta
Comp_Delay_Ctrl      dw  0          ;AIM Computed Typematic Delay Delta
Comp_AIMTimeout      dw  0          ;AIM Computed Timeout value

Public    Comp_Rep_Count,Tick_Per_Sec
Comp_Rep_Count       dw  0          ;AIM Computed Repeat count
Tick_Per_Sec         dw  18         ;AIM System Tick / 1 second

;*
;* AIM   Filter Key Support Misc Variables
;*

Public    Beep_State,Bp_Count,Rep_Count,Shift_Count
Beep_State           db  0          ;AIM Beep State
Bp_Count             db  0          ;AIM Bypass Count
Shift_Count          db  0          ;AIM Counter for Shift Key Interrupt
Rep_Count            dw  0          ;AIM General Counter for Interrupt

Public    PrevKey,LastKey,FinalKey,ShiftKey
PrevKey              db  0          ;AIM
LastKey              db  0          ;AIM
FinalKey             db  0          ;AIM
ShiftKey             db  0          ;AIM

Public    Hw_Typa_Rate,Hw_Typa_Delay,Em_Typa_Rate,Em_Typa_Delay,Hw_Typa_Time
Hw_Typa_Rate         dw  0          ;AIM Hardware Typa Rate
Hw_Typa_Delay        dw  0          ;AIM Hardware Typa Delay
Em_Typa_Rate         dw  0          ;AIM Emulated Typa Rate
Em_Typa_Delay        dw  0          ;AIM Emulated Typa Delay
Hw_Typa_Time         dw  0          ;AIM Hardware Typa Time

;*
;*    Mouse Data used by AIM
;*
Public MSEDDname,MSEDDrm@,MSEDDrds,MSEDDpm@,MSEDDpds
Public MSEStickyHdl, MSEFilterHdl, MSEFilterStatus, MSEStickyStatus

MSEDDname        db 'MOUSE$  ',0      ; Mouse Device Driver name

even
MSEDDrm@         dd    0              ; Real mode entry point.
MSEDDrds         dw    0              ; Real mode DS segment.
MSEDDpm@         dd    0              ; Protect mode entry point.
MSEDDpds         dw    0              ; Protect mode DS selector.

MSEFilterHdl     dw    0              ;AIM  Returned from Open_Mouse (Filter keys)
MSEStickyHdl     dw    0              ;AIM  Returned from Open_Mouse (Sticky keys)
MSEFilterStatus  dw    0              ;AIM  Mouse activity Status
MSEStickyStatus  dw    0              ;AIM  Mouse activity Status

;*
;*    Lock down code handles
;*
Public LockHandle
LockHandle   db      lhlen   dup(0)

;*
;* Rate parm values to use in Set Typamatic IOCtl call.
;*

Public  TypaRates

;*
;* Rate:        0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 cps
;*
TypaRates db 00,31,31,26,23,20,18,17,15,13,12,11,10,09,09

;*
;* Rate:       15 16 17 18 19 20 21 22 23 24 25 26 27 cps
;*
          db 08,07,06,05,04,04,03,03,02,02,01,01,01 ; >27 use 0.

;*
;*            
;*  Extended Extended table for mapping xlated scan code to original scan code.
;*  This is used by IOCtl 79h.
;*

Public ExTable
ExTable Label Byte

;*
;*   Original    ;Translated
;*   Scan        ;Scan
;*   --------    -----------
db   057h        ;85           ;F11
db   058h        ;86           ;F12
db   057h        ;87           ;F11
db   058h        ;88           ;F12
db   057h        ;89           ;F11
db   058h        ;8A           ;F12
db   057h        ;8B           ;F11
db   058h        ;8C           ;F12

Public ExExTable
ExExTable  Label Byte

;*
;*   Original    ;Translated
;*   Scan        ;Scan
;*
;*   --------    -----------
db   06Bh        ;C0           ;F24
db   05Bh        ;C1           ;Shift F13
db   07Fh        ;C2           ;UNUSED ***** UNDEFINED
db   05Ch        ;C3           ;Shift F14
db   05Dh        ;C4           ;Shift F15
db   063h        ;C5           ;Shift F16
db   064h        ;C6           ;Shift F17
db   065h        ;C7           ;Shift F18
db   066h        ;C8           ;Shift F19
db   067h        ;C9           ;Shift F20
db   068h        ;CA           ;Shift F21
db   069h        ;CB           ;Shift F22
db   06Ah        ;CC           ;Shift F23
db   06Bh        ;CD           ;Shift F24
db   05Bh        ;CE           ;Ctrl F13
db   05Ch        ;CF           ;Ctrl F14
db   05Dh        ;D0           ;Ctrl F15
db   063h        ;D1           ;Ctrl F16
db   064h        ;D2           ;Ctrl F17
db   065h        ;D3           ;Ctrl F18
db   066h        ;D4           ;Ctrl F19
db   067h        ;D5           ;Ctrl F20
db   068h        ;D6           ;Ctrl F21
db   069h        ;D7           ;Ctrl F22
db   06Ah        ;D8           ;Ctrl F23
db   06Bh        ;D9           ;Ctrl F24
db   05Bh        ;DA           ;Alt F13
db   05Ch        ;DB           ;Alt F14
db   05Dh        ;DC           ;Alt F15
db   063h        ;DD           ;Alt F16
db   064h        ;DE           ;Alt F17
db   065h        ;DF           ;Alt F18
db   07Fh        ;E0           ;UNUSED ****** UNDEFINED
db   07Fh        ;E1           ;UNUSED ****** UNDEFINED
db   066h        ;E2           ;Alt F19
db   067h        ;E3           ;Alt F20
db   068h        ;E4           ;Alt F21
db   069h        ;E5           ;Alt F22
db   06Ah        ;E6           ;Alt F23
db   06Bh        ;E7           ;Alt F24
db   05Ah        ;E8           ;PA1
db   05Ah        ;E9           ;Shift PA1
db   05Ah        ;EA           ;Ctrl PA1
db   05Ah        ;EB           ;Alt PA1
db   05Bh        ;EC           ;F13
db   05Ch        ;ED           ;F14
db   05Dh        ;EE           ;F15
db   063h        ;EF           ;F16
db   06Dh        ;F0           ;EraseEOF
db   06Dh        ;F1           ;Shift EraseEOF
db   06Dh        ;F2           ;Ctrl EraseEOF
db   06Dh        ;F3           ;Alt EraseEOF
db   064h        ;F4           ;F17
db   065h        ;F5           ;F18
db   066h        ;F6           ;F19
db   067h        ;F7           ;F20
db   068h        ;F8           ;F21
db   069h        ;F9           ;F22
db   06Ah        ;FA           ;F23
db   076h        ;FB           ;Shift clear or clear
db   076h        ;FC           ;Ctrl clear
db   076h        ;FD           ;Alt clear


;*
;*  TRANSLATION PROCESS SHARED DATA.
;*  The following data is pointed to by DS:SI when the translation
;*  routines are called. It is also used by other parts of KBDDD.
;*
;*  Key Packets for use in the translation process. The first is always
;*  used to pass the current scan-code and its translation on from the
;*  translation process. The second is used when the translation process
;*  needs to pass two characters (e.g., when it must pass an accent char
;*  followed by another char).
;*
Public KeyPacket1,KeyPacket2,SQComp,NotifyPct   ; Add packet declaration for
                                                ; SQ update comparisons.
                                                ; Add Read or Peek Packet.
Public XDRPacket, XDRMonFlags, XDRCharData, XDRFlagArea
Public MLNotifyPct                              ;           
KeyPacket1  KPacket <>   ; This is the packet we use normally.
KeyPacket2  KPacket <>   ; This is the spare one.
SQComp      KPacket <>   ; Packet used to compare previous SQ packet
                         ; with current
NotifyPct   NPacket <>   ; This is the Read or Peek Notification Packet.
MLNotifyPct MLPacket<>   ;            This is a Multi-Layer NLS Notification Pct.

        EVEN             ; Ensure following starts on word boundary.

;*
;*  The area contains the flag states to be used by the KbdXlate
;*  routine when translation is required at interrupt time.
;*

Public IntFlagArea
IntFlagArea     db KBXTFlagsSIZE Dup (0) ;@@ For interrupt handling.

;*
;*  The following area is equivalent to the KeyPacket, but is used at
;*  Strategy time (for the Translate Scan Code IOCTL, 79h).
;*  NOTE that the structure of XDRPacket through XDRDDFlags
;*  (inclusive) is identical to the KPacket structure, while the
;*  XDRFlagArea is identical to the IntFlagArea above (see the XlateVars
;*  structure in KBDDDR.INC).
;*
Public XDRPacket,XDRCharData,XDRDDflags,XDRFlagArea,XDRSIZE
XDRPacket       Label Word              ; Area to be used by KbdXlate
                                        ;  for translation at Strategy
                                        ;  time.
XDRMonFlags     dw 0                    ; "MonFlags"-like area.
XDRCharData     db ChDaRecLen Dup (0)   ; Character Data Record part
                                        ;  of the Xlate Data Record.
XDRDDFlags      dw 0                    ; DDFlags word for strategy
                                        ;  time translation.
XDRFlagArea     db KBXTFlagsSIZE Dup (0); Translation state variables
                                        ;  part of Xlate Data Record.
XDRSIZE         Equ ($-XDRCharData) - 4 ; Byte count for copying
                                        ; caller's data buffer to/fro
                                        ;  ( -4 because Alt-xxx
                                        ;  accumulator byte,
                                        ;  PSGFlags high byte, and
                                        ;  XHotKeyShift word
                                        ;  in XDRFlagArea are NOT copied).

;***** END OF TRANSLATION PROCESS SHARED DATA **********************

;*
;*  TRANSLATION PROCESS UNSHARED DATA.
;*  The following data is only used by the translation process, and
;*  may be deleted from here if the translation process is replaced.
;*
;*  Translation for keypresses on PadKeys with Ctl or Alt pressed.
;*  These translations are constant despite the XlateTable in use.
;*  The index into these tables is the Char1 value in the XlateTable,
;*  which is REQUIRED to be an offset into these tables.
;*

Public AltPadMap
AltPadMap  Label Byte
        db       7,8,9,-1
        db       4,5,6,-1
        db       1,2,3
        db       0,-1

Public CtlPadMap
CtlPadMap  Label Byte
        db       119,141,132,142  ; Keypad 7, 8, 9, -                
        db       115,143,116,144  ; Keypad 4, 5, 6, +                
        db       117,145,118      ; Keypad 1, 2, 3                   
        db       146,147          ; Keypad 0, .                      

;*
;*  Translation for keypresses on AlphaKeys with Alt pressed. This
;*  translation is ALWAYS indexed by the Char1 value less 96 (which
;*  is ascii "a").  The translation value is the scan code that
;*  would come in on a regular PC keyboard (or PC/AT keyboard in
;*  compatability mode).
;*

Public AltTable
AltTable  Label  Byte

;*               a, b, c, d, e, f, g, h, i, j, k, l, m
        db      30,48,46,32,18,33,34,35,23,36,37,38,50 ; 
;*               n, o, p, q, r, s, t, u, v, w, x, y, z
        db      49,24,25,16,19,31,20,22,47,17,45,21,44 ; 


;*
;*             BEGIN
;*  Following is a partial table of new extended scan codes, used by KbdInt
;*  routines to search when an extended ASCII character is seen on a standard
;*  read/peek.  Other extended characters are determined algorithmically.
;*

Public          NewExtSC,NewExtSCLen
NewExtSC        LABEL BYTE

;*
;*            ALT+
;*                 [  ]    ;   '   `   \   ,   .   /  Tab
;*
                db  1Ah,1Bh,27h,28h,29h,2Bh,33h,34h,35h,0Fh

NewExtSCLen     equ $-NewExtSC                  ;@@ Used by interrupt handler.

;*
;*            ALT+
;*                Esc  BackSp  Return  Keypad*  Keypad-  Keypad5  Keypad+
;*
                db  01 ,  0Eh,    1Ch,     37h,     4Ah,     4Ch,     4Eh

;*
;*            END
;*


;*
;*  KeyHistory: last five non-repeated key-Makes seen by the translation
;*  process, along with the SG number active when they were seen. If a
;*  key-Break is seen that is for the same key as one of these (starting
;*  with the first), and the KeyHistory entry is from a different SG,
;*  then KbdXlate will assume that that keystroke was made in that other
;*  SG. It will then arrange to have the keystroke processed by that
;*  other SG.
;*
Public KeyHistory       ; 
KeyHistory dw 0,0,0,0,0 ;Last five non-repeated keymakes & their SG.

Public KeyHistBuf,SCCount,ScanBlockId  ;           
KeyHistBuf db 0,0,0,0,0,0,0,0,0,0 ;            Last 10 non-repeated makes
SCCount     db  0                 ;            Count of scan codes in KHBuffer
ScanBlockId dw  0,0               ;            Block ID Location for
                                  ; possible IOCTL 55h ProcBlock
Public KcbBlockId                 ;           
KcbBlockId  dw  0,0               ;            Block ID location for


;***** END OF TRANSLATION PROCESS UNSHARED DATA ********************

;
;*  The following table is an entry bit mask for indicating which
;*  screen groups (session numbers) are created.  Therefore the PKBD DD
;*  supports "MaxSessions" at this time.  For VDM sessions (SG numbers
;*  above 15) the corresponding bit in the SGCreatedTbl will be turned
;*  on when the PKBD receives a VDMCreated call for a VDM session.  For
;*  FS sessions (0-15) corresponding bit will be turned on when memory
;*  for the FS's PSG is allocated.
;*
;*           

Public SGCreatedTbl
SGCreatedTbl  Label  Byte
        dw    16  dup (0)

;*
;*  Pointers to the PSG data areas will start here.  The pointer table
;*  and its attendant PSG data areas (determined dynamically by the
;*  DD INIT routine) follow.
;*     (SG = 1.0 Screen Group = 1.1 Session):
;*

            EVEN                ; Ensure we're on a word boundary.
Public      PSGPointers
PSGPointers Label  Word         ; Beginning of PSG Pointer table.

;*
;*  This ends the definition of the STATIC portion of the KBD DD data
;*  segment. The remainder of the data segment is laid out as follows:
;*
;*    PSG Pointers      (Memory = MaxSG * word, Offset = PSGPointers)
;*    PSG Data Areas    (Memory = MaxSG * PSGSize,
;*                       Offset = [PSGPointers])
;*
;*  The memory is determined and the offsets are calculated in the
;*  DD INIT routine (KbdInit, in KBDDD.ASM).
;*
;*  So allocate memory for the rest of the segment, make it:
;*
;*   (Nominal MAX SG value * (PSGSize + size of each PSGPointer word))
;*
;*  NOTE:  The nominal max SG value must not be SMALLER than the
;*  actual system value (currently 16)...
;*
;*  This done at P. Smith's request in order to have a smaller initial
;*  data segment size.  Reducing from an approx. 64k initial size is
;*  not practical.
;*

PadBytes db     32*(SizePSG+2) dup(?)   ; Filler array.

;*
;*
;*       Keyboard Device Driver Scan Code Translate Table
;*
;* NOTE: The length of the translate table must be in KBDDD.INC. It
;*       is set at label XTLen in that file. Be sure to update that
;*       if any size change is made to the table below!
;*

;*
;*          HERE IS THE BEGINNING OF THE TRANSLATION TABLE.
;*

  Even                            ;Put the table on a word boundary.

Public XlateTable

XlateTable Label Byte             ;Beginning of the table, (can be overlayed).

;*
;* form of XtHeader "XtHeader cp,a,b,c,d,e,f,g,h,i,j,k,kb,l,cc,cs"
;* where cp is the code page, a,b,c,d,e,f,g,h,i are the flags:
;*

;* a - ShiftAlt (use shift-alt for Char 3)
;* b - AltGrafL (use left alt key for Char 3)
;* c - AltGrafR (use right alt key for Char 3)
;* d - ShiftLock (all core keys are shifted when Capslock active)
;* e - DefaultCP (default code page for country)
;* f - ShiftToggle (ShiftLock is toggle operated, not latched)
;* g - AccentPass (invalid dead key/char combination outputs both and beeps)
;* h - CapsShift (use Char 5 for Caps-Shift combination)
;* i - MultiLayout (indicates multiple layouts/tables for country)
;* j - MultiLayered (double layered code page)
;* k - TableLayer2 (secondary layer Xlation table of a Multi-Layer CP)
;* m - DefaultLayout (indicates the default layout for multi-layout countries)
;* kb is the keyboard type, l is the length of the table in bytes,
;* cc is the country layout ID, and cs is the subcountry layout ID

;*
;*        cp  a b c d e f g h i j k m kb  l    cc    cs
;*         |  | | | | | | | | | | | |  |  |    |     |
XtHeader  437,0,0,0,0,1,0,0,0,0,0,0,0,AT,Len1,'US','103'

;*
;*  Form of XlateTable KeyDefs: "KeyDef f,g1,g2,g3,g4,g5,g6,g7,a,b,c,d,e
;*  where a,b,c,d,e are Char1 - Char5, f is the Action number to
;*  apply in translating this key, and g1-7 are 1 or 0 flags if
;*  accents 1 - 7 apply to the key.
;*

;*
;*       +--Key Type number.   +---Chars-+----+----+    Scan    Legend
;*       |  +AccentFlags+      1    2    3    4    5    Code      |
;*       |  | | | | | | |      |    |    |    |    |      |       |
 KeyDef  8, 0,0,0,0,0,0,0,    27,  27,   0,   0,   0    ; 1      ESC
 KeyDef  4, 0,0,0,0,0,0,0,   '1', '!',   0,   0,   0    ; 2      1 !
 KeyDef  4, 0,0,0,0,0,0,0,   '2', '@',   0,   0,   0    ; 3      2 @
 KeyDef  4, 0,0,0,0,0,0,0,   '3', '#',   0,   0,   0    ; 4      3 #
 KeyDef  4, 0,0,0,0,0,0,0,   '4', '$',   0,   0,   0    ; 5      4 $
 KeyDef  4, 0,0,0,0,0,0,0,   '5', '%',   0,   0,   0    ; 6      5 %
 KeyDef  4, 0,0,0,0,0,0,0,   '6', '^',   0,   0,   0    ; 7      6 ^
 KeyDef  4, 0,0,0,0,0,0,0,   '7', '&',   0,   0,   0    ; 8      7 &
 KeyDef  4, 0,0,0,0,0,0,0,   '8', '*',   0,   0,   0    ; 9      8 *
 KeyDef  4, 0,0,0,0,0,0,0,   '9', '(',   0,   0,   0    ; 10     9 (
 KeyDef  4, 0,0,0,0,0,0,0,   '0', ')',   0,   0,   0    ; 11     0 )
 KeyDef  4, 0,0,0,0,0,0,0,   '-', '_',   0,   0,   0    ; 12     - _
 KeyDef  4, 0,0,0,0,0,0,0,   '=', '+',   0,   0,   0    ; 13     = +
 KeyDef  8, 0,0,0,0,0,0,0,     8, 127,   0,   0,   0    ; 14    BkSp
 KeyDef  4, 0,0,0,0,0,0,0,     9,   0,   0,   0,   0    ; 15    Tabs
 KeyDef  1, 0,0,0,0,0,0,0,   'q', 'Q',   0,   0,   0    ; 16     q Q
 KeyDef  1, 0,0,0,0,0,0,0,   'w', 'W',   0,   0,   0    ; 17     w W
 KeyDef  1, 0,0,0,0,0,0,0,   'e', 'E',   0,   0,   0    ; 18     e E
 KeyDef  1, 0,0,0,0,0,0,0,   'r', 'R',   0,   0,   0    ; 19     r R
 KeyDef  1, 0,0,0,0,0,0,0,   't', 'T',   0,   0,   0    ; 20     t T
 KeyDef  1, 0,0,0,0,0,0,0,   'y', 'Y',   0,   0,   0    ; 21     y Y
 KeyDef  1, 0,0,0,0,0,0,0,   'u', 'U',   0,   0,   0    ; 22     u U
 KeyDef  1, 0,0,0,0,0,0,0,   'i', 'I',   0,   0,   0    ; 23     i I
 KeyDef  1, 0,0,0,0,0,0,0,   'o', 'O',   0,   0,   0    ; 24     o O
 KeyDef  1, 0,0,0,0,0,0,0,   'p', 'P',   0,   0,   0    ; 25     p P
 KeyDef  4, 0,0,0,0,0,0,0,   '[', '{',   0,   0,   0    ; 26     [ {
 KeyDef  4, 0,0,0,0,0,0,0,   ']', '}',   0,   0,   0    ; 27     ] }
 KeyDef  8, 0,0,0,0,0,0,0,    13,  10,   0,   0,   0    ; 28    Enter
 KeyDef 12, 0,0,0,0,0,0,0,     4,   1,   4,   0,   0    ; 29    Ctrl
 KeyDef  1, 0,0,0,0,0,0,0,   'a', 'A',   0,   0,   0    ; 30     a A
 KeyDef  1, 0,0,0,0,0,0,0,   's', 'S',   0,   0,   0    ; 31     s S
 KeyDef  1, 0,0,0,0,0,0,0,   'd', 'D',   0,   0,   0    ; 32     d D
 KeyDef  1, 0,0,0,0,0,0,0,   'f', 'F',   0,   0,   0    ; 33     f F
 KeyDef  1, 0,0,0,0,0,0,0,   'g', 'G',   0,   0,   0    ; 34     g G
 KeyDef  1, 0,0,0,0,0,0,0,   'h', 'H',   0,   0,   0    ; 35     h H
 KeyDef  1, 0,0,0,0,0,0,0,   'j', 'J',   0,   0,   0    ; 36     j J
 KeyDef  1, 0,0,0,0,0,0,0,   'k', 'K',   0,   0,   0    ; 37     k K
 KeyDef  1, 0,0,0,0,0,0,0,   'l', 'L',   0,   0,   0    ; 38     l L
 KeyDef  4, 0,0,0,0,0,0,0,   ';', ':',   0,   0,   0    ; 39     ; :
 KeyDef  4, 0,0,0,0,0,0,0,   "'", '"',   0,   0,   0    ; 40     ' "
 KeyDef  4, 0,0,0,0,0,0,0,   '`', '~',   0,   0,   0    ; 41     ` ~
 KeyDef 12, 0,0,0,0,0,0,0,     2,   0,   0,   0,   0    ; 42   Shift(L)
 KeyDef  4, 0,0,0,0,0,0,0,   '\', '|',   0,   0,   0    ; 43     \ |
 KeyDef  1, 0,0,0,0,0,0,0,   'z', 'Z',   0,   0,   0    ; 44     z Z
 KeyDef  1, 0,0,0,0,0,0,0,   'x', 'X',   0,   0,   0    ; 45     x X
 KeyDef  1, 0,0,0,0,0,0,0,   'c', 'C',   0,   0,   0    ; 46     c C
 KeyDef  1, 0,0,0,0,0,0,0,   'v', 'V',   0,   0,   0    ; 47     v V
 KeyDef  1, 0,0,0,0,0,0,0,   'b', 'B',   0,   0,   0    ; 48     b B
 KeyDef  1, 0,0,0,0,0,0,0,   'n', 'N',   0,   0,   0    ; 49     n N
 KeyDef  1, 0,0,0,0,0,0,0,   'm', 'M',   0,   0,   0    ; 50     m M
 KeyDef  4, 0,0,0,0,0,0,0,   ',', '<',   0,   0,   0    ; 51     , <
 KeyDef  4, 0,0,0,0,0,0,0,   '.', '>',   0,   0,   0    ; 52     . >
 KeyDef  4, 0,0,0,0,0,0,0,   '/', '?',   0,   0,   0    ; 53     / ?
 KeyDef 12, 0,0,0,0,0,0,0,     1,   0,   0,   0,   0    ; 54   Shift(R)
 KeyDef  9, 0,0,0,0,0,0,0,   '*', 114,   0,   0,   0    ; 55     * PrtSc
 KeyDef 14, 0,0,0,0,0,0,0,     8,   2,   8,   0,   0    ; 56     Alt
 KeyDef  4, 0,0,0,0,0,0,0,   ' ', ' ',   0,   0,   0    ; 57    Space
 KeyDef 16, 0,0,0,0,0,0,0,   40h, 40h, 40h,   0,   0    ; 58   CapsLock
 KeyDef  6, 0,0,0,0,0,0,0,     1,   0,   0,   0,   0    ; 59     F1
 KeyDef  6, 0,0,0,0,0,0,0,     2,   0,   0,   0,   0    ; 60     F2
 KeyDef  6, 0,0,0,0,0,0,0,     3,   0,   0,   0,   0    ; 61     F3
 KeyDef  6, 0,0,0,0,0,0,0,     4,   0,   0,   0,   0    ; 62     F4
 KeyDef  6, 0,0,0,0,0,0,0,     5,   0,   0,   0,   0    ; 63     F5
 KeyDef  6, 0,0,0,0,0,0,0,     6,   0,   0,   0,   0    ; 64     F6
 KeyDef  6, 0,0,0,0,0,0,0,     7,   0,   0,   0,   0    ; 65     F7
 KeyDef  6, 0,0,0,0,0,0,0,     8,   0,   0,   0,   0    ; 66     F8
 KeyDef  6, 0,0,0,0,0,0,0,     9,   0,   0,   0,   0    ; 67     F9
 KeyDef  6, 0,0,0,0,0,0,0,    10,   0,   0,   0,   0    ; 68     F10
 KeyDef 15, 0,0,0,0,0,0,0,   20h, 20h, 20h,   0,   0    ; 69    NumLock
 KeyDef 17, 0,0,0,0,0,0,0,   10h, 10h, 10h,   0,   0    ; 70  ScrollLock
 KeyDef  7, 0,0,0,0,0,0,0,     0, '7',   0,   0,   0    ; 71  Home 7
 KeyDef  7, 0,0,0,0,0,0,0,     1, '8',   0,   0,   0    ; 72  'Up' 8
 KeyDef  7, 0,0,0,0,0,0,0,     2, '9',   0,   0,   0    ; 73  PgUp 9
 KeyDef  7, 0,0,0,0,0,0,0,     3, '-',   0,   0,   0    ; 74   - (on pad)
 KeyDef  7, 0,0,0,0,0,0,0,     4, '4',   0,   0,   0    ; 75 'Left'4
 KeyDef  7, 0,0,0,0,0,0,0,     5, '5',   0,   0,   0    ; 76      5
 KeyDef  7, 0,0,0,0,0,0,0,     6, '6',   0,   0,   0    ; 77'Right'6
 KeyDef  7, 0,0,0,0,0,0,0,     7, '+',   0,   0,   0    ; 78   + (on pad)
 KeyDef  7, 0,0,0,0,0,0,0,     8, '1',   0,   0,   0    ; 79   End 1
 KeyDef  7, 0,0,0,0,0,0,0,     9, '2',   0,   0,   0    ; 80 'Down'2
 KeyDef  7, 0,0,0,0,0,0,0,    10, '3',   0,   0,   0    ; 81  PgDn 3
 KeyDef  7, 0,0,0,0,0,0,0,    11, '0',   0,   0,   0    ; 82   Ins 0
 KeyDef  7, 0,0,0,0,0,0,0,    12, '.',   0,   0,   0    ; 83   Del .
 KeyDef 10, 0,0,0,0,0,0,0,     0, 80h, 80h,   0,   0    ; 84   SysReq
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 85  (undefined)
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 86      '
 KeyDef  6, 0,0,0,0,0,0,0,    11,   0,   0,   0,   0    ; 87     F11
 KeyDef  6, 0,0,0,0,0,0,0,    12,   0,   0,   0,   0    ; 88     F12
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 89  (undefined)
 KeyDef 26, 0,0,0,0,0,0,0,  0E8h,0E9h,   0,0EAh,0EBh    ; 90   PA1   (Jaguar)
 KeyDef 26, 0,0,0,0,0,0,0,  0ECh,0C1h,   0,0CEh,0DAh    ; 91   F13   (Jaguar)
 KeyDef 26, 0,0,0,0,0,0,0,  0EDh,0C3h,   0,0CFh,0DBh    ; 92   F14   (Jaguar)
 KeyDef 26, 0,0,0,0,0,0,0,  0EEh,0C4h,   0,0D0h,0DCh    ; 93   F15   (Jaguar)
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 94  (undefined)
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 95      '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 96      '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 97      '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 98      '
 KeyDef 26, 0,0,0,0,0,0,0,  0EFh,0C5h,   0,0D1h,0DDh    ; 99   F16   (Jaguar)
 KeyDef 26, 0,0,0,0,0,0,0,  0F4h,0C6h,   0,0D2h,0DEh    ; 100  F17   (Jaguar)
 KeyDef 26, 0,0,0,0,0,0,0,  0F5h,0C7h,   0,0D3h,0DFh    ; 101  F18   (Jaguar)
 KeyDef 26, 0,0,0,0,0,0,0,  0F6h,0C8h,   0,0D4h,0E2h    ; 102  F19   (Jaguar)
 KeyDef 26, 0,0,0,0,0,0,0,  0F7h,0C9h,   0,0D5h,0E3h    ; 103  F20   (Jaguar)
 KeyDef 26, 0,0,0,0,0,0,0,  0F8h,0CAh,   0,0D6h,0E4h    ; 104  F21   (Jaguar)
 KeyDef 26, 0,0,0,0,0,0,0,  0F9h,0CBh,   0,0D7h,0E5h    ; 105  F22   (Jaguar)
 KeyDef 26, 0,0,0,0,0,0,0,  0FAh,0CCh,   0,0D8h,0E6h    ; 106  F23   (Jaguar)
 KeyDef 26, 0,0,0,0,0,0,0,  0C0h,0CDh,   0,0D9h,0E7h    ; 107  F24   (Jaguar)
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 108 (undefined)
 KeyDef 26, 0,0,0,0,0,0,0,  0F0h,0F1h,   0,0F2h,0F3h    ; 109  ErEOF (Jaguar)
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 110     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 111     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 112     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 113     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 114     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 115     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 116     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 117     '
 KeyDef 26, 0,0,0,0,0,0,0,  0FBh,0FBh,   0,0FCh,0FDh    ; 118  CLEAR (Jaguar)
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 119     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 120     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 121     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 122     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 123     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 124     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 125     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 126     '
 KeyDef  0, 0,0,0,0,0,0,0,     0,   0,   0,   0,   0    ; 127     '

;*
;* Form of AccEnt's below is:
;* "AccentEntry <a,b,c,d,e,f,c1,s1,c2,s2..c20,s20>"
;* where a & b are the scan code & char to use when the key following this accent
;* isn't affected by the accent so the accent itself must be used,
;* c & d are the scan code & char to use when Ctl-[accent] is pressed,
;* and e & f do the same for Alt-[accent]. c1,s1 - c20,s20 are the char/scan code
;* mapping for accented translation.
;*

;*
;* Accent key definitions and mappings.
;*

AccEnt <>
AccEnt <>
AccEnt <>
AccEnt <>
AccEnt <>
AccEnt <>
AccEnt <>

Len1    EQU  $ - XlateTable

Even                        ;Make sure we're an even number of bytes.


;*
;**** END OF THE TRANSLATION TABLE **********************************
;*

KbdData Ends

  End
