;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/

;/*****************************************************************************
;*
;* SOURCE FILE NAME = KBDAIM.INC
;*
;* DESCRIPTIVE NAME = Keyboard Device Driver Common Structures and Equates 
;*                    For Alternate Input Method.
;*
;*
;* VERSION      V2.0
;*
;* DATE         15/01/92
;*
;* DESCRIPTION  This file defines various equates,structures used by PKBD
;*              for the processing of AIM functions.
;*
;* FUNCTIONS    NONE
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*****************************************************************************/

;**************************************************************************
;* AIMFlags - Bit definitions for AIM Processing Flags                    *
;**************************************************************************

    StickNextScan       equ 0001h        ;AIM
    EatNextBreak        equ 0002h        ;AIM
    ConsumeScan         equ 0004h        ;AIM
    AddStickyKey        equ 0008h        ;AIM
    DelStickyKey        equ 0010h        ;AIM
    StickyBeep          equ 0020h        ;AIM
    AIMActive           equ 0040h        ;AIM
    UnStickAll          equ 0080h        ;AIM
    NonAIMScan          equ 0100h        ;AIM
    FirstAimReq         equ 0200h        ;AIM
    MouseIDC            equ 0400h        ;AIM
    DupModKey           equ 0800h        ;AIM
    AIMLocked           equ 1000h        ;AIM
    DeleteAllBeep       equ 2000h        ;AIM
    TYPACONTROL_CALLING equ 4000h        ;AIM
    ;xxxxxxx            equ 8000h        ;AIM

;**************************************************************************
;* Various  - definitions for AIM Processing                              *
;**************************************************************************
NumForModifer equ 3            ;AIM  # shifts needed before defining modifier
NumForUnStick equ 3            ;AIM  # shifts needed before defining modifier
NumForReset   equ 5            ;AIM  # shifts needed before defining modifier
MouseButton   equ 0FFFEh       ;AIM  Equate for MouseStatus word, Button hit.
MaxStickyKeys equ 9            ;AIM  Current Max number of sticky keys allowed
Empty         equ 0            ;AIM
StkyEntrySize equ 2
ExtdFld       equ 1
TimedBeep     equ 3
AddFreq       equ 2000
KeyDuration   equ 50
NormDuration  equ 500
FullFreq      equ 200
FullDuration  equ 100
DelFreq       equ 1000
KeyFreq       equ 3500
FilterQuery   equ 0
StickyQuery   equ 1
FilterAttach  equ 0
StickyAttach  equ 1

AIM_ActiveMask equ 0FFFEh
AIM_TimeOutMax equ 1800
AIM_AcceptMax  equ 10000
AIM_RateMax    equ 10000
AIM_DelayMax   equ 10000

AIM_ActiveErr  equ 0001h
AIM_TimeoutErr equ 0002h
AIM_AcceptErr  equ 0004h
AIM_RateErr    equ 0008h
AIM_DelayErr   equ 0010h


;*** Beep_State equates ***

FINAL_BEEP    equ 0            ; No further beeping will be allowed
ENABLE_TEST   equ 1            ; Test if enabling Filter Key can be done
DISABLE_BEEP  equ 2            ; Beeping is forbidden
COMEBACK_BEEP equ 3            ; Beeping bounced back from other beep routine
ENABLE_BEEP   equ 4            ; Beeping is allowed

IMMEDIATE_TICK    equ   00001h ;AIM  Timer Tick equates
HALF_SECOND_TICK  equ   00012h ;AIM  Timer Tick for 1/2 second
MAXIMUM_TICK      equ   0FFFFh ;AIM  Maxmum Timer Tick (about 54 minutes)

R_SHIFT       equ 036h         ; scan code for Right Shift Key
R_SHIFT_BRK   equ 0B6h         ; 
L_SHIFT       equ 02Ah         ; scan code for Left Shift Key
L_SHIFT_BRK   equ 0AAh         ; 
CTRL_MK       equ 01Dh         ; 
CTRL_BRK      equ 09Dh         ; 


lhlen         equ     12       ; lock handle length (from pgexport.inc)

FAKE_NORMAL_RATE  equ     3    ; 3 interrupt -> 1 interrupt
FAKE_NORMAL_DELAY equ     8    ; 8 interrupt -> 1 interrupt
KBD_FAST_RATE     equ    30    ; 30 characters per second
KBD_NORMAL_RATE   equ    11    ; 11 characters per second
KBD_FAST_DELAY    equ   250    ; 250 milliseconds typematic delay
KBD_NORMAL_DELAY  equ   500    ; 500 milliseconds typematic delay
KBD_TYPA_TIME     equ    33    ; 33 milliseconds per character
FIVESEC           equ  5000    ; 5 seconds in milliseconds
DELAY_DISABLED    equ  0FFFFh

;********************************************************************
;*                                                                  *
;*  Status for FilterFlags                                          *
;*                                                                  *
;********************************************************************

FILTER_ACTIVE   equ        01h        ;Filter Key is Active
TYP_ACC         equ        02h        ;Acceptance Rate is enabled
TYP_REP         equ        04h        ;Typematic Repeat is ON
TYP_DELAY       equ        08h        ;Typematic Delay is ON
TIMEOUT         equ        10h        ;Time out switch is ON
ExtKey_Mode     equ        20h        ;Extended Key Mode ON
KBD_NORMAL      equ        40h        ;NORMAL Keyboard speed
KBD_CONTROL     equ        80h        ;FAST Keyboard speed

;********************************************************************
;*                                                                  *
;*  Bit for Equipment Extention Byte                                *
;*                                                                  *
;********************************************************************
FAST_SPEED      equ        10h        ; Fast Keyboard Speed

;********************************************************************
;*                                                                  *
;*   AIM STRUCTURE                                                  *
;*                                                                  *
;********************************************************************

AIM Struc                                ;AIM This is used for picking
 AIM_Errors     dd  0                    ;AIM the parms out of the call
 AIM_Active     dw  0                    ;AIM data field.  Call data field
 AIM_Timeout    dw  0                    ;AIM begins at offset 4 from the
 AIM_FKAccept   dd  0                    ;AIM Parm Packet ES:SI address.
 AIM_FKRate     dd  0                    ;AIM
 AIM_FKDelay    dd  0                    ;AIM
AIM Ends                                 ;AIM
                                         ;AIM STRUCTURE

;********************************************************************
;*                                                                  *
;*   Figure out the typematic rate and delay - Used By Initilization*
;*                                                                  *
;*    NORMAL :  10.9 chars/sec and 500 milliseconds delay           *
;*    FAST   :  30.0 chars/sec and 250 milliseconds delay           *
;*                     ;AIM       to determine whether the keyboard *
;*                     ;AIM  speed is NORMAL or FAST.               *
;********************************************************************

Include iodelay.inc               ;DevIODelay macro replaced IODELAY

Get_KBD_Speed   Macro
       cli
       xor     dx,dx
       mov     dl,70h             ;Magical mistery way to get keyboard speed
       mov     al,13h
       out     dx,al
       DevIODelay                 
       inc     dl
       in      al,dx              ; Get Equipment Extension Byte from port 71h
       sti
       Test    al,FAST_SPEED      ;AIM If bit 4 is off, then NORMAL
 .IF <z>                          ;AIM else FAST
     Or   FilterFlags,KBD_NORMAL  ;AIM      to put set number for NORMAL speed
     Mov  Hw_Typa_Rate,KBD_NORMAL_RATE
     Mov  Hw_Typa_Delay,KBD_NORMAL_DELAY
     Mov  Em_Typa_Rate,KBD_NORMAL_RATE
     Mov  Em_Typa_Delay,KBD_NORMAL_DELAY
 .Else
     Mov  Hw_Typa_Rate,KBD_FAST_RATE
     Mov  Hw_Typa_Delay,KBD_FAST_DELAY
     Mov  Em_Typa_Rate,KBD_FAST_RATE
     Mov  Em_Typa_Delay,KBD_FAST_DELAY
 .Endif                           ;AIM
                Endm              ;End Get_KBD_Speed macro.

;*
