/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*      Page  58,132
**      Title   KbdINIT - Kbd Device Dependent Initialization
**      Name    Kbdinit
*/

/*****************************************************************************/
/*                                                                           */
/* SOURCE FILE NAME = KBDINIT.C                                              */
/*                                                                           */
/* DESCRIPTIVE NAME = Physical Keyboard Device Dependent Initialization      */
/*                                                                           */
/*                                                                           */
/* VERSION      V2.2                                                         */
/*                                                                           */
/* DATE         01/11/94                                                     */
/*                                                                           */
/* DESCRIPTION  Initialization for Device Dependent Driver.                  */
/*                                                                           */
/* FUNCTIONS    void Init(void)                                              */
/*                                                                           */
/* NOTES       DEPENDENCIES:  Controller or keyboard must be set to the      */
/*                            PC compatible scan code set.                   */
/*             RESTRICTIONS:  Machine must be a 386 or compatible with       */
/*                            a 386.                                         */
/*                                                                           */
/* STRUCTURES   PRPH                                                         */
/*              AttachDDStr                                                  */
/*                                                                           */
/* EXTERNAL REFERENCES                                                       */
/*                                                                           */
/*              NONE                                                         */
/*                                                                           */
/* EXTERNAL FUNCTIONS                                                        */
/*                                                                           */
/*              NONE                                                         */
/*                                                                           */
/* ??CHANGE ACTIVITY =                                                       */
/* ??  DATE      FLAG        APAR   CHANGE DESCRIPTION                       */
/* ??  --------  ----------  -----  ----------------------------------       */
/* ??  mm/dd/yy                                                              */
/* ??                                                                        */
/* ??                                                                        */
/* ??                                                                        */
/*                                                                           */
/*****************************************************************************/

/*-----------------------------*/
/*   Include files             */
/*-----------------------------*/

 #include "os2.h"
 #include "devcmd.h"
 #include "strat2.h"
 #include "reqpkt.h"
 #include "dhcalls.h"
 #include "kbd.h"
 #include "kbddd.h"
 #include "kbdrm.h"

/*-----------------------------*/
/*   Define files              */
/*-----------------------------*/

 #define FP_OFF(ptr) ((USHORT)((ULONG)(ptr)&0xFFFF))

/*-----------------------------*/
/*     External Variables      */
/*-----------------------------*/

 extern  int  endvariable;

 extern  PRPH    pRPH;            /* Pointer to RPH (Request Packet Header)  */
 extern  PFN     Device_Help;
 extern  PFN     KbdDI_Entry;
 extern  AttachDDStr KbdDI;

 extern  USHORT  Offset_Int_Handler;
 extern  USHORT  Offset_IDC_Handler;
 extern  USHORT  Offset_Timer_Handler;
 extern  USHORT  Keycount;

 extern  BYTE    Current_State;
 extern  BYTE    InitTime;
 extern  BYTE    InterruptTime;
 extern  BYTE    KbdResend;
 extern  BYTE    KbdError;
 extern  BYTE    TIMERFLAG;
 extern  BYTE    CMD_In_Progress;
 extern  BYTE    LED_State;
 extern  BYTE    Type_Rate;

/*****************************************************************************/
/*                                                                           */
/* FUNCTION NAME  : Init                                                     */
/*                 "IBM Unique Code"                                         */
/*                                                                           */
/* DESCRIPTION    : Initialization function for the keyboard device dependent*/
/*                  driver.  If device independent driver is not installed   */
/*                  yet, or can not get IRQ 1 then it won't install itself.  */
/*                                                                           */
/*****************************************************************************/

void Init(void)
{
  PRPINITIN             pRPI = (PRPINITIN)  pRPH;
  PRPINITOUT            pRPO = (PRPINITOUT) pRPH;

  InitTime = TURNON;                        /* Turn on Init flag.            */
  KbdError = TURNOFF;                       /* Reset Error flag.             */
  KbdResend = TURNOFF;                      /* Reset Resend flag.            */
  InterruptTime = TURNOFF;                  /* Reset Interrupt flag.         */
  TIMERFLAG = TURNOFF;                      /* Reset Timer flag.             */
  Type_Rate = Fast_Type_Rate;               /* Default type rate and delay.  */
  Device_Help =  pRPI->DevHlpEP;            /* Load Device Help pointer.     */
                                  /*                                         */
                                  /* First we must get the address of the    */
                                  /* independent keyboard driver.            */
                                  /*                                         */
  if (DevHelp_AttachDD("KBD$    ",(NPBYTE)&KbdDI)) {  /* Attach to KBDDI.    */
    KbdError = TURNON;
  }
  else  {
    KbdDI_Entry = (PFN)KbdDI.Pmode;         /* Load pointer to driver.       */

    if ( RM_KBD_CreateDriver()    /* Resource Manager Setup.       */
      || RM_KBD_AllocIRQ(KBD_IRQ) /* Reserve IRQ.                  */
      || RM_KBD_AllocPortBuffer() /* Reserve Port 64.              */
      || RM_KBD_AllocPortCmd()    /* Reserve Port 64.              */
      || RM_KBD_CreateAdapter()){ /* Create Adapter.               */
      KbdError = TURNON;
      goto KbdFail;
    }

    Disable_Keyboard();
                                  /*                                         */
                                  /* Now we must install our handy-dandy     */
                                  /* keyboard interrupt handler.             */
                                  /*                                         */
    Offset_Int_Handler = FP_OFF(&STATE_MACH_CTL);
    if (DevHelp_SetIRQ((NPFN) Offset_Int_Handler,(USHORT) KBD_IRQ, 0)) {
      KbdError = TURNON;
    }
  }
  Enable_Keyboard();

KbdFail:
  if (KbdError) {
    pRPO->CodeEnd = (USHORT) 0;             /* Init failed.                  */
    pRPO->DataEnd = (USHORT) 0;
    pRPH->Status = STATUS_DONE | STERR | STATUS_ERR_UNKCMD;

    RM_KBD_DestroyDriver();                 /* Delete from Resource Manager. */
  }
  else  {
    pRPO->CodeEnd = (USHORT) &Init;         /* Init complete successfully.   */
    pRPO->DataEnd = (USHORT) &endvariable;
    pRPH->Status = STATUS_DONE;

    Offset_IDC_Handler = FP_OFF(&IDC_Entry_Point);
    Offset_Timer_Handler = FP_OFF(&KbdTimerHandler);
    DevHelp_TickCount((NPFN)Offset_Timer_Handler, MAX_Tick); /* Create timer.*/

    HOTPLGPG(CMD_SELFTEST);                 /* Start hotplug/init routine.   */
    STI;
    while (Current_State > S_SENTSCSD);

    RM_KBD_CreateDevice(Keycount);          /* Resource Manager Setup.       */
  }
}


