/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/*-----------------------------*/
/*        Structures           */
/*-----------------------------*/

typedef struct {
   PVOID  Rmode;
   USHORT Rds;
   PVOID  Pmode;
   USHORT Pds;
} AttachDDStr;

typedef struct {
   USHORT DevFlags;
   USHORT KeyCount;
   USHORT MaxTypa;
   USHORT MinTypa;
   USHORT MaxDelay;
   USHORT MinDelay;
} CapStruc;

typedef struct {
   USHORT idlen;
   UCHAR idbytes[8];
} IDstruc;

typedef struct {
   USHORT wait_time;
   USHORT strlength;
   UCHAR strbytes[20];
} CmdStruc;

typedef struct {
   UCHAR key1;
   UCHAR key2;
} KeyStroke;

/*-----------------------------*/
/*     Defined Constants       */
/*-----------------------------*/

#define   TURNOFF         0
#define   TURNON          1
#define   TRYAGAIN        2
#define   MAX_Tick       -1
#define   Wait_Time      10
#define   Fast_Type_Rate  5        /* Default keyboard type rate and delay.   */
#define   UnKnown         0
#define   AT              1
#define   ENH             2
#define   ENHPlus         3
#define   KBD84           0x84
#define   KBD88           0x54
#define   KBD101          0x41
#define   KBD101x         0x83
#define   KBD122          0x85
#define   KBD122x         0x86
#define   Enable_OFF      0
#define   INT_Enable      1
#define   HW_Enable       2
#define   TYPE_Enable     3
#define   LEDS_Enable     4
#define   GEN_Enable      5
#define   ScanCodeSet1    1
#define   ScanCodeSet2    2
#define   TRANSLATE_BIT   0x40
#define   CLI             _asm{cli}
#define   STI             _asm{sti}

/******* State Machine Valuse *********/

#define   S_NOCMDIPG      0
#define   S_RCVDE0SC      1
#define   S_HOTPLGPG      2
#define   S_SENTLEDC      3
#define   S_SENTLEDD      4
#define   S_SENTTYPC      5
#define   S_SENTTYPD      6
#define   S_GTKBDCMD      7
#define   S_SENTSCSC      8
#define   S_SENTSCSD      9
#define   S_SENTIDCM      10
#define   S_WAITIDB1      11
#define   S_WAITIDB2      12
#define   S_WAIT_ACK      13

/******* IDC Values *******************/

#define   Q_Open          0
#define   Q_Close         1
#define   Q_Cap           2
#define   Q_Type          3
#define   Q_LEDs          4
#define   Q_ID            5
#define   Q_Disabled      6
#define   Disable_K       7
#define   Enable_K        8
#define   Reset_Hw        9
#define   S_Type          10
#define   S_LED           11
#define   Send_Gen        14
#define   Q_Kbd_Rdy       15
#define   Flush_Pt        16
#define   Save_St         18
#define   Restore_St      19

#define   CMD_Open        0
#define   CMD_Close       1
#define   CMD_ScanCode    2
#define   CMD_Reinit      3

/* Prototypes from KBDSTRA.C */

void    Block_Thread(void);
void    Run_Thread(void);
USHORT  Query_Open(void);
USHORT  Query_Close(void);
USHORT  Query_Capabilites(USHORT CMD_Offset,USHORT CMD_Segment);
USHORT  Query_Typematic(void);
USHORT  Query_LEDs(void);
USHORT  Query_ID(USHORT CMD_Offset,USHORT CMD_Segment);
USHORT  Query_Disabled(void);
USHORT  Disable_Keyboard(void);
USHORT  Enable_Keyboard(void);
USHORT  CheckKBD(void);
USHORT  Reset_Hardware(void);
USHORT  Set_Typematic(BYTE New_Type_Rate);
USHORT  Set_LEDs(BYTE New_LED_State);
USHORT  Send_Generic(USHORT CMD_Offset, USHORT CMD_Segment);
USHORT  Query_Kbd_Rdy(void);
USHORT  Flush_Partial(void);
USHORT  Save_State(void);
USHORT  Restore_State(void);
USHORT  FAR _loadds IDC_Entry_Point(USHORT Req,USHORT Req_Off,USHORT Req_Seg);
void    FAR Strategy(void);

/* Prototypes from KBDSTATE.C */

void    IODelay(void);
void    KbdBeeper(void);
void    KeyERROR(void);
USHORT  KbdStatusWait(void);
void    SendPacket(BYTE First,BYTE Second);
void    GetID(void);
void    FAR KbdTimerHandler(void);
void    StartTimer(void);
void    SendData(BYTE KbdData);
void    RESENDData(BYTE DataResend);
void    NOCMDIPG(BYTE keystroke);
void    RCVDE0SC(BYTE keystroke);
void    HOTPLGPG(BYTE keystroke);
void    SENTLEDC(BYTE kbdreturn);
void    SENTLEDD(BYTE kbdreturn);
void    SENTTYPC(BYTE kbdreturn);
void    SENTTYPD(BYTE kbdreturn);
void    GTKBDCMD(BYTE kbdreturn);
void    SENTSCSC(BYTE kbdreturn);
void    SENTSCSD(BYTE kbdreturn);
void    SENTIDCM(BYTE kbdreturn);
void    WAITIDB1(BYTE IDreturn);
void    WAITIDB2(BYTE IDreturn);
void    WAIT_ACK(BYTE kbdreturn);
void    FAR STATE_MACH_CTL(void);

/* Prototypes from KBDINIT.C */

void    Init(void);

/* Extra Prototypes needed */

USHORT APIENTRY DevHelp_Yield(void);


