/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*      Page  58,132
**      Title   KbdData - Kbd Device Dependent Data
**      Name    Kbddata
*/

/*****************************************************************************/
/*                                                                           */
/* SOURCE FILE NAME = KBDDATA.C                                              */
/*                                                                           */
/* DESCRIPTIVE NAME = Physical Keyboard Device Dependent Data                */
/*                                                                           */
/*                                                                           */
/* VERSION      V2.2                                                         */
/*                                                                           */
/* DATE         01/11/94                                                     */
/*                                                                           */
/* DESCRIPTION  Data for Device Dependent Driver.                            */
/*                                                                           */
/* NOTES       DEPENDENCIES:  Controller or keyboard must be set to the      */
/*                            PC compatible scan code set.                   */
/*             RESTRICTIONS:  Machine must be a 386 or compatible with       */
/*                            a 386.                                         */
/*                                                                           */
/* STRUCTURES   PRPH                                                         */
/*              AttachDDStr                                                  */
/*              KeyStroke                                                    */
/*                                                                           */
/* ??CHANGE ACTIVITY =                                                       */
/* ??  DATE      FLAG        APAR   CHANGE DESCRIPTION                       */
/* ??  --------  ----------  -----  ----------------------------------       */
/* ??  mm/dd/yy                                                              */
/* ??                                                                        */
/* ??                                                                        */
/* ??                                                                        */
/*                                                                           */
/*****************************************************************************/

/*-----------------------------*/
/*   Include files             */
/*-----------------------------*/

 #include "os2.h"
 #include "strat2.h"
 #include "reqpkt.h"
 #include "kbddd.h"

/*-----------------*/
/*   Variables     */
/*-----------------*/

 PRPH  pRPH;                      /* Pointer to RPH (Request Packet Header)  */
 PFN   Device_Help         = 0L;  /* Pointer to DevHelp routines.            */
 AttachDDStr KbdDI;               /* Structure to store AttachDD addresses.  */
 KeyStroke KeyBuffer;             /* Structure to store key stroke bytes.    */
 PFN   KbdDI_Entry;               /* Pointer to KbdDI IDC entry point.       */

 USHORT KbdDI_Handle;             /* Handle to KBDDI.                        */
 USHORT KbdCS          = 0xFFFF;  /* Code Segment value.                     */
 USHORT KbdDS          = 0xFFFF;  /* Data Segment value.                     */
 USHORT Keycount;                 /* Number of keys on the keyboard.         */
 USHORT Offset_Int_Handler;       /* Offset of State_Mach_Ctl.               */
 USHORT Offset_IDC_Handler;       /* Offset of IDC_Entry_Point.              */
 USHORT Offset_Timer_Handler;     /* Offset of KbdTimerHandler.              */

 BYTE  Current_State;             /* Holds current state value.              */
 BYTE  LED_State;                 /* Current LED state.                      */
 BYTE  Type_Rate;                 /* Current type rate.                      */
 BYTE  DataByte1            = 0;  /* First ID byte.                          */
 BYTE  DataByte2            = 0;  /* Second ID byte.                         */
 BYTE  CMD_In_Progress;           /* Flags if a command is in progress.  Bool*/
 BYTE  InitTime;                  /* Initialize flag.                    Bool*/
 BYTE  InterruptTime;             /* Interrupt flag                      Bool*/
 BYTE  TIMERFLAG;                 /* Set when waiting for the timer.     Bool*/
 BYTE  KbdResend;                 /* Set after a resend is sent from KBD.Bool*/
 BYTE  KbdError;                  /* Flags that an error has occured.    Bool*/
 BYTE  DisableFlag;               /* Set when the kbd is disabled.       Bool*/
 BYTE  HotPlugInit;               /* Flag that a Hot Plug is occuring.   Bool*/
 BYTE  FirstByte;                 /* Stores first scan code (E0 or E1).      */
 BYTE  PrevState;                 /* Previous state.                         */
 BYTE  Save_LED;                  /* Saved LED state.                        */
 BYTE  Save_Type;                 /* Saved Type rate.                        */
 BYTE  Next_Block;                /* Pointer to signify a thread is blocked. */
 BYTE  Next_Run;                  /* Pointer to next thread to run.          */
 BYTE  Enabler;                   /* Who gets to reenable keyboard.          */
 BYTE  SCSet;                     /* Scan-Code Set.                          */



