;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = src/dev/dasd/os2scsi/scsubra.asm, scsy, ddk_subset, b_bdd.032 93/04/06

        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = SCSUBRA.ASM
;*
;* DESCRIPTIVE NAME = OS2SCSI.DMD - OS/2 SCSI.SYS Emulation
;*
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION : Assembly helper routines
;*
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   04/01/93  @V65575     65575  Fix parameter stack offset - S_to_MS
;*
;*****************************************************************************/


        title   SCSUBRA - OS/2 2.0 OS2SCSI
        name    SCSUBRA


        .xlist
        include basemaca.inc
        .list


_DATA   segment dword public 'DATA'

_DATA   ends


Code    segment dword public 'CODE'
        assume  CS:Code,DS:_Data

        CPUMODE 386

;******************************************************************************
;*
;*  SUBROUTINE NAME:   MS_to_S
;*
;*  DESCRIPTIVE NAME: Convert form milisecond to second
;*
;*  FUNCTION:     Convert from milisecond to second
;*
;*  ENTRY POINT:  MS_to_S
;*
;*  LINKAGE:      Near
;*
;******************************************************************************


          public _MS_to_S
_MS_to_S proc near

        push    bp
        mov     bp,sp
        push    ebx
        mov     ax,[bp+6]
        shl     eax,16
        mov     ax,[bp+4]
        xor     edx,edx
        mov     ebx,1000
        div     ebx
        or      edx,edx
        jz      not_inc
        inc     ax
not_inc:
        push    ax
        shr     eax,16
        mov     dx,ax
        pop     ax
        pop     ebx
        pop     bp
        ret

_MS_to_S endp


;******************************************************************************
;*
;*  SUBROUTINE NAME:   S_to_MS
;*
;*  DESCRIPTIVE NAME: Convert form second to milisecond
;*
;*  FUNCTION:     Convert from second to milisecond
;*
;*  ENTRY POINT:  S_to_MS
;*
;*  LINKAGE:      Near
;*
;******************************************************************************


          public _S_to_MS
_S_to_MS proc near

        push    bp
        mov     bp,sp
        push    ebx
        mov     eax,[bp+4]                                              ;@V65575
        xor     edx,edx
        mov     ebx,1000
        mul     ebx
        push    ax
        shr     eax,16
        mov     dx,ax
        pop     ax
        pop     ebx
        pop     bp
        ret

_S_to_MS endp

Code            ends

                end
