;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = src/dev/dasd/os2aspi/aspivirt.asm, aspi, r206 93/03/20

        page    ,132

;/*****************************************************************************
;*
;* SOURCE FILE NAME = ASPIVIRT.ASM
;*
;* DESCRIPTIVE NAME = OS2ASPI.DMD - OS/2 ASPI Device Manager
;*
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION : ASPI Device Manager segment declarations
;*
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vnnnnn     xxxxx  xxxxxxx
;*****************************************************************************/

        .386p

        include devhlp.inc
        include devsym.inc
        include iorbtype.inc

        include scsi.inc
        include dhcalls.inc
        include aspivirt.inc

_DATA   SEGMENT  WORD PUBLIC USE16 'DATA'
extrn  _Device_Help:dword
extrn  _VDDProc:word
_DATA   ENDS

CONST   SEGMENT  WORD PUBLIC USE16 'CONST'
CONST   ENDS

_BSS    SEGMENT  WORD PUBLIC USE16 'BSS'
_BSS    ENDS

DGROUP  GROUP   CONST, _BSS, _DATA

Code    segment dword public USE16 'CODE'
        assume  CS:Code,DS:DGROUP

extrn   _ASPISRBEntr:near
extrn   _ASPIEntry:near

        PUBLIC  VirtualASPIEntry
;
;VOID _pascal _far VirtualASPIEntry (ULONG functionCode,PASPI_SRB_HEADER pSRB,
;                                    PVOID pOutBuf);
VirtualASPIEntry       proc    far

        push    bp
        mov     bp, sp

        push    ds
        push    es
        push    ebx
        push    edi
        push    esi

        mov     ax, DGROUP
        mov     ds, ax

        mov     eax, dword ptr [bp] + 18

        cmp     eax, PDDCMD_SRB_REQUEST         ;ASPI request
        je      StandardRequest

        cmp     eax, PDDCMD_VDD_INITIALIZE      ;initialization
        je      VirtualEntryInit

        cmp     eax, PDDCMD_OS2_ASPI_PASSTHRU
        je      OS2Request

        cmp     eax, PDDCMD_VDM_DESTROY_EVENT
        je      OS2Request
        jmp short VirtualASPIDone               ;invalid request

VirtualEntryInit:
        ;Save the entry point of the VDD
        mov     ax,[bp] + 14
        mov     [_VDDProc]+4,ax
        mov     ax,[bp] + 10
        mov     [_VDDProc],ax
        mov     ax,[bp] + 12
        mov     [_VDDProc]+2,ax
        jmp short VirtualASPIDone

OS2Request:
        ;Submit an OS2 request that avoids the VDD queues
        cmp     eax, PDDCMD_VDM_DESTROY_EVENT
        je      RememberVDMDead

        mov     ax, 0
        jmp short PassOS2SRBAddress

RememberVDMDead:
        mov     ax, VDM_DESTROY_EVENT

PassOS2SRBAddress:
        push    ax
        mov     eax, [bp] + 14                  ;pass 16:16 address of SRB
        push    eax
        call    _ASPISRBEntr
        add     sp, 6
        jmp short VirtualASPIDone

StandardRequest:
        ;Use the GDT selector allocated in the VDD
        ;Pass a pointer to the SRB

        push    1
        mov     eax, [bp] + 14                  ;pass 16:16 address of SRB
        push    eax
        call    _ASPISRBEntr
        add     sp, 6

VirtualASPIDone:
        pop     esi
        pop     edi
        pop     ebx
        pop     es
        pop     ds
        pop     bp
        db      066h
        ret

VirtualASPIEntry       endp

;
;VOID _CallVirtPostRoutine(PASPI_SRB_EXECUTE_IO pSRB)
;
        PUBLIC  _CallVirtPostRoutine
_CallVirtPostRoutine     proc    near

        push    bp
        mov     bp, sp

        push    si
        push    di

        ;Call the VDD (16:32)
        xor     ebx, ebx
        push    ebx                             ;pass function code

        ;Pass VIRTUAL address of SRB
        mov     eax, dword ptr [bp + 4]         ;pass SRB pointer ()
        push    eax

        ;Pass unused third parameter
        push    ebx

        call    fword ptr [_VDDProc]            ;call the VDD Post routine
                                                ;the stack is automatically
                                                ;adjusted to remove all
                                                ;parameters passed!!
        pop     di
        pop     si
        pop     bp
        ret

_CallVirtPostRoutine     endp

Code    ends

end

