/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/os2aspi/aspitype.h, aspi, r206 93/03/20";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = ASPITYPE.H
 *
 * DESCRIPTIVE NAME = OS2ASPI.DMD - OS/2 ASPI Device Manager
 *                    Internal Data Structures
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Defines data types used locally within this driver.
 *
 *
 *
*/

typedef struct _ACB         ACB,      *NPACB,      FAR *PACB;
typedef struct _ATE         ATE,      *NPATE,      FAR *PATE;
typedef struct _SRB_LINK    SRB_LINK, *NPSRB_LINK, FAR *PSRB_LINK;

typedef UCHAR  NEAR *NPUCHAR;



/*--------------------------------------------------*/
/*                                                  */
/* Adapter Control Block                            */
/* ---------------------                            */
/*                                                  */
/* One control block is allocated per Host Adapter  */
/*                                                  */
/*--------------------------------------------------*/

typedef struct _ACB
{

  /*-----------------------------------------------------------*/
  /* Pointers to next ACB and associated Target Entries        */
  /*-----------------------------------------------------------*/
  NPACB     npNextACB;
  NPATE     npFirstATE;

  /*--------------------*/
  /* Adapter Data       */
  /*--------------------*/
  USHORT    AdapterFlags;
  UCHAR     AdapterIndex;
  UCHAR     AdapterTargetID;
  UCHAR     AdapterName[16];                                         /*@V53752*/

/* Extended adapter inquiry data */                                  /*@V53040*/
  USHORT    AdapterFeatures;                                         /*@V53040*/
  USHORT    MaximumSGList;                                           /*@V53040*/
  ULONG     MaximumCDBTransfer;                                      /*@V53040*/

} ACB;


/*----------------------------------------------------------*/
/*                                                          */
/* Adapter Target Entry                                     */
/* --------------------                                     */
/*                                                          */
/* One control block is allocated per available SCSI Device */
/*                                                          */
/*----------------------------------------------------------*/

typedef struct _ATE
{
  /*-------------------------------------*/
  /*                                     */
  /*-------------------------------------*/
  NPACB         npOwnerACB;
  NPATE         npNextATE;

  /*-------------------------------------*/
  /*                                     */
  /*-------------------------------------*/
  USHORT        SRBActiveQueueCount;
  NPSRB_LINK    npSRBActiveQueue;

  UCHAR         UnitControlIORB[sizeof(IORB_UNIT_CONTROL)];          /*@V64399*/

  VOID      (FAR *TargetADD_Entry)( PIORBH);

  /*--------------------*/
  /* Target Data        */
  /*--------------------*/
  USHORT        Flags;
  USHORT        UnitHandle;
  USHORT        QueuingCount;
  UCHAR         DeviceTargetID;
  UCHAR         DeviceTargetLUN;
  UCHAR         DeviceType;
  NPUCHAR       npDirTable;
  NPUCHAR       npDirExcept;

/* Padding to assure all data is on a WORD boundary */               /*@V53752*/
  UCHAR         Reserved1;                                           /*@V53752*/

/* Extended target inquiry data */
  USHORT        TargetFeatures;

} ATE;

#define ATEF_ASPI_ALLOCATED     0x0001       //Device allocated permanently
#define ATEF_IGNORE_ALLOCATION  0x0002       //Share device with other managers
#define ATEF_SHARE_ALLOCATION   0x0004       //Allocated for an I/O request

/*----------------------------------------------------------*/
/*                                                          */
/* SRB Link Element                                         */
/* ----------------                                         */
/*                                                          */
/* Tracks SRBs received by ASPI Device Manager              */
/*                                                          */
/*----------------------------------------------------------*/

typedef struct _SRB_LINK
{
   /*-------------------------------------*/
   /*                                     */
   /*-------------------------------------*/

   NPSRB_LINK               npNextSRBLink;
   PASPI_SRB_HEADER         pSRB;
   IORB_ADAPTER_PASSTHRU    IORB;
   SEL                      SRBGDTSelector;                          /*@V@58231*/
   SEL                      SGGDTSelector;                           /*@V@58231*/
   PVOID                    OrigSRBPtr;
   SCSI_STATUS_BLOCK        commandStatus;

/* Padding to assure that all data is on a WORD boundary */          /*@V53752*/
/* (SCSI_STATUS_BLOCK) ends has an odd byte boundary.    */          /*@V53752*/
   UCHAR         reserved1;                                          /*@V53752*/
}  SRB_LINK;


/*----------------------------------------------------------*/       /*@V61092*/
/*                                                          */       /*@V61092*/
/* SRB Waiting Queue                                        */       /*@V61092*/
/* --------------------                                     */       /*@V61092*/
/*                                                          */       /*@V61092*/
/* Tracks SRBs received when all the SRB_LINKs are allocated*/       /*@V61092*/
/*                                                          */       /*@V61092*/
/*----------------------------------------------------------*/       /*@V61092*/
typedef struct _SRB_WAIT_Q                                           /*@V61092*/
{                                                                    /*@V61092*/
                                                                     /*@V61092*/
   PASPI_SRB_HEADER        SRBPtr;                                   /*@V61092*/
   NPATE                   ATEPtr;                                   /*@V61092*/
   USHORT                  virtualASPI;
   VOID                    (NEAR *callbackFunction)(NPATE,           /*@V61092*/
                                                    PASPI_SRB_HEADER,/*@V61092*/
                                                    NPSRB_LINK,
                                                    BOOL);
}  SRB_WAIT_Q;                                                       /*@V61092*/

#define VDM_REQUEST        0x01        /* Request is from a VDD */
#define VDM_DESTROY_EVENT  0x02        /* The VDM has been destroyed */

/*--------------------------------------------------------------------*/
/* IORB DMWorkSpace Structure                                         */
/*--------------------------------------------------------------------*/
typedef struct _IORB_DMWORK
{
   NPATE          npATE;
   SCATGATENTRY   SGList;
   SEL            SGGDTSelector;                                     /*@V58231*/
   SEL            SRBGDTSelector;
   USHORT         virtualASPI;                                       /*@V53752*/
   USHORT         reserved1;
} IORB_DMWORK, FAR *PIORB_DMWORK, NEAR *NPIORB_DMWORK;


/*--------------------------------------------------------------------*/
/* ASPI SRB WorkSpace Structure                                       */
/*--------------------------------------------------------------------*/
typedef struct _ASPI_SRBWORK
{
   PVOID          pSRB;                /* Virtual address from VDD */
   PIORBH         pIORB;               /* IORB for VDD request */
   UCHAR          UnusedWorkSpace[14];
} ASPI_SRBWORK, FAR *PASPI_SRBWORK, NEAR *NPASPI_SRBWORK;

/*--------------------------------------------------------------------*/
/*                                                                    */
/*--------------------------------------------------------------------*/
typedef struct _DIREXCEPT
{

   NPUCHAR      npVendorID;
   NPUCHAR      npProductID;
   NPUCHAR      npExceptList;

} DIREXCEPT, FAR *PDIREXCEPT, NEAR *NPDIREXCEPT;
