/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = MMSCB.H
 *
 * DESCRIPTIVE NAME = IBM2SCSI.ADD - Adapter Driver for IBM scsi adapters.
 *                    Move mode definitions.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION  Defines move mode control elements.
 *
 *
*/


/*--------------------------------------*/
/* Generic request element definitions. */
/*--------------------------------------*/

typedef struct _REQH {    /* Generic request element header     */

   USHORT length;         /* length of the element in bytes     */
   USHORT type;           /* format type (0) for corvette       */
   USHORT rsvd1;          /* reserved mbz                       */
   USHORT ci;             /* common indicators field            */
   USHORT dstid;          /* destination unit ID                */
   USHORT srcid;          /* source unit ID (0 for system unit) */
   ULONG  corrid;         /* coorelation ID                     */
   USHORT optctrl;        /* option control                     */
   USHORT timeout;        /* timeout value (see option control) */

} REQH, FAR *PREQH, NEAR *NPREQH;

/* common indicators field defines */

#define EID             0xc000      /* Element ID bits              */
#define EID_REQ         0x0000      /*   request element            */
#define EID_REP         0x4000      /*   reply element              */
#define EID_EVNT        0x8000      /*   event element              */
#define EID_ERR         0xc000      /*   error element              */
#define SUPPRESS_REPLY  0x2000      /* Suppress reply element bit   */
#define CHCTRL          0x1800      /* Chain control bits           */
#define CHCTRL_NONE     0x0000      /*   no chaining                */
#define CHCTRL_START    0x0800      /*   start of chain             */
#define CHCTRL_MIDDLE   0x1000      /*   middle of chain            */
#define CHCTRL_END      0x1800      /*   end of chain               */
#define EXPEDITE        0x0080      /* Expedite bit                 */
#define FN_FUNCTION     0x007f      /* Function field               */
#define FN_READLIST     0x0005      /*   Read List                  */
#define FN_READIMMED    0x0006      /*   Read immediate             */
#define FN_WRITELIST    0x0008      /*   write list                 */
#define FN_CANCEL       0x000c      /*   cancel element             */
#define FN_DIAGNOSE     0x000f      /*   diagnose                   */
#define FN_MGMNT        0x0010      /*   management request         */
#define FN_WRAP         0x003f      /*   wrap element               */
#define FN_ABORTSCSI    0x0040      /*   abort scsi                 */
#define FN_SENDSCSI     0x0041      /*   send scsi cdb              */
#define FN_READCAP      0x0042      /*   read device capacity       */
#define FN_READVERIFY   0x0044      /*   read verify                */
#define FN_WRITEVERIFY  0x0048      /*   write list verify          */
#define FN_INITSCSI     0x0052      /*   init scsi                  */
#define FN_LOOPSCATGAT  0x0060      /*   loop scatter gather        */
#define FN_EXECSCB      0x0070      /*   execute locate mode scb    */
#define FN_REACTIVATEQ  0x007e      /*   reactivate queue           */

/* option control field defines */

#define TO_MINUTES      0x8000      /* timeout in minutes, not seconds      */
#define IO_PORTENABLE   0x2000      /* address is uChannel I/O port         */
#define OP_CONSTADDR    0x1000      /* maintain constant address (IO space) */
#define TO_MOVEMODE     0x0800      /* use MM timeout value not locat@x08084*/
#define OP_ND           0x0040      /* no disconnect message                */
#define OP_SS           0x0020      /* suppress short                       */
#define OP_LOOPSCATGAT  0x0010      /* loop scatter gather enable           */
#define OP_ARSENSE      0x0008      /* auto req sense enable                */
#define OP_UT           0x0004      /* untagged message                     */
#define OP_RQ           0x0002      /* re-activate queue                    */
#define OP_RD           0x0001      /* data in (read if set, write if clear)*/


typedef struct _ARSENSE {  /* Autorequest sense structure      */

   ULONG  ppSenseData;     /* phys ptr for auto request sense  */
   ULONG  cSenseBytes;     /* count of sense bytes             */

} ARSENSE, NEAR *NPARSENSE, FAR *PARSENSE;


typedef struct _STDHEAD {  /* Standard element header          */

   REQH     ReqH;          /* Generic element header           */
   ARSENSE  arsense;       /* Autoreq sense structure          */

} STDHEAD, NEAR *NPSTDHEAD, FAR *PSTDHEAD;


typedef struct _REPLY {    /* Generic reply element               */

   USHORT length;          /* length of the element in bytes      */
   USHORT type;            /* format type (0) for corvette        */
   USHORT rsvd1;           /* reserved mbz                        */
   USHORT ci;              /* common indicators field             */
   USHORT dstid;           /* destination unit ID                 */
   USHORT srcid;           /* source unit ID (0 for system unit)  */
   ULONG  corrid;          /* coorelation ID                      */

} REPLY, FAR *PREPLY, NEAR *NPREPLY;



typedef struct _EXTREPLY { /* Extended reply and generic error element. */

   USHORT length;          /* length of the element in bytes      */
   USHORT type;            /* format type (0) for corvette        */
   USHORT rsvd1;           /* reserved mbz                        */
   USHORT ci;              /* common indicators field             */
   USHORT dstid;           /* destination unit ID                 */
   USHORT srcid;           /* source unit ID (0 for system unit)  */
   ULONG  corrid;          /* coorelation ID                      */
   TSB    tsb;             /* the tsb                             */
   USHORT rsvd2;           /* rounds out to even double words     */

} EXTREPLY, FAR *PEXTREPLY, NEAR *NPEXTREPLY,
  ERRREPLY, FAR *PERRREPLY, NEAR *NPERRREPLY;

/*----------------------------*/
/* Managment request elements */
/*----------------------------*/



typedef struct _CFGPIPES { /* configure pipes control element  */

   USHORT length;          /* length of the element in bytes               */
   USHORT type;            /* format type (0) for corvette                 */
   USHORT rsvd1;           /* reserved mbz                                 */
   USHORT ci;              /* common indicators field                      */
   UCHAR  rsvd2;           /* reserved mbz                                 */
   UCHAR  AdpUID1;         /* adapter ID                                   */
   USHORT srcid;           /* source unit ID (0 for system unit)           */
   ULONG  corrid;          /* coorelation ID                               */
   USHORT id;              /* id                                           */
   USHORT function;        /* function                                     */
   UCHAR  AdpUID2;         /* Adapter ID                                   */
   UCHAR  PeerUID;         /* Peer ID                                      */
   USHORT CfgStatus;       /* config status                                */
   ULONG  ppPeerSigAdr;    /* phys ptr to peer signalling address          */
   ULONG  ppAdpSigAdr;     /* phys ptr to adapter signalling address       */
   USHORT AdpBaseIO;       /* adapter base I/O address                     */
   USHORT PeerBaseIO;      /* peer base I/O address                        */
   USHORT TimerFreq;       /* timer frequency                              */
   UCHAR  TimeUnit;        /* timer unit                                   */
   UCHAR  SysMID;          /* ??                                           */
   USHORT AdpCfgOpt;       /* adapter configuration options                */
   USHORT PeerCfgOpt;      /* peer configuration options                   */
   USHORT OutPipeSize;     /* outbound pipe size in bytes                  */
   USHORT InPipeSize;      /* inbound pipe size in bytes                   */
   ULONG  ppInPipe;        /* phys ptr to inboud pipe                      */
   ULONG  ppInSDS;         /* phys ptr to inbound surr dequeue status      */
   ULONG  ppInSSE;         /* phys ptr to inbound surr start of elements   */
   ULONG  ppInSES;         /* phys ptr to inbound surr enqueue status      */
   ULONG  ppInSSF;         /* phys ptr to inbound surr start of free       */
   ULONG  ppOutPipe;       /* phys ptr to outboud pipe                     */
   ULONG  ppOutSDS;        /* phys ptr to outbound surr dequeue status     */
   ULONG  ppOutSSE;        /* phys ptr to outbound surr start of elements  */
   ULONG  ppOutSES;        /* phys ptr to outbound surr enqueue status     */
   ULONG  ppOutSSF;        /* phys ptr to outbound surr start of free      */

} CFGPIPES, FAR *PCFGPIPES, NEAR *NPCFGPIPES;

/* Managment function codes  */

#define MGMT_CFGPIPES        0x8010      /* configure pipes             */
#define MGMT_DECFGPIPES      0x8011      /* deconfigure pipes           */
#define MGMT_ASSIGNENTITY    0xa000      /* assign entity ID            */
#define MGMT_RELENTITY       0xa001      /* release specific entity ID  */
#define MGMT_RELALLENTITIES  0xa002      /* release all entity IDs      */
#define MGMT_QUERYENTITY     0xa010      /* query entity ID assignment  */

/* Configuration options     */

#define CO_SIG_FULL2NFULL   0x0001       /* FULL TO NOT FULL            */
#define CO_SIG_NMT2MT       0x0002       /* not empty to empty          */
#define CO_SIG_NFULL2FULL   0x0004       /* not full 2 full             */
#define CO_SIG_MT2NMT       0x0008       /* empty to not empty          */
#define CO_SIG_ENQ          0x0010       /* signal on enqueue           */
#define CO_SIG_DEQ          0x0020       /* signal on dequeue           */
#define CO_SIG_TIMER        0x0040       /* signal on timer expiration  */
#define CO_SIG_RSVD         0x0080       /* reserved                    */
#define CO_UT_SYSTEM        0x0000       /* system unit                 */
#define CO_UT_PHYSADP       0x0800       /* physical adapter            */
#define CO_PP_ADPMEM        0x8000       /* adapter shared memory       */
#define CO_PP_SYSMEM        0x4000       /* system memory               */



typedef struct _ME_ASGNEID { /* assign/release entity ID element  */

   USHORT length;          /* length of the element in bytes                 */
   USHORT type;            /* format type (0) for corvette                   */
   USHORT rsvd1;           /* reserved mbz                                   */
   USHORT ci;              /* common indicators field                        */
   USHORT dstid;           /* destination unit ID                            */
   USHORT srcid;           /* source unit ID (0 for system unit)             */
   ULONG  corrid;          /* coorelation ID                                 */
   USHORT id;              /* ID (not used)                                  */
   USHORT function;        /* function                                       */
   UCHAR  eid;             /* entity ID                                      */
   UCHAR  rsvd2;           /* reserved                                       */
   UCHAR  tid_lun;         /* bits 7-4 = target ID, 3 = 0, 2-0 = LUN         */
   UCHAR  bus;             /* bits 7-4 = bus ID,  3-0 = 0                    */
   ULONG  option;          /* negotiate options (b0 - no queue, b1 - no wide)*/

} ME_ASGNEID, NEAR *NPME_ASGNEID, FAR PME_ASGNEID;

#define OPTION_NOQMSG 0x0000001    /* send no queue messages  */
#define OPTION_NOWIDE 0x0000002    /* send no wide messages   */

/*---------------------------*/
/* General control elements. */
/*---------------------------*/

typedef struct _CE_READDEVCAP {  /* Read device capacity                 */

   REQH    ReqH;                 /* common request element header        */
   ARSENSE arsense;              /* auto request sense                   */
   ULONG   ppBuf;                /* phys ptr to buffer for capacity data */
   ULONG   cSizeBuf;             /* size of device capacity buffer       */

} CE_READDEVCAP, NEAR *NPREADDEVCAP;


typedef struct _CE_IOLIST {   /* I/O list - Reads and writes    */

   REQH         ReqH;         /* common request element header  */
   ARSENSE      arsense;      /* auto request sense             */
   ULONG        RBA;          /* relative block address (lba)   */
   USHORT       cBlocks;      /* number of blocks to xfer       */
   USHORT       BlockSize;    /* block size in bytes            */
   SCATGATENTRY SGList[17];   /* 17 scatter gather entries      */

} CE_IOLIST, NEAR *NPCE_IOLIST, FAR *PCE_IOLIST;


typedef struct _CE_ABORT {    /* Abort request element  */

   REQH   ReqH;               /* generic request header */
   ULONG  abortid;            /* abort correlation ID   */

} CE_ABORT, NEAR *NPCE_ABORT, FAR *PCE_ABORT;

/* some option control bits for the abort */

#define OP_E   0x0800   /* suppress error reply elements for aborted reqs */
#define OP_Q   0x0400   /* send clear queue message to device             */
#define OP_T   0x0200   /* send abort tag for specific ID                 */
#define OP_B   0x0100   /* send bus device reset message                  */
#define OP_S   0x4000   /* supress any scsi msg to device                 */


typedef struct _CE_EXEC_CDB { /* execute CDB control element  */

   REQH         ReqH;         /* request header               */
   ARSENSE      arsense;      /* auto request sense address   */
   UCHAR        cdb[12];      /* 12 byte CDB                  */
   ULONG        cBytes;       /* total xfer length            */
   SCATGATENTRY SGList[17];   /* scatter gather list          */

} CE_EXEC_CDB, NEAR *NPCE_EXEC_CDB, FAR *PCE_EXEC_CDB;


typedef struct _CE_EXEC_SCB { /* Execute locate mode SCB  */

   REQH         ReqH;         /* request header           */
   ARSENSE      arsense;      /* autorequest sense        */
   ULONG        ppSCB;        /* phys ptr to the SCB      */

} CE_EXEC_SCB, NEAR *NPCE_EXEC_SCB, FAR *PCE_EXEC_SCB;


typedef struct _CE_REACTQUE {  /* Reactivate adapter device queue     */

   USHORT length;              /* length of the element in bytes      */
   USHORT type;                /* format type (0) for corvette        */
   USHORT rsvd1;               /* reserved mbz                        */
   USHORT ci;                  /* common indicators field             */
   USHORT dstid;               /* destination unit ID                 */
   USHORT srcid;               /* source unit ID (0 for system unit)  */
   ULONG  corrid;              /* coorelation ID                      */

} CE_REACTQUE, NEAR *NPCE_REACTQUE, FAR *PCE_REACTQUE;

/*-----------------*/
/* New TSB defines */
/*-----------------*/

#define  CMDQ_SUSPEND  0x2000    /* adapter command queue has been suspended */
#define  SENSEDATA     0x0040    /* auto req sense data valid                */

#define SYSTEM_UNIT    0x00      /* sytem unit ID for move mode              */
