/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/ibm/ibm2scsi/ibm2scpr.c, scsi, r206, 6.506 93/03/20";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = IBM2SCPR.C
 *
 * DESCRIPTIVE NAME = IBM2SCSI.ADD - Adapter Driver for ABIOS SCB Devices
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Calling sequences for TESTCFG Device Driver
 *
 *
*/
#define INCL_DOSDEVICES
#include <os2def16.h>
#include <bsedos16.h>


#define TSTCFG_CAT              0x80
#define TSTCFG_FCN_READBIOS     0x40
#define TSTCFG_FCN_INPUT        0x41
#define TSTCFG_FCN_OUTPUT       0x42
#define TSTCFG_FCN_BUSTYPE      0x60
#define TSTCFG_FCN_RETURNPOSIDS 0x61

#define OEMHLP_CAT              0x80                                 /*@V96790*/
#define OEMHLP_FCN_QUERYROMBIOS 0x05                                 /*@V96790*/

#define MODEL_PS2               0xF8                                 /*@V96790*/
#define SUBMODEL_8556           0x25   /* SCSI I */                  /*@V96790*/
#define SUBMODEL_8556_8557      0x26   /* SCSI I */                  /*@V96790*/
#define SUBMODEL_BAHAMA         0x27   /* SCSI I */                  /*@V96790*/
#define SUBMODEL_MIDWAY_CAT_CAY 0x35   /* SCSI I */                  /*@V96790*/
#define SUBMODEL_CANERY         0x38   /* SCSI I */                  /*@V96790*/
#define SUBMODEL_9576_9577      0x41   /* SCSI I */                  /*@V96790*/
#define SUBMODEL_8585           0x48   /* SCSI I */                  /*@V96790*/
#define SUBMODEL_SERVER85       0xB4   /* Corvette SCSI II */        /*@V96790*/

#define MAX_POS_IDS             16

#define BUSTYPE_MCA              1

#define PRESENT                  0
#define NOT_PRESENT             -1


USHORT  AdapterIds[] =
{
  0x8EFC,               /* IBM PS/2 SCSI-2 Adapter              */
  0x8EFE,               /* IBM PS/2 SCSI-1 Adapter (w/o  cache) */
  0x8EFF                /* IBM PS/2 SCSI-1 Adapter (w/   cache) */
};

#define MAX_ADAPTER_IDS  (sizeof(AdapterIds)/sizeof(AdapterIds[0]))

typedef struct _OEMHLP_QueryRomBIOS {                               /*@V96790*/
   USHORT     Model;                                                /*@V96790*/
   USHORT     SubModel;                                             /*@V96790*/
   USHORT     BIOSRevLevel;                                         /*@V96790*/
   USHORT     flags;                                                /*@V96790*/
} OEMHLP_QueryRomBIOS_t;                                            /*@V96790*/

OEMHLP_QueryRomBIOS_t OEMHLP_DataPacket  = { 0 };                   /*@V96790*/

/*----------------------------------------*/
/*                                        */
/* Presence Check for IBM SCSI Adapters   */
/*                                        */
/*----------------------------------------*/

main()
{
  HFILE         hTESTCFG;
  HFILE         hIBMSCSI;
  HFILE         hOEMHLP;                                           /*@V96790*/
  USHORT        rc;
  USHORT        action;

  USHORT        i;
  USHORT        j;

  USHORT        pos_ids[MAX_POS_IDS];
  USHORT        pos_id_count;
  USHORT        pos;

  USHORT        Present = NOT_PRESENT;

  ULONG         Command = 0;
  ULONG         BusType;

  OEMHLP_QueryRomBIOS_t OEMHLP_DataPacket;                          /*@V96790*/
  USHORT                Model;                                      /*@V96790*/
  USHORT                SubModel;                                   /*@V96790*/

  /*-----------------------------------------------*/               /*@V98451*/
  /* If IBM2SCSI.ADD driver is loaded, then IBM    */               /*@V98451*/
  /* SCSI adapters(s) are present.                 */               /*@V98451*/
  /*                                               */               /*@V98451*/
  /*-----------------------------------------------*/               /*@V98451*/

  if (!(rc=                                                         /*@V98451*/
         DosOpen("IBMSCSI$",&hIBMSCSI,&action,0L,0,1,0x40,0L)))     /*@V98451*/
  {                                                                 /*@V98451*/
     DosClose( hIBMSCSI );                                          /*@V98451*/
     return( 0 );                                                   /*@V98451*/
  }                                                                 /*@V98451*/

  /*------------------------*/
  /* Open TESTCFG Driver    */
  /*------------------------*/

  if ( rc=DosOpen( "TESTCFG$",
                   &hTESTCFG,
                   &action,
                   0L,
                   0,
                   1,
                   0x40,
                   0L          ) )

  {
    goto ExitPresenceCheck;
  }

  /*----------------------------*/
  /* Determine Machine Bus Type */
  /*----------------------------*/

  rc = DosDevIOCtl( (PVOID) &BusType,
                    (PVOID) &Command,
                    (USHORT) TSTCFG_FCN_BUSTYPE,
                    (USHORT) TSTCFG_CAT,
                    (HFILE)  hTESTCFG           );

  if ( rc || BusType != BUSTYPE_MCA )
  {
    DosClose(hTESTCFG);                                             /*@V96790*/
    goto ExitPresenceCheck;
  }

  /*----------------------------*/
  /* Scan POS IDs               */
  /*----------------------------*/

  for (i=0; i < MAX_POS_IDS; i++ )
  {
    pos_ids[i] = 0;
  }

  rc = DosDevIOCtl( (PVOID)  pos_ids,
                    (PVOID)  &Command,
                    (USHORT) TSTCFG_FCN_RETURNPOSIDS,
                    (USHORT) TSTCFG_CAT,
                    (HFILE)  hTESTCFG                 );

  if ( !rc )
  {
    for ( i=1; i < MAX_POS_IDS && (Present == NOT_PRESENT); i++ )
    {
      pos = pos_ids[i];

      if ( pos && (pos != 0xffff) )
      {
        for (j = 0; j < MAX_ADAPTER_IDS; j++ )
        {
          if ( AdapterIds[j] == pos )
          {
            Present = PRESENT;
            break;
          }
        }
      }
    }
  }

  DosClose(hTESTCFG);

  /***************************************************/             /*@V96790*/
  /*  Scan the Model/submodel bits for on Board SCSI */             /*@V96790*/
  /***************************************************/             /*@V96790*/

  if (!rc)                                                          /*@V96790*/
  {                                                                 /*@V96790*/
     /*------------------------*/                                   /*@V96790*/
     /* Open OEMHLP Driver     */                                   /*@V96790*/
     /*------------------------*/                                   /*@V96790*/
                                                                    /*@V96790*/
     if ( rc=DosOpen( "OEMHLP$",                                    /*@V96790*/
                      &hOEMHLP,                                     /*@V96790*/
                      &action,                                      /*@V96790*/
                      0L,                                           /*@V96790*/
                      0,                                            /*@V96790*/
                      1,                                            /*@V96790*/
                      0x40,                                         /*@V96790*/
                      0L          ) )                               /*@V96790*/
                                                                    /*@V96790*/
     {                                                              /*@V96790*/
       goto ExitPresenceCheck;                                      /*@V96790*/
     }                                                              /*@V96790*/
                                                                    /*@V96790*/
     if ( !(rc=DosDevIOCtl( &OEMHLP_DataPacket,                     /*@V96790*/
                            &Command,                               /*@V96790*/
                            OEMHLP_FCN_QUERYROMBIOS,                /*@V96790*/
                            OEMHLP_CAT,                             /*@V96790*/
                            hOEMHLP )))                             /*@V96790*/
     {                                                              /*@V96790*/
        Model = OEMHLP_DataPacket.Model;                            /*@V96790*/
        SubModel = OEMHLP_DataPacket.SubModel;                      /*@V96790*/
                                                                    /*@V96790*/
        /* PS/2 Machines with onboard SCSI chips */                 /*@V96790*/
                                                                    /*@V96790*/
        if ( ( Model==MODEL_PS2 ) &&                                /*@V96790*/
             ( ( SubModel==SUBMODEL_8556          ) ||              /*@V96790*/
               ( SubModel==SUBMODEL_8556_8557     ) ||              /*@V96790*/
               ( SubModel==SUBMODEL_BAHAMA        ) ||              /*@V96790*/
               ( SubModel==SUBMODEL_MIDWAY_CAT_CAY) ||              /*@V96790*/
               ( SubModel==SUBMODEL_CANERY        ) ||              /*@V96790*/
               ( SubModel==SUBMODEL_9576_9577     ) ||              /*@V96790*/
               ( SubModel==SUBMODEL_8585          ) ||              /*@V96790*/
               ( SubModel==SUBMODEL_SERVER85      )   ) )           /*@V96790*/
        {                                                           /*@V96790*/
           Present = PRESENT;                                       /*@V96790*/
        }                                                           /*@V96790*/
     }                                                              /*@V96790*/
  }                                                                 /*@V96790*/
                                                                    /*@V96790*/
  DosClose(hOEMHLP);                                                /*@V96790*/

ExitPresenceCheck:

  return( Present );
}
