/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/ibm/ibm2flpy/fl2trace.c, flp2, ddk_subset, b_bdd.032 93/03/21";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = FL2TRACE.C
 *
 * DESCRIPTIVE NAME = IBM2FLPY.ADD - Adapter Driver for ABIOS Diskette
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Internal Trace Routines
 *
 *
 *
*/

#define INCL_NOPMAPI
#define INCL_NOBASEAPI
#include <os2.h>
#include <dhcalls.h>
#include <strat2.h>     /* needed to keep reqpkt.h happy */
#include <reqpkt.h>
#include <scb.h>        /* needed to keey abios.h happy */
#include <abios.h>
#include <iorb.h>
#include <addcalls.h>
#include "fl2def.h"
#include "fl2proto.h"
#include "fl2data.h"
#include "fl2trace.h"


/*****************************************************************************/
/*                                                                           */
/*   Routine     : CreateTraceBuff                                           */
/*                                                                           */
/*   Description :                                                           */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/

VOID NEAR CreateTraceBuff()
{
   SEL   TraceBuffSel;
   ULONG PhysAddr;

   DevHelp_AllocGDTSelector( &TraceBuffSel, 1 );

   DevHelp_AllocPhys( 65536, 0, &PhysAddr );

   DevHelp_PhysToGDTSelector( PhysAddr, 0, TraceBuffSel );

   TraceBuffPtr = MAKEP( TraceBuffSel, 0 );

   ClearTraceBuff();
}


/*****************************************************************************/
/*                                                                           */
/*   Routine     : ClearTraceBuff                                            */
/*                                                                           */
/*   Description :                                                           */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/

VOID NEAR ClearTraceBuff()
{
   OFFSETOF( TraceBuffPtr ) = 0;

   do { *((PUSHORT)TraceBuffPtr)++ = 0; } while( OFFSETOF(TraceBuffPtr) != 0 );
}


