/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = FL2DEF.H
 *
 * DESCRIPTIVE NAME = IBM2FLPY.ADD - Adapter Driver for ABIOS Diskette
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Internal Control Blocks/Defines
 *
 *
 *
*/

#define MAXUNITS    4           /* PS/2 only supports three floppys          */
#define TIMERCNT    MAXUNITS+1  /* Need an extra timer for shut down delay   */
#define SHUTDNTIMER TIMERCNT-1  /* Shut down timer is the last one           */
#define SHUTDNDELAY 10000       /* Milliseconds to delay before shuting down */
#define SUSPENDDELAY 3000       /* Milliseconds to delay before suspending   */
#define MINBUFFSIZE 4096        /* Minimum size that DMA buffer can be       */
#define SUCCESS     FALSE       /* Success means no error                    */
#define FAILURE     TRUE        /* Failure means there is an error           */
#define STARTUP     0L          /* Tells context hook handler to start up    */
#define SHUTDOWN    1L          /* Tells context hook handler to shut down   */

#define STATUS_SUCCESS      0x0000 /* Req Pkt Status of Success           */
#define STATUS_ERR_GENFAIL  0x800C /* Req Pkt Status of General Failure   */
#define STATUS_QUIET_FAIL   0x8015 /* Req Pkt Status of Fail Init Quietly */
#define DP_READBACK_NOT_REQ 0x0020 /* Read Dev Parms dev control flag     */

typedef VOID (FAR *PCFN)();

typedef struct _ABRB_GENERIC       /* Generic ABIOS request block         */
   {                               /* Used for clearing reserved fields   */
      ABRBH     abrbh;
      USHORT    Offset10H;
      USHORT    Offset12H;
      USHORT    Offset14H;
      USHORT    Offset16H;
      USHORT    Offset18H;
      USHORT    Offset1AH;
      USHORT    Offset1CH;
      USHORT    Offset1EH;
      ULONG     WaitTime;
      USHORT    cSectors;
   } ABRB_GENERIC;

typedef ABRB_GENERIC near *NPABRB_GENERIC;


typedef VOID (FAR *PCOMPFN)();        /* Completion routine definition */

typedef VOID (FAR *PPOSTFN)(USHORT);  /* Timer post routine definition */

typedef struct _TIMER           /* Entry in the timer table */
   {
      USHORT   TicksToGo;
      PPOSTFN NotifyRoutine;
   } TIMER;


typedef struct _GLBLFLGS         /* Global Flags */
   {
      USHORT Resetting      : 1; /* Set when reset is in progress      */
      USHORT Unlocking      : 1; /* Set when unlock is in progress     */
      USHORT VideoPauseOn   : 1; /* Set if video pause is on           */
      USHORT ProcDisabled   : 1; /* Set if IORB processing is disabled */
      USHORT ShutdnPending  : 1; /* Set when shut down is in progress  */
      USHORT BootComplete   : 1; /* Set when boot is complete          */
      USHORT StageOnInt     : 1; /* Set when expecting an interrupt    */
      USHORT CtxHookArmed   : 1; /* Set if context hook is armed       */
      USHORT CleanupMode    : 1; /* Set if cleanup from shutdown       */
      USHORT Locking        : 1; /* Set when lock in progress          */
      USHORT Allocating     : 1; /* Set when allocate in progress      */
      USHORT Freeing        : 1; /* Set when freeing in progress       */
      USHORT HookRestart    : 1; /* Set when in hook restart code      */

   } GLBLFLGS;


typedef struct _DRVFLGS         /* Drive Flags */
   {
      USHORT HasChangeLine     : 1; /* Drive has change line capability */
      USHORT ReadBackReq       : 1; /* Drive requires read back         */
      USHORT Allocated         : 1; /* Set if unit is allocated         */
      USHORT LogicalMedia      : 1; /* Media geometry is logical        */
      USHORT UnknownMedia      : 1; /* Media geometry is unknown        */
      USHORT MediaNotFormatted : 1; /* Media is not formatted           */ /*@V82589*/
      USHORT MotorOn           : 1; /* Motor is on                      */
   } DRVFLGS;

typedef struct _DRIVE           /* Drive structure */
   {
      GEOMETRY  Geometry[2];    /* Device geometry and media geometry       */
      USHORT    MotorOffDelay;  /* Millisecs before turning off drive motor */
      UCHAR     RetryCount;     /* Number of times to retry failed attempt  */
      UCHAR     SectorSizeCode; /* Current Sector Size Code (N)             *//*@V82589*/
      UCHAR     FormatGap;      /* Gap length for format (GAP 2,3)          */
      UCHAR     ReadGap;        /* Default GAP length for read (GAP 1)      *//*@V82589*/
      UCHAR     DataLen;        /* Data Length (DTL)                        *//*@V82589*/
      UCHAR     FillByte;       /* Fill byte for format                     */
      PUNITINFO pUnitInfo;      /* Passed in on Change Unit Info            */
      DRVFLGS   Flags;          /* Drive flags                              */
      UCHAR     LockState;      /* Drive Lock state                         *//*@V54106*/
      PCFN      DetermineComplete;/* Media Determine callback address       *//*@V82589*/
   } DRIVE;

/* Indexes into the Drive[].Geometry[] table */
#define DEVICE      0           /* Max geometry for the drive    */
#define MEDIA       1           /* Geometry of the current media */

/* Drive Lock State  */                                              /*@V54106*/
#define LOCK_STATE_UNKNOWN   0                                       /*@V54106*/
#define LOCKED               1                                       /*@V54106*/
#define UNLOCKED             2                                       /*@V54106*/

#define DisableInts _asm cli    /* Disable Interrupts           */
#define EnableInts  _asm sti    /* Enable Interrupts            */


/* ABIOS Device Block */
typedef struct _DEV_BLK
   {
      UCHAR        Reserved[12];
      ULONG        Port3F0;
      ULONG        Port3F4;
      ULONG        Port3F7;
      PVOID        pPortCMOS;
      PVOID        pPortDMA;
      ULONG        PortDMAMask;
      ULONG        PortDMAPage;
      USHORT       DeviceLength;
      UCHAR        DeviceStatus;
      UCHAR        MotorStatus;
      UCHAR        TimeoutCount;
      UCHAR        LastRate;
      USHORT       DBUnitCount;
      USHORT       UnitLength;
   } DEV_BLK;

typedef DEV_BLK far *PDEV_BLK;



