/*
   ABIOS LOG Translator

   This program will read the output of an ABIOS DEBUG log, and format it
   for human understanding.  To capture the log, run the LOGGING version
   of IBM2ADSK.ADD (compile with /DLOGGING on all modules), then under
   the kernel debugger, type:

     DB _ALOGHISTORY L1900

   The output from that is what this program expects - to put the log
   in chronological order, look for the line of FF's in the log, and
   move the log entries BEFORE the FF's to the end of the log, then
   delete the line of FF's

*/

LOG_INTH     = '11'         /* start of int handler                */
LOG_INTHE1   = '12'         /* EOI (exceeded nesting level)        */
LOG_INTHE2   = '13'         /* EOI (normal)                        */
LOG_STAGE    = '21'         /* start of StageABIOSRequest          */
LOG_STAGE2   = '22'         /* StageABIOSRequest after ABIOS call  */
LOG_STAGE3   = '23'         /* StageABIOSRequest IntClaimed        */
LOG_STAGE4   = '24'         /* StageABIOSRequest stage on INT      */
LOG_STAGE5   = '25'         /* StageABIOSRequest stage on Time     */
LOG_STAGE6   = '26'         /* StageABIOSRequest exit              */
LOG_IORB     = '31'         /* IORB request router                 */
LOG_STARTLCB = '41'         /* Start LCB                           */
LOG_ABERR    = '51'         /* ABIOSErrortoRC decrements LID       */
LOG_BUSYQ    = '61'         /* RetryLCBBusyQ dec's LID, still !0   */
LOG_BUSYQ2   = '62'         /* RetryLCBBusyQ dec's LID, now 0      */
LOG_DEFINT   = '71'         /* ProcessDefaultInt                   */

LogType.LOG_INTH     = 'Interrupt  '
LogType.LOG_INTHE1   = 'EOI (nest) '
LogType.LOG_INTHE2   = 'EOI        '
LogType.LOG_STAGE    = 'Stage      '
LogType.LOG_STAGE2   = 'ABIOS Call '
LogType.LOG_STAGE3   = 'INT Claimed'
LogType.LOG_STAGE4   = 'Stg on INT '
LogType.LOG_STAGE5   = 'Stg on TIME'
LogType.LOG_STAGE6   = 'Stage Exit '
LogType.LOG_IORB     = 'IORB Req   '
LogType.LOG_STARTLCB = 'Start LCB  '
LogType.LOG_ABERR    = 'LID dec err'
LogType.LOG_BUSYQ    = 'LID dec    '
LogType.LOG_BUSYQ2   = 'LID dec    '
LogType.LOG_DEFINT   = 'Default Int'

Parse Upper Arg logfile

result = Stream( logfile, 'Command', 'Query Exists' )  /* Look for log file */

if result='' then
do
   say "Can't find log file"
   exit
end

do forever

   parse value linein(logfile) with addr b0 b1 b2 b3 b4 b5 b6 b7'-'b8 b9 ba bb bc bd be bf .
   if addr='' then leave

   LogFlags = b5||b4
   LogLID   = b7||b6
   LogParm1 = b9||b8
   LogParm2 = bb||ba
   LogParm3 = bd||bc
   LogParm4 = bf||be

   LogLine = LogType.b0 ||'  LID='b1 || ' IFlg=' || LogFlags || ' LCnt=' || b6 || ' ICnt=' b7

   select
      when b0 = LOG_IORB then do
         say ''
         say LogType.b0 || ' Unit=' || b1 || '  Cmd='LogParm1 || ' Mod=' || LogParm2
      end

      when b0 = LOG_INTH then do
         say LogLine ' ABRC='LogParm1
      end

      when b0 = LOG_INTHE1 | b0 = LOG_INTHE2 then do
         say LogLine ' ILvl='LogParm1
      end

      when b0 >= LOG_STAGE & b0 <= LOG_STAGE9 then do
         say LogLine ' ABRC='LogParm1 ' ATyp='LogParm2
      end

      otherwise say LogLine

   end /* select */
end /* do forever */
