/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*******************\
*
* Logging defines
*
\*******************/
#if defined (LOGGING)

   #define MAXLOGBUF   400             // Max number of log entries

   #define LOG_INTH      0x11          // start of int handler
   #define LOG_INTHE1    0x12          // EOI (exceeded nesting level)
   #define LOG_INTHE2    0x13          // EOI (normal)
   #define LOG_STAGE     0x21          // start of StageABIOSRequest
   #define LOG_STAGE2    0x22          // StageABIOSRequest after ABIOS call
   #define LOG_STAGE3    0x23          // StageABIOSRequest IntClaimed
   #define LOG_STAGE4    0x24          // StageABIOSRequest stage on INT
   #define LOG_STAGE5    0x25          // StageABIOSRequest stage on Time
   #define LOG_STAGE6    0x26          // StageABIOSRequest exit
   #define LOG_IORB      0x31          // IORB request router
   #define LOG_STARTLCB  0x41          // Start LCB
   #define LOG_ABERR     0x51          // ABIOSErrortoRC decrements LID
   #define LOG_BUSYQ     0x61          // RetryLCBBusyQ dec's LID, still !0
   #define LOG_BUSYQ2    0x62          // RetryLCBBusyQ dec's LID, now 0
   #define LOG_DEFINT    0x71          // ProcessDefaultInt


   typedef struct
   {
      UCHAR   cLogID;                  // What Log Entry is this?
      UCHAR   cLidIndex;               // What LID are we working on?
      USHORT  nLine;                   // Line Number in source file
      USHORT  nIntFlags;               // Current value of IntFlags
      UCHAR   cLidCount;               // Count of outstanding ops on this LID
      UCHAR   cIntCount;               // Count of interrupting stages
      USHORT  nParm1;                  // 1st parameter (defined by a log entry)
      USHORT  nParm2;                  // 2nd parameter
      USHORT  nParm3;                  // 3rd parameter
      USHORT  nParm4;                  // 4th parameter
   } LOG;

   typedef LOG *PLOG;

    extern LOG alogHistory[ MAXLOGBUF ];
    extern PLOG plogCurrent;

    extern void LogEvent( UCHAR cLogID,
          UCHAR  cLidIndex,
          USHORT nLine,
          USHORT nIntFlags,
          UCHAR  cLidCount,
          UCHAR  cIntCount,
          USHORT nParm1,
          USHORT nParm2,
          USHORT nParm3,
          USHORT nParm4);

    #define LogHere( cLogID, nParm1, nParm2, nParm3, nParm4 )  \
        LogEvent( cLogID, (UCHAR)npLCB->LidIndex, __LINE__,npLCB->IntFlags,(UCHAR)LidIOCount[npLCB->LidIndex], (UCHAR)npLCB->IntCount, nParm1, nParm2, nParm3, nParm4)

#else  /* no logging desired */

    #define LogHere( cLogID, nParm1, nParm2, nParm3, nParm4 )

#endif /* LOGGING */
