/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/ibm/ibm2adsk/adskerrt.h, adsk, ddk_subset, b_bdd.032 93/03/20";*/
/**************************************************************************
 *
 * SOURCE FILE NAME =  ADSKERRT.H
 *
 * DESCRIPTIVE NAME =  IBM2ADSK.ADD - Adapter Driver for ABIOS DASD Devices
 *                     ABIOS return code translation tables
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Defines look-up tables for converting ABIOS Error Codes
 *               to IORB error codes.
 *
 *               This file is included by ADSKDATA.C
 *
 *
*/

/*--------------------------------------------------------------------------*/
/*                                                                          */
/* ABIOS Errors are converted as follows:                                   */
/*                                                                          */
/* 1.) An error class is generated by examining BITS 15-12 of the           */
/*     ABIOS Rc.                                                            */
/*                                                                          */
/* 2.) The error class is used to select one of the index tables:           */
/*                                                                          */
/*       AB_8xxx_To_Index[]                                                 */
/*       AB_9xxx_To_Index[] (also used for classes Axxx, Bxxx)              */
/*       AB_Cxxx_To_Index[]                                                 */
/*                                                                          */
/* 3.) The table is searched for BITS 7-0 of the ABIOS Rc.                  */
/*                                                                          */
/* 4.) The index of the matching entry is used to look up the               */
/*     IORB error in one of the following tables:                           */
/*                                                                          */
/*       AB_8xxx_Index_To_IORBErr[]                                         */
/*       AB_9xxx_Index_To_IORBErr[] (also used for class Bxxx)              */
/*       AB_Axxx_Index_To_IORBErr[]                                         */
/*       AB_Cxxx_Index_To_IORBErr[]                                         */
/*                                                                          */
/*     If the index search (3) was unsuccessful, each of these tables       */
/*     an additional entry to handle an ABIOS error with a known class      */
/*     an unknown error code.                                               */
/*                                                                          */
/*--------------------------------------------------------------------------*/


UCHAR   AB_8xxx_To_Index[] = {

        ABRC_BUSY                    & 0x00ff,  /* 8000                     */
        ABRC_DISK_DEV_NOT_POWERED_ON & 0x00ff,  /* 8001                     */
        ABRC_DISK_DEV_BLOCK_INIT_ERR & 0x00ff,  /* 8002                     */
        ABRC_DISK_DEV_NOT_ALLOCATED  & 0x00ff,  /* 8003                     */
        ABRC_DISK_DMA_ARB_INVALID    & 0x00ff   /* 800F                     */
};

USHORT  AB_8xxx_Max_Index = sizeof(AB_8xxx_To_Index) / sizeof(UCHAR);


USHORT  AB_8xxx_Index_To_IORBErr[] = {

        IOERR_DEVICE_BUSY,
        IOERR_UNIT_PWR_OFF,             /* ABRC_DISK_DEV_NOT_POWERED_ON     */
        IOERR_CMD_SW_RESOURCE,          /* ABRC_DISK_DEV_BLOCK_INIT_ERR     */
        IOERR_UNIT_NOT_ALLOCATED,       /* ABRC_DISK_DEV_NOT_ALLOCATED      */
        IOERR_ADAPTER_HOSTBUSCHECK,     /* ABRC_DISK_DMA_ARB_INVALID        */
        IOERR_ADAPTER_REFER_TO_STATUS   /* Other ABRC_                      */
};


UCHAR   AB_9xxx_To_Index[] = {

        0xA000                      & 0x00ff,  /* A000                      */
        ABRC_DISK_BAD_COMMAND       & 0x00ff,  /* 9101,A001,B001,B101       */
        ABRC_DISK_ADDRMARK_NOTFND   & 0x00ff,  /* 9102,A002                 */
        ABRC_DISK_WRITE_PROTECT     & 0x00ff,  /* 9103                      */
        ABRC_DISK_RECORD_NOTFND     & 0x00ff,  /* 9104,A004                 */
        ABRC_DISK_RESET_FAIL        & 0x00ff,  /* 9105,A005,A105            */
        ABRC_DISK_MEDIA_CHANGED     & 0x00ff,  /* 9106                      */
        ABRC_DISK_CTRL_PARM_FAIL    & 0x00ff,  /* 9107,A007,A107            */
        ABRC_DISK_DMA_FAIL          & 0x00ff,  /* 9108                      */
        ABRC_DISK_DEFECTIVE_SECTOR  & 0x00ff,  /*      A00A                 */
        ABRC_DISK_BAD_TRACK         & 0x00ff,  /*      A00B                 */
        ABRC_DISK_FORMAT_ERROR      & 0x00ff,  /*      A00D                 */
        ABRC_DISK_CAM_RV            & 0x00ff,  /*      A00E                 */
        ABRC_DISK_CRC               & 0x00ff,  /*      A010                 */
        ABRC_DISK_ECC_CORRECTED     & 0x00ff,  /*      A011                 */
        ABRC_DISK_DEVICE_FAILED     & 0x00ff,  /* 9114                      */
        ABRC_DISK_BUS_FAULT         & 0x00ff,  /* 9115                      */
        ABRC_DISK_BAD_CONTROLLER    & 0x00ff,  /* 9120,A020,A120,B020,B120  */
        ABRC_DISK_EQUIP_CHECK       & 0x00ff,  /* 9121,A021,A121,B021,B121  */
        ABRC_DISK_BAD_SEEK          & 0x00ff,  /* 9140,A040,A140            */
        ABRC_DISK_DEVICE_NORESPONSE & 0x00ff,  /* 9180,A080,A180,B080,B180  */
        ABRC_DISK_DRIVE_NOTREADY    & 0x00ff,  /* 91AA,A0AA,A1AA            */
        ABRC_DISK_UNDEFINED_ERROR   & 0x00ff,  /* 91BB,A0BB,A1BB,B0BB,B1BB  */
        ABRC_DISK_WRITE_FAULT       & 0x00ff,  /* 91CC,A0CC,A1CC            */
        ABRC_DISK_STATUS_ERROR      & 0x00ff,  /* 91E0                      */
        ABRC_DISK_INCOMPLETE_SENSE  & 0x00ff   /* 91FF,A0FF,A1FF,B0FF,B1FF  */
};

USHORT  AB_9xxx_Max_Index = sizeof(AB_9xxx_To_Index) / sizeof(UCHAR);


USHORT  AB_9xxx_Index_To_IORBErr[] = {

        IOERR_ADAPTER_DEVICE_TIMEOUT,   /*                                  */
        IOERR_DEVICE_REQ_NOT_SUPPORTED, /* ABRC_DISK_BAD_COMMAND            */
        IOERR_RBA_ADDRESSING_ERROR,     /* ABRC_DISK_ADDRMARK_NOTFND        */
        IOERR_MEDIA_WRITE_PROTECT,      /* ABRC_DISK_WRITE_PROTECT          */
        IOERR_RBA_ADDRESSING_ERROR,     /* ABRC_DISK_RECORD_NOTFND          */
        IOERR_DEVICE_DIAGFAIL,          /* ABRC_DISK_RESET_FAIL             */
        IOERR_MEDIA_CHANGED,            /* ABRC_DISK_MEDIA_CHANGED          */
        IOERR_DEVICE_REQ_NOT_SUPPORTED, /* ABRC_DISK_CTRL_PARM_FAIL         */
        IOERR_ADAPTER_HOSTBUSCHECK,     /* ABRC_DISK_DMA_FAIL               */
        IOERR_RBA_CRC_ERROR,            /* ABRC_DISK_DEFECTIVE_SECTOR       */
        IOERR_RBA_CRC_ERROR,            /* ABRC_DISK_BAD_TRACK              */
        IOERR_RBA_CRC_ERROR,            /* ABRC_DISK_FORMAT_ERROR           */
        IOERR_RBA_ADDRESSING_ERROR,     /* ABRC_DISK_CAM_RV                 */
        IOERR_RBA_CRC_ERROR,            /* ABRC_DISK_CRC                    */
        IOERR_RBA_CRC_ERROR,            /* ABRC_DISK_ECC_CORRECTED          */
        IOERR_DEVICE_DIAGFAIL,          /* ABRC_DISK_DEVICE_FAILED          */
        IOERR_DEVICE_DEVICEBUSCHECK,    /* ABRC_DISK_BUS_FAULT              */
        IOERR_DEVICE_DIAGFAIL,          /* ABRC_DISK_BAD_CONTROLLER         */
        IOERR_DEVICE_DIAGFAIL,          /* ABRC_DISK_EQUIP_CHECK            */
        IOERR_RBA_ADDRESSING_ERROR,     /* ABRC_DISK_BAD_SEEK               */
        IOERR_ADAPTER_DEVICE_TIMEOUT,   /* ABRC_DISK_DEVICE_NORESPONSE      */
        IOERR_UNIT_NOT_READY,           /* ABRC_DISK_DRIVE_NOTREADY         */
        IOERR_DEVICE_DIAGFAIL,          /* ABRC_DISK_UNDEFINED_ERROR        */
        IOERR_RBA_CRC_ERROR,            /* ABRC_DISK_WRITE_FAULT            */
        IOERR_DEVICE_DIAGFAIL,          /* ABRC_DISK_STATUS_ERROR           */
        IOERR_DEVICE_DIAGFAIL,          /* ABRC_DISK_INCOMPLETE_SENSE       */
        IOERR_ADAPTER_REFER_TO_STATUS   /* Other ABRC_                      */
};


USHORT  AB_Axxx_Index_To_IORBErr[] = {

        IOERR_ADAPTER_DEVICE_TIMEOUT,   /*                                  */
        IOERR_ADAPTER_REQ_NOT_SUPPORTED,/* ABRC_DISK_BAD_COMMAND            */
        IOERR_RBA_ADDRESSING_ERROR,     /* ABRC_DISK_ADDRMARK_NOTFND        */
        IOERR_MEDIA_WRITE_PROTECT,      /* ABRC_DISK_WRITE_PROTECT          */
        IOERR_RBA_ADDRESSING_ERROR,     /* ABRC_DISK_RECORD_NOTFND          */
        IOERR_ADAPTER_DIAGFAIL,         /* ABRC_DISK_RESET_FAIL             */
        IOERR_MEDIA_CHANGED,            /* ABRC_DISK_MEDIA_CHANGED          */
        IOERR_ADAPTER_REQ_NOT_SUPPORTED,/* ABRC_DISK_CTRL_PARM_FAIL         */
        IOERR_ADAPTER_HOSTBUSCHECK,     /* ABRC_DISK_DMA_FAIL               */
        IOERR_RBA_CRC_ERROR,            /* ABRC_DISK_DEFECTIVE_SECTOR       */
        IOERR_RBA_CRC_ERROR,            /* ABRC_DISK_BAD_TRACK              */
        IOERR_RBA_CRC_ERROR,            /* ABRC_DISK_FORMAT_ERROR           */
        IOERR_RBA_ADDRESSING_ERROR,     /* ABRC_DISK_CAM_RV                 */
        IOERR_RBA_CRC_ERROR,            /* ABRC_DISK_CRC                    */
        IOERR_RBA_CRC_ERROR,            /* ABRC_DISK_ECC_CORRECTED          */
        IOERR_DEVICE_DIAGFAIL,          /* ABRC_DISK_DEVICE_FAILED          */
        IOERR_DEVICE_DEVICEBUSCHECK,    /* ABRC_DISK_BUS_FAULT              */
        IOERR_ADAPTER_DIAGFAIL,         /* ABRC_DISK_BAD_CONTROLLER         */
        IOERR_ADAPTER_DIAGFAIL,         /* ABRC_DISK_EQUIP_CHECK            */
        IOERR_RBA_ADDRESSING_ERROR,     /* ABRC_DISK_BAD_SEEK               */
        IOERR_ADAPTER_DEVICE_TIMEOUT,   /* ABRC_DISK_DEVICE_NORESPONSE      */
        IOERR_UNIT_NOT_READY,           /* ABRC_DISK_DRIVE_NOTREADY         */
        IOERR_ADAPTER_DIAGFAIL,         /* ABRC_DISK_UNDEFINED_ERROR        */
        IOERR_RBA_CRC_ERROR,            /* ABRC_DISK_WRITE_FAULT            */
        IOERR_DEVICE_DIAGFAIL,          /* ABRC_DISK_STATUS_ERROR           */
        IOERR_ADAPTER_DIAGFAIL,         /* ABRC_DISK_INCOMPLETE_SENSE       */
        IOERR_ADAPTER_REFER_TO_STATUS   /* Other ABRC_                      */
};

UCHAR   AB_Cxxx_To_Index[] = {

        ABRC_UNSUPPORTED_LID      & 0x00ff,    /* C000                      */
        ABRC_UNSUPPORTED_FUNCTION & 0x00ff,    /* C001                      */
        ABRC_UNSUPPORRTED_UNIT    & 0x00ff,    /* C003                      */
        ABRC_UNSUPPORTED_RB_LEN   & 0x00ff,    /* C004                      */
        ABRC_INVALID_PARM         & 0x00ff     /* C005                      */
};

USHORT  AB_Cxxx_Max_Index = sizeof(AB_Cxxx_To_Index) / sizeof(UCHAR);


USHORT  AB_Cxxx_Index_To_IORBErr[] = {

        IOERR_UNIT_NOT_ALLOCATED,       /* ABRC_UNSUPPORTED_LID             */
        IOERR_ADAPTER_REQ_NOT_SUPPORTED,/* ABRC_UNSUPPORTED_FUNCTION        */
        IOERR_UNIT_NOT_ALLOCATED,       /* ABRC_UNSUPPORRTED_UNIT           */
        IOERR_CMD_SYNTAX,               /* ABRC_UNSUPPORTED_RB_LEN          */
        IOERR_CMD_SYNTAX,               /* ABRC_INVALID_PARM                */
        IOERR_ADAPTER_REQ_NOT_SUPPORTED /* Other ABRC_                      */
};
