/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = FLP1EXTN.H
 *
 * DESCRIPTIVE NAME = External data declarations.
 *
 *
 *
 * VERSION = V2.1
 *
 * DATE = 94/03/14
 *
 * DESCRIPTION : Data External References
 *
 * Purpose:  This file provides external references for global
 *           data contained in FLP1DATA.C
 *
 *
 *
 *
*/
/*------------------------------------------------------------------------*/
/*                                                                        */
/* Global Static Data                                                     */
/*                                                                        */
/*------------------------------------------------------------------------*/

extern ACBPTRS    ACBPtrs[MAX_ADAPTERS];

extern VOID       (NEAR *ReqRoutine[])(NPACB npACB);

extern PFN        Device_Help;
extern HDRIVER    hDriver;        /*V98451*/


extern USHORT     ADDHandle;
extern USHORT     cAdapters;
extern USHORT     cUnits;

extern USHORT     Calibrate;
extern ULONG      MSRWaitCount;
extern ULONG      IODelayCount;

extern LIN        plDataSeg;

extern LIN        plSwapCode;
extern USHORT     SwapCodeLen;

extern USHORT     ADDLockCount;
extern LIN        plADDLockHandle;
extern UCHAR      ADDLockHandle[12];

extern PULONG     pCurIntLvl;

extern ULONG      ADDMotorIdleHandle;

extern USHORT     InitComplete;

extern USHORT     uCMachine;

extern UCHAR      AdapterName[18];

extern HWRESOURCE HWResource[MAX_ADAPTERS];

extern UCHAR      IRQUseCount[16];

/*------------------------------------------------------------------------*/
/*                                                                        */
/*      Area to build Control Blocks                                      */
/*                                                                        */
/*------------------------------------------------------------------------*/

extern USHORT   ACBPoolAvail;
extern NPBYTE   npACBPool;
extern UCHAR    ACBPool[ACB_POOL_SIZE+TIMER_POOL_SIZE];


/*------------------------------------------------------------------------*/
/*                                                                        */
/*      Initialization Data                                               */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*------------------------------------*/
/*                                    */
/*                                    */
/*                                    */
/*------------------------------------*/
extern  NPUCB   npUCBLast;
extern  USHORT  FLP1IOWait;
extern  USHORT  BIOSUnit;
extern  USHORT  IBMModel;
extern  USHORT  IBMSubModel;

/*------------------------------------*/
/*                                    */
/*                                    */
/*                                    */
/*------------------------------------*/

extern ATBL     AdapterTable[MAX_ADAPTERS];

extern PDDD_PARM_LIST pDDD_Parm_List;

/*------------------------------------*/
/*                                    */
/*                                    */
/*                                    */
/*------------------------------------*/

extern ULONG           CalibrateTimerHandle;
extern USHORT          CallWorkerSync;
extern USHORT          CallWorker;

extern USHORT          Verbose;
extern USHORT          uCInstall;

/*------------------------------------*/
/*                                    */
/* ASCII Text Data                    */
/*                                    */
/*------------------------------------*/

extern MSGTABLE  InitMsg;
extern NPSZ AdptMsgs[];
extern NPSZ UnitMsgs[];
extern NPSZ UnitType[];
extern NPSZ AdptOpts[];
extern NPSZ UnitOpts[];
extern NPSZ MsgNull;
extern UCHAR UninstallMsg[];
extern UCHAR ParmErrMsg[];
extern UCHAR VersionMsg[];

/*------------------------------------*/
/*                                    */
/* Media tables                       */
/*                                    */
/*------------------------------------*/

extern MEDIAINFO        MediaTable_0360;
extern MEDIAINFO        MediaTable_0362;
extern MEDIAINFO        MediaTable_1200;
extern MEDIAINFO        MediaTable_0720;
extern MEDIAINFO        MediaTable_1440;
extern MEDIAINFO        MediaTable_2880;
extern MEDIALOOKUP      MediaLookUp[MAX_FORM_FACTOR];

extern USHORT           SRTRate[4];
extern USHORT           HLTDelay15ms[4];

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Command Line Parser Data                                     */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

#include "cmdphdr.h"

extern PSZ          pcmdline1;
extern PSZ          pcmdline_slash;
extern PSZ          pcmdline_start;
extern INT          tokv_index;
extern INT          state_index;
extern INT          length;
extern CHARBYTE     tokvbuf[];
extern POPT         pend_option;
extern POPT         ptable_option;
extern BYTE         *poutbuf1;
extern BYTE         *poutbuf_end;
extern CC           cc;
extern USHORT       outbuf_len;
extern PBYTE        poutbuf;
extern OPTIONTABLE  opttable;
extern USHORT       DrvrNameSize;        /*V98451*/
extern DRIVERSTRUCT DriverStruct;        /*V98451*/
extern ADAPTERSTRUCT AdapterStruct;      /*V98451*/
extern DEVICESTRUCT DevStruct;           /*V98451*/
extern UCHAR        ResourceBuf[];       /*V98451*/
extern PAHRESOURCE  pResourceList;       /*V98451*/
