/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = FLP1DATA.C
 *
 * DESCRIPTIVE NAME = Data Module
 *
 *
 *
 * VERSION = V2.1
 *
 * DATE = 94/03/14
 *
 * DESCRIPTION :
 *
 * Purpose: Contains all static data for driver
 *
 *
 *
*/
#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#include "os2.h"
#include "dos.h"

#include "dskinit.h"

#include "iorb.h"
#include "addcalls.h"
#include "dhcalls.h"

#define INCL_INITRP_ONLY
#include "reqpkt.h"

#include "flp1cons.h"
#include "flp1regs.h"
#include "flp1misc.h"
#include "flp1type.h"
#include "flp1extn.h"
#include "flp1pro.h"
#include "flp1mif.h"

/*------------------------------------------------------------------------*/
/*                                                                        */
/* Static Data Declarations                                               */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*---------------------------------------------*/
/*                                             */
/* List of allocated ACBs and their interrupt  */
/* entry points.                               */
/*                                             */
/*---------------------------------------------*/

ACBPTRS        ACBPtrs[MAX_ADAPTERS] = { { &DsktIRQ0 },
                                         { &DsktIRQ1 } };

/*------------------------------------*/
/*                                    */
/* Call table for FLP1ISM.C           */
/*                                    */
/*------------------------------------*/

VOID          (NEAR *ReqRoutine[])(NPACB npACB) =
{
  StartReset,         /* ACBR_RESET        0x0001   */
  StartSelect,        /* ACBR_FORCE_SELECT 0x0002   */
  StartSelect,        /* ACBR_SELECT       0x0004   */
  StartSpecify,       /* ACBR_SPECIFY      0x0008   */
  StartMotorOn,       /* ACBR_MOTOR_ON     0x0010   */
  MotorWait,          /* ACBR_MOTOR_SPINUP 0x0020   */               /*@V85053*/
  CheckMediaChange,   /* ACBR_CHECK_MEDIA  0x0040   */
  ResetMediaChange,   /* ACBR_RESET_CHANGE 0x0080   */
  StartRecal,         /* ACBR_RECAL        0x0100   */
  StartSeek,          /* ACBR_SEEK         0x0200   */
  MotorWait,          /* ACBR_MOTOR_WAIT   0x0400   */
  StartSettle,        /* ACBR_SETTLE       0x0800   */
  StartCommand        /* ACBR_COMMAND      0x1000   */

};

/*------------------------------------*/
/*                                    */
/* Global variables for ADD driver    */
/*                                    */
/*------------------------------------*/

PFN             Device_Help           = 0L;
PFNRM           RM_Help0              = 0L;  /*V98451*/
PFNRM           RM_Help3              = 0L;  /*V98451*/
HDRIVER         hDriver               = 0L;  /*V98451*/
ULONG           RMFlags               = 0L;  /*V98451*/


USHORT          ADDHandle             = 0;
USHORT          cAdapters             = 0;
USHORT          cUnits                = 0;
USHORT          Calibrate             = 0;

ULONG           MSRWaitCount          = 0;
ULONG           IODelayCount          = 0;

LIN             plDataSeg             = 0;

LIN             plSwapCode            = 0;
USHORT          SwapCodeLen           = 0;

USHORT          ADDLockCount          = 0;
LIN             plADDLockHandle       = 0;
UCHAR           ADDLockHandle[12]     = {0};

PULONG          pCurIntLvl            = 0;

ULONG           ADDMotorIdleHandle    = 0;

USHORT          InitComplete          = 0;

USHORT          uCMachine             = 0;

UCHAR           AdapterName[18]       = "Family 1 Floppy";

HWRESOURCE      HWResource[MAX_ADAPTERS] = { 0 };

UCHAR           IRQUseCount[16]       = { 0 };

/*------------------------------------------------------------------------*/
/*                                                                        */
/*      Area to build Control Blocks                                      */
/*                                                                        */
/*------------------------------------------------------------------------*/

USHORT          ACBPoolAvail          = ACB_POOL_SIZE+TIMER_POOL_SIZE;
NPBYTE          npACBPool             = ACBPool;

UCHAR           ACBPool[ACB_POOL_SIZE+TIMER_POOL_SIZE] = { 0 };


/*------------------------------------------------------------------------*/
/*                                                                        */
/*      Initialization Data                                               */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*------------------------------------*/
/*                                    */
/*                                    */
/*                                    */
/*------------------------------------*/
NPUCB           npUCBLast   = 0;
USHORT          FLP1IOWait  = 0;
USHORT          BIOSUnit    = 0;
USHORT          IBMModel    = 0;
USHORT          IBMSubModel = 0;

/*------------------------------------*/
/*                                    */
/* Adapter table structures           */
/*                                    */
/*------------------------------------*/

ATBL            AdapterTable[MAX_ADAPTERS] =
{
 /*---------------------------------*/
 /* Port  IRQ  DMA    Flags         */
 /*                                 */
 /*---------------------------------*/
  {0x3F0,  6,    2,  ATBF_INSTALLED },
  {0x370,  6,    2,  ATBF_INSTALLED }
};

PDDD_PARM_LIST pDDD_Parm_List        = { 0 };

/*------------------------------------*/
/*                                    */
/* Used by Calibrate routines         */
/*                                    */
/*------------------------------------*/

ULONG           CalibrateTimerHandle = 0;
USHORT          CallWorkerSync       = 0;
USHORT          CallWorker           = 0;

USHORT          Verbose              = 0;
USHORT          uCInstall            = 0;



/*------------------------------------*/
/*                                    */
/* ASCII Message data                 */
/*                                    */
/*------------------------------------*/

#define MSG_REPLACEMENT_STRING  1178

MSGTABLE  InitMsg = { MSG_REPLACEMENT_STRING,
                      1,
                      0,
                          };

/*------------------------------------------------------*/
/* Note: The reason we are declaring messages in this   */
/*       unnatural way is to avoid creating persistent  */
/*       constants that we would need to carry past     */
/*       init time.                                     */
/*------------------------------------------------------*/


UCHAR Adpt01[] = "OK";
UCHAR Adpt02[] = "Not detected";
UCHAR Adpt03[] = "Ignored";
UCHAR Adpt04[] = "IRQ Conflict";
UCHAR Adpt05[] = "Reset Failed";


NPSZ AdptMsgs[] = { Adpt01,
                    Adpt02,
                    Adpt03,
                    Adpt04,
                    Adpt05
                  };

UCHAR UnitS01[] = "OK";
UCHAR UnitS02[] = "Recal Failed";
UCHAR UnitS03[] = "Incompatible Unit";


NPSZ UnitMsgs[] = { UnitS01,
                    UnitS02,
                    UnitS03
                  };

UCHAR UnitT01[] = "";
UCHAR UnitT02[] = "360KB";
UCHAR UnitT03[] = "1.2MB";
UCHAR UnitT04[] = "720KB";
UCHAR UnitT05[] = "1.44MB";
UCHAR UnitT06[] = "2.88MB";

NPSZ UnitType[] = { UnitT01,
                    UnitT02,
                    UnitT03,
                    UnitT04,
                    UnitT05,
                    UnitT06
                  };

UCHAR AdptO01[] = "FI";

NPSZ AdptOpts[] = { AdptO01 };

UCHAR UnitO01[] = "CL";
UCHAR UnitO02[] = "MS";

NPSZ UnitOpts[] = { UnitO01,
                    UnitO02
                  };

NPSZ MsgNull    = "";

UCHAR ParmErrMsg[]   = " Warning: IBM1FLPY.ADD - Invalid CONFIG.SYS parameters";
UCHAR UninstallMsg[] = " Warning: IBM1FLPY.ADD - Driver did not load";
UCHAR VersionMsg[]   = "IBM  ISA Diskette  OS/2 3.x Driver  (941101)";

/*------------------------------------*/
/*                                    */
/* Media Information Tables           */
/*                                    */
/*------------------------------------*/

MEDIAINFO MediaTable_0360 =
{
   { MI_CYLN_0360 * MI_HEAD_0360 * MI_SECT_0360,
     BYTES_512,
     0,
     MI_HEAD_0360,
     MI_CYLN_0360,
     MI_SECT_0360  },

     0,

   { MI_SPEC_0360_1,
     MI_SPEC_0360_2  },

     MI_FMGL_0360,
     MI_RWGL_0360,
     MI_FMT_FILLBYTE,
     MI_SECT_0360,
     MI_RATE_0360
};

/*----------------------------------------*/
/* 360KB Media in 1.2MB Drive             */
/*                                        */
/* Note: Data Rate and DOUBLE_STEP differ */
/*       from 360KB drive                 */
/*----------------------------------------*/

MEDIAINFO MediaTable_0362 =
{
   { MI_CYLN_0360 * MI_HEAD_0360 * MI_SECT_0360,
     BYTES_512,
     0,
     MI_HEAD_0360,
     MI_CYLN_0360,
     MI_SECT_0360  },

     MIF_DOUBLE_STEP,

   { MI_SPEC_0360_1,
     MI_SPEC_0360_2  },

     MI_FMGL_0360,
     MI_RWGL_0360,
     MI_FMT_FILLBYTE,
     MI_SECT_0360,
     MI_RATE_0362
};


MEDIAINFO MediaTable_1200 =
{
   { MI_CYLN_1200 * MI_HEAD_1200 * MI_SECT_1200,
     BYTES_512,
     0,
     MI_HEAD_1200,
     MI_CYLN_1200,
     MI_SECT_1200  },

     0,

   { MI_SPEC_1200_1,
     MI_SPEC_1200_2  },

     MI_FMGL_1200,
     MI_RWGL_1200,
     MI_FMT_FILLBYTE,
     MI_SECT_1200,
     MI_RATE_1200
};

MEDIAINFO MediaTable_0720 =
{
   { MI_CYLN_0720 * MI_HEAD_0720 * MI_SECT_0720,
     BYTES_512,
     0,
     MI_HEAD_0720,
     MI_CYLN_0720,
     MI_SECT_0720  },

     0,

   { MI_SPEC_0720_1,
     MI_SPEC_0720_2  },

     MI_FMGL_0720,
     MI_RWGL_0720,
     MI_FMT_FILLBYTE,
     MI_SECT_0720,
     MI_RATE_0720
};

MEDIAINFO MediaTable_1440 =
{
   { MI_CYLN_1440 * MI_HEAD_1440 * MI_SECT_1440,
     BYTES_512,
     0,
     MI_HEAD_1440,
     MI_CYLN_1440,
     MI_SECT_1440  },

     0,

   { MI_SPEC_1440_1,
     MI_SPEC_1440_2  },

     MI_FMGL_1440,
     MI_RWGL_1440,
     MI_FMT_FILLBYTE,
     MI_SECT_1440,
     MI_RATE_1440
};

MEDIAINFO MediaTable_2880 =
{
   { MI_CYLN_2880 * MI_HEAD_2880 * MI_SECT_2880,
     BYTES_512,
     0,
     MI_HEAD_2880,
     MI_CYLN_2880,
     MI_SECT_2880  },

     0,

   { MI_SPEC_2880_1,
     MI_SPEC_2880_2  },

     MI_FMGL_2880,
     MI_RWGL_2880,
     MI_FMT_FILLBYTE,
     MI_SECT_2880,
     MI_RATE_2880
};


MEDIALOOKUP MediaLookUp[MAX_FORM_FACTOR] =
{
  0             , { 0                                                    },
  MAX_MEDIA_0360, { &MediaTable_0360                                     },
  MAX_MEDIA_1200, { &MediaTable_1200, &MediaTable_0362                   },
  MAX_MEDIA_0720, { &MediaTable_0720                                     },
  MAX_MEDIA_1440, { &MediaTable_1440, &MediaTable_0720                   },
  MAX_MEDIA_2880, { &MediaTable_2880, &MediaTable_1440, &MediaTable_0720 }
};


/*-------------------------------------------------*/
/* This table provides the multipliers to convert  */
/* SRT values to actual step rates.                */
/*                                                 */
/* The table is indexed by the controller data     */
/* rate.                                           */
/*-------------------------------------------------*/

                    /*     500Kbps  300Kbps  250Kbps    1Mbps  */
USHORT SRTRate[4]      = {   100,     167,     200,      50   };


/*---------------------------------------------*/
/* HLT values to provide a minimum of 15ms of  */
/* settle delay,                               */
/*---------------------------------------------*/

                    /*     500Kbps  300Kbps  250Kbps    1Mbps  */
USHORT HLTDelay15ms[4] = {    8,       5,       4,       15   };

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Command Line Parser Data                                     */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

#define TOKVBUF_LEN 255

PSZ        pcmdline1              = 0;
PSZ        pcmdline_slash         = 0;
PSZ        pcmdline_start         = 0;
INT        tokv_index             = 0;
INT        state_index            = 0;
INT        length                 = 0;
CHARBYTE   tokvbuf[TOKVBUF_LEN]   = { 0 };
POPT       pend_option            = 0;
POPT       ptable_option          = 0;
BYTE       *poutbuf1              = 0;
BYTE       *poutbuf_end           = 0;
CC         cc                     = { 0, 0 };

#define OUTBUF_LEN       255

BYTE     outbuf[OUTBUF_LEN] = {0};
USHORT   outbuf_len         = OUTBUF_LEN + 1;
PBYTE    poutbuf            = outbuf;

#define ENTRY_STATE        0
#define MAX_STATES         5

/*                                        opt.state[] initialization definitions
**                                         ____ entry state
**                                         |                           previous
**                                         v                               opt |
**  ----Command Line Option --------      ----- STATE TABLE  --------------    |
**  token id          string   type        0    1    2   3      4     5        |
**                                                                           <-|
**                                         *   /MCA /A: /DMA: /UNIT: /F
**                                             /PS2     /IRQ:        /AHS
**                                                      /P:          /SPEC
**                                                                   /CL
*/
OPT OPT_VERBOSE =
   {TOK_ID_V,       "/V",    TYPE_0,      {0,  1,   2,  3,    4,     5 }};

OPT OPT_NOT_VERBOSE =
   {TOK_ID_NOT_V,   "/!V",   TYPE_0,      {0,  1,   2,  3,    4,     5 }};

OPT OPT_ADAPTER =
   {TOK_ID_ADAPTER, "/A:",   TYPE_D,      {2,  2,   2,  2,    E,     E }}; /*@V85053*/

OPT OPT_IGNORE =
   {TOK_ID_IGNORE,  "/I",    TYPE_0,      {E,  E,   2,  E,    E,     E }};

OPT OPT_PORT =
    {TOK_ID_PORT,   "/P:",   TYPE_HHHH,   {E,  E,   3,  3,    E,     E }};

OPT OPT_UNIT =
    {TOK_ID_UNIT,   "/UNIT:",TYPE_D,      {4,  E,   4,  4,    E,     4 }};

OPT OPT_U =
    {TOK_ID_UNIT,   "/U:",   TYPE_D,      {4,  E,   4,  4,    E,     4 }};

OPT OPT_DMA =
    {TOK_ID_DMA,    "/DMA:", TYPE_D,      {E,  E,   3,  3,    E,     E }};

OPT OPT_IRQ =
    {TOK_ID_IRQ,    "/IRQ:", TYPE_DD,     {E,  E,   3,  3,    E,     E }};

OPT OPT_AHS =
    {TOK_ID_AHS,    "/AHS",  TYPE_0,      {E,  E,   E,  E,    5,     5 }};

OPT OPT_NAHS =
    {TOK_ID_NOT_AHS,"/!AHS", TYPE_0,      {E,  E,   E,  E,    5,     5 }};

OPT OPT_FORMAT =
    {TOK_ID_FORMAT, "/F:",   TYPE_FORMAT, {E,  E,   E,  E,    5,     5 }};

OPT OPT_SBYTES =
    {TOK_ID_S_BYTES,"/SPEC:",TYPE_HH,     {E,  E,   E,  E,    5,     5 }};

OPT OPT_CHGLINE =
    {TOK_ID_CHGLINE,"/CL:",  TYPE_CHGLINE,{E,  E,   E,  E,    5,     5 }};

OPT OPT_MEDIASENSE =
    {TOK_ID_MS,     "/MS",   TYPE_0,      {E,  E,   E,  E,    5,     5 }};

OPT OPT_NOMEDIASENSE   =
    {TOK_ID_NO_MS,  "/!MS",  TYPE_0,      {E,  E,   E,  E,    5,     5 }};

OPT OPT_DUALSPEED      =
    {TOK_ID_DUALSP, "/DSP",  TYPE_0,      {E,  E,   E,  E,    5,     5 }};

OPT OPT_PS2 =
    {TOK_ID_PS2,    "/PS2",  TYPE_0,      {1,  E,   E,  E,    E,     E }};

OPT OPT_MCA =
    {TOK_ID_MCA,    "/MCA",  TYPE_0,      {1,  E,   E,  E,    E,     E }};

OPT OPT_END =
    {TOK_ID_END,    "\0",    TYPE_0,      {O,  O,   O,  O,    O,     O }};

/*                                                                          */
/*   The following is a generic OPTIONTABLE for ADDs which support diskette */
/*   devices.                                                               */
/*                                                                          */
OPTIONTABLE  opttable =

{   ENTRY_STATE, MAX_STATES,
    {(POPT) &OPT_VERBOSE,
     (POPT) &OPT_NOT_VERBOSE,
     (POPT) &OPT_ADAPTER,
     (POPT) &OPT_IGNORE,
     (POPT) &OPT_PORT,
     (POPT) &OPT_UNIT,
     (POPT) &OPT_U,
     (POPT) &OPT_DMA,
     (POPT) &OPT_IRQ,
     (POPT) &OPT_AHS,
     (POPT) &OPT_NAHS,
     (POPT) &OPT_FORMAT,
     (POPT) &OPT_SBYTES,
     (POPT) &OPT_CHGLINE,
     (POPT) &OPT_MEDIASENSE,
     (POPT) &OPT_NOMEDIASENSE,
     (POPT) &OPT_DUALSPEED,
     (POPT) &OPT_PS2,
     (POPT) &OPT_MCA,
     (POPT) &OPT_END
    }
};


/*----------------------------------------------*/
/* Driver Description                           */    /*V98451*/
/*----------------------------------------------*/

UCHAR  DrvrNameTxt[]     = "IBM1FLPY.ADD";
USHORT DrvrNameSize     = sizeof(DrvrNameTxt);
UCHAR  DrvrDescriptTxt[] = "IBM Family 1 Floppy Driver";
UCHAR  VendorNameTxt[]   = "IBM OS/2";

DRIVERSTRUCT DriverStruct =
{
   DrvrNameTxt,                              /* DrvrName                */
   DrvrDescriptTxt,                          /* DrvrDescript            */
   VendorNameTxt,                            /* VendorName              */
   CMVERSION_MAJOR,                          /* MajorVer                */
   CMVERSION_MINOR,                          /* MinorVer                */
   1994,9,17,                                /* Date                    */
   DRF_STATIC,                               /* DrvrFlags               */
   DRT_ADDDM,                                /* DrvrType                */
   DRS_ADD,                                  /* DrvrSubType             */
   NULL                                      /* DrvrCallback            */
};


/*----------------------------------------------*/
/* Adapter Description                          */    /*V98451*/
/*----------------------------------------------*/

UCHAR AdapterDescriptNameTxt[] = "FLOPPY_# Floppy Controller";

ADAPTERSTRUCT AdapterStruct =
{
  AdapterDescriptNameTxt,            /* AdaptDescriptName; */
  AS_16MB_ADDRESS_LIMIT,             /* AdaptFlags;        */
  AS_BASE_MSD,                       /* BaseType;          */
  AS_SUB_FLPY,                       /* SubType;           */
  AS_INTF_GENERIC,                   /* InterfaceType;     */
  AS_HOSTBUS_ISA,                    /* HostBusType;       */
  AS_BUSWIDTH_16BIT,                 /* HostBusWidth;      */
  NULL,                              /* pAdjunctList;      */
  NULL                               /* reserved           */
};

/*----------------------------------------------*/
/* Device Description                           */    /*V98451*/
/*----------------------------------------------*/


DEVICESTRUCT DevStruct =
{
   NULL,                /* DevDescriptName; */
   DS_REMOVEABLE_MEDIA, /* DevFlags;     */
   DS_TYPE_DISK         /* DevFlags;        */

};


UCHAR            ResourceBuf[sizeof(AHRESOURCE)+sizeof(HRESOURCE)*3];/*V98451*/
PAHRESOURCE      pResourceList = (PAHRESOURCE) &ResourceBuf;         /*V98451*/
