/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = FLP1CONS.H
 *
 * DESCRIPTIVE NAME = Constants.
 *
 *
 *
 * VERSION = V2.1
 *
 * DATE = 94/03/14
 *
 * DESCRIPTION : Locally defined equates.
 *
 * Purpose: Fixed timing values and limits set in this driver
 *
 *
 *
 *
 *
*/
/*---------------------*/
/* Max Adapters/Drives */
/*---------------------*/
#define MAX_ADAPTERS            2
#define MAX_DRIVES              4
#define MAX_FORM_FACTOR         6
#define MAX_MEDIA_INFO          3

/*--------------------*/
/* Error retry limits */
/*--------------------*/
#define MAX_DETERMINE_ERROR     2                                    /*@V85053*/
#define MAX_EXECIO_RECAL        3
#define MAX_EXECIO_ERROR        3
#define MAX_ISM_RECAL           2

/*-------------------*/
/* Timing constants  */
/*-------------------*/
#define uSPerMS                         1000

/*--------------------------*/
/* DOR reset duration (uS)  */
/*--------------------------*/
#define RESET_DELAY_TIME                10

/*-------------------------------------------*/
/* Send/Receive controller byte timeout (uS) */
/*-------------------------------------------*/
#define MAX_WAIT_MSR                    600                          /*@V92714*/

/*--------------------------*/
/* Motor Scan Interval (ms) */
/*--------------------------*/
#define MOTOR_CHECK_INTERVAL            500

/*---------------------------------*/
/* Number of Motor Scans           */
/* before turning off drive motor  */
/*---------------------------------*/
#define MOTOR_OFF_COUNT                 7

/*------------------------------*/
/* Motor on delay interval (ms) */
/*------------------------------*/
#define MOTOR_ON_DELAY_35INCH           500
#define MOTOR_ON_DELAY_525INCH          625

/*---------------------------*/
/* Seek settle interval (ms) */
/*---------------------------*/
#define SEEK_SETTLE_TIME                15

/*-----------------------------------*/
/* Command to interrupt timeout (ms) */
/*-----------------------------------*/
#define IRQ_TIMEOUT                     1500

/*----------------------------------------*/
/* Initial controller reset timeout (ms)  */
/*----------------------------------------*/
#define INIT_RESET_TIMEOUT              250                          /*@V88786*/

/*-----------------------------------*/                              /*@V90990*/
/* Time till next Retry timeout (ms) */
/*-----------------------------------*/
#define RETRY_TIMEOUT                   1500

/*---------------------------------------------------*/
/* Arbitrary loop count to calibrate worker routines */
/*---------------------------------------------------*/
#define CALIBRATE_LOOP_COUNT            1024

/*--------------------------------------------------------*/
/* Interval to run worker routines during Calibration (ms)*/
/*--------------------------------------------------------*/
#define CALIBRATE_TIMER_INTERVAL        (4*31L)
#define CALIBRATE_INTERVAL_ACTUAL       (CALIBRATE_TIMER_INTERVAL + 31L)

/*-------------------*/
/* ISA DMA limits    */
/*-------------------*/
#define MAX_BUFFER_RETRY       16

#define C16MEG                 (ULONG)(16L*1024*1024)
#define C64KB                  (ULONG)(64L*1024)
#define C4KB                   (ULONG)(4L*1024)

/*-------------------*/
/* Sector code limit */
/*-------------------*/
#define MAX_N                   7

/*---------------------------------------------------*/
/* Timer Pool                                        */
/*                                                   */
/* Note: There are two timers per ACB, the Interrupt */
/*       Timeout and a Delay Timer. There is one     */
/*       global timer per ADD for calibration and    */
/*       motor scanning.                             */
/*---------------------------------------------------*/

#define TIMERS_PER_ACB          2

#define TIMER_POOL_SIZE  (sizeof(ADD_TIMER_POOL) +                        \
                           ((TIMERS_PER_ACB * MAX_ADAPTERS))              \
                             * sizeof(ADD_TIMER_DATA))

/*-------------------------------*/
/* Miscellaneous                 */
/*-------------------------------*/
#define ENABLE  _asm{ sti }
#define DISABLE _asm{ cli }


/*-------------------------------*/
/* IBM Specific                  */
/*-------------------------------*/
#define IBM_MODEL_386           0xF8
#define IBM_SUBMODEL_L40SX      0x23
#define IBM_SUBMODEL_N1         0x87
#define IBM_SUBMODEL_N2         0x97

#define IBM_L40SX_PWR_DISABLE   0x04



