/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/* Externals  */



/*
** This file defines the what is needed for an external ADD to be able
** to attach to and call the delivery ADD.
*/


/************************************************************************/
/* Type defines 							*/
/************************************************************************/


/* ----------------------------------------------------------------------
** pipe control structure.  Each describes a set of pipes for use by the
** common code.  All addresses are 16:16.
*/

typedef struct _PIPEDATA {

   PBYTE   pInPipe;	    // System inbound pipe address
   PBYTE   pOutPipe;	    // System outbound pipe address

   PUSHORT pInSES;	    // Inbound surrogate enqueue status address
   PUSHORT pInSSF;	    // Inbound surrogate start of free address
   PUSHORT pInSDS;	    // Inbound surrogate dequeue status address
   PUSHORT pInSSE;	    // Inbound surrogate start of elements address

   PUSHORT pOutSES;	    // Outbound surrogate enqueue status address
   PUSHORT pOutSSF;	    // Outbound surrogate start of free address
   PUSHORT pOutSDS;	    // Outbound surrogate dequeue status address
   PUSHORT pOutSSE;	    // Outbound surrogate start of elements address

   USHORT  cSizeInPipe;     // size of inbound pipe in bytes
   USHORT  cSizeOutPipe;    // size of outbound pipe in bytes

   PVOID   pSysSCA;	    // system signalling control area address
   PVOID   pAdpSCA;	    // adapter signalling control area address

   USHORT  SysCfgOpt;	    // system configuration option
   USHORT  AdpCfgOpt;	    // adapter configuration option

   ULONG   InitSysSig;	    // initial system signal value
   ULONG   InitAdpSig;	    // initial peer signal value

   USHORT  RegPipOpt;	    // register pipe options

} PIPEDATA, FAR *PPIPEDATA;


/* ----------------------------------------------------------------------
** Host routine table.	This is a table of entry pts in the adapter ADD
** for the delivery ADD to call.  All fields must be filled in.
** The called routine must load it's own DS value (_loadds).
*/

typedef struct _HOSTRTNTBL {	 // all addresses are 16:16

   ULONG    (FAR *Signal)();	       // signal routine
   ULONG    (FAR *RxRouter)();	       // router for dequeued control elements
   ULONG    (FAR *PipeFull)();	       // pipe full handler
   ULONG    (FAR *EnqueueSignal)();    // called when an enqueue signal recvd
   ULONG    (FAR *DequeueSignal)();    // called when an dequeue signal recvd

} HOSTRTNTBL, FAR *PHOSTRTNTBL, NEAR *NPHOSTRTNTBL;


/* ----------------------------------------------------------------------
** SCB Delivery routine table.	This is a table that is filled in by the
** delivery ADD when an ADD registers.	After registration only these entry
** points should be called.
*/

typedef struct _DELIVERYTABLE {        // all addresses are 16:16

   USHORT   (FAR *AllocateUnit)();     // allocate a unit #
   USHORT   (FAR *AllocateEntity)();   // allocate an entity for a unit
   USHORT   (FAR *RegisterPipe)();     // register a pipe for a unit
   USHORT   (FAR *InitPipe)();	       // initialize a pipe
   USHORT   (FAR *Enqueue)();	       // enqueue elements
   USHORT   (FAR *Dequeue)();	       // dequeue elements
   USHORT   (FAR *SignalHandler)();    // handle a signal

} DELIVERYTABLE, FAR *PDELIVERYTABLE;


/************************************************************************/
/* constant defines							*/
/************************************************************************/

/* General defines  */


#define  MAXADDS	   8	       // max number of ADDs supported
#define  MAXUNITS	   8	       // max number of units supported
#define  MAXPIPES	   8	       // max number of pipes supported

#define  SIZEUNITDESC	  20

#define  SYSTEMUNIT	   0	       // system unit number equate


/* --------------------------------------------------------------------
** delivery ADD return codes.  Returned on all delivery ADD function
** calls.
*/

#define  DADD_NOERROR		   0   // no error
#define  DADD_ERR_UNITINVLD	   1   // unit number is invalid
#define  DADD_ERR_PIPEHINVLD	   2   // pipe handle invalid
#define  DADD_ERR_MAXPIPES	   3   // max # pipes exceeded
#define  DADD_ERR_MAXADDS	   4   // max # of ADDs exceeded
#define  DADD_ERR_MAXUNITS	   5   // max # of units exceeded
#define  DADD_ERR_MAXENTITIES	   6   // max # of enitities exceeded
#define  DADD_ERR_PIPEEMPTY	   8   // pipe is empty
#define  DADD_PIPE_FULL 	   9   // pipe if full
#define  DADD_LEVEL_NOT_SUPPORTED 10   // delivery service lvl not supported
